<?php
function get_all_internal_pages(){
	$all_pages = new WP_Query(array(
		'post_type' 		=> 'page',
		'posts_per_page' 	=> -1,
		'post_status' 		=> 'publish',
		'orderby' 			=> 'date',
		'order' 			=> 'DESC',
	)
);
	$data = $all_pages->posts;
	return $data;
}
function save_redirection($data){
	global $wpdb;
	$redirection_table = $wpdb->prefix.'corsair_redirection';
	$wpdb->insert( $redirection_table,$data);
	$last_id = $wpdb->insert_id;
	$redirection_details=$wpdb->get_row("SELECT * FROM $redirection_table WHERE id=".$last_id);
	return $redirection_details;
}
function check_redirection($user_role){
	global $wpdb;
	$redirection_table = $wpdb->prefix.'corsair_redirection';
	$redirection_details=$wpdb->get_row("SELECT * FROM $redirection_table WHERE user_role='".$user_role."'");
	return $redirection_details;
}
function redirection_details_by_id($id){
	global $wpdb;
	$redirection_table = $wpdb->prefix.'corsair_redirection';
	$redirection_details=$wpdb->get_row("SELECT * FROM $redirection_table WHERE id=".$id);
	return $redirection_details;
}
function get_all_rules(){
	global $wpdb;
	$redirection_table = $wpdb->prefix.'corsair_redirection';
	$redirection_details=$wpdb->get_results("SELECT * FROM $redirection_table");
	return $redirection_details;
}
function update_redirection($id,$data){
	global $wpdb;
	$redirection_table = $wpdb->prefix.'corsair_redirection';
	$wpdb->update($redirection_table, $data,array('id'=>$id));
	$redirection_details=$wpdb->get_row("SELECT * FROM $redirection_table WHERE id=".$id);
	return $redirection_details;
}
function delete_redirection($id){
	global $wpdb;
	$delete_item=false;
	$redirection_table = $wpdb->prefix.'corsair_redirection';
	$delete=$wpdb->query("DELETE FROM $redirection_table WHERE id=".$id);
	if($delete){
		$delete_item=true;
	}
	return $delete_item;
	
}
function get_all_redirection_rules(){
	$html='';
	$all_redirecion_rule=get_all_rules();
	if(!empty($all_redirecion_rule)){
		foreach ($all_redirecion_rule as $key_rule => $value_rule) {
			if($value_rule->url_source=='internal'){
				$link=get_the_permalink($value_rule->redirection_url);
			}
			else{
				$link=$value_rule->redirection_url;
			}
			$status=($value_rule->status == 1) ? 'checked' : '';
			$status_value=($value_rule->status == 1) ? '2' : '1';
			$html.='<tr class="role-section">';
			$html.='<td>'.ucfirst($value_rule->user_role).'</td>';
			$html.='<td>'.ucfirst($value_rule->url_source).'</td>';
			$html.='<td>'.$link.'</td>';
			$html.='<td><label class="switch"><input onclick="change_status('.$value_rule->id.','.$status_value.')" type="checkbox" '.$status.'><span class="slider round"></span></label></td>';
			$html.='<td class="action"><span class="dashicons dashicons-edit-large" title="Update Redirection" onclick="update_redirecion('.$value_rule->id.')"></span> <span class="dashicons dashicons-trash" title="Delete Redirection" onclick="delete_redirecion('.$value_rule->id.')"></span></td>';
			$html.='</tr>';
		}
	}
	else{
		$html.='<tr class="role-section">';
		$html.='<td colspan="5">'.__("Nothing Found" , "corsair-login").'</td>';
		$html.='</tr>';
	}
	return $html;
}
function get_redirection_pages($url_source){
	$html='';
	$all_pages=get_all_internal_pages();
	if($url_source!='' && $url_source=='internal'){
		$html='<select name="redirection_link" class="redirection_link">';
		$html.='<option value="">'.__("Select Page" , "corsair-login").'</option>';
		foreach ($all_pages as $key_page => $value_page) {
			
			$html.='<option value="'.$value_page->ID.'">'.get_the_title($value_page->ID).'('.$value_page->post_name.')</option>';
			
		}
		$html.='</select>';
		$html.='<span class="redirection-link-error"></span>';
	}
	elseif($url_source!='' && $url_source=='external'){
		$html='<input type="text" name="redirection_link" class="redirection_link" placeholder="'.__("Please enter external redirect url" , "corsair-login").'"/>';
		$html.='<span class="redirection-link-error"></span>';
	}
	else{
		$html='<input type="text" name="redirection_link" class="redirection_link" placeholder="'.__("Please enter external redirect url" , "corsair-login").'"/>';
		$html.='<span class="redirection-link-error"></span>';
	}
	return $html;
}
function get_selected_page($page_id,$value=''){
	$selected='';
	if($page_id==$value){
		$selected='selected';
	}
	return $selected;
}
function get_selected_source($source,$value){
	$selected='';
	if($source==$value){
		$selected='selected';
	}
	return $selected;
}
function get_redirection_update_html($id){
	$html='';
	$all_pages=get_all_internal_pages();
	$redirection_details=redirection_details_by_id($id);
	$url_source=$redirection_details->url_source;
	$user_role=$redirection_details->user_role;
	$redirection_url=$redirection_details->redirection_url;
	if($url_source!='' && $url_source=='internal' && $user_role!=''){
		$html='<h3>'.__("Update Redirection" , "corsair-login").'</h3>';
		$html.='<div class="loading-image" id="lodingimages_popup_update">';
		$html.='<img src="'.PLUGIN_URL.'/image/loading.gif">';
		$html.='</div>';
		$html.='<div class="source_section">';
		$html.='<select name="redirection_source_update" class="redirection_source_update">';
		$html.='<option value="internal" '.get_selected_source($url_source,'internal').'>'.__("Internal" , "corsair-login").'</option>';
		$html.='<option value="external" '.get_selected_source($url_source,'external').'>'.__("External" , "corsair-login").'</option>';
		$html.='</select>';
		$html.='<span class="redirection_source_update-error" style="disply:none;"></span>';
		$html.='</div>';
		$html.='<div class="redirection_section">';
		$html.='<select name="redirection_link_update" class="redirection_link_update">';
		$html.='<option value="">'.__("Select Page" , "corsair-login").'</option>';
		foreach ($all_pages as $key_page => $value_page) {
			if($redirection_url==$value_page->ID){
				$selected='selected';
			}
			else{
				$selected='';
			}
			$html.='<option value="'.$value_page->ID.'" '.$selected.'>'.get_the_title($value_page->ID).'</option>';
			
		}
		$html.='</select>';
		$html.='<span class="redirection_link_update_error" style="disply:none;"></span>';
		$html.='</div>';
		$html.='<input type="hidden" name="user_role_redirect_update" id="user_role_redirect_update" value="'.$user_role.'">';
		$html.='<input type="hidden" name="redirection_id" id="redirection_id" value="'.$id.'">';
		$html.='<span class="redirection_update-error" style="disply:none;"></span>';
		$html.='<button type="button" class="button-primary btn-redirection-update">'.esc_attr('Update', 'corsair-login').'</button>';
	}
	elseif($url_source!='' && $url_source=='external' && $user_role!=''){
		$html='<h3>Update Redirection</h3>';
		$html.='<div class="loading-image" id="lodingimages_popup_update">';
		$html.='<img src="'.PLUGIN_URL.'/image/loading.gif">';
		$html.='</div>';
		$html.='<div class="source_section">';
		$html.='<select name="redirection_source_update" class="redirection_source_update">';
		$html.='<option value="internal" '.get_selected_source($url_source,'internal').'>'.__("Internal" , "corsair-login").'</option>';
		$html.='<option value="external" '.get_selected_source($url_source,'external').'>'.__("External" , "corsair-login").'</option>';
		$html.='</select>';
		$html.='<span class="redirection_source_update-error" style="disply:none;"></span>';
		$html.='</div>';
		$html.='<div class="redirection_section">';
		$html.='<input type="text" name="redirection_link_update" class="redirection_link_update" value="'.$redirection_url.'" placeholder="'.__("Please enter external redirect url" , "corsair-login").'"/>';
		$html.='<span class="redirection_link_update_error" style="disply:none;"></span>';
		$html.='</div>';
		$html.='<input type="hidden" name="user_role_redirect_update" id="user_role_redirect_update" value="'.$user_role.'">';
		$html.='<input type="hidden" name="redirection_id" id="redirection_id" value="'.$id.'">';
		$html.='<span class="redirection_update-error" style="disply:none;"></span>';
		$html.='<button type="button" class="button-primary btn-redirection-update">'.esc_attr('Update', 'corsair-login').'</button>';
	}
	else{
		$html='<h3>Update Redirection</h3>';
		$html.='<div class="loading-image" id="lodingimages_popup_update">';
		$html.='<img src="'.PLUGIN_URL.'/image/loading.gif">';
		$html.='</div>';
		$html.='<div class="source_section">';
		$html.='<select name="redirection_source_update" class="redirection_source_update">';
		$html.='<option value="internal" '.get_selected_source($url_source,'internal').'>Internal</option>';
		$html.='<option value="external" '.get_selected_source($url_source,'external').'>External</option>';
		$html.='</select>';
		$html.='<span class="redirection_source_update-error" style="disply:none;"></span>';
		$html.='</div>';
		$html.='<div class="redirection_section">';
		$html.='<input type="text" name="redirection_link_update" class="redirection_link_update" value="'.$redirection_url.'" placeholder="'.__("Please enter external redirect url" , "corsair-login").'"/>';
		$html.='<span class="redirection_link_update_error" style="disply:none;"></span>';
		$html.='</div>';
		$html.='<input type="hidden" name="user_role_redirect_update" id="user_role_redirect_update" value="'.$user_role.'">';
		$html.='<input type="hidden" name="redirection_id" id="redirection_id" value="'.$id.'">';
		$html.='<span class="redirection_update-error" style="disply:none;"></span>';
		
		$html.='<button type="button" class="button-primary btn-redirection-update">'.esc_attr('Update', 'corsair-login').'</button>';
		
	}
	return $html;
}
function link_html_by_source($url_source){
	$html='';
	$all_pages=get_all_internal_pages();
	if($url_source!='' && $url_source=='internal'){
		$html='<select name="redirection_link_update" class="redirection_link_update">';
		$html.='<option value="">'.__("Select Page" , "corsair-login").'</option>';
		foreach ($all_pages as $key_page => $value_page) {
			
			$html.='<option value="'.$value_page->ID.'">'.get_the_title($value_page->ID).'('.$value_page->post_name.')</option>';
			
		}
		$html.='</select>';
		$html.='<span class="redirection_link_update_error" style="disply:none;"></span>';
	}
	elseif($url_source!='' && $url_source=='external'){
		$html='<input type="text" name="redirection_link_update" class="redirection_link_update" value="'.$redirection_url.'" placeholder="'.__("Please enter external redirect url" , "corsair-login").'"/>';
		$html.='<span class="redirection_link_update_error" style="disply:none;"></span>';
	}
	else{
		$html='<input type="text" name="redirection_link_update" class="redirection_link_update" value="'.$redirection_url.'" placeholder="'.__("Please enter external redirect url" , "corsair-login").'"/>';
		$html.='<span class="redirection_link_update_error" style="disply:none;"></span>';
	}
	return $html;
}
add_action( 'wp_ajax_nopriv_link_by_source', 'link_by_source' );
add_action( 'wp_ajax_link_by_source', 'link_by_source' );
function link_by_source(){
	$status=fasle;
	$html='';
	if(isset($_POST['action'])){
		$html=link_html_by_source($_POST['url_source']);
		$status=true;
	}
	$response = array('status' => $status, 'html' => $html);
	wp_send_json($response);
	exit;
}
add_action( 'wp_ajax_nopriv_get_redirection_popup', 'get_redirection_popup' );
add_action( 'wp_ajax_get_redirection_popup', 'get_redirection_popup' );
function get_redirection_popup(){
	$status=fasle;
	$html='';
	if(isset($_POST['action'])){
		$html=get_redirection_pages($_POST['url_source']);
		$status=true;
	}
	$response = array('status' => $status, 'html' => $html);
	wp_send_json($response);
	exit;
}
add_action( 'wp_ajax_nopriv_update_redirection_popup', 'update_redirection_popup' );
add_action( 'wp_ajax_update_redirection_popup', 'update_redirection_popup' );
function update_redirection_popup(){
	$status=fasle;
	$html='';
	if(isset($_POST['action'])){
		$html=get_redirection_update_html($_POST['id']);
		$status=true;
	}
	$response = array('status' => $status, 'html' => $html);
	wp_send_json($response);
	exit;
}
add_action( 'wp_ajax_nopriv_add_redirection', 'add_redirection' );
add_action( 'wp_ajax_add_redirection', 'add_redirection' );
function add_redirection(){
	$status=fasle;
	$html='';
	$message='';
	if(isset($_POST['action'])){
		$data=array(
			'redirection_url'=>$_POST['link'],
			'url_source'=>$_POST['url_source'],
			'user_role'=>$_POST['user_role'],
			'status'=>1
		);
		
		$check_redirection=check_redirection($_POST['user_role']);
		if(!empty($check_redirection)){
			$status=false;
			$message='aleady_exist';
			$html.='<tr>';
			$html.='<th>'.__("User Role" , "corsair-login").'</th>';
			$html.='<th>'.__("URL Source" , "corsair-login").'</th>';
			$html.='<th>'.__("Redirection Link" , "corsair-login").'</th>';
			$html.='<th>Status<span class="tooltip"><span class="tooltiptext">'.__("Drag to change status, Redirection will not work utill it is inactive" , "corsair-login").'</span></span></th>';
			$html.='<th>'.__("Action" , "corsair-login").'</th>';
			$html.='</tr>';
			$html.=get_all_redirection_rules();
		}
		else{
			$save_data=save_redirection($data);
			if(!empty($save_data)){
				$status=true;
				$message='success';
				$html.='<tr>';
				$html.='<th>'.__("User Role" , "corsair-login").'</th>';
				$html.='<th>'.__("URL Source" , "corsair-login").'</th>';
				$html.='<th>'.__("Redirection Link" , "corsair-login").'</th>';
				$html.='<th>Status<span class="tooltip"><span class="tooltiptext">'.__("Drag to change status, Redirection will not work utill it is inactive" , "corsair-login").'</span></span></th>';
				$html.='<th>'.__("Action" , "corsair-login").'</th>';
				$html.='</tr>';
				$html.=get_all_redirection_rules();
			}
			else{
				$status=false;
				$message='error';
				$html.='<tr>';
				$html.='<th>'.__("User Role" , "corsair-login").'</th>';
				$html.='<th>'.__("URL Source" , "corsair-login").'</th>';
				$html.='<th>'.__("Redirection Link" , "corsair-login").'</th>';
				$html.='<th>Status<span class="tooltip"><span class="tooltiptext">'.__("Drag to change status, Redirection will not work utill it is inactive" , "corsair-login").'</span></span></th>';
				$html.='<th>'.__("Action" , "corsair-login").'</th>';
				$html.='</tr>';
				$html.=get_all_redirection_rules();
			}
		}
	}
	$response = array('status' => $status, 'html' => $html,'message' => $message);
	wp_send_json($response);
	exit;
}
add_action( 'wp_ajax_nopriv_uppdate_redirection_rules', 'uppdate_redirection_rules' );
add_action( 'wp_ajax_uppdate_redirection_rules', 'uppdate_redirection_rules' );
function uppdate_redirection_rules(){
	$status=fasle;
	$html='';
	$message='';
	if(isset($_POST['action'])){
		$id=$_POST['id'];
		$data=array(
			'redirection_url'=>$_POST['link'],
			'url_source'=>$_POST['url_source'],
		);
		
		$update_redirection=update_redirection($id,$data);
		if(!empty($update_redirection)){
			$status=true;
			$message='success';
			$html.='<tr>';
			$html.='<th>'.__("User Role" , "corsair-login").'</th>';
			$html.='<th>'.__("URL Source" , "corsair-login").'</th>';
			$html.='<th>'.__("Redirection Link" , "corsair-login").'</th>';
			$html.='<th>Status<span class="tooltip"><span class="tooltiptext">'.__("Drag to change status, Redirection will not work utill it is inactive" , "corsair-login").'</span></span></th>';
			$html.='<th>'.__("Action" , "corsair-login").'</th>';
			$html.='</tr>';
			$html.=get_all_redirection_rules();
		}
		
		else{
			$status=false;
			$message='error';
			$html.='<tr>';
			$html.='<th>'.__("User Role" , "corsair-login").'</th>';
			$html.='<th>'.__("URL Source" , "corsair-login").'</th>';
			$html.='<th>'.__("Redirection Link" , "corsair-login").'</th>';
			$html.='<th>Status<span class="tooltip"><span class="tooltiptext">'.__("Drag to change status, Redirection will not work utill it is inactive" , "corsair-login").'</span></span></th>';
			$html.='<th>'.__("Action" , "corsair-login").'</th>';
			$html.='</tr>';
			$html.=get_all_redirection_rules();
		}
		
	}
	$response = array('status' => $status, 'html' => $html,'message' => $message);
	wp_send_json($response);
	exit;
}
add_action( 'wp_ajax_nopriv_delete_redirection_rule', 'delete_redirection_rule' );
add_action( 'wp_ajax_delete_redirection_rule', 'delete_redirection_rule' );
function delete_redirection_rule(){
	$status=false;
	$html='';
	$message='';
	if(isset($_POST['action'])){
		$id=$_POST['id'];
		$delete_redirection=delete_redirection($id);
		
		$status=true;
		$message='success';
		$html.='<tr>';
		$html.='<th>'.__("User Role" , "corsair-login").'</th>';
		$html.='<th>'.__("URL Source" , "corsair-login").'</th>';
		$html.='<th>'.__("Redirection Link" , "corsair-login").'</th>';
		$html.='<th>Status<span class="tooltip"><span class="tooltiptext">'.__("Drag to change status, Redirection will not work utill it is inactive" , "corsair-login").'</span></span></th>';
		$html.='<th>'.__("Action" , "corsair-login").'</th>';
		$html.='</tr>';
		$html.=get_all_redirection_rules();
	}
	$response = array('status' => $status, 'html' => $html,'message' => $message);
	wp_send_json($response);
	exit;
}
add_action( 'wp_ajax_nopriv_update_status_redirection', 'update_status_redirection' );
add_action( 'wp_ajax_update_status_redirection', 'update_status_redirection' );
function update_status_redirection(){
	$status=false;
	$html='';
	$message='';
	if(isset($_POST['action'])){
		$id=$_POST['id'];
		$data=array(
			'status'=>$_POST['status']
		);
		
		$update_redirection=update_redirection($id,$data);
		if(!empty($update_redirection)){
			$status=true;
			$message='success';
			$html.='<tr>';
			$html.='<th>'.__("User Role" , "corsair-login").'</th>';
			$html.='<th>'.__("URL Source" , "corsair-login").'</th>';
			$html.='<th>'.__("Redirection Link" , "corsair-login").'</th>';
			$html.='<th>Status<span class="tooltip"><span class="tooltiptext">'.__("Drag to change status, Redirection will not work utill it is inactive" , "corsair-login").'</span></span></th>';
			$html.='<th>'.__("Action" , "corsair-login").'</th>';
			$html.='</tr>';
			$html.=get_all_redirection_rules();
		}
		
		else{
			$status=false;
			$message='error';
			$html.='<tr>';
			$html.='<th>'.__("User Role" , "corsair-login").'</th>';
			$html.='<th>'.__("URL Source" , "corsair-login").'</th>';
			$html.='<th>'.__("Redirection Link" , "corsair-login").'</th>';
			$html.='<th>Status<span class="tooltip"><span class="tooltiptext">'.__("Drag to change status, Redirection will not work utill it is inactive" , "corsair-login").'</span></span></th>';
			$html.='<th>'.__("Action" , "corsair-login").'</th>';
			$html.='</tr>';
			$html.=get_all_redirection_rules();
		}
		
	}
	$response = array('status' => $status, 'html' => $html,'message' => $message);
	wp_send_json($response);
	exit;
}
/**
 * ajax login script 28-03-2023
 */
function corsairlogin_client_ip(){
	global $corsairlogin_client_ip;
	if (!is_null($corsairlogin_client_ip)) {
		// We've already discovered the browser's IP address.
	} elseif (!empty($_SERVER['HTTP_CLIENT_IP'])) {
		$corsairlogin_client_ip = filter_var($_SERVER['HTTP_CLIENT_IP'], FILTER_VALIDATE_IP);
	} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
		$corsairlogin_client_ip = filter_var($_SERVER['HTTP_X_FORWARDED_FOR'], FILTER_VALIDATE_IP);
	} else {
		$corsairlogin_client_ip = filter_var($_SERVER['REMOTE_ADDR'], FILTER_VALIDATE_IP);
	}
	return $corsairlogin_client_ip;
}

add_action('wp_ajax_nopriv_check_user_country', 'check_user_country_cb');
function check_user_country_cb(){

	$out = array( "error" => 1,'msg' => __('Something went wrong.','corsair-login') );
	if (filter_var($_POST['user_email'], FILTER_VALIDATE_EMAIL)) {
		$check_user = get_user_by( 'email', $_POST['user_email'] );
	}else{
		$check_user = get_user_by( 'login', $_POST['user_email'] );
	}

	$body = [
		'email'	=>	$check_user->user_email,
	];
	$response = amplivo_api_send_requests( $body, 'get-user-data');

	if( $response['success'] == true ){
		$result = $response['result'];

		if($result['Country'] == 'canada' || $result['Country'] == 'Canada')
		{
			$out = array( "error" => 0,"isCanada"=>true,'msg' => __('User is from canada.','corsair-login') );
		}
	}
	else
	{
		$out = array( "error" => 1,'msg' => __('User data not found.','corsair-login') );
	}

	wp_send_json($out);
	exit;
}


add_action('wp_ajax_nopriv_corsair_user_login', 'corsair_login_try_to_login_action');
function corsair_login_try_to_login_action(){
	if (empty($client_ip_address = corsairlogin_client_ip())) {
		die();
	}
	global $wpdb;
	$tableKyc = $wpdb->prefix.'kyc_data';
	$client_key = 'login_attempt_' . $client_ip_address;
	$clientResendKey = 'resend_attempt_' . $client_ip_address;
	$status_code = 200;
	$response = array(
		'isLoggedIn' => false,
		'isResetRequested' => false,
		'pwdin' => false,
		'isOtpSend' => false,
		'isincorrectup' => false,
		'errorMessage' => '',
		'infoMessage' => '',
	);
	$routine_maintenance = get_option('cip_routine_maintenance_mode'); //live
	$site_maintenance = get_option('cip_site_maintenance_mode'); //whole
	$sitelogin = 0;
		if (filter_var($_POST['user_email'], FILTER_VALIDATE_EMAIL)) {
			$check_user = get_user_by( 'email', $_POST['user_email'] );
		}else{
			$check_user = get_user_by( 'login', $_POST['user_email'] );
		}
	if(!in_array( 'administrator', $check_user->roles, true ) && !in_array( 'supportmanager', $check_user->roles, true )){
		$data = corsair_validation_users_from_sourceapi($_POST['user_email'],$_POST['user_password']);

		$sitelogin = 1;
		if($data->success == true){
			if (!filter_var($_POST['user_email'], FILTER_VALIDATE_EMAIL)) {
				$amplivo_api_mode = get_option( 'amplivo_api_mode' );
				if($amplivo_api_mode == 'live'){
					$sourceUrl = get_option( 'amplivo_api_live_source_url' ).'userstatus/get';
				}else{
					$sourceUrl = get_option( 'amplivo_api_test_source_url' ).'userstatus/get';
				}
				$request_url = add_query_arg( 'username', $_POST['user_email'], $sourceUrl );
			
				$responseApi = wp_remote_get( $request_url );
			
				$response_body = wp_remote_retrieve_body( $responseApi );
			
				$data = json_decode( $response_body );
			
				$_POST['user_email'] = $data->Email;
				$user_email = $data->Email;
			}else{
				$amplivo_api_mode = get_option( 'amplivo_api_mode' );
				if($amplivo_api_mode == 'live'){
					$sourceUrl = get_option( 'amplivo_api_live_source_url' ).'userstatus/get';
				}else{
					$sourceUrl = get_option( 'amplivo_api_test_source_url' ).'userstatus/get';
				}
				$request_url = add_query_arg( 'email', urlencode($_POST['user_email']), $sourceUrl );
			
				$responseApi = wp_remote_get( $request_url );
			
				$response_body = wp_remote_retrieve_body( $responseApi );
			
				$data = json_decode( $response_body );
			
				$_POST['user_email'] = $data->Email;
				$user_email = $data->Email;
			}

			// check if user is from canada
			$body = [
				'email'	=>	$data->Email,
			];
			$responseUserGet = amplivo_api_send_requests( $body, 'get-user-data');

			if( $responseUserGet['success'] == true ){
				$result = $responseUserGet['result'];
    if(!in_array( 'supportagent', $check_user->roles, true ))
                {
				if($result['Country'] != 'canada' && $result['Country'] != 'Canada')
				{
					$response = array( "error" => 1, "isNotCanada"=>true ,'msg' => __('User is not of Canadian origin.','corsair-login') );
					return wp_send_json(
						$response,
						$status_code
					);

				}}
			}
			// check if user is from canada end

			$user_email = $_POST['user_email'];
			if( email_exists( $user_email ) ){
				$user = get_user_by( 'email', $user_email );
				if( $routine_maintenance == 1 || $site_maintenance == 1){
					if( !empty( $user_email )){
						$user = get_user_by( 'email', $user_email );
						$allowed_roles = array('supportmanager', 'supportagent');
						if( !array_intersect($allowed_roles, $user->roles ) ) {
							$response['errorMessage'] = "Site in maintenance, you cannot log in at this time. Please try again later.";
							$response['maintenace'] = true;
							wp_send_json(
								$response,
								$status_code
							);
							die();
						}	
					}
				}
				$isSupportManagerAgent = false;
				if( $user instanceof WP_User ) {
					$user_id = $user->ID;
					if( in_array( 'supportmanager', $user->roles ) || in_array( 'supportagent', $user->roles ) ){
						$isSupportManagerAgent = true;
					}
				}
				if( $isSupportManagerAgent === true ){
					$isLoginEnable = 1; //by pass manager / agent
				}else{
					$isLoginEnable = get_user_meta( $user_id, 'csrnow_login_enable', true );
				}
				if( $isLoginEnable != 1 ){
					$response['errorMessage'] = __('Your account has been temporarily suspended.<br/>Please contact support.', 'corsair-login');
				}else{
					$response['pwdin'] = true;
				}
			} else {
				$foundUser = corsair_validation_users_from_sourceapi($_POST['user_email'],$_POST['user_password']);  
				if( $foundUser->success == true ){
					$response['pwdin'] = true;
					$user_password = wp_generate_password( 12, false );
					$user = wp_create_user( $data->Username, $user_password, $user_email );
					wp_update_user(array(
						'ID' => $user,
						'first_name' => $data->user_first_name,
						'last_name' => $data->user_last_name,
					));
					if( $routine_maintenance == 1 || $site_maintenance == 1){
						if( !empty( $user_email )){
							$user = get_user_by( 'email', $user_email );
							$allowed_roles = array('supportmanager', 'supportagent');
							if( !array_intersect($allowed_roles, $user->roles ) ) {
								$response['errorMessage'] = "Site in maintenance, you cannot log in at this time. Please try again later.";
								$response['maintenace'] = true;
								wp_send_json(
									$response,
									$status_code
								);
								die();
							}	
						}
					}
					if( !is_wp_error($user) ){
						$user = get_user_by( 'email', $user_email );
						if( $user ) {
							// if( $user instanceof WP_User ) {
							$user->add_role( 'member' );
							$user->remove_role( 'subscriber' );
							$user_id = $user->ID;
							$user_info = get_userdata($user_id);
							update_user_meta( $user_id, 'csrnow_login_enable', 1 );
							$unique = get_password_reset_key( $user_info );
							$unique_url = network_site_url("wp-login.php?action=rp&key=$unique&login=" . rawurlencode($user_info->user_login), 'login');

							$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
							$siteUrl = get_bloginfo('url');
							$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
							add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
							add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
							add_filter('wp_mail_content_type', function(){ return "text/html"; } );

							$subject = sprintf(__("%s - Reset Password Link", 'corsair-login'), $blogname);
					
							$htmlurl = CLOG_PLUGIN_URL.'mail_template.html';
							$htmlContent = file_get_contents($htmlurl);
							$unique_url_txt = disable_email_link( $unique_url );

							$message = sprintf(__('<br><p>This is an e-mail from %s.</p> <p>You are receiving this email because we received a password reset request for your account.</p><br/> <p><a href="%s" target="_blank" REPLACE_STYLE>Reset Password</a></p><br/>If the button above does not work, paste this link into your web browser: <br> %s <br> If you did not make this request, you can safely ignore this e-mail.<br/><p>This is an automated message, please do not reply.</p><br/><p>Best regards,<br/>Amplivo</p>', 'corsair-login'),$blogname, esc_url($unique_url), $unique_url_txt );
							$corsair_emailtmpl_logo = ( get_option( 'corsair_emailtmpl_logo' ) ) ? get_option( 'corsair_emailtmpl_logo') : '';
							$corsair_emailtmpl_basecolor = ( get_option( 'corsair_emailtmpl_basecolor' ) ) ? get_option( 'corsair_emailtmpl_basecolor') : '';
							$corsair_emailtmpl_headercss = ( get_option( 'corsair_emailtmpl_headercss' ) ) ? get_option( 'corsair_emailtmpl_headercss') : '';
							
							$htmlContent = str_replace('REPLACE_MESSAGE', $message, $htmlContent);
							$htmlContent = str_replace('REPLACE_SITEURL', site_url(), $htmlContent);
							$htmlContent = str_replace('REPLACE_COPYRIGHT', 'Copyright © Amplivo  '.date('Y').'. All rights reserved.', $htmlContent);
							$htmlContent = str_replace('REPLACE_HEADER_LOGO', $corsair_emailtmpl_logo, $htmlContent);
							$htmlContent = str_replace('REPLACE_STYLE', 'style="font-size: 18px; font-family: Google Sans, Arial, Helvetica, sans-serif; color: #ffffff; text-decoration: none; padding: 6px 24px; display: inline-block;'.$corsair_emailtmpl_basecolor.'"', $htmlContent);
							$htmlContent = str_replace('REPLACE_FOOTER_STYLE', $corsair_emailtmpl_basecolor, $htmlContent);
							$htmlContent = str_replace('REPLACE_HEADER_STYLE', $corsair_emailtmpl_headercss, $htmlContent);
							update_user_meta( $user_id, 'cssetautologin', 1 );
						/*	$sent_mail = wp_mail( $user_email, $subject, $htmlContent );

							if ( !$sent_mail ){
								$response['errorMessage'] = __('There was a problem sending you email. Please try again or contact an admin.', 'corsair-login');
							}else{
								update_user_meta( $user_id, 'cssetautologin', 1 );
							} */
							
						}else{
							$response['errorMessage'] = __('Something went wrong. Please try again.');
						}
					}else{
						$response['errorMessage'] = "Use your Amplivo.com email / username and password to login.";
					}

				}else{
					$response['errorMessage'] = 'Email address not found.<br/>Use your Amplivo Canada email to register.';
				}
			}
		}else{
			$response['errorMessage'] = "Use your Amplivo.com email / username and password to login.";
		}
		if(isset($response['errorMessage']) && $response['errorMessage'] != ""){
			wp_send_json(
				$response,
				$status_code
			);
			die();
		}
	}
	if( wp_verify_nonce( $_POST['micro_nonce'],'corsair_login_request' ) ){
		if( !empty( $_POST['user_email'] ) && ( !isset( $_POST['user_password'] ) || empty( $_POST['user_password'] ) ) ){ // check email for reset or enter password
			if ((get_transient($client_key) !== false)) {
				$response['errorMessage'] = 'Slow down a bit';
			} elseif (empty($user_email = $_POST['user_email'])) {
				$response['errorMessage'] = 'No user email';
			} elseif( !filter_var($user_email, FILTER_VALIDATE_EMAIL) ){
				$response['errorMessage'] = 'Invalid email';
			} elseif( email_exists( $user_email ) ){
				$user = get_user_by( 'email', $user_email );
				$isSupportManagerAgent = false;
				if( $user instanceof WP_User ) {
					$user_id = $user->ID;
					if( in_array( 'supportmanager', $user->roles ) || in_array( 'supportagent', $user->roles ) ){
						$isSupportManagerAgent = true;
					}
				}
				if( $isSupportManagerAgent === true ){
					$isLoginEnable = 1; //by pass manager / agent
				}else{
					$isLoginEnable = get_user_meta( $user_id, 'csrnow_login_enable', true );
				}
				if( $isLoginEnable != 1 ){
					$response['errorMessage'] = __('Your account has been temporarily suspended.<br/>Please contact support.', 'corsair-login');
				}else{
					$response['pwdin'] = true;
				}
			} else {
				$foundUser = corsair_get_users_from_sourceapi( $user_email );
				
				if( $foundUser ){
					$user_password = wp_generate_password( 12, false );
					$user = wp_create_user( $user_email, $user_password, $user_email );
					if( $routine_maintenance == 1 || $site_maintenance == 1){
						if( !empty( $user_email )){
							$user = get_user_by( 'email', $user_email );
							$allowed_roles = array('supportmanager', 'supportagent');
							if( !array_intersect($allowed_roles, $user->roles ) ) {
								$response['errorMessage'] = "Site in maintenance, you cannot log in at this time. Please try again later.";
								$response['maintenace'] = true;
								wp_send_json(
									$response,
									$status_code
								);
								die();
							}	
						}
					}
					if( !is_wp_error($user) ){
						$user = get_user_by( 'email', $user_email );
						if( $user ) {
							// if( $user instanceof WP_User ) {
							$user->add_role( 'member' );
							$user->remove_role( 'subscriber' );
							$user_id = $user->ID;
							$user_info = get_userdata($user_id);
							update_user_meta( $user_id, 'csrnow_login_enable', 1 );
							$unique = get_password_reset_key( $user_info );
							$unique_url = network_site_url("wp-login.php?action=rp&key=$unique&login=" . rawurlencode($user_info->user_login), 'login');
	
							$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
							$siteUrl = get_bloginfo('url');
							$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
							add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
							add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
							add_filter('wp_mail_content_type', function(){ return "text/html"; } );
	
							$subject = sprintf(__("%s - Reset Password Link", 'corsair-login'), $blogname);
					
							$htmlurl = CLOG_PLUGIN_URL.'mail_template.html';
							$htmlContent = file_get_contents($htmlurl);
							$unique_url_txt = disable_email_link( $unique_url );
	
							$message = sprintf(__('<br><p>This is an e-mail from %s.</p> <p>You are receiving this email because we received a password reset request for your account.</p><br/> <p><a href="%s" target="_blank" REPLACE_STYLE>Reset Password</a></p><br/>If the button above does not work, paste this link into your web browser: <br> %s <br> If you did not make this request, you can safely ignore this e-mail.<br/><p>This is an automated message, please do not reply.</p><br/><p>Best regards,<br/>Amplivo</p>', 'corsair-login'),$blogname, esc_url($unique_url), $unique_url_txt );
							$corsair_emailtmpl_logo = ( get_option( 'corsair_emailtmpl_logo' ) ) ? get_option( 'corsair_emailtmpl_logo') : '';
							$corsair_emailtmpl_basecolor = ( get_option( 'corsair_emailtmpl_basecolor' ) ) ? get_option( 'corsair_emailtmpl_basecolor') : '';
							$corsair_emailtmpl_headercss = ( get_option( 'corsair_emailtmpl_headercss' ) ) ? get_option( 'corsair_emailtmpl_headercss') : '';
							
							$htmlContent = str_replace('REPLACE_MESSAGE', $message, $htmlContent);
							$htmlContent = str_replace('REPLACE_SITEURL', site_url(), $htmlContent);
							$htmlContent = str_replace('REPLACE_COPYRIGHT', 'Copyright © Amplivo  '.date('Y').'. All rights reserved.', $htmlContent);
							$htmlContent = str_replace('REPLACE_HEADER_LOGO', $corsair_emailtmpl_logo, $htmlContent);
							$htmlContent = str_replace('REPLACE_STYLE', 'style="font-size: 18px; font-family: Google Sans, Arial, Helvetica, sans-serif; color: #ffffff; text-decoration: none; padding: 6px 24px; display: inline-block;'.$corsair_emailtmpl_basecolor.'"', $htmlContent);
							$htmlContent = str_replace('REPLACE_FOOTER_STYLE', $corsair_emailtmpl_basecolor, $htmlContent);
							$htmlContent = str_replace('REPLACE_HEADER_STYLE', $corsair_emailtmpl_headercss, $htmlContent);
								update_user_meta( $user_id, 'cssetautologin', 1 );
						/*	$sent_mail = wp_mail( $user_email, $subject, $htmlContent );
	
							if ( !$sent_mail ){
								$response['errorMessage'] = __('There was a problem sending you email. Please try again or contact an admin.', 'corsair-login');
							}else{
								update_user_meta( $user_id, 'cssetautologin', 1 );
							} */
							
						}else{
							$response['errorMessage'] = __('Something went wrong. Please try again.');
						}
					}else{
						$response['errorMessage'] = "Use your Amplivo.com email / username and password to login.";
					}
	
				}else{
					$response['errorMessage'] = 'Email address not found.<br/>Use your Amplivo Canada email to register.';
				}
				
				
			}
		}else{ //regular login script
			if ((get_transient($client_key) !== false)) {
				$response['errorMessage'] = 'Slow down a bit';
			} elseif (empty($user_email = $_POST['user_email'])) {
				$response['errorMessage'] = 'No user email';
			} elseif (empty($user_password = $_POST['user_password'])) {
				$response['errorMessage'] = 'No password';
			} elseif( !filter_var($user_email, FILTER_VALIDATE_EMAIL) ){
				$response['errorMessage'] = 'Invalid email';
			} elseif ((isset($response['pwdin']) && $response['pwdin'] != true) && $sitelogin == 1) {
				$response['errorMessage'] = 'Invalid email or password';
				$response['isincorrectup'] = true;
			}else {
				if($sitelogin == 1){
					$token = wp_generate_password(24, false);

					// Update user's password to a temporary token
					wp_set_password($token, $user->ID);
					$user_password = $token;
				}
				$user = wp_authenticate($user_email, $user_password);
				if( !is_wp_error($user) ){
					$user_id = $user->ID;
					$isSupportManagerAgent = false;
					if( in_array( 'supportmanager', $user->roles ) || in_array( 'supportagent', $user->roles ) ){
						$isSupportManagerAgent = true;
					}
					if( $isSupportManagerAgent === true ){
						$isLoginEnable = 1; //by pass manager / agent
					}else{
						$isLoginEnable = get_user_meta( $user_id, 'csrnow_login_enable', true );
					}
					if( $isLoginEnable != 1 ){
						$response['errorMessage'] = __('Your account has been temporarily suspended.<br/>Please contact support.', 'corsair-login');
						wp_send_json(
							$response,
							$status_code
						);
						exit;
					}
					$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
					$siteUrl = get_bloginfo('url');
					$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
					add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
					add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
					add_filter( 'wp_mail_content_type', function(){ return "text/html"; } );
					if($user){
						$remember = ( isset( $_POST['remember'] ) && $_POST['remember'] == 1 ) ? true : false;
						$user_id = $user->ID;
						$isLoginType = get_login_auth_type( $user_id );
						
						if( $isLoginType['status'] == true && $isLoginType['type'] == 'both' ){
							if( isset( $_POST['switch_method'] ) && !empty( $_POST['switch_method'] ) ){
								$decryptedSwitchRaw = base64_decode( $_POST['switch_method'] );
								if( $decryptedSwitchRaw == md5( 'Email_OTP_Switch' ) ){ //switch to email
									$isLoginType['type'] = 'otp';
								}else if( $decryptedSwitchRaw == md5( 'Google_2FA_Switch' ) ){ //switch to google 2fa
									$isLoginType['type'] = '2fa';
								}else{
									$response['errorMessage'] = __('User authentication failed. Please try again or contact an admin', 'corsair-login');
								}
							}else{
								if( isset( $_POST['activetype'] ) && !empty( $_POST['activetype'] ) ){
									$decryptedActiveType = base64_decode( $_POST['activetype'] );
									if( $decryptedActiveType == md5( 'EmailOtp' ) ){ //continue to email otp
										$isLoginType['type'] = 'otp';
									}else if( $decryptedActiveType == md5( 'GoogleAuth2FA' ) ){ //continue to google 2FA
										$isLoginType['type'] = '2fa';
									}else{
										$response['errorMessage'] = __('User authentication failed. Please try again or contact an admin', 'corsair-login');
									}
								}else{
									$isLoginType['type'] = '2fa';
								}
							}
						}
						if( $isLoginType['status'] == true && $isLoginType['type'] == 'otp' ){
							if( isset( $_POST['resendOtpAct'] ) && $_POST['resendOtpAct'] == 1 ){ //resend OTP
								if ((get_transient($clientResendKey) !== false)) {
									$response['errorMessage'] = __('You can resend OTP after timer reset', 'corsair-login');
								}else{
									$decryptedIdRaw = base64_decode( $_POST['microtoken'] );
									$decryptedUserId = preg_replace(sprintf('/%s/', md5('CL_RESEND_CL') ), '', $decryptedIdRaw);
									if( $decryptedUserId == $user_id ){
										$user_otp = sprintf("%'.06d",mt_rand(0,999999));
										$user_otp_expiration = date("Y-m-d H:i" ,strtotime(date('Y-m-d H:i')." +30 mins"));
										$otp_resend_time = date("Y-m-d H:i:s" ,strtotime(date('Y-m-d H:i:s')." +1 min"));
										update_user_meta( $user_id, 'user_otp', $user_otp );
										update_user_meta( $user_id, 'user_otp_expiration', $user_otp_expiration );
										$siteUrl = get_bloginfo('url');
										$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
										add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
										add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
										add_filter( 'wp_mail_content_type', function(){ return "text/html"; } );
										$subject = sprintf(__("%s - Email OTP Verification", 'corsair-login'), $blogname);
										$message = sprintf(__('<h2>You are Attempting to Login in %s</h2><p>Here is your OTP (One-Time-Passcode) to login.</p><h3><b>%s</b></h3><br/><p>This is an automated message, please do not reply.</p><p>Best regards,<br/>Amplivo</p>', 'corsair-login' ), $siteUrlName, $user_otp );
										$htmlContent = mailTemplateHtmlRender( $message );
										$sent_mail = wp_mail( $user->user_email, $subject, $htmlContent );
										if( $sent_mail ){
											$response['isOtpSend'] = true;
											$encryptId = base64_encode( $user->ID . md5('CL_RESEND_CL'));
											$encryptSwitchType = base64_encode( md5('Google_2FA_Switch') );
											$activeType = base64_encode( md5('EmailOtp') );
											set_transient($clientResendKey, '1', 60);
											ob_start();
											?>
											<input type="hidden" name="microtoken" value="<?php echo $encryptId; ?>"  />
											<input type="hidden" name="activetype" value="<?php echo $activeType; ?>"  />
											<div class="otp_section pb-3">
												<label for="user_email"><?php echo __('Please enter the OTP', 'corsair-login'); ?></label>
												<input type="text" name="user_otp" id="user_otp" class="input" maxlength="6" pattern="{0-9}+" />
												<small class="form-text text-muted"><?php _e('Enter the 6-digit verification code sent to your email.') ?></small>
											</div>
											<input type="submit" name="wpa-submit-verify" id="wpa-submit-verify" class="btn btn-primary" value="<?php echo __('Verify OTP', 'corsair-login'); ?>" />
											<a class="btn btn-primary bg-gradient disabled" data-stat="countdown" href="javascript:void(0);" id="resend" disabled><?= time() < strtotime($otp_resend_time) ? 'Resend in '.(strtotime($otp_resend_time) - time()).' s' : 'Resend OTP' ?></a>
											<script>
												jQuery(document).ready(function($){
													var is_countdown_resend = $('body').find('#resend').attr('data-stat') == 'countdown';
													if(is_countdown_resend){
														var sec = parseInt('<?= time() < strtotime($otp_resend_time) ? (strtotime($otp_resend_time) - time()) : 0 ?>');
														var countdown = setInterval(() => {
															if(sec > 0){
																sec--;
																$('#resend').text("Resend in "+(sec)+' s')
															}else{
																$('#resend').attr('data-stat','').removeClass('disabled').text('Resend OTP')
																clearInterval(countdown)
															}
														}, 1000);
													}
												});
											</script>
											<?php
											if( $isLoginType['switch'] === true ){
												?><div class="switch-section"><a href="javascript:void(0);" class="switch-method" data-type="<?php echo $encryptSwitchType; ?>"><?php echo __('Switch to another verification method', 'corsair-login'); ?></a></div><?php
											}
											$otpContent = ob_get_clean();
											$response['otpContent'] = $otpContent;
										}else{
											$response['errorMessage'] = __('There was a problem sending OTP to your email. Please try again or contact an admin.', 'corsair-login');
										}
									}else{
										$response['errorMessage'] = __('User authentication failed. Please try again or contact an admin', 'corsair-login');
									}
								}
							}else if( !isset( $_POST['user_otp'] ) ){ //send OTP to user email
								$user_otp = sprintf("%'.06d",mt_rand(0,999999));
                				$user_otp_expiration = date("Y-m-d H:i" ,strtotime(date('Y-m-d H:i')." +30 mins"));
                				$otp_resend_time = date("Y-m-d H:i:s" ,strtotime(date('Y-m-d H:i:s')." +1 min"));
								update_user_meta( $user_id, 'user_otp', $user_otp );
								$siteUrl = get_bloginfo('url');
								$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
								add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
								add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
								add_filter( 'wp_mail_content_type', function(){ return "text/html"; } );
								update_user_meta( $user_id, 'user_otp_expiration', $user_otp_expiration );
								$subject = sprintf(__("%s - Email OTP Verification", 'corsair-login'), $blogname);
								$message = sprintf(__('<h2>You are Attempting to Login in %s</h2><p>Here is your OTP (One-Time-Passcode) to login.</p><h3><b>%s</b></h3><br/><p>This is an automated message, please do not reply.</p><p>Best regards,<br/>Amplivo</p>', 'corsair-login' ), $siteUrlName, $user_otp );
								$htmlContent = mailTemplateHtmlRender( $message );
								$sent_mail = wp_mail( $user->user_email, $subject, $htmlContent );
								if( $sent_mail ){
									$response['isOtpSend'] = true;
									$encryptId = base64_encode( $user->ID . md5('CL_RESEND_CL'));
									$encryptSwitchType = base64_encode( md5('Google_2FA_Switch') );
									$activeType = base64_encode( md5('EmailOtp') );
									set_transient($clientResendKey, '1', 60);
									ob_start();
									?>
									<input type="hidden" name="microtoken" value="<?php echo $encryptId; ?>"  />
									<input type="hidden" name="activetype" value="<?php echo $activeType; ?>"  />
									<div class="otp_section pb-3">
										<label for="user_email"><?php echo __('Please enter the OTP', 'corsair-login'); ?></label>
										<input type="text" name="user_otp" id="user_otp" class="input" maxlength="6" pattern="{0-9}+" />
										<small class="form-text text-muted"><?php _e('Enter the 6-digit verification code sent to your email.') ?></small>
									</div>
									<input type="submit" name="wpa-submit-verify" id="wpa-submit-verify" class="btn btn-primary" value="<?php echo __('Verify OTP', 'corsair-login'); ?>" />
									<a class="btn btn-primary bg-gradient disabled" data-stat="countdown" href="javascript:void(0);" id="resend" disabled><?= time() < strtotime($otp_resend_time) ? 'Resend in '.(strtotime($otp_resend_time) - time()).' s' : 'Resend OTP' ?></a>
									<script>
										jQuery(document).ready(function($){
											var is_countdown_resend = $('body').find('#resend').attr('data-stat') == 'countdown';
											if(is_countdown_resend){
												var sec = '<?= time() < strtotime($otp_resend_time) ? (strtotime($otp_resend_time) - time()) : 0 ?>';
												var countdown = setInterval(() => {
													if(sec > 0){
														sec--;
														$('#resend').text("Resend in "+(sec)+' s')
													}else{
														$('#resend').attr('data-stat','').removeClass('disabled').text('Resend OTP')
														clearInterval(countdown)
													}
												}, 1000);
											}
										});
									</script>
									<?php
									if( $isLoginType['switch'] === true ){
										?><div class="switch-section"><a href="javascript:void(0);" class="switch-method" data-type="<?php echo $encryptSwitchType; ?>"><?php echo __('Switch to another verification method', 'corsair-login'); ?></a></div><?php
									}
									$otpContent = ob_get_clean();
									$response['otpContent'] = $otpContent;
								}else{
									$response['errorMessage'] = __('There was a problem sending OTP to your email. Please try again or contact an admin.', 'corsair-login');
								}
							}else if( isset( $_POST['user_otp'] ) ){
								$user_otp = get_user_meta( $user_id, 'user_otp', true );
								$user_otp_expiration = get_user_meta( $user_id, 'user_otp_expiration', true );
								if( strtotime($user_otp_expiration) > time() && $user_otp == $_POST['user_otp'] ){
									$credentials = array();
									$credentials['user_login'] = $user_email;
									$credentials['user_password'] = $user_password;
									$credentials['remember'] = $remember;
									
									$user_signon = wp_signon( $credentials, true );
									$response['user_signon'] = $user_signon;
									if( is_wp_error($user_signon) ){
										$response['errorMessage'] = $user_signon->get_error_message();
									}else{
										wp_set_auth_cookie( $user_signon->ID, true );
										wp_set_current_user( $user_signon->ID ); 
										$response['isLoggedIn'] = true;
										$_SESSION['refAccount']=$user_signon->data->user_email;
										add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
										add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
										add_filter( 'wp_mail_content_type', function(){ return "text/html"; } );
										$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
										$siteUrl = get_bloginfo('url');
										$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
										$subject = sprintf(__("Login to %s", 'corsair-login'), $blogname);
										
										$message = sprintf(__('<h2>Dear member,</h2><p>We noticed a new sign-in to your %s account:</p> <p> -When: %s <br/> -IP: %s</p><br/> <p>If this was you, you don\'t need to do anything.</p><p>If not, please <a href="%s">reset your login password</a> and <a href="%s">contact our support</a> immediately.</p><br/><p>This is an automated message, please do not reply.</p><p>Best regards,<br/>Amplivo</p>', 'corsair-login'), $siteUrlName, date_i18n( 'F d, Y, H:i:s A' ) . ' GMT', corsairlogin_client_ip(), get_permalink( get_page_by_path( 'request-reset-link' ) ), get_permalink( 3818 ) );
										$htmlContent = mailTemplateHtmlRender( $message );
										if( get_email_send_toggle('login') == 1 ){
											$sent_mail = wp_mail( $user_signon->data->user_email, $subject, $htmlContent );
										}
			
									}
								}else{
									$response['errorMessage'] = __('Expired or invalid OTP', 'corsair-login');
								}
								
							}
						}else if( $isLoginType['status'] == true && $isLoginType['type'] == '2fa' ){
							if( !isset( $_POST['user_otp'] ) ){ //send OTP to user email
								$response['isOtpSend'] = true;
								$encryptId = base64_encode( $user->ID . md5('CL_RESEND_CL'));
								$encryptSwitchType = base64_encode( md5('Email_OTP_Switch') );
								$activeType = base64_encode( md5('GoogleAuth2FA') );
								ob_start();
								?>
								<input type="hidden" name="microtoken" value="<?php echo $encryptId; ?>" />
								<input type="hidden" name="activetype" value="<?php echo $activeType; ?>" />
								<div class="otp_section pb-3">
									<label for="user_otp"><?php echo __('Please enter authenticator code', 'corsair-login'); ?></label>
									<input type="text" name="user_otp" id="user_otp" class="input" maxlength="6" pattern="{0-9}+" />
									<small class="form-text text-muted"><?php _e('Enter the 6-digit code generated by the Authenticator App.') ?></small>
								</div>
								<input type="submit" name="wpa-submit-verify" id="wpa-submit-verify" class="button-primary" value="<?php echo __('Verify Code', 'corsair-login'); ?>" />
								<?php
								if( $isLoginType['switch'] === true ){
								?><div class="switch-section"><a href="javascript:void(0);" class="switch-method" data-type="<?php echo $encryptSwitchType; ?>"><?php echo __('Switch to another verification method', 'corsair-login'); ?></a></div><?php
								}
								$otpContent = ob_get_clean();
								$response['otpContent'] = $otpContent;
							}else if( isset( $_POST['user_otp'] ) ){
								$user_id = $user->ID;
								$decryptedIdRaw = base64_decode( $_POST['microtoken'] );
								$decryptedUserId = preg_replace(sprintf('/%s/', md5('CL_RESEND_CL') ), '', $decryptedIdRaw);
								if( $decryptedUserId == $user_id ){
									$google_auth_key = get_user_meta( $user_id, 'google_auth_key', true );
									if( !empty( $_POST['user_otp'] ) ){
										$google2fa = new \PragmaRX\Google2FA\Google2FA();
										if( $google2fa->verifyKey($google_auth_key, $_POST['user_otp'], 0) ){
	
											$credentials = array();
											$credentials['user_login'] = $user_email;
											$credentials['user_password'] = $user_password;
											$credentials['remember'] = $remember;
											
											$user_signon = wp_signon( $credentials, true );
											$response['user_signon'] = $user_signon;
											if( is_wp_error($user_signon) ){
												$response['errorMessage'] = $user_signon->get_error_message();
											}else{
												wp_set_auth_cookie( $user_signon->ID, true );
												wp_set_current_user( $user_signon->ID ); 
												$response['isLoggedIn'] = true;
												if( in_array( 'member', $user_signon->roles ) || in_array( 'supportmanager', $user_signon->roles ) || in_array( 'supportagent', $user_signon->roles ) ){ //only for member
													$_SESSION['refAccount']=$user_signon->data->user_email;
		
													add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
													add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
													add_filter( 'wp_mail_content_type', function(){ return "text/html"; } );
		
													$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
													$siteUrl = get_bloginfo('url');
													$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
													$subject = sprintf(__("Login to %s", 'corsair-login'), $blogname);
													
													$message = sprintf(__('<h2>Dear member,</h2><p>We noticed a new sign-in to your %s account:</p> <p> -When: %s <br/> -IP: %s</p><br/> <p>If this was you, you don\'t need to do anything.</p><p>If not, please <a href="%s">reset your login password</a> and <a href="%s">contact our support</a> immediately.</p><br/><p>This is an automated message, please do not reply.</p><p>Best regards,<br/>Amplivo</p>', 'corsair-login'), $siteUrlName, date_i18n( 'F d, Y, H:i:s A' ) . ' GMT', corsairlogin_client_ip(), get_permalink( get_page_by_path( 'request-reset-link' ) ), get_permalink( 3818 ) );
		
													$htmlContent = mailTemplateHtmlRender( $message );
													if( get_email_send_toggle('login') == 1 ){
														$sent_mail = wp_mail( $user_signon->data->user_email, $subject, $htmlContent );
													}
												}
	
											}
	
										}else{
											$response['errorMessage'] = __('Invalid authenticator code', 'corsair-login');
										}
									}else{
										$response['errorMessage'] = __('Please enter authenticator code', 'corsair-login');
									}
								}else{
									$response['errorMessage'] = __('User authentication failed. Please try again or contact an admin', 'corsair-login');
								}
							}
						}else{
							$credentials = array();
							$credentials['user_login'] = $user_email;
							$credentials['user_password'] = $user_password;
							$credentials['remember'] = $remember;
							
							$user_signon = wp_signon( $credentials, true );
							$response['user_signon'] = $user_signon;
							if( is_wp_error($user_signon) ){
								$response['errorMessage'] = $user_signon->get_error_message();
							}else{
								wp_set_auth_cookie( $user_signon->ID, true );
								wp_set_current_user( $user_signon->ID ); 
								$response['isLoggedIn'] = true;
								
								$dontShow = get_user_meta( $user_signon->ID, 'dont_show_2fa_profile_popup', true );
								if( $dontShow ){
									$response['infoMessage'] = '';
								}else{
									$response['infoMessage'] = __('<b>Logged In</b><br/><br/>You have not set up 2FA login.<br/><br/>You can enable 2FA login under "Settings" page.', 'corsair-login');
								}
								
								if( in_array( 'supportmanager', $user_signon->roles ) || in_array( 'supportagent', $user_signon->roles ) ){
									$response['infoMessage'] = '';
								}
								
								if( in_array( 'member', $user_signon->roles ) || in_array( 'supportmanager', $user_signon->roles ) || in_array( 'supportagent', $user_signon->roles ) ){ //only for member
									$_SESSION['refAccount']=$user_signon->data->user_email;
		
									add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
									add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
									add_filter( 'wp_mail_content_type', function(){ return "text/html"; } );
	
									$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
									$siteUrl = get_bloginfo('url');
									$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
									$subject = sprintf(__("Login to %s", 'corsair-login'), $blogname);
									
									$message = sprintf(__('<h2>Dear member,</h2><p>We noticed a new sign-in to your %s account:</p> <p> -When: %s <br/> -IP: %s</p><br/> <p>If this was you, you don\'t need to do anything.</p><p>If not, please <a href="%s">reset your login password</a> and <a href="%s">contact our support</a> immediately.</p><br/><p>This is an automated message, please do not reply.</p><p>Best regards,<br/>Amplivo</p>', 'corsair-login'), $siteUrlName, date_i18n( 'F d, Y, H:i:s A' ) . ' GMT', corsairlogin_client_ip(), get_permalink( get_page_by_path( 'request-reset-link' ) ), get_permalink( 3818 ) );
	
									$htmlContent = mailTemplateHtmlRender( $message );
									if( get_email_send_toggle('login') == 1 ){
										$sent_mail = wp_mail( $user->user_email, $subject, $htmlContent );
									}
								}
	
							}
						}
						
					}
				}else{
					$response['errorMessage'] = "Use your Amplivo.com email / username and password to login.";
				}
				
			}
		}
		if (!empty($response['errorMessage'])) {
			set_transient($client_key, '1', 2);
		}
	}else{
		$response['errorMessage'] = __('Something went wrong. Please try again.');
	}
	unset($response['pwdin']);
	wp_send_json(
		$response,
		$status_code
	);
}
function mailTemplateHtmlRender( $message ){
	
	$htmlurl = CLOG_PLUGIN_URL.'mail_template.html';
	$htmlContent = file_get_contents($htmlurl);
	$corsair_emailtmpl_logo = ( get_option( 'corsair_emailtmpl_logo' ) ) ? get_option( 'corsair_emailtmpl_logo') : '';
	$corsair_emailtmpl_basecolor = ( get_option( 'corsair_emailtmpl_basecolor' ) ) ? get_option( 'corsair_emailtmpl_basecolor') : '';
	$corsair_emailtmpl_headercss = ( get_option( 'corsair_emailtmpl_headercss' ) ) ? get_option( 'corsair_emailtmpl_headercss') : '';
	
	$htmlContent = str_replace('REPLACE_MESSAGE', $message, $htmlContent);
	$htmlContent = str_replace('REPLACE_SITEURL', site_url(), $htmlContent);
	$htmlContent = str_replace('REPLACE_COPYRIGHT', 'Copyright © Amplivo  '.date('Y').'. All rights reserved.', $htmlContent);
	$htmlContent = str_replace('REPLACE_HEADER_LOGO', $corsair_emailtmpl_logo, $htmlContent);
	$htmlContent = str_replace('REPLACE_STYLE', 'style="font-size: 18px; font-family: Google Sans,Arial, Helvetica, sans-serif; color: #ffffff; text-decoration: none; padding: 6px 24px; display: inline-block;'.$corsair_emailtmpl_basecolor.'"', $htmlContent);
	$htmlContent = str_replace('REPLACE_FOOTER_STYLE', $corsair_emailtmpl_basecolor, $htmlContent);
	$htmlContent = str_replace('REPLACE_HEADER_STYLE', $corsair_emailtmpl_headercss, $htmlContent);
	return $htmlContent;
}
add_action('wp_ajax_nopriv_corsair_user_reset_password', 'corsair_login_try_to_reset_request_action');
function corsair_login_try_to_reset_request_action(){
	if (empty($client_ip_address = corsairlogin_client_ip())) {
		die();
	}
	$client_key = 'reset_request_attempt_' . $client_ip_address;
	$status_code = 200;
	$response = array(
		'isResetRequested' => false,
		'errorMessage' => '',
	);
	if( wp_verify_nonce( $_POST['micro_nonce'],'corsair_reset_password_request' ) ){
		if ((get_transient($client_key) !== false)) {
			$response['errorMessage'] = 'Slow down a bit';
		} elseif (empty($user_email = sanitize_text_field($_POST['user_email']))) {
			$response['errorMessage'] = 'No email';
		} elseif( !filter_var($user_email, FILTER_VALIDATE_EMAIL) ){
			$response['errorMessage'] = 'Invalid email';
		}elseif( !email_exists( $user_email ) ){


			$amplivo_api_mode = ( !empty( get_option('amplivo_api_mode') ) ) ? get_option('amplivo_api_mode') : 'test';
			$amplivo_api_test_source_url = ( !empty( get_option('amplivo_api_test_source_url') ) ) ? get_option('amplivo_api_test_source_url') : 'https://cloudhorizon.sandbox.jox.hu/api/';
			$amplivo_api_live_source_url = ( !empty( get_option('amplivo_api_live_source_url') ) ) ? get_option('amplivo_api_live_source_url') : 'https://amplivo.com/api/';
			$sourceUrl = ( $amplivo_api_mode == 'live' ) ? $amplivo_api_live_source_url : $amplivo_api_test_source_url;
			$Status = "";
			if( !empty( $sourceUrl ) ){
				$request_url = add_query_arg( 'email', urlencode( $user_email ), $sourceUrl.'userstatus/get' );
				$responseUserGet = wp_remote_get( $request_url );
				if( !is_wp_error( $responseUserGet ) ) {
					$bodyResponse = json_decode( wp_remote_retrieve_body( $responseUserGet ), true );
					if( isset( $bodyResponse['Status'] ) && !empty( $bodyResponse['Status'] ) ){
						$Status = $bodyResponse['Status'];
					}
				}
			}
			if( !empty( $Status ) ){
				$response['errorMessage'] = __('You can\'t reset your password from Amplivo-Canada site. You need to reset your password from Amplivo.com', 'corsair-login');
				wp_send_json(
					$response,
					$status_code
				);
				exit;
			}else{
				$response['errorMessage'] = __('Email address not found', 'corsair-login');
				wp_send_json(
					$response,
					$status_code
				);
				exit;
			}
		}else {
			
			$user = get_user_by( 'email', $user_email );
			if( $user instanceof WP_User ) {
				$user_id = $user->ID;
				$user_info = get_userdata($user_id);

				if( in_array( 'member', $user->roles ) ){
					$response['errorMessage'] = __('You can\'t reset your password from Amplivo-Canada site. You need to reset your password from Amplivo.com', 'corsair-login');
					wp_send_json(
						$response,
						$status_code
					);
					exit;
				}

				$unique = get_password_reset_key( $user_info );
				$unique_url = network_site_url("wp-login.php?action=rp&key=$unique&login=" . rawurlencode($user_info->user_login), 'login');
				$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
				add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
				add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
				add_filter('wp_mail_content_type', function(){ return "text/html"; } );
				$subject = sprintf(__("%s - Reset Password Link", 'corsair-login'), $blogname);
				$siteUrl = get_bloginfo('url');
				$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
		
				$htmlurl = CLOG_PLUGIN_URL.'mail_template.html';
				$htmlContent = file_get_contents($htmlurl);
				$unique_url_txt = disable_email_link( $unique_url );
				$message = sprintf(__('<br><p>This is an e-mail from %s. </p> <p>You are receiving this email because we received a password reset request for your account.</p> <br/> <p><a href="%s" target="_blank" REPLACE_STYLE>Reset Password</a></p><br/>If the button above does not work, paste this link into your web browser: <br> %s <br> If you did not make this request, you can safely ignore this e-mail.<br/><p>This is an automated message, please do not reply.</p><br/><p>Best regards,<br/>Amplivo</p>', 'corsair-login'),$blogname, esc_url($unique_url), $unique_url_txt );
				
				$corsair_emailtmpl_logo = ( get_option( 'corsair_emailtmpl_logo' ) ) ? get_option( 'corsair_emailtmpl_logo') : '';
				$corsair_emailtmpl_basecolor = ( get_option( 'corsair_emailtmpl_basecolor' ) ) ? get_option( 'corsair_emailtmpl_basecolor') : '';
				$corsair_emailtmpl_headercss = ( get_option( 'corsair_emailtmpl_headercss' ) ) ? get_option( 'corsair_emailtmpl_headercss') : '';
				
				$htmlContent = str_replace('REPLACE_MESSAGE', $message, $htmlContent);
				$htmlContent = str_replace('REPLACE_SITEURL', site_url(), $htmlContent);
				$htmlContent = str_replace('REPLACE_COPYRIGHT', 'Copyright © Amplivo  '.date('Y').'. All rights reserved.', $htmlContent);
				$htmlContent = str_replace('REPLACE_HEADER_LOGO', $corsair_emailtmpl_logo, $htmlContent);
				$htmlContent = str_replace('REPLACE_STYLE', 'style="font-size: 18px; font-family: Google Sans, Arial, Helvetica, sans-serif; color: #ffffff; text-decoration: none; padding: 6px 24px; display: inline-block;'.$corsair_emailtmpl_basecolor.'"', $htmlContent);
				$htmlContent = str_replace('REPLACE_FOOTER_STYLE', $corsair_emailtmpl_basecolor, $htmlContent);
				$htmlContent = str_replace('REPLACE_HEADER_STYLE', $corsair_emailtmpl_headercss, $htmlContent);
				
				
			/*	$sent_mail = wp_mail( $user_email, $subject, $htmlContent );
				if ( !$sent_mail ){
					$response['errorMessage'] = __('There was a problem sending you email. Please try again or contact an admin.', 'corsair-login');
				}else{
					$response['errorMessage'] = __('Password reset link sent.', 'corsair-login');
					$response['isResetRequested'] = true;
				} */
				
			}else{
				$response['errorMessage'] = __('Something went wrong. Please try again.');
			}
			
		}
		if (!empty($response['errorMessage'])) {
			set_transient($client_key, '1', 2);
		}
	}else{
		$response['errorMessage'] = __('Something went wrong. Please try again.');
	}
	wp_send_json(
		$response,
		$status_code
	);
}
add_action('wp_ajax_nopriv_corsair_user_reseting_password', 'corsair_login_try_to_reseting_password_action');
function corsair_login_try_to_reseting_password_action(){
	if (empty($client_ip_address = corsairlogin_client_ip())) {
		die();
	}
	$client_key = 'reseting_password_attempt_' . $client_ip_address;
	$status_code = 200;
	$response = array(
		'isReset' => false,
		'isLoggedIn' => false,
		'errorMessage' => '',
	);
	if( wp_verify_nonce( $_POST['micro_nonce'],'corsair_reseting_password' ) ){
		$rp_cookie       = 'wp-resetpass-' . COOKIEHASH;
		
		$trim_pass1 = $_POST['pass1'] = trim( $_POST['pass1'] );
		$number    = preg_match('@[0-9]@', $_POST['pass1']);
		$pwStrengthError = false;
		$pwStrengthMsg = array();
		$pwStrengthMsg[] = __('<b>Password</b>','corsair-login');
		$errorOne = false;
		$errorTwo = false;
		if( !$number ){
			$pwStrengthMsg[] = __("must contain at least one number.","corsair-login"); 
			$pwStrengthError = true;
			$errorOne = true;
		}
		if( strlen($_POST['pass1']) < 8 ){
			$pwStrengthMsg[] = __("must be at least 8 characters.","corsair-login"); 
			$pwStrengthError = true;
			$errorTwo = true;
		}
		if( $errorOne && $errorTwo ){
			$pwStrengthMsg = array();
			$pwStrengthMsg[] = __('<b>Password</b>','corsair-login');
			$pwStrengthMsg[] = __("must contain at least one number and must be at least 8 characters.","corsair-login"); 
		}
		if( (get_transient($client_key) !== false) ){
			$response['errorMessage'] = 'Slow down a bit';
		} elseif ( empty( $_POST['pass1'] ) ) {
			$response['errorMessage'] = 'The password is required.';
		} elseif( !empty( $_POST['pass1'] ) && empty( $trim_pass1 ) ){
			$response['errorMessage'] = 'The password cannot be a space or all spaces.';
		}elseif ( ! empty( $_POST['pass1'] ) && trim( $_POST['pass2'] ) !== $_POST['pass1'] ) {
			$response['errorMessage'] = 'Passwords don\'t match.';
		}else if( $pwStrengthError ){
			$response['errorMessage'] = implode("<br/>", $pwStrengthMsg );
		}else {
			
			if ( isset( $_COOKIE[ $rp_cookie ] ) && 0 < strpos( $_COOKIE[ $rp_cookie ], ':' ) ) {
				list( $rp_login, $rp_key ) = explode( ':', wp_unslash( $_COOKIE[ $rp_cookie ] ), 2 );
	
				$user = check_password_reset_key( $rp_key, $rp_login );
				$decryptedLogin = base64_decode( $_POST['user_login'] );
				$user_login = urldecode( preg_replace(sprintf('/%s/', md5('CLRPLOGIN') ), '', $decryptedLogin) );
				
				if ( isset( $user_login ) && !hash_equals( $rp_login, $user_login ) ) {
					$user = false;
					$response['errorMessage'] = __('Something went wrong. Please try again.');
					wp_send_json(
						$response,
						$status_code
					);
				}
	
				if ( isset( $_POST['pass1'] ) && ! hash_equals( $rp_key, $_POST['rp_key'] ) ) {
					$user = false;
					$response['errorMessage'] = __('Something went wrong. Please try again.');
					wp_send_json(
						$response,
						$status_code
					);
				}
			} else {
				$user = false;
			}
			if($user){
				if( !is_wp_error($user) ){
					reset_password( $user, $_POST['pass1'] );
					$response['isReset'] = true;
					$response['errorMessage'] = __('Password reset successfully');
					$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
					$siteUrl = get_bloginfo('url');
					$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
					add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
					add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
					add_filter( 'wp_mail_content_type', function(){ return "text/html"; } );
					$subject = sprintf(__("%s - Login password changed", 'corsair-login'), $blogname);
			
					$htmlurl = CLOG_PLUGIN_URL.'mail_template.html';
					$htmlContent = file_get_contents($htmlurl);
					$message = sprintf(__('<br>Dear member,<br/><p>This notice confirms that your login password was changed on <a href="%s">%s</a>.</p><p>If this was you, you don\'t need to do anything.</p><p>If not, please <a href="%s">reset your login password</a> and <a href="%s">contact our support</a> immediately.</p><p>This is an automated message, please do not reply.</p><br/><p>Best regards,<br/>Amplivo</p>', 'corsair-login'), $siteUrl, $siteUrlName, get_permalink( get_page_by_path( 'request-reset-link' ) ), get_permalink( 3818 ) );
					
					$corsair_emailtmpl_logo = ( get_option( 'corsair_emailtmpl_logo' ) ) ? get_option( 'corsair_emailtmpl_logo') : '';
					$corsair_emailtmpl_basecolor = ( get_option( 'corsair_emailtmpl_basecolor' ) ) ? get_option( 'corsair_emailtmpl_basecolor') : '';
					$corsair_emailtmpl_headercss = ( get_option( 'corsair_emailtmpl_headercss' ) ) ? get_option( 'corsair_emailtmpl_headercss') : '';
					
					$htmlContent = str_replace('REPLACE_MESSAGE', $message, $htmlContent);
					$htmlContent = str_replace('REPLACE_SITEURL', site_url(), $htmlContent);
					$htmlContent = str_replace('REPLACE_COPYRIGHT', 'Copyright © Amplivo  '.date('Y').'. All rights reserved.', $htmlContent);
					$htmlContent = str_replace('REPLACE_HEADER_LOGO', $corsair_emailtmpl_logo, $htmlContent);
					$htmlContent = str_replace('REPLACE_STYLE', 'style="font-size: 18px; font-family: Google Sans, Arial, Helvetica, sans-serif; color: #ffffff; text-decoration: none; padding: 6px 24px; display: inline-block;'.$corsair_emailtmpl_basecolor.'"', $htmlContent);
					$htmlContent = str_replace('REPLACE_FOOTER_STYLE', $corsair_emailtmpl_basecolor, $htmlContent);
					$htmlContent = str_replace('REPLACE_HEADER_STYLE', $corsair_emailtmpl_headercss, $htmlContent);
					
					$sent_mail = wp_mail( $user->user_email, $subject, $htmlContent );
					$cssetautologin = get_user_meta( $user->ID, 'cssetautologin', true );
					$logs = sprintf( __('%s reset their password at %s', 'corsair-login'), $user->user_email, date_i18n('d/m/Y H:i A') );
					create_corsairlogin_logs_entry( $user->ID, 'profile', '','member', $logs, true  );
					if( $cssetautologin ){
						$remember = false;
						$credentials = array();
						$credentials['user_login'] = $user->user_email;
						$credentials['user_password'] = $_POST['pass1'];
						$credentials['remember'] = $remember;
			
						$user_signon = wp_signon( $credentials, true );
						if( is_wp_error($user_signon) ){
							$response['errorMessage'] = $user_signon->get_error_message();
						}else{
							wp_set_auth_cookie( $user_signon->ID, true );
							wp_set_current_user($user_signon->ID); 
							$response['isLoggedIn'] = true;
							$_SESSION['refAccount']=$user_signon->data->user_email;
						}
						delete_user_meta( $user->ID, 'cssetautologin' );
					}
				}else{
					$response['errorMessage'] = __('Something went wrong. Please try again.');
				}
			}else{
				$response['errorMessage'] = __('Something went wrong. Please try again.');
			}
			
		}
		if (!empty($response['errorMessage'])) {
			set_transient($client_key, '1', 2);
		}
	}else{
		$response['errorMessage'] = __('Something went wrong. Please try again.');
	}
	wp_send_json(
		$response,
		$status_code
	);
}
add_action( 'login_form_rp', 'redirect_to_custom_password_reset' );
add_action( 'login_form_resetpass', 'redirect_to_custom_password_reset' );
function redirect_to_custom_password_reset() {
    if ( 'GET' == $_SERVER['REQUEST_METHOD'] ) {
        // Verify key / login combo 
        $user = check_password_reset_key( $_REQUEST['key'], $_REQUEST['login'] );
        if ( ! $user || is_wp_error( $user ) ) {
            if ( $user && $user->get_error_code() === 'expired_key' ) {
                wp_redirect( home_url( 'request-reset-link?error=expiredkey' ) );
            } else {
                wp_redirect( home_url( 'request-reset-link?error=invalidkey' ) );
            }
            exit;
        }
        $redirect_url = home_url( 'reset-password' );
        $redirect_url = add_query_arg( 'login', esc_attr( $_REQUEST['login'] ), $redirect_url );
        $redirect_url = add_query_arg( 'key', esc_attr( $_REQUEST['key'] ), $redirect_url );
        wp_redirect( $redirect_url );
        exit;
    }
}
function get_error_message( $error_code ) {
    switch ( $error_code ) {
        case 'expiredkey':
		case 'invalidkey':
			return __( 'The password reset link you used is not valid anymore.', 'corsair-login' );
		case 'password_reset_mismatch':
			return __( "The two passwords you entered don't match.", 'corsair-login' );
				
		case 'password_reset_empty':
			return __( "Sorry, we don't accept empty passwords.", 'corsair-login' );
        default:
            break;
    }
	
    return __( 'An unknown error occurred. Please try again later.', 'corsair-login' );
}
add_action( 'wp_ajax_user_login_auth_option_act', 'corsair_login_user_login_auth_option_act_callback' );
function corsair_login_user_login_auth_option_act_callback(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.','corsair-login') );
	if( wp_verify_nonce( $_POST['_micro'],'_USERS_LogiN_AuthenticatioN_OPTION_' ) && ( current_user_can( 'member' ) || current_user_can( 'supportagent' ) || current_user_can( 'supportmanager' ) ) ){
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		$corsair_2fa_otp = get_option( 'corsair_2fa_otp' );
		$corsair_2fa_ga = get_option( 'corsair_2fa_ga' );
		if( $_POST['login_auth_type'] == 'otp' ){
			if( $corsair_2fa_otp == 'yes' ){
				update_user_meta( $user_id, 'login_auth_type', $_POST['login_auth_type'] );
			}
		}else if( $_POST['login_auth_type'] == '2fa' ){
			if( $corsair_2fa_ga == 'yes' ){
				update_user_meta( $user_id, 'login_auth_type', $_POST['login_auth_type'] );
			}
		}
		$out = array( "error" => 0,'msg' => __('Option updated.','corsair-login') );
	}
	wp_send_json($out);
	exit;
}
add_action( 'wp_ajax_googleAuth2FAactivationAct', 'corsair_login_googleAuth2FAactivationAct_callback' );
function corsair_login_googleAuth2FAactivationAct_callback(){
	$out = array( "error" => 1,'msg' => __('Something went wrong. Please try agin or contact admin.','corsair-login') );
	if( wp_verify_nonce( $_POST['_micro'],'_CIPGoogleAuthenticatorEnablingCIP_' ) && ( current_user_can( 'member' ) || current_user_can( 'supportagent' ) || current_user_can( 'supportmanager' ) ) ){
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		if( isset( $_POST['thisType'] ) && ( $_POST['thisType'] == 'login' ) ){
			if( !empty( $_POST['key'] ) && !empty( $_SESSION['google_auth_key'] ) ){
				if( $_POST['key'] == $_SESSION['google_auth_key'] ){
					$google2fa = new \PragmaRX\Google2FA\Google2FA();
					if( $google2fa->verifyKey($_SESSION['google_auth_key'], $_POST['code'], 0) ){
						update_user_meta( $user_id, 'google_auth_key', $_SESSION['google_auth_key'] );
						$_SESSION['google_auth_key'] = "";
						unset( $_SESSION['google_auth_key'] );
						
						if( $_POST['thisType'] == 'login' ){
							update_user_meta( $user_id, 'google_auth_key_login', 1 );
						}
						$out = array( "error" => 0,'msg' => __('Google authenticator activated.','corsair-login'), 'thisType' => $_POST['thisType'] );
						
						$logs = sprintf( __('2FA google authenticator activated for %s by %s at %s', 'corsair-login'), $_POST['thisType'], $current_user->user_email, date_i18n('d/m/Y H:i A') );
						create_corsairlogin_logs_entry( $user_id, 'profile', '','member', $logs, true  );
					}else{
						$out = array( "error" => 1,'msg' => __('Invalid backup key or 6-digit code.','corsair-login') );
					}
				}else{
					$out = array( "error" => 1,'msg' => __('Please enter valid backup key to continue.','corsair-login') );
				}
			}else{
				$out = array( "error" => 1,'msg' => __('Please enter valid backup key to continue.','corsair-login') );
			}
		}
	}
	wp_send_json($out);
	exit;
}
add_action( 'wp_ajax_googleAuth2FADeactivateAct', 'corsair_login_googleAuth2FADeactivateAct_callback' );
function corsair_login_googleAuth2FADeactivateAct_callback(){
	$out = array( "error" => 1,'msg' => __('Something went wrong. Please try agin or contact admin.','corsair-login') );
	if( wp_verify_nonce( $_POST['_micro'],'_CIPGoogleAuthenticatorDisablingCIP_' ) && ( current_user_can( 'member' ) || current_user_can( 'supportagent' ) || current_user_can( 'supportmanager' ) ) ){
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		$google_auth_key = get_user_meta( $user_id, 'google_auth_key', true );
		if( !empty( $_POST['code'] ) ){
			$google2fa = new \PragmaRX\Google2FA\Google2FA();
			if( $google2fa->verifyKey($google_auth_key, $_POST['code'], 0) ){
				delete_user_meta( $user_id, 'google_auth_key' );
				delete_user_meta( $user_id, 'google_auth_key_login' );
				$out = array( "error" => 0,'msg' => __('Google authenticator disabled.','corsair-login') );
				$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
				$siteUrl = get_bloginfo('url');
				$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
				$subject = sprintf(__("%s - Google 2FA (disabled)", 'corsair-login'), $blogname);
				$message = sprintf( __('Dear member, <br/><p>Your Google 2FA authentication has been disabled.</p><br/><p>This is an automated message, please do not reply.</p><p>Best regards,<br/>Amplivo</p>', 'corsair-login' ));
					
				add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
				add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
				add_filter( 'wp_mail_content_type', function(){ return "text/html"; } );
	
				$htmlContent = mailTemplateHtmlRender( $message );
				if( get_email_send_toggle('2fa_enabled_disabled') == 1 ){
					$sent_mail = wp_mail( $current_user->user_email, $subject, $htmlContent );
				}
				$logs = sprintf( __('2FA google authenticator disabled by %s at %s', 'corsair-login'), $current_user->user_email, date_i18n('d/m/Y H:i A') );
				create_corsairlogin_logs_entry( $user_id, 'profile', '','member', $logs, true  );
			}else{
				$out = array( "error" => 1,'msg' => __('Invalid 6-digit google authenticator code.','corsair-login') );
			}
		}else{
			$out = array( "error" => 1,'msg' => __('Please enter 6-digit google authenticator code.','corsair-login') );
		}
	}
	wp_send_json($out);
	exit;
}
add_action( 'wp_ajax_sendOtpForActivatingAct', 'corsair_login_sendOtpForActivatingAct_callback' );
function corsair_login_sendOtpForActivatingAct_callback(){
	$out = array( "error" => 1,'msg' => __('Something went wrong. Please try agin or contact admin.','corsair-login'), 'html' => '' );
	if (empty($client_ip_address = corsairlogin_client_ip())) {
		wp_send_json($out);
		die();
	}
	if( current_user_can( 'member' ) || current_user_can( 'supportagent' ) || current_user_can( 'supportmanager' ) ){
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		$formHtml = "";
		$clientResendKey = 'resend_enabledisable_attempt_' . $client_ip_address;
		$user_otp = sprintf("%'.06d",mt_rand(0,999999));
		$otp_resend_time = date("Y-m-d H:i:s" ,strtotime(date('Y-m-d H:i:s')." +1 min"));
		if( isset( $_POST['resendOtpAct'] ) && $_POST['resendOtpAct'] == 1 ){
			if ((get_transient($clientResendKey) !== false)) {
				$out = array( "error" => 1,'msg' => __('You can resend OTP after timer reset.','corsair-login'), 'html' => '' );
				wp_send_json($out);
				exit;
			}
			$otp_resend_time = date("Y-m-d H:i:s" ,strtotime(date('Y-m-d H:i:s')." +1 min"));
			update_user_meta( $user_id, 'user_otp_activate_code', $user_otp );
	
			add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
			add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
			add_filter( 'wp_mail_content_type', function(){ return "text/html"; } );
	
			$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
			$siteUrl = get_bloginfo('url');
			$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
			$subject = sprintf(__("%s - Email OTP Verification", 'corsair-login'), $blogname);
			$message = sprintf(__('<h2>You are attempting to activate One-Time-Passcode (OTP) authentication in %s</h2><p>Please insert the Passcode below to activate OTP.</p><h3><b>%s</b></h3><br/><p>This is an automated message, please do not reply.</p><p>Best regards,<br/>Amplivo</p>', 'corsair-login' ), $siteUrlName, $user_otp );
			$htmlContent = mailTemplateHtmlRender( $message );
			$sent_mail = wp_mail( $current_user->user_email, $subject, $htmlContent );
			if( $sent_mail ){
				set_transient($clientResendKey, '1', 60);
				$out = array( "error" => 0,'msg' => __('OTP Sent to your email','corsair-login'), 'html' => '' );
			}else{
				$out = array( "error" => 1,'msg' => __('There was a problem sending you email. Please try again or contact an admin.','corsair-login'), 'html' => $formHtml );
			}
			
		}else{
			$otp_resend_time = date("Y-m-d H:i:s" ,strtotime(date('Y-m-d H:i:s')." +1 min"));
			update_user_meta( $user_id, 'user_otp_activate_code', $user_otp );
	
			add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
			add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
			add_filter( 'wp_mail_content_type', function(){ return "text/html"; } );
	
			$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
			$siteUrl = get_bloginfo('url');
			$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
			$subject = sprintf(__("%s - Email OTP Verification", 'corsair-login'), $blogname);
			$message = sprintf(__('<h2>You are attempting to activate One-Time-Passcode (OTP) authentication in %s</h2><p>Please insert the Passcode below to activate OTP.</p><h3><b>%s</b></h3><br/><p>This is an automated message, please do not reply.</p><p>Best regards,<br/>Amplivo</p>', 'corsair-login' ), $siteUrlName, $user_otp );
			$htmlContent = mailTemplateHtmlRender( $message );
			$sent_mail = wp_mail( $current_user->user_email, $subject, $htmlContent );
			if( $sent_mail ){
				set_transient($clientResendKey, '1', 60);
				ob_start();
				?>
				<div class="container-fluid">
					<div class="row">
						<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 p-0 mt-2 mb-2">
							<div class="card-">
								<form name="otp2faEnableFrm" class="otp2faEnableFrm">
									<div class="row">
										<div class="col-12">
											<p class="text-center main_heading text-success mb-0"><b><?php _e('One-Time-Passcode has been sent to your email.', 'corsair-login'); ?></b></p>
											<p class="text-center main_heading"><b><?php _e('Activate OTP Authentication', 'corsair-login'); ?></b></p>
											<div class="form-group">
												<label for="verify-code"><?php _e('Please enter the OTP', 'corsair-login'); ?></label>
												<input type="number" class="form-control" name="code" placeholder="" id="verify-code" maxlength="6">
												<small class="form-text text-muted"><?php _e('Enter the 6-digit verification code sent to your email.') ?></small>
											</div>
											<input type="submit" name="submit" class="btn action-button" value="<?php _e('Verify', 'corsair-login'); ?>" />
											<input type="button" name="cancel" class="btn action-button" data-dismiss="modal" value="<?php _e('Cancel', 'corsair-login'); ?>" />
											<a class="btn getnewcodeenable disabled" data-stat="countdown" href="javascript:void(0);" id="getnewcode" disabled><?= time() < strtotime($otp_resend_time) ? 'Resend in '.(strtotime($otp_resend_time) - time()).' s' : 'Resend OTP' ?></a>
										</div>
									</div>
									<input type="hidden" name="action" value="otpAuth2FAactivateAct" />
									<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPOTPAuthenticatorActivatingCIP_'); ?>" />
									<p class="resend_response"></p>
								</form>
							</div>
						</div>
					</div>
				</div>
				<script>
					jQuery(document).ready(function($){
						var is_countdown_resend = $('body').find('#getnewcode').attr('data-stat') == 'countdown';
						if(is_countdown_resend){
							var sec = parseInt('<?= time() < strtotime($otp_resend_time) ? (strtotime($otp_resend_time) - time()) : 0 ?>');
							var countdown = setInterval(() => {
								if(sec > 0){
									sec--;
									$('#getnewcode').text("Resend in "+(sec)+' s')
								}else{
									$('#getnewcode').attr('data-stat','').removeClass('disabled').text('Resend OTP')
									clearInterval(countdown)
								}
							}, 1000);
						}
					});
				</script>
				<?php
				$formHtml .= ob_get_clean();
				$out = array( "error" => 0,'msg' => __('OTP Sent to your email','corsair-login'), 'html' => $formHtml );
			}else{
				$out = array( "error" => 1,'msg' => __('There was a problem sending you email. Please try again or contact an admin.','corsair-login'), 'html' => $formHtml );
			}
		}
	}
	wp_send_json($out);
	exit;
}
add_action( 'wp_ajax_sendOtpForDeActivatingAct', 'corsair_login_sendOtpForDeActivatingAct_callback' );
function corsair_login_sendOtpForDeActivatingAct_callback(){
	$out = array( "error" => 1,'msg' => __('Something went wrong. Please try agin or contact admin.','corsair-login'), 'html' => '' );
	if (empty($client_ip_address = corsairlogin_client_ip())) {
		wp_send_json($out);
		die();
	}
	if( current_user_can( 'member' ) || current_user_can( 'supportagent' ) || current_user_can( 'supportmanager' ) ){
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		$formHtml = "";
		$clientResendKey = 'resend_enabledisable_attempt_' . $client_ip_address;
		$user_otp = sprintf("%'.06d",mt_rand(0,999999));
		if( isset( $_POST['resendOtpAct'] ) && $_POST['resendOtpAct'] == 1 ){
			if ((get_transient($clientResendKey) !== false)) {
				$out = array( "error" => 1,'msg' => __('You can resend OTP after timer reset.','corsair-login'), 'html' => '' );
				wp_send_json($out);
				exit;
			}
			$otp_resend_time = date("Y-m-d H:i:s" ,strtotime(date('Y-m-d H:i:s')." +1 min"));
			update_user_meta( $user_id, 'user_otp_deactivate_code', $user_otp );
			
			add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
			add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
			add_filter( 'wp_mail_content_type', function(){ return "text/html"; } );
	
			$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
			$siteUrl = get_bloginfo('url');
			$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
			$subject = sprintf(__("%s - Email OTP Verification", 'corsair-login'), $blogname);
			$message = sprintf(__('<h2>You are attempting to deactivate One-Time-Passcode (OTP) authentication in %s</h2><p>Please insert the Passcode below to deactivate OTP.</p><h3><b>%s</b></h3><br/><p>This is an automated message, please do not reply.</p><p>Best regards,<br/>Amplivo</p>', 'corsair-login' ), $siteUrlName, $user_otp );
			$htmlContent = mailTemplateHtmlRender( $message );
			$sent_mail = wp_mail( $current_user->user_email, $subject, $htmlContent );
			if( $sent_mail ){
				set_transient($clientResendKey, '1', 60);
				$out = array( "error" => 0,'msg' => __('OTP Sent to your email','corsair-login'), 'html' => '' );
			}else{
				$out = array( "error" => 1,'msg' => __('There was a problem sending you email. Please try again or contact an admin.','corsair-login'), 'html' => $formHtml );
			}
			
		}else{
			$otp_resend_time = date("Y-m-d H:i:s" ,strtotime(date('Y-m-d H:i:s')." +1 min"));
			update_user_meta( $user_id, 'user_otp_deactivate_code', $user_otp );
			
			add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
			add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
			add_filter( 'wp_mail_content_type', function(){ return "text/html"; } );
	
			$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
			$siteUrl = get_bloginfo('url');
			$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
			$subject = sprintf(__("%s - Email OTP Verification", 'corsair-login'), $blogname);
			$message = sprintf(__('<h2>You are attempting to deactivate One-Time-Passcode (OTP) authentication in %s</h2><p>Please insert the Passcode below to deactivate OTP.</p><h3><b>%s</b></h3><br/><p>This is an automated message, please do not reply.</p><p>Best regards,<br/>Amplivo</p>', 'corsair-login' ), $siteUrlName, $user_otp );
			$htmlContent = mailTemplateHtmlRender( $message );
			$sent_mail = wp_mail( $current_user->user_email, $subject, $htmlContent );
			if( $sent_mail ){
				set_transient($clientResendKey, '1', 60);
				ob_start();
				?>
				<div class="container-fluid">
					<div class="row">
						<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 p-0 mt-2 mb-2">
							<div class="card-">
								<form name="otp2faDisableFrm" class="otp2faDisableFrm">
									<div class="row">
										<div class="col-12">
											<p class="text-center main_heading text-success mb-0"><b><?php _e('One-Time-Passcode has been sent to your email.', 'corsair-login'); ?></b></p>
											<p class="text-center main_heading"><b><?php _e('Deactivate OTP Authentication', 'corsair-login'); ?></b></p>
											<div class="form-group">
												<label for="verify-code"><?php _e('Please enter the OTP', 'corsair-login'); ?></label>
												<input type="number" class="form-control" name="code" placeholder="" id="verify-code" maxlength="6">
												<small class="form-text text-muted"><?php _e('Enter the 6-digit verification code sent to your email.') ?></small>
											</div>
											<input type="submit" name="submit" class="btn action-button" value="<?php _e('Verify', 'corsair-login'); ?>" />
											<input type="button" name="cancel" class="btn action-button" data-dismiss="modal" value="<?php _e('Cancel', 'corsair-login'); ?>" />
											<a class="btn getnewcodedisable disabled" data-stat="countdown" href="javascript:void(0);" id="getnewcode" disabled><?= time() < strtotime($otp_resend_time) ? 'Resend in '.(strtotime($otp_resend_time) - time()).' s' : 'Resend OTP' ?></a>
										</div>
									</div>
									<input type="hidden" name="action" value="otpAuth2FDeAactivateAct" />
									<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPOTPAuthenticatorDeActivatingCIP_'); ?>" />
									<p class="resend_response"></p>
								</form>
							</div>
						</div>
					</div>
				</div>
				<script>
					jQuery(document).ready(function($){
						var is_countdown_resend = $('body').find('#getnewcode').attr('data-stat') == 'countdown';
						if(is_countdown_resend){
							var sec = parseInt('<?= time() < strtotime($otp_resend_time) ? (strtotime($otp_resend_time) - time()) : 0 ?>');
							var countdown = setInterval(() => {
								if(sec > 0){
									sec--;
									$('#getnewcode').text("Resend in "+(sec)+' s')
								}else{
									$('#getnewcode').attr('data-stat','').removeClass('disabled').text('Resend OTP')
									clearInterval(countdown)
								}
							}, 1000);
						}
					});
				</script>
				<?php
				$formHtml .= ob_get_clean();
				$out = array( "error" => 0,'msg' => __('OTP Sent to your email','corsair-login'), 'html' => $formHtml );
			}else{
				$out = array( "error" => 1,'msg' => __('There was a problem sending you email. Please try again or contact an admin.','corsair-login'), 'html' => $formHtml );
			}
		}
	}
	wp_send_json($out);
	exit;
}
add_action( 'wp_ajax_otpAuth2FAactivateAct', 'corsair_login_otpAuth2FAactivateAct_callback' );
function corsair_login_otpAuth2FAactivateAct_callback(){
	$out = array( "error" => 1,'msg' => __('Something went wrong. Please try agin or contact admin.','corsair-login') );
	if( wp_verify_nonce( $_POST['_micro'],'_CIPOTPAuthenticatorActivatingCIP_' ) && ( current_user_can( 'member' ) || current_user_can( 'supportagent' ) || current_user_can( 'supportmanager' ) ) ){
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		$user_otp_activate_code = get_user_meta( $user_id, 'user_otp_activate_code', true );
		if( !empty( $_POST['code'] ) ){
			if( $_POST['code'] == $user_otp_activate_code ){
				update_user_meta( $user_id, 'otp_auth_key', 1 );
				delete_user_meta( $user_id, 'user_otp_activate_code' );
				$out = array( "error" => 0,'msg' => __('Email OTP authentication activated.','corsair-login') );
				$logs = sprintf( __('2FA OTP authentication activated by %s at %s', 'corsair-login'), $current_user->user_email, date_i18n('d/m/Y H:i A') );
				create_corsairlogin_logs_entry( $user_id, 'profile', '','member', $logs, true  );
			}else{
				$out = array( "error" => 1,'msg' => __('Invalid OTP code.','corsair-login') );
			}
		}else{
			$out = array( "error" => 1,'msg' => __('Please enter valid OTP code.','corsair-login') );
		}
	}
	wp_send_json($out);
	exit;
}
add_action( 'wp_ajax_otpAuth2FDeAactivateAct', 'corsair_login_otpAuth2FDeAactivateAct_callback' );
function corsair_login_otpAuth2FDeAactivateAct_callback(){
	$out = array( "error" => 1,'msg' => __('Something went wrong. Please try agin or contact admin.','corsair-login') );
	if( wp_verify_nonce( $_POST['_micro'],'_CIPOTPAuthenticatorDeActivatingCIP_' ) && ( current_user_can( 'member' ) || current_user_can( 'supportagent' ) || current_user_can( 'supportmanager' ) ) ){
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		$user_otp_deactivate_code = get_user_meta( $user_id, 'user_otp_deactivate_code', true );
		if( !empty( $_POST['code'] ) ){
			if( $_POST['code'] == $user_otp_deactivate_code ){
				delete_user_meta( $user_id, 'otp_auth_key', 1 );
				delete_user_meta( $user_id, 'user_otp_deactivate_code' );
				$out = array( "error" => 0,'msg' => __('Email OTP authentication deactivated.','corsair-login') );
				$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
				$siteUrl = get_bloginfo('url');
				$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
				$subject = sprintf(__("%s - Email OTP (disabled)", 'corsair-login'), $blogname);
				$message = sprintf( __('Dear member, <br/><p>Your email OTP (One-Time-Passcode) authentication has been disabled.</p><br/><p>This is an automated message, please do not reply.</p><p>Best regards,<br/>Amplivo</p>', 'corsair-login' ) );
				add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
				add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
				add_filter( 'wp_mail_content_type', function(){ return "text/html"; } );
	
				$htmlContent = mailTemplateHtmlRender( $message );
				if( get_email_send_toggle('otp_enabled_disabled') == 1 ){
					$sent_mail = wp_mail( $current_user->user_email, $subject, $htmlContent );
				}
				$logs = sprintf( __('2FA OTP authentication deactivated by %s at %s', 'corsair-login'), $current_user->user_email, date_i18n('d/m/Y H:i A') );
				create_corsairlogin_logs_entry( $user_id, 'profile', '','member', $logs, true  );
			}else{
				$out = array( "error" => 1,'msg' => __('Invalid OTP code.','corsair-login') );
			}
		}else{
			$out = array( "error" => 1,'msg' => __('Please enter valid OTP code.','corsair-login') );
		}
	}
	wp_send_json($out);
	exit;
}
function get_login_auth_type( $user_id = 0 ){
	$response = array('type' => '', 'status' => false, 'switch' => false );
	$corsair_2fa_otp = get_option( 'corsair_2fa_otp' );
	$corsair_2fa_ga = get_option( 'corsair_2fa_ga' );
	$login_auth_type = get_user_meta( $user_id, 'login_auth_type', true );
	$otp_auth_key = get_user_meta( $user_id, 'otp_auth_key', true );
	$google_auth_key = get_user_meta( $user_id, 'google_auth_key', true );
	$google_auth_key_login = get_user_meta( $user_id, 'google_auth_key_login', true );
	$ga2fa_login_enabled = ( !empty( $google_auth_key ) && $google_auth_key_login == 1 ) ? 1 : 0;
	$status = false;
	if( ( $corsair_2fa_otp == 'yes' && $otp_auth_key == 1 ) && $corsair_2fa_ga == 'yes' && $ga2fa_login_enabled == 1 ){
		$response['type'] = 'both';
		$response['status'] = true;
		$response['switch'] = true;
	}else if( $corsair_2fa_otp == 'yes' && $otp_auth_key == 1 ){
		$response['type'] = 'otp';
		$response['status'] = true;
	}else if( $corsair_2fa_ga == 'yes' && $ga2fa_login_enabled == 1 ){
		$response['type'] = '2fa';
		$response['status'] = true;
	}
	return $response;
}
add_action( 'wp_ajax_cl_reset2faauth_act', 'cl_reset2faauth_act_callback' );
function cl_reset2faauth_act_callback(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.','corsair-login') );
	if( wp_verify_nonce( $_POST['_micro'],'_XyReset2FaAuthyX_' ) && ( current_user_can( 'supportmanager' ) ) ){
		$decrypted_id_raw = base64_decode( $_POST['thisid'] );
		$decryptedType = base64_decode( $_POST['thistype'] );
		$user_id = preg_replace(sprintf('/%s/', md5('324CL_MembeR_CL324') ), '', $decrypted_id_raw);
		$memberInfo = get_userdata($user_id);
		$reset = false;
		if( $user_id ){
			$memberInfo = get_userdata($user_id);
			if( $memberInfo ){
				$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
				$siteUrl = get_bloginfo('url');
				$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
				$currentUserData = get_user_by( 'id', get_current_user_id() );
				
				$isSendEmail = false;

				if( $decryptedType == md5( 'EmailOtpReset' ) ){
					delete_user_meta( $user_id, 'otp_auth_key' );
					$subject = sprintf(__("%s - Email OTP (disabled)", 'corsair-login'), $blogname);
					$message = sprintf( __('Dear member, <br/><p>Your email OTP (One-Time-Passcode) authentication has been disabled.</p><br/><p>This is an automated message, please do not reply.</p><p>Best regards,<br/>Amplivo</p>', 'corsair-login' ) );
					$logs = sprintf( __('Email OTP (One-Time-Passcode) Authentication Disabled of %s by %s at %s', 'corsair-login'),$memberInfo->user_email, $currentUserData->user_email, date_i18n('d/m/Y H:i A') );
					$reset = true;

					if( get_email_send_toggle('otp_enabled_disabled') == 1 ){
						$isSendEmail = true;
					}

				}else if( $decryptedType == md5( 'Google2FAReset' ) ){
					delete_user_meta( $user_id, 'google_auth_key' );
					delete_user_meta( $user_id, 'google_auth_key_login' );
					$subject = sprintf(__("%s - Google 2FA (disabled)", 'corsair-login'), $blogname);
					$message = sprintf( __('Dear member, <br/><p>Your Google 2FA authentication has been disabled.</p><br/><p>This is an automated message, please do not reply.</p><p>Best regards,<br/>Amplivo</p>', 'corsair-login' ) );
					$logs = sprintf( __('Google 2FA Authentication Disabled of %s by %s at %s', 'corsair-login'),$memberInfo->user_email, $currentUserData->user_email, date_i18n('d/m/Y H:i A') );
					$reset = true;

					if( get_email_send_toggle('2fa_enabled_disabled') == 1 ){
						$isSendEmail = true;
					}
				}
				if( $reset === true ){
					
					add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
					add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
					add_filter( 'wp_mail_content_type', function(){ return "text/html"; } );
		
					$htmlContent = mailTemplateHtmlRender( $message );
					if( $isSendEmail ){
						$sent_mail = wp_mail( $memberInfo->user_email, $subject, $htmlContent );
					}
					
					create_corsairlogin_logs_entry( 0, 'member', '','sm', $logs, true  );
					$out = array( "error" => 0,'msg' => __('Reset successfully.','corsair-login') );
				}
	
			}
		}
	}
	echo wp_json_encode( $out );
	exit;
}
add_action( 'wp_ajax_cl_resetpwd_act', 'cl_resetpwd_act_callback' );
function cl_resetpwd_act_callback(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.','corsair-login') );
	if( wp_verify_nonce( $_POST['_micro'],'_XyResetPWDLinkyX_' ) && ( current_user_can( 'supportmanager' ) ) ){
		$decrypted_id_raw = base64_decode( $_POST['thisid'] );
		$decryptedType = base64_decode( $_POST['thistype'] );
		$user_id = preg_replace(sprintf('/%s/', md5('324CL_MembeR_CL324') ), '', $decrypted_id_raw);
		$user_info = get_userdata($user_id);
		$currentUserData = get_user_by( 'id', get_current_user_id() );
		if( $user_id ){
			$user_info = get_userdata($user_id);
			if( $user_info ){
				$unique = get_password_reset_key( $user_info );
				
				$unique_url = network_site_url("wp-login.php?action=rp&key=$unique&login=" . rawurlencode($user_info->user_login), 'login');
				$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
				$siteUrl = get_bloginfo('url');
				$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
				
				add_filter( 'wp_mail_from', function(){ return 'noreply@'.$_SERVER['HTTP_HOST']; } );
				add_filter( 'wp_mail_from_name', function(){ return sprintf( __( '%s','corsair-login'), get_option('blogname') ); } );
				add_filter('wp_mail_content_type', function(){ return "text/html"; } );
				$subject = sprintf(__("%s - Reset Password Link", 'corsair-login'), $blogname);
				$unique_url_txt = disable_email_link( $unique_url );
	
				$message = sprintf( __('<br><p>This is an e-mail from %s.</p> <p> You are receiving this email because we received a password reset request for your account.</p><br/> <p><a href="%s" target="_blank" REPLACE_STYLE>Reset Password</a></p><br/>If the button above does not work, paste this link into your web browser: <br> %s <br> If you did not make this request, you can safely ignore this e-mail.<br/><p>This is an automated message, please do not reply.</p><br/><p>Best regards,<br/>Amplivo</p>', 'corsair-login'),$blogname, esc_url($unique_url), $unique_url_txt );
				
				$htmlContent = mailTemplateHtmlRender( $message );
			/*	$sent_mail = wp_mail( $user_info->user_email, $subject, $htmlContent );
				if ( !$sent_mail ){
					$out = array( "error" => 1,'msg' => __('There was a problem sending you email. Please try again or contact an admin.','corsair-login') );
				}else{
					$logs = sprintf( __('Password reset link sent of %s by %s at %s', 'corsair-login'),$user_info->user_email, $currentUserData->user_email, date_i18n('d/m/Y H:i A') );
					create_corsairlogin_logs_entry( 0, 'member', '','sm', $logs, true  );
					$out = array( "error" => 0,'msg' => __('Password reset link sent.','corsair-login') );
				} */
			}
		}
	}
	echo wp_json_encode( $out );
	exit;
}
add_action( 'wp_ajax_cl_togglelogin_act', 'cl_togglelogin_act_callback' );
function cl_togglelogin_act_callback(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.','corsair-login') );
	if( wp_verify_nonce( $_POST['_micro'],'_XyToggleLoginEnableX_' ) && ( current_user_can( 'supportmanager' ) ) ){
		$decrypted_id_raw = base64_decode( $_POST['thisid'] );
		$togglelogin = $_POST['togglelogin'];
		$user_id = preg_replace(sprintf('/%s/', md5('324CL_MembeR_CL324') ), '', $decrypted_id_raw);
		$user_info = get_userdata($user_id);
		$currentUserData = get_user_by( 'id', get_current_user_id() );
		if( $user_id ){
			$user_info = get_userdata($user_id);
			if( $user_info ){
				$currentStatus = __('Suspended', 'corsair-login');
				if( $togglelogin == 1 ){
					update_user_meta( $user_id, 'csrnow_login_enable', 1 );
					$logs = sprintf( __('Login enabled of %s by %s at %s', 'corsair-login'),$user_info->user_email, $currentUserData->user_email, date_i18n('d/m/Y H:i A') );
					$currentStatus = __('Enabled', 'corsair-login');
				}else{
					update_user_meta( $user_id, 'csrnow_login_enable', 0 );
					$logs = sprintf( __('Login suspended of %s by %s at %s', 'corsair-login'),$user_info->user_email, $currentUserData->user_email, date_i18n('d/m/Y H:i A') );
				}
				create_corsairlogin_logs_entry( 0, 'member', '','sm', $logs, true  );
				$out = array( "error" => 0,'msg' => __('Success','corsair-login'), 'statusLabel' => $currentStatus );
			}
		}
	}
	echo wp_json_encode( $out );
	exit;
}
function disable_email_link($unique_url) {
	$unique_url_txt = str_replace('@', '&#x40;', '<p><span>' . esc_url( $unique_url ) . '</span></p>');
	$unique_url_txt = str_replace(':', '<span>:</span>', $unique_url_txt);
	$unique_url_txt = str_replace('.', '<span>.</span>', $unique_url_txt);
	return $unique_url_txt;
}
add_action('wp_ajax_dont_show_profile_page_action', 'dont_show_profile_page_action_logged_in_cb');
function dont_show_profile_page_action_logged_in_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.','corsair-login') );
	if( ( current_user_can( 'member' ) || current_user_can( 'supportagent' ) || current_user_can( 'supportmanager' ) ) ){
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		update_user_meta( $user_id, 'dont_show_2fa_profile_popup', 1 );
		$out = array( "error" => 0,'msg' => __('Success','corsair-login') );
	}
	echo wp_json_encode( $out );
	exit;
}
// 5753 code
add_action('wp_ajax_check_for_user_ga_twofa', 'check_for_user_ga_twofa_cb');
function check_for_user_ga_twofa_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.','corsair-login') );
	if( current_user_can( 'member' ) || current_user_can( 'supportagent' ) || current_user_can( 'supportmanager' ) ){
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		$thisType = ( isset( $_POST['thisType'] ) && ( $_POST['thisType'] == 'login' ) ) ? $_POST['thisType'] : '-';
		$google_auth_key = get_user_meta( $user_id, 'google_auth_key', true );
		if( !empty( $google_auth_key ) ){
			$out = array( "error" => 0,'msg' => __('Success','corsair-login'), 'isopen' => 0 );
			if( $thisType == 'login' ){
				update_user_meta( $user_id, 'google_auth_key_login', 1 );
			}
			$logs = sprintf( __('2FA google authenticator activated for %s by %s at %s', 'corsair-login'), $thisType, $current_user->user_email, date_i18n('d/m/Y H:i A') );
			create_corsairlogin_logs_entry( $user_id, 'profile', '','member', $logs, true  );
		}else{
			$out = array( "error" => 0,'msg' => __('Success','corsair-login'), 'isopen' => 1 );
		}
	}
	wp_send_json($out);
	exit;
}
add_action('wp_ajax_disable_for_user_ga_twofa', 'disable_for_user_ga_twofa_cb');
function disable_for_user_ga_twofa_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.','corsair-login') );
	if( ( current_user_can( 'member' ) || current_user_can( 'supportagent' ) || current_user_can( 'supportmanager' ) ) && wp_verify_nonce( $_POST['_micro'],'_CL_Toogle2FAMicro_LC_' ) ){
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		$thisType = ( isset( $_POST['thisType'] ) && ( $_POST['thisType'] == 'login' ) ) ? $_POST['thisType'] : '-';
		$google_auth_key = get_user_meta( $user_id, 'google_auth_key', true );
		if( !empty( $_POST['code'] ) ){
			$google2fa = new \PragmaRX\Google2FA\Google2FA();
			if( $google2fa->verifyKey($google_auth_key, $_POST['code'], 0) ){
				$out = array( "error" => 0,'msg' => __('Google 2FA is disabled','corsair-login'), 'thisType' => $thisType );
				if( $thisType == 'login' ){
					delete_user_meta( $user_id, 'google_auth_key_login' );
				}
				$logs = sprintf( __('2FA google authenticator disabled for %s by %s at %s', 'corsair-login'), $thisType, $current_user->user_email, date_i18n('d/m/Y H:i A') );
				create_corsairlogin_logs_entry( $user_id, 'profile', '','member', $logs, true  );
			}else{
				$out = array( "error" => 1,'msg' => __('Invalid 6-digit google authenticator code.','corsair-login') );
			}
		}else{
			$out = array( "error" => 1,'msg' => __('Please enter 6-digit google authenticator code.','corsair-login') );
		}
	}
	wp_send_json($out);
	exit;
}

/* register */

add_action('wp_ajax_nopriv_corsair_user_register', 'corsair_user_register_action');
function corsair_user_register_action(){
	$request_params = array(
		'username' => $_POST['username'],
		'birthdate' => $_POST['birthdate'],
		'gender' => $_POST['gender'],
		'email' => $_POST['email'],
		'sponsor_username' => $_POST['sponsor_username'],
		'firstname' => $_POST['firstname'],
		'lastname' => $_POST['lastname'],
		'address_line_1' => $_POST['address_line_1'],
		'address_line_2' => $_POST['address_line_2'],
		'city' => $_POST['city'],
		'state' => $_POST['state'],
		'zip' => $_POST['zip'],
		'country_id' => $_POST['country_id'],
		// Add other parameters as needed
	);
	$posted_data = $_POST; // Assuming the data is posted via a form

	// Define the required fields
	$required_fields = array(
		'username',
		'birthdate',
		'gender',
		'email',
		'sponsor_username',
		'firstname',
		'lastname',
		'address_line_1',
		'city',
		'state',
		'zip',
		'country_id'
		// Add other required fields here
	);

	// Initialize an array to store any missing fields
	$missing_fields = array();

	// Check for missing required fields
	foreach ($required_fields as $field) {
		if (empty($posted_data[$field])) {
			$missing_fields[] = $field;
		}
	}

	// If there are missing fields, construct an error response
	if (!empty($missing_fields)) {
		$error_msg = sprintf(
			__('The following fields are required: %s', 'corsair-login'),
			implode(', ', $missing_fields)
		);
		$out = array("error" => 1, 'msg' => $error_msg);
	} else {
		// Construct the request URL based on API mode
		$amplivo_api_mode = get_option('amplivo_api_mode');
		if ($amplivo_api_mode == 'live') {
			$sourceUrl = get_option('amplivo_api_live_source_url') . 'signup';
		} else {
			$sourceUrl = get_option('amplivo_api_test_source_url') . 'signup';
		}
		
		// Prepare the request arguments for wp_remote_post()
		$username = get_option( 'amplivo_api_auth_username' );
		$auth_password = get_option( 'amplivo_api_auth_pwd' );

		// Create an array with the request arguments, including Basic Auth in the headers
		$request_args = array(
			'headers' => array(
				'Authorization' => 'Basic ' . base64_encode( $username . ':' . $auth_password ),
				'Content-Type' => 'application/json', // Adjust content type if necessary
			),
			'body' => json_encode($request_params),
		);
		
		// Make the POST request using wp_remote_post()
		$responseApi = wp_remote_post($sourceUrl, $request_args);
		
		if (is_wp_error($responseApi)) {
			// Handle error
			$error_message = $responseApi->get_error_message();
			$out = array("error" => 1, 'msg' => $error_message);
		} else {
			// Get the response body
			$response_body = wp_remote_retrieve_body($responseApi);
		
			// Decode the response JSON data
			$data = json_decode($response_body);
			$out = array("success" => 1, 'data' => $data);
		}
		
	}

	// Send JSON response
	wp_send_json($out);
	
	
}