<?php
add_shortcode('CIP-MA-TOKEN-HOLDERS-LIST','cip_ma_token_holders_list_cb');
function cip_ma_token_holders_list_cb(){
	$html = "";
	ob_start();
	if( is_user_logged_in() && current_user_can('member_assistant') ){
		global $wpdb;
		$tableName = $wpdb->prefix.'token_holder';
		
		wp_enqueue_style( 'cip-css' );
		wp_enqueue_style( 'bs-table' );
		wp_enqueue_style( 'bs-sticky-header' );
		wp_enqueue_script('bs-table');
		wp_enqueue_script('bs-sticky-header');
		wp_enqueue_script('bs-table-filter-control');
		if( ( isset($_GET['action']) && $_GET['action'] === 'edit' ) && ( isset($_GET['id']) && is_numeric( $_GET['id'] ) ) ){
			global $wpdb;
			$getMember = $wpdb->get_row("SELECT * FROM $tableName WHERE id = ".$_GET['id']." AND ma_enabled = 1");
			if( $getMember ){
				global $defaultColumnsArr;
				unset( $defaultColumnsArr['imported_by'] );
				unset( $defaultColumnsArr['import_at'] );
				unset( $defaultColumnsArr['last_update_at'] );
				$columnOrders = get_option('cip_sm_column_order');
				$columnsArr = array();
				if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
					foreach( $columnOrders as $columnOrder ){
						$columnsArr[$columnOrder] = $defaultColumnsArr[$columnOrder];
					}
				}
				if( empty( $columnsArr ) ){
					$columnsArr = $defaultColumnsArr;
				}
				$saEditColOption = (array)get_option('cip_column_sa_toggle_columns');


			?>
			<div class="container">
			<form name="ma_member_update" id="ma_member_update">
				<div class="row">
				<?php
				if( $columnsArr ){
					$column_count = 0;
					foreach( $columnsArr as $columnKey => $columnLbl ){
						if( isset( $defaultColumnsArr[ $columnKey ] ) ){
							if( isset( $saEditColOption[ $columnKey ] ) ){
								$attr = 'id="'.$columnKey.'" name="'.$columnKey.'"';
							}else{
								continue;
							}
                            $extra_attr = "readonly disabled";
                            if( $columnKey == 'first_name' || $columnKey == 'last_name' || $columnKey == 'email' || $columnKey == 'eth_address' ){
                                $extra_attr = "";
                                if( $columnKey == 'eth_address' && !empty( $getMember->$columnKey ) ){
                                    $extra_attr = "readonly disabled";
                                    $attr = "";
                                }
                            }else{
                                $attr = "";
                            }
						?>
						<div class="col-md-4">
							<div class="form-group">
						    	<label for="<?php echo $columnKey ?>"><?php echo $columnKey; ?></label>
						    	<?php if( $columnKey == 'notes_internal' || $columnKey == 'notes_external' ){ ?>
						    		<textarea <?php echo $attr; ?> <?php echo $extra_attr; ?>><?php echo $getMember->$columnKey; ?></textarea>
						    	<?php }else{ ?>
						    		<input type="text" class="form-control" <?php echo $attr; ?> value="<?php echo $getMember->$columnKey; ?>" <?php echo $extra_attr; ?> />
						    	<?php } ?>
						  	</div>
						</div>
						<?php
						}
					}
				}
				?>
				</div>
				<div class="row">
				<div class="col-md-4">
					<div class="form-check">
						<input class="form-check-input" type="checkbox" value="1" name="update_all_match" id="update_all_match">
						<label class="form-check-label" for="update_all_match" style="margin-bottom: 0.5rem;padding-top: 0px !important;"><?php _e('Update all',CIP_TXTDOMAIN); ?></label>
					</div>
					<div class="form-group update_all_option_section" style="display: none;">
						<label for="update_all_option"><?php _e('Update all options', CIP_TXTDOMAIN); ?></label>
						<select class="form-control" name="update_all_option" id="update_all_option">
							<option value="single_row_update"><?php _e('Single row update', CIP_TXTDOMAIN); ?></option>
							<option value="all_username_update"><?php _e('All rows with this username', CIP_TXTDOMAIN); ?></option>
							<option value="all_email_update"><?php _e('All rows with this email', CIP_TXTDOMAIN); ?></option>
							<option value="all_reference_update"><?php _e('All rows with this reference number', CIP_TXTDOMAIN); ?></option>
							<option value="all_wallet_address_update"><?php _e('All rows with this wallet address', CIP_TXTDOMAIN); ?></option>
						</select>
					</div>
					<div class="form-group reference_update_section" style="display: none;">
						<label for="reference_update_field"><?php _e('Reference*', CIP_TXTDOMAIN); ?></label>
						<input type="text" class="form-control" name="reference_update_field" id="reference_update_field" />
					</div>
				</div>
				</div>
				<input type="hidden" name="action" value="ma_update_th_tp1_act" />
				<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XMAupdatethtp1MAX_'); ?>" />
				<input type="hidden" name="sathid" value="<?php echo $_GET['id']; ?>">
		  		<button type="submit" class="btn btn-primary"><?php _e('Update',CIP_TXTDOMAIN); ?></button>
		  		<p><span class="form_response"></span></p>
			</form>
			</div>
			<div class="modal fade" id="update_warning" tabindex="-1" role="dialog" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered" role="document">
				<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title"><span class="fa fa-exclamation-circle"></span> <?php _e('Warning', CIP_TXTDOMAIN); ?></h5>
				</div>
				<div class="modal-body">
					<h5><?php _e('Exercise caution and double check any updates',CIP_TXTDOMAIN); ?></h5>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Close',CIP_TXTDOMAIN); ?></button>
				</div>
				</div>
			</div>
			</div>
			<?php
			}
		}else{
		?>
		<div class="container">
		
		<div class="table-responsive">
		<?php

			$user_id = get_current_user_id();
			if( !metadata_exists( 'user', $user_id, 'cip_sagent_toggle_columns' ) ){
				$columnsSAColumnOption = (array)get_option('cip_column_sa_toggle_columns');
				update_user_meta( $user_id, 'cip_sagent_toggle_columns', $columnsSAColumnOption );
			}

			$saUserData = get_user_by( 'id', $user_id );
			global $defaultColumnsArr;
			if( $saUserData && in_array( "member_assistant", $saUserData->roles ) ){

				$columnOrders = (array)get_option('cip_sm_column_order');
				$columnsLabelArr = (array)get_option('cip_sm_column_labels');
				$columnsSAColumnOption = (array)get_option('cip_column_sa_toggle_columns');
				$columnsArr = array();
				if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
					if( empty( $columnsArr ) ){
						foreach( $columnOrders as $columnOrder ){
							if( isset( $columnsSAColumnOption[$columnOrder] ) ){
								$columnsArr[$columnOrder] = ( isset( $columnsLabelArr[$columnOrder] ) && !empty( $columnsLabelArr[$columnOrder] ) ) ? $columnsLabelArr[$columnOrder] : $defaultColumnsArr[$columnOrder];
							}
						}
					}
				}else{
					unset( $defaultColumnsArr['imported_by'] );
					unset( $defaultColumnsArr['import_at'] );
					unset( $defaultColumnsArr['last_update_at'] );
					$columnsArr = $defaultColumnsArr;
				}

			}else{
				unset( $defaultColumnsArr['imported_by'] );
				unset( $defaultColumnsArr['import_at'] );
				unset( $defaultColumnsArr['last_update_at'] );
				$columnsArr = $defaultColumnsArr;
			}
		?>
	    <table id="tokenholder_table_ma" class="ma_own_holder" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="true" data-show-columns-toggle-all="true" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
			<thead>
			<tr>
				<th data-field="id" class="id"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
				<?php
				if( $columnsArr ){
					foreach( $columnsArr as $columnKey => $columnsVal ){
						$filter_attr = 'data-filter-control="input"';
						$filterData_attr = '';
						if( $columnKey == '_user_status' || $columnKey == 'kyc_status' || $columnKey == 'corp_approved'  ){
							if( $columnKey == '_user_status' ){
								$filterData_attr = ' data-filter-data="var:filterUserStatus"';
							}
							if( $columnKey == 'kyc_status' ){
								$filterData_attr = ' data-filter-data="var:filterKycStatus"';
							}
							if( $columnKey == 'corp_approved' ){
								$filterData_attr = ' data-filter-data="var:filterCorpApproved"';
							}
							$filter_attr = 'data-filter-control="select" class="status" data-filter-custom-search="BsTableFilterStatus"'.$filterData_attr;
						}

					?>
					<th data-field="<?php echo $columnKey ?>" data-sortable="true" <?php echo $filter_attr; ?> class="<?php echo $columnKey ?>"><?php echo $columnsVal; ?></th>
					<?php
					}
				}
				?>
				<th data-field="action" class="action"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
			</tr>
			</thead>
			<tbody>
			</tbody>
		</table>

		</div>

	</div>
	<?php } ?>
	<?php
	}else{
		?><h2><?php echo __('No record(s) found', CIP_TXTDOMAIN); ?></h2><?php
	}
	$html .= ob_get_clean();
	return $html;
}
add_filter( 'login_redirect', 'cip_ma_login_redirect', 10, 3 );
function cip_ma_login_redirect( $redirect_to, $request, $user ) {
    global $user;
    if( isset( $user->roles ) && is_array( $user->roles ) ){
        if( in_array( 'member_assistant', $user->roles ) ){
			$redirect_to = home_url();
		}
    }
	return $redirect_to;
}