jQuery("#yearly,#single_payment").hide();
function getUrlParameter(sParam) {
  var sPageURL = window.location.search.substring(1),
    sURLVariables = sPageURL.split("&"),
    sParameterName,
    i;
  for (i = 0; i < sURLVariables.length; i++) {
    sParameterName = sURLVariables[i].split("=");
    if (sParameterName[0] === sParam) {
      return sParameterName[1] === undefined
        ? true
        : decodeURIComponent(sParameterName[1]);
    }
  }
  return false;
}
const swalToast = Swal.mixin({
  toast: true,
  animation: true,
  position: "bottom",
  showConfirmButton: false,
  timer: 4000,
});
jQuery(document).ready(function ($) {
  var notifyErrorOpt = {
    position: "top",
    className: "error",
    autoHide: true,
    autoHideDelay: 3000,
    clickToHide: true,
  };
  var block_config = {
    message: null,
    overlayCSS: { backgroundColor: "#fff", opacity: 0.8 },
  };
  $(document).on("submit", "#maintenance_form", function (e) {
    e.preventDefault();
    $form = $(this);
    $form.block(block_config);
    var data = new FormData($form[0]);
    data.append("action", "save_maintenance_mode");
    $.ajax({
      url: cipscript.ajax_url,
      type: "post",
      data: data,
      processData: false,
      contentType: false,
      success: function (response) {
        var obj = JSON.parse(response);
        $form.unblock();
        if (obj.error == 0) {
          swalToast({ type: "success", title: obj.msg });
        } else {
          swalToast({ type: "error", title: obj.msg });
        }
      },
    });
  });
  if ($(".sm_import_mi_frm").length > 0) {
    var current_fs, next_fs, previous_fs; //fieldsets
    var opacity;
    var current = 1;
    var steps = $("fieldset").length;
    var $form = $(".sm_import_mi_frm");
    setProgressBar(current);
    $(".next").click(function () {
      current_fs = $(this).parent();
      next_fs = $(this).parent().next();

      if (current == 1) {
        var mi_csv_file = $("body")
          .find('.sm_import_mi_frm input[name="mi_csv_file"]')
          .val();
        if (typeof mi_csv_file === "undefined" || mi_csv_file == "") {
          $(this).notify("Please choose file", notifyErrorOpt);
          return false;
        }
        var data = new FormData($form[0]);
        $form.block(block_config);
        $.ajax({
          url: cipscript.ajax_url,
          type: "post",
          data: data,
          processData: false,
          contentType: false,
          success: function (response) {
            var obj = $.parseJSON(response);
            console.dir(obj);
            if (obj.error == 0) {
              $(".import_update_response").html(obj.logs);
              $("#progressbar li")
                .eq($("fieldset").index(next_fs))
                .addClass("active");
              next_fs.show();
              current_fs.animate(
                { opacity: 0 },
                {
                  step: function (now) {
                    opacity = 1 - now;
                    current_fs.css({
                      display: "none",
                      position: "relative",
                    });
                    next_fs.css({ opacity: opacity });
                  },
                  duration: 500,
                }
              );
              setProgressBar(++current);
            }
            $form.unblock();
          },
        });
        $("#investment_interested_frm").block(block_config);
      } else {
        $("#progressbar li")
          .eq($("fieldset").index(next_fs))
          .addClass("active");
        next_fs.show();
        current_fs.animate(
          { opacity: 0 },
          {
            step: function (now) {
              opacity = 1 - now;
              current_fs.css({
                display: "none",
                position: "relative",
              });
              next_fs.css({ opacity: opacity });
            },
            duration: 500,
          }
        );
        setProgressBar(++current);
      }
    });
    $(".previous").click(function () {
      current_fs = $(this).parent();
      previous_fs = $(this).parent().prev();
      //Remove class active
      $("#progressbar li")
        .eq($("fieldset").index(current_fs))
        .removeClass("active");
      //show the previous fieldset
      previous_fs.show();
      //hide the current fieldset with style
      current_fs.animate(
        { opacity: 0 },
        {
          step: function (now) {
            // for making fielset appear animation
            opacity = 1 - now;
            current_fs.css({
              display: "none",
              position: "relative",
            });
            previous_fs.css({ opacity: opacity });
          },
          duration: 500,
        }
      );
      setProgressBar(--current);
    });
    function setProgressBar(curStep) {
      var percent = parseFloat(100 / steps) * curStep;
      percent = percent.toFixed();
      $(".progress-bar").css("width", percent + "%");
    }
    $("input[name='th_csv_file']").on("change", function (e) {
      var is_error = false;
      var this_ext = $(this).val().split(".").pop().toLowerCase();
      console.log(this_ext);
      if ($.inArray(this_ext, ["csv"]) == -1) {
        is_error = true;
        $(this).notify("Choose valid csv file", notifyErrorOpt);
        $(this).val("");
      }
    });
  }
  //remove members invoice by sm
  $("body").on("submit", "#smclearmi_frm", function () {
    Swal({
      title: "Are you sure?",
      text:
        "Are you sure you want to clear " + cipscript.allminum + " records?",
      type: "warning",
      showCancelButton: true,
      confirmButtonText: "Yes",
    }).then((result) => {
      if (result.value) {
        $form = $(this);
        $form.find(".form_response").html("");
        var data = $(this).serialize();
        $form.block(block_config);
        $.post(cipscript.ajax_url, data, function (response) {
          var obj = JSON.parse(response);
          $form.unblock();
          $form.find(".form_response").html(obj.msg);
        });
      }
    });
    return false;
  });
  //maintenance mode enable/disable
  $("body").on("change", "#routine_maintenance_mode", function (event) {
    var checked = $(this).is(":checked");
    var $thisCheck = $(this);

    $("#routine_maintenance_frm").submit();
    event.preventDefault();
    event.stopPropagation();
  });
  // MEMBER MAINTENANCE MODE
  $("body").on("change", "#member_maintenance_mode", function (event) {
    var checked = $(this).is(":checked");
    var $thisCheck = $(this);
    $("#member_maintenance_mode").submit();
    event.preventDefault();
    event.stopPropagation();
  });
  // SITE MAINTENANCE MODE
  $("body").on("change", "#site_maintenance_mode", function (event) {
    var checked = $(this).is(":checked");
    var $thisCheck = $(this);
    $("#site_maintenance_mode").submit();
    event.preventDefault();
    event.stopPropagation();
  });
  $("body").on("change", "#retirement_maintenance_mode", function (event) {
    var checked = $(this).is(":checked");
    var $thisCheck = $(this);
    $("#retirement_maintenance_mode").submit();
    event.preventDefault();
    event.stopPropagation();
  });
  // support ticket mode
  $("body").on("change", "#support_ticket_mode", function (event) {
    $("#smsupport_endpoint").submit();
  });
  $("body").on("submit", "#smsupport_endpoint", function () {
    $form = $(this);
    $form.find(".form_response").html("");
    var data = $(this).serialize();
    $form.block(block_config);
    $.post(cipscript.ajax_url, data, function (response) {
      var obj = JSON.parse(response);
      $form.unblock();
      $form.find(".form_response").html(obj.msg);
    });
    return false;
  });

  $("body").on("submit", "#redeem_amplivo_gift_code_funcation", function () {
    $form = $(this);
    $form.find(".form_response").html("");
    var data = $(this).serialize();
    $form.block(block_config);
    $.post(cipscript.ajax_url, data, function (response) {
      var obj = JSON.parse(response);
      $form.unblock();
      // $form.find('.form_response').html( obj.msg );
      if (obj.error == 0) {
        jQuery(".redeem_gift_code_contant").html(obj.html);
        jQuery("#amplivo_gift_code_popup").val(1);
        jQuery("#redeem_gift_code_modal").modal("show");
      } else {
        Swal.fire({
          type: "error",
          title: obj.msg,
          text: "",
          allowOutsideClick: false,
        });
      }
    });
    return false;
  });
  $(document).on("hidden.bs.modal", "#redeem_gift_code_modal", function () {
    jQuery(".redeem_gift_code_contant").html("");
    jQuery("#amplivo_gift_code_popup").val(0);
  });
  $(document).on("click", "#gift_code_now", function () {
    $form = $(redeem_gift_code_modal);
    $form.find(".form_response").html("");
    var data = $("#redeem_amplivo_gift_code_funcation").serialize();
    $form.block(block_config);
    $.post(cipscript.ajax_url, data, function (response) {
      var obj = JSON.parse(response);
      $form.unblock();
      // $form.find('.form_response').html( obj.msg );
      if (obj.error == 0) {
        $("#redeem_gift_code").val("");
        Swal.fire({
          type: "success",
          title: obj.msg,
          text: "",
          allowOutsideClick: false,
        });
        // window.location.reload();
        setTimeout(() => {
          jQuery("#redeem_gift_code_modal").modal("hide");
          Swal.close();
        }, 10000);
      } else {
        Swal.fire({
          type: "error",
          title: obj.msg,
          text: "",
          allowOutsideClick: false,
        });
      }
    });
    return false;
  });
  $("body").on("submit", "#routine_maintenance_frm", function () {
    $form = $(this);
    $form.find(".form_response").html("");
    var data = $(this).serialize();
    $form.block(block_config);
    $.post(cipscript.ajax_url, data, function (response) {
      var obj = JSON.parse(response);
      $form.unblock();
      swalToast({ type: "success", title: obj.msg });
    });
    return false;
  });
  // MEMBER MAINTENANCE MODE
  $("body").on("submit", "#member_maintenance_frm", function () {
    $form = $(this);
    $form.find(".form_response").html("");
    var data = $(this).serialize();
    $form.block(block_config);
    $.post(cipscript.ajax_url, data, function (response) {
      var obj = JSON.parse(response);
      $form.unblock();
      $form.find(".form_response").html(obj.msg);
    });
    return false;
  });
  // Site MAINTENANCE MODE
  $("body").on("submit", "#site_maintenance_frm", function () {
    $form = $(this);
    $form.find(".form_response").html("");
    var data = $(this).serialize();
    $form.block(block_config);
    $.post(cipscript.ajax_url, data, function (response) {
      var obj = JSON.parse(response);
      $form.unblock();
      swalToast({ type: "success", title: obj.msg });
    });
    return false;
  });
  $("body").on("submit", "#retirement_maintenance_frm", function () {
    $form = $(this);
    $form.find(".form_response").html("");
    var data = $(this).serialize();
    $form.block(block_config);
    $.post(cipscript.ajax_url, data, function (response) {
      var obj = JSON.parse(response);
      $form.unblock();
      $form.find(".form_response").html(obj.msg);
    });
    return false;
  });
  $("#viewMoreModal").on("show.bs.modal", function (event) {
    var button = $(event.relatedTarget);
    var viewmoreContent = button.data("viewmore");
    var modal = $(this);
    modal.find(".modal-body").html("");
    modal.find(".modal-body").html(viewmoreContent);
  });
  if ($("#cip_logs_table").length > 0) {
    var $tableTH = $("#cip_logs_table");
    $tableTH.bootstrapTable();
  }
  //#4966

  $("body").on("click", "button#show_all", function () {
    $("table.table-borderless tbody").find("tr").css("display", "table-row");
  });
  $("body").on("click", "button#error_all", function () {
    $("table.table-borderless tbody").find("tr").css("display", "none");
    $("table.table-borderless tbody")
      .find("tr.table-danger")
      .css("display", "table-row");
  });

  var block_config = {
    message: null,
    overlayCSS: { backgroundColor: "#fff", opacity: 0.8 },
  };
  $("body").on("change", ".proforma_toggle", function (event) {
    var selected_id = $(this).val();
    var this_toggle_status = $(this).parent().find(".proforma_toggle_status");
    var refElem = $(this).parent().find(".ref_val");
    var ref = refElem.val();
    // alert(ref);
    var data = { id: selected_id, ref: ref, action: "proforma_toggle_action" };
    var current_tr = $(this).closest("tr");
    var checked = $(this).is(":checked");
    var $thisCheck = $(this);
    if (!checked) {
      Swal({
        title: "",
        html: "<h5> You are about to mark the Invoice as unpaid <br/> Are you sure?</h5>",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Confirm",
      }).then((result) => {
        if (result.value) {
          current_tr.block(block_config);
          jQuery.ajax({
            type: "post",
            data: data,
            cache: false,
            url: cipscript.ajax_url,
            dataType: "html",
            success: function (response) {
              var obj = JSON.parse(response);
              if (obj.error == 0) {
                this_toggle_status.html(obj.status);
                refElem.val(obj.status);
              }
              current_tr.unblock();
            },
          });
        } else {
          $thisCheck.prop("checked", true);
          return false;
        }
      });
    } else {
      current_tr.block(block_config);
      jQuery.ajax({
        type: "post",
        data: data,
        cache: false,
        url: cipscript.ajax_url,
        dataType: "html",
        success: function (response) {
          var obj = JSON.parse(response);
          if (obj.error == 0) {
            this_toggle_status.html(obj.status);
            refElem.val(obj.status);
          }
          current_tr.unblock();
        },
      });
    }
  });
  // ARCHIEVE STATUS JS
  $("body").on("change", ".archive_toggle", function (event) {
    var selected_id = $(this).val();
    var this_toggle_status = $(this)
      .parent()
      .parent()
      .find(".archive_toggle_status");
    var archElem = $(this).parent().find(".arch_val");
    var arch = archElem.val();
    var data = { id: selected_id, arch: arch, action: "archive_toggle_action" };
    var current_tr = $(this).closest("tr");
    var checked = $(this).is(":checked");
    var $thisCheck = $(this);
    if (!checked) {
      Swal({
        title: "",
        html: "<h5> You are about to mark the Archive Status as No <br/> Are you sure?</h5>",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Confirm",
      }).then((result) => {
        if (result.value) {
          current_tr.block(block_config);
          jQuery.ajax({
            type: "post",
            data: data,
            cache: false,
            url: cipscript.ajax_url,
            dataType: "html",
            success: function (response) {
              var obj = JSON.parse(response);
              if (obj.error == 0) {
                this_toggle_status.html(obj.status);
                archElem.val(obj.status);
              }
              current_tr.unblock();
            },
          });
        } else {
          $thisCheck.prop("checked", true);
          return false;
        }
      });
    } else {
      current_tr.block(block_config);
      jQuery.ajax({
        type: "post",
        data: data,
        cache: false,
        url: cipscript.ajax_url,
        dataType: "html",
        success: function (response) {
          var obj = JSON.parse(response);
          if (obj.error == 0) {
            this_toggle_status.html(obj.status);
            archElem.val(obj.status);
          }
          current_tr.unblock();
        },
      });
    }
  });
  // END CODE SECTION

  // 	BECOME PLASTIC NEUTRAL PAGE FUNCTINALITY
  function addCommas(nStr) {
    nStr += "";
    x = nStr.split(".");
    x1 = x[0];
    x2 = x.length > 1 ? "." + x[1] : "";
    var rgx = /(\d+)(\d{3})/;
    while (rgx.test(x1)) {
      x1 = x1.replace(rgx, "$1" + "," + "$2");
    }
    return x1 + x2;
  }
  jQuery("input[type=range]").on("input", function () {
    jQuery(this).trigger("change");
  });
  if ($(window).width() >= 1024) {
    jQuery("#kgText,#kgText1,#kgText2").css({
      display: "block",
      "text-align": "center",
      "font-size": "90px",
      "font-weight": "bold",
      color: "#6050c8",
    });
  } else {
    jQuery("#kgText,#kgText1,#kgText2").css({
      display: "block",
      "text-align": "center",
      "font-size": "55px",
      "font-weight": "bold",
      color: "#6050c8",
    });
  }
  var incCsr = cipscript.incCsr;
  var selling_price = parseFloat(cipscript.selling_price);
  var url = window.location.hostname;
  var page_url = url;
  var priceAmt = parseInt($('div#monthly input[type="range"]').val());
  if (priceAmt == 0) {
    priceAmt = 10;
  }
  var kgs = cip_convert_kgs_by_price(priceAmt);
  jQuery("#monthly_plastic_waste").text(addCommas(kgs));
  jQuery("#yearly_val,#oneTime_val,#monthly_val").text(addCommas(kgs));
  jQuery("#kgPlastic_range").text(addCommas(priceAmt));
  var inclusive_csr = cip_convert_csr_by_price(priceAmt);
  jQuery("#inclusive-csr").text(addCommas(inclusive_csr));
  jQuery("#plastic_amt").val(kgs);
  jQuery("#total_price").val(priceAmt);
  jQuery(".confirmBtn").click(function () {
    jQuery("#buyfrm").submit();
  });
  // TRIGGER RANGE SLIDER ON CLICK NEXT/PREVIOUS ARROWS
  jQuery(".monthly_next").click(function () {
    jQuery("#plasticRange")
      .val(parseInt(jQuery("#plasticRange").val()) + 10)
      .trigger("change");
  });
  jQuery(".monthly_previous").click(function () {
    jQuery("#plasticRange")
      .val(parseInt(jQuery("#plasticRange").val()) - 10)
      .trigger("change");
  });
  // END CODE SECTION
  jQuery(`input[name='plastic_waste']`).change(function () {
    var frequency = $(this).val();
    $("#monthText").html(frequency);
    $(".paymentType").html(" (" + frequency + ")");
  });
  jQuery(`input[type='range']`).change(function () {
    var priceAmt = parseInt(jQuery(this).val());
    if (priceAmt == 0) {
      priceAmt = 10;
    }
    var kgs = cip_convert_kgs_by_price(priceAmt);
    jQuery("#monthly_plastic_waste").text(addCommas(kgs));
    jQuery("#yearly_val,#oneTime_val,#monthly_val").text(addCommas(kgs));
    jQuery("#kgPlastic_range").text(addCommas(priceAmt));
    var inclusive_csr = cip_convert_csr_by_price(priceAmt);
    jQuery("#inclusive-csr").text(addCommas(inclusive_csr));
    jQuery("#plastic_amt").val(kgs);
    jQuery("#total_price").val(priceAmt);
    $(`input[name='custom_amount']`).val("");
    jQuery(".confirmBtn").show();
    jQuery(".invalid-feedback").hide();
  });
  jQuery(`input[name='custom_amount']`).keyup(function (e) {
    var priceAmt = parseInt(jQuery(this).val());
    if (isNaN(priceAmt)) {
      priceAmt = 0;
      jQuery(this).val("");
    }

    if (priceAmt < 10) {
      priceAmt = 10;
      jQuery(this).closest(".input-group").find(".invalid-feedback.min").show();
      jQuery(".confirmBtn").hide();
    } else {
      jQuery(".confirmBtn").show();
      jQuery(this).closest(".input-group").find(".invalid-feedback.min").hide();
    }
    if (priceAmt > 500000) {
      priceAmt = 500000;
      jQuery(this).val(priceAmt);
      jQuery(this).closest(".input-group").find(".invalid-feedback.max").show();
    } else {
      jQuery(this).closest(".input-group").find(".invalid-feedback.max").hide();
    }
    var kgs = cip_convert_kgs_by_price(priceAmt);
    jQuery("#monthly_plastic_waste").text(addCommas(kgs));
    jQuery("#yearly_val,#oneTime_val,#monthly_val").text(addCommas(kgs));
    jQuery("#kgPlastic_range").text(addCommas(priceAmt));
    var inclusive_csr = cip_convert_csr_by_price(priceAmt);
    jQuery("#inclusive-csr").text(addCommas(inclusive_csr));
    jQuery("#plastic_amt").val(kgs);
    jQuery("#total_price").val(priceAmt);
    var keyCode = e.keyCode || e.which;
    if (keyCode === 13) {
      e.preventDefault();
      return false;
    }
  });
  jQuery(`input[name='custom_amount']`).keypress(function (e) {
    var charCode = e.which ? e.which : e.keyCode;
    if (charCode === 13) {
      e.preventDefault();
      return false;
    }
    if (String.fromCharCode(charCode).match(/[^0-9]/g)) return false;
  });
  function cip_convert_csr_by_price(price = 10) {
    var csr_amount = Math.round(parseFloat(price / selling_price).toFixed(2));
    return csr_amount;
  }
  function cip_convert_kgs_by_price(price = 10) {
    var csr_amount = price / selling_price;
    var kgs = Math.round(parseFloat(csr_amount / 10).toFixed(2));
    return kgs;
  }
  // END CODE SECTION

  $("body").on("submit", "#sm_api_settings", function () {
    $form = $(this);
    $form.find(".form_response").html("");
    var data = $(this).serialize();
    $form.block(block_config);
    $.post(cipscript.ajax_url, data, function (response) {
      var obj = JSON.parse(response);
      $form.unblock();
      $form.find(".form_response").html(obj.msg);
    });
    return false;
  });

  $("body").on("submit", "#sm_csr_wallet_settings", function () {
    $form = $(this);
    $form.find(".form_response").html("");
    var data = $(this).serialize();
    $form.block(block_config);
    $.post(cipscript.ajax_url, data, function (response) {
      var obj = JSON.parse(response);
      $form.unblock();
      $form.find(".form_response").html(obj.msg);
    });
    return false;
  });

  jQuery(`input[name='csr_wallet_api_mode']`).change(function () {
    var thisVal = $(this).val();
    if (thisVal == "live") {
      $(".csr_wallet_api_mode_live").show();
      $(".csr_wallet_api_mode_test").hide();
    } else {
      $(".csr_wallet_api_mode_live").hide();
      $(".csr_wallet_api_mode_test").show();
    }
  });
  /* SA 2FA */
  if ($(".smsaGa2faEnableFrm").length > 0) {
    var current_fs, next_fs, previous_fs; //fieldsets
    var opacity;
    var current = 1;
    var steps = $("body").find(".smsaGa2faEnableFrm fieldset").length;
    setProgressBarWdGa(current);

    $("body").on("click", ".next_wdga", function (event) {
      var this_next = $(this);
      current_fs = $(this).parent();
      next_fs = $(this).parent().next();
      // console.log( current );

      var $form = $("body").find(".smsaGa2faEnableFrm");
      if (current == 3) {
        google2FaWdelivery(event, "google2fa");
      } else {
        $(".smsaGa2faEnableFrm #progressbar li")
          .eq($(".smsaGa2faEnableFrm fieldset").index(next_fs))
          .addClass("active");
        next_fs.show();
        current_fs.animate(
          { opacity: 0 },
          {
            step: function (now) {
              opacity = 1 - now;

              current_fs.css({
                display: "none",
                position: "relative",
              });
              next_fs.css({ opacity: opacity });
            },
            duration: 500,
          }
        );
        setProgressBarWdGa(++current);
      }
    });

    $("body").on("click", ".previous_wdga", function () {
      current_fs = $(this).parent();
      previous_fs = $(this).parent().prev();
      // console.log( current );

      $(".smsaGa2faEnableFrm #progressbar li")
        .eq($(".smsaGa2faEnableFrm fieldset").index(current_fs))
        .removeClass("active");

      previous_fs.show();

      current_fs.animate(
        { opacity: 0 },
        {
          step: function (now) {
            opacity = 1 - now;

            current_fs.css({
              display: "none",
              position: "relative",
            });
            previous_fs.css({ opacity: opacity });
          },
          duration: 500,
        }
      );
      setProgressBarWdGa(--current);
    });

    function setProgressBarWdGa(curStep) {
      var percent = parseFloat(100 / steps) * curStep;
      percent = percent.toFixed();
      $("body")
        .find(".smsaGa2faEnableFrm .progress-bar")
        .css("width", percent + "%");
    }

    function google2FaWdelivery(event, fid) {
      event.preventDefault();
      if (fid == "google2fa") {
        if ($("#google_auth_key").val() != $("#backupkey").val()) {
          swalToast({
            type: "error",
            title: "Please enter valid backup key to continue.",
          });
          return false;
        }
      }

      let form = $('form[name="smsaGa2faEnableFrm"');
      let formData = $('form[name="smsaGa2faEnableFrm"]')[0];
      let request = new FormData(formData);

      $(form).block(block_config);
      $(form).addClass("working");
      $(form).find("input, button").prop("disabled", true);

      $.ajax({
        url: cipscript.ajax_url,
        type: "POST",
        data: request,
        processData: false,
        contentType: false,
        success: function (response) {
          //var obj = JSON.parse( response );
          if (response.error == 0) {
            // Swal.fire({ type: 'success', title: response.msg, text: '',allowOutsideClick: true}).then(function(){ window.location.reload(); });
            swalToast({ type: "success", title: response.msg }).then(
              function () {
                window.location.reload();
              }
            );

            $("#ga2fa_walletdelivery").prop("checked", true);
            $("#ga2fa_smsa_login").prop("checked", true);
            /* if( response.thisType == 'delivery' ){
									$('#ga2fa_walletdelivery').prop( "checked", true );
								}else if( response.thisType == 'login' ){
									$('#ga2fa_smsa_login').prop( "checked", true );
								} */
            $("#enableSmSaGa2faModal").modal("hide");
          } else {
            // Swal.fire({ type: 'error', title: response.msg, text: '',allowOutsideClick: true}).then(function(){ });
            swalToast({ type: "error", title: response.msg });
          }
          $(form).find("input, button").prop("disabled", false);
          $(form).removeClass("working");
          $(form).unblock();
        },
      });
      return false;
    }
  }
  /* SA 2FA  END*/
});
const ethereum = window.ethereum;
var DataEncrypt = cryptojs.web3provider;
var DataKey = CryptoJS.enc.Utf8.parse(cryptojs.cipEncki);
var DataVector = CryptoJS.enc.Utf8.parse(cryptojs.cipEncvct);
var decrypted = CryptoJS.AES.decrypt(DataEncrypt, DataKey, { iv: DataVector });
var decrypted = CryptoJS.enc.Utf8.stringify(decrypted);
const cipweb3 = new Web3(new Web3.providers.HttpProvider(decrypted));
const cipABI = [
  {
    constant: true,
    inputs: [{ name: "_owner", type: "address" }],
    name: "balanceOf",
    outputs: [{ name: "balance", type: "uint256" }],
    type: "function",
  },
];
function reloadPage() {
  window.location.reload();
}
//csr schedular
$("body").on("submit", "#cip_schedule_changer", function () {
  $form = $(this);
  $form.find(".form_response").html("");
  var selling_price_csr = $(this).find('input[name="selling_price_csr"]').val();
  var price_type = $(this).find('select[name="price_type"]').val();
  var schedule_time = $(this).find('input[name="schedule_time"]').val();
  console.log(price_type);
  if (selling_price_csr == "" || price_type == "" || price_type == null) {
    $form.find(".form_response").html("* Fields are required");
    return false;
  }
  if (price_type == "scheduled" && schedule_time == "") {
    $form.find(".form_response").html("* Fields are required");
    return false;
  }
  var data = $(this).serialize();
  $form.block(block_config);
  $.post(cipscript.ajax_url, data, function (response) {
    var obj = JSON.parse(response);
    $form.unblock();
    $form.find(".form_response").html(obj.msg);
    if (obj.error == 0) {
      window.location.href = obj.redirect_url;
    }
  });
  return false;
});
$('#cip_schedule_changer select[name="price_type"]').on("change", function () {
  var thisVal = $(this).val();
  if (thisVal == "scheduled") {
    $(".time_schedule").slideDown();
  } else {
    $(".time_schedule").slideUp();
  }
});
$("body").on("click", ".del_scheduler", function () {
  var current_tr = $(this).closest("tr");
  Swal({
    title: "Are you sure?",
    text: "Are you sure you want to delete CSR schedular?",
    type: "warning",
    showCancelButton: true,
    confirmButtonText: "Yes",
  }).then((result) => {
    if (result.value) {
      var thisid = current_tr.attr("data-schedular");
      current_tr.block(block_config);
      var data = {
        action: "cip_schedular_remover",
        thisid: thisid,
        _micro: cipscript.microschedulardel,
      };
      $form.block(block_config);
      $.post(cipscript.ajax_url, data, function (response) {
        var obj = JSON.parse(response);
        current_tr.unblock();
        if (obj.error == 0) {
          Swal.fire({
            type: "success",
            title: obj.msg,
            text: "",
            allowOutsideClick: false,
          });
          window.location.reload();
        } else {
          Swal.fire({
            type: "error",
            title: obj.msg,
            text: "",
            allowOutsideClick: false,
          });
        }
        current_tr.unblock();
      });
    }
  });
  return false;
});
if ($('[data-toggle="tooltip"]').length > 0) {
  $('[data-toggle="tooltip"]').tooltip();
}
//4966
jQuery(document).ready(function ($) {
  var notifyErrorOpt = {
    position: "bottom",
    className: "error",
    autoHide: true,
    autoHideDelay: 3000,
    clickToHide: true,
  };
  var block_config = {
    message: null,
    overlayCSS: { backgroundColor: "#fff", opacity: 0.8 },
  };
  var block_config_spinner = {
    css: { backgroundColor: "transparent", border: "none" },
    message: '<div class="blockUIspinner"></div>',
    baseZ: 1500,
    overlayCSS: { backgroundColor: "#FFFFFF", opacity: 0.8, cursor: "wait" },
  };
  $(document).on("submit", "#sm_ampliov_url_set_frm", function (event) {
    event.preventDefault();
    $form = $(this);
    var data = $(this).serialize();
    $form.block(block_config_spinner);
    $.post(cipscript.ajax_url, data, function (response) {
      var obj = JSON.parse(response);
      $form.unblock();
      if (obj.error == 0) {
        swalToast({ type: "success", title: obj.msg });
      } else {
        swalToast({ type: "error", title: obj.msg });
      }
    });
    return false;
  });

  $(document).on("submit", "#sm_ampliov_price_type_setting_form", function (event) {
    event.preventDefault();
    $form = $(this);
    var data = $(this).serialize();
    $form.block(block_config_spinner);
    $.post(cipscript.ajax_url, data, function (response) {
      var obj = JSON.parse(response);
      $form.unblock();
      if (obj.error == 0) {
        swalToast({ type: "success", title: obj.msg });
      } else {
        swalToast({ type: "error", title: obj.msg });
      }
    });
    return false;
  });
  $(document).on("submit", "#sm_selling_price_csr25_setting_form", function (event) {
    event.preventDefault();
    $form = $(this);
    var data = $(this).serialize();
    $form.block(block_config_spinner);
    $.post(cipscript.ajax_url, data, function (response) {
      var obj = JSON.parse(response);
      $form.unblock();
      if (obj.error == 0) {
        swalToast({ type: "success", title: obj.msg });
      } else {
        swalToast({ type: "error", title: obj.msg });
      }
    });
    return false;
  });

  $("body").on("click", ".cip_notice_dismiss", function () {
    var dont_show = $(this).prev().find("input[name=dont_show]").is(":checked");
    var dont_show_again = 0;
    if (dont_show) {
      dont_show_again = 1;
    }
    var thisAlert = $(this).parent().closest(".alert");
    var formData = {
      action: "cip_dismiss_notice_action",
      thisnotice: $(this).attr("data-id"),
      dont_show: dont_show_again,
    };
    console.log(formData);
    $.ajax({
      method: "POST",
      url: cipscript.ajax_url,
      data: formData,
      success: function (response) {
        var obj = JSON.parse(response);
        if (obj.error == 0) {
          thisAlert.alert("close");
        }
        $form.unblock();
      },
      error: function () {
        console.log("An error was encountered");
        $form.unblock();
      },
    });
  });
  $(".vat_rate_field").keypress(function (event) {
    if (
      (event.which != 46 || $(this).val().indexOf(".") != -1) &&
      (event.which < 48 || event.which > 57) &&
      event.which != 0 &&
      event.which != 8
    ) {
      event.preventDefault();
    }

    var text = $(this).val();

    if (
      text.indexOf(".") != -1 &&
      text.substring(text.indexOf(".")).length > 2 &&
      event.which != 0 &&
      event.which != 8 &&
      $(this)[0].selectionStart >= text.length - 2
    ) {
      event.preventDefault();
    }
  });
  $("body").on("submit", "#province_vat_rates", function () {
    var $form = $(this);
    var data = $form.serialize();
    $.blockUI(block_config_spinner);
    $.post(cipscript.ajax_url, data, function (response) {
      var obj = JSON.parse(response);
      if (obj.error == 0) {
        console.log(response);
      } else {
        Swal.fire({
          type: "error",
          title: obj.msg,
          text: "",
          allowOutsideClick: false,
        });
      }
      $.unblockUI();
    });
    return false;
  });
  const inputmaskOptions = {
    inputFormat: "dd/mm/yyyy",
    alias: "datetime",
    placeholder: "dd/mm/yyyy",
  };
  if ($("form#add_new_receipt").length > 0) {
    if ($('input[name="receipt_date"]').length > 0) {
      $('input[name="receipt_date"]').inputmask(inputmaskOptions);
      $('input[name="receipt_date"]').datepicker({
        format: "dd/mm/yyyy",
        autoclose: true,
        clearBtn: true,
        endDate: "today",
        orientation: "bottom",
        beforeShow: function () {
          setTimeout(function () {
            $(".datepicker").css("z-index", 99999999999999);
          }, 0);
        },
      });
    }
    $("body").on("submit", "#add_new_receipt", function () {
      var $form = $(this);
      var data = $form.serialize();
      console.log(data);
      if (
        $form.find('input[name="receipt_date"]').val() == "" ||
        $form.find('input[name="sender_name"]').val() == "" ||
        $form.find('input[name="amount"]').val() == "" ||
        $form.find('input[name="sender_account_number"]').val() == "" ||
        $form.find('textarea[name="transaction_notes"]').val() == "" ||
        $form.find('textarea[name="receipts_assistant_notes"]').val() == "" ||
        $form.find('select[name="currency"]').val() == "" ||
        $form.find('select[name="member_email"]').val() == ""
      ) {
        swalToast({ type: "error", title: "All fields are required." });
        return false;
      }
      var disabled = $form.find(":input:disabled").removeAttr("disabled");
      var data = $form.serialize();
      $form.block(block_config_spinner);
      $.post(cipscript.ajax_url, data, function (response) {
        var obj = JSON.parse(response);
        if (obj.error == 0) {
          swalToast({ type: "success", title: obj.msg });
          $form[0].reset();
          $form.block(block_config_spinner);
          window.location.reload();
        } else {
          swalToast({ type: "error", title: obj.msg });
        }
        $form.unblock();
      });
      return false;
    });
  }

  $(document).on("change", "form#edit_new_receipt select#curr", function () {
    var thisValue = 100;
    var fromCurrency = $(this).val();
    if (fromCurrency == "EURO") {
      fromCurrency = "EUR";
    }

    var data = {
      action: "get_estimate_amount",
      from: fromCurrency,
      to: "EUR",
      amount: thisValue,
    };

    $.ajax({
      url: cipscript.ajax_url,
      type: "post",
      data: data,
      success: function (response) {
        var obj = $.parseJSON(response);
        if (obj.error == 0) {
          $('input[type="text"][name="exchange_rate"]').val(obj.exchangeRate);
          $('input[type="text"][name="cunverted_amount"]').val(
            parseFloat(0).toFixed(2)
          );
          if (
            $('form#edit_new_receipt input[type="text"][name="amount"]').val()
          ) {
            $(
              'form#edit_new_receipt input[type="text"][name="amount"]'
            ).trigger("change");
          }
        } else {
          Swal.fire({
            type: "error",
            title: obj.msg,
            text: "",
            allowOutsideClick: false,
          });
        }
        // $form.unblock();
      },
    });
  });

  $(document).on(
    "change",
    'form#edit_new_receipt input[type="text"][name="amount"]',
    function () {
      var exchangeRate = $('input[type="text"][name="exchange_rate"]').val();
      $('input[type="text"][name="cunverted_amount"]').val(
        parseFloat($(this).val() * exchangeRate).toFixed(2)
      );
    }
  );

  $("body").on(
    "input",
    'input[name="sender_name"], input[name="sender_account_number"]',
    function () {
      var c = this.selectionStart,
        r = /[^a-z0-9-_ ]/gi,
        v = $(this).val();
      if (r.test(v)) {
        $(this).val(v.replace(r, ""));
        c--;
      }
      this.setSelectionRange(c, c);
    }
  );
  $("body").on("click", ".edit-receipt[data-receipt]", function (e) {
    var receiptId = $(this).attr("data-receipt");
    var data = { action: "get_data_receipt_action", receiptId: receiptId };
    var thisTr = $(this).closest("tr");
    thisTr.block(block_config);
    $.post(cipscript.ajax_url, data, function (response) {
      var obj = JSON.parse(response);
      if (obj.error == 0) {
        $("#editReceiptModal .modal-body").html(obj.html);
        $("#editReceiptModal").modal(
          { backdrop: "static", keyboard: false },
          "show"
        );
        $("body")
          .find('input[name="receipt_date"]')
          .inputmask(inputmaskOptions);
        $("body").find('input[name="receipt_date"]').datepicker({
          format: "dd/mm/yyyy",
          autoclose: true,
          clearBtn: true,
          endDate: "today",
        });
        if (
          $('form#edit_new_receipt input[type="text"][name="amount"]').val()
        ) {
          $("form#edit_new_receipt select#curr").trigger("change");
        }
        $("#member_email").select2();
      } else {
        swalToast({ type: "error", title: obj.msg });
      }
      thisTr.unblock();
    });
    return false;
  });
  $("body").on("submit", "#edit_new_receipt", function () {
    var $form = $(this);
    var data = $form.serialize();
    console.log(data);
    if (
      $form.find('input[name="receipt_date"]').val() == "" ||
      $form.find('input[name="sender_name"]').val() == "" ||
      $form.find('input[name="amount"]').val() == "" ||
      $form.find('input[name="sender_account_number"]').val() == "" ||
      $form.find('textarea[name="transaction_notes"]').val() == "" ||
      $form.find('textarea[name="receipts_assistant_notes"]').val() == "" ||
      $form.find('select[name="currency"]').val() == "" ||
      $form.find('select[name="member_email"]').val() == ""
    ) {
      swalToast({ type: "error", title: "All fields are required." });
      return false;
    }
    var disabled = $form.find(":input:disabled").removeAttr("disabled");
    var data = $form.serialize();
    $form.block(block_config_spinner);
    $.post(cipscript.ajax_url, data, function (response) {
      var obj = JSON.parse(response);
      if (obj.error == 0) {
        swalToast({ type: "success", title: obj.msg });
        $form[0].reset();
        $form.block(block_config_spinner);
        $("#editReceiptModal").modal("hide");
        window.location.reload();
      } else {
        swalToast({ type: "error", title: obj.msg });
      }
      $form.unblock();
    });
    return false;
  });
  $("body").on(
    "keypress",
    '#edit_new_receipt input[name="amount"], #add_new_receipt input[name="amount"]',
    function (event) {
      if (
        (event.which != 46 || $(this).val().indexOf(".") != -1) &&
        (event.which < 48 || event.which > 57) &&
        event.which != 0 &&
        event.which != 8
      ) {
        event.preventDefault();
      }

      var text = $(this).val();

      if (
        text.indexOf(".") != -1 &&
        text.substring(text.indexOf(".")).length > 2 &&
        event.which != 0 &&
        event.which != 8 &&
        $(this)[0].selectionStart >= text.length - 2
      ) {
        event.preventDefault();
      }
    }
  );
  if ($(".receiptAllocationFrm").length > 0) {
    var block_config_spinner = {
      css: { backgroundColor: "transparent", border: "none" },
      message: '<div class="blockUIspinner"></div>',
      baseZ: 1500,
      overlayCSS: {
        backgroundColor: "#FFFFFF",
        opacity: 0.8,
        cursor: "default",
      },
    };
    var current_fs, next_fs, previous_fs; //fieldsets
    var opacity;
    var current = 1;
    var steps = $("body").find(".receiptAllocationFrm fieldset").length;
    setProgressBarRA(current);
    var $form = $("body").find(".receiptAllocationFrm");
    $("body").on("click", ".next", function (event) {
      var this_next = $("form.receiptAllocationFrm .responseSection");
      current_fs = $(this).parent();
      next_fs = $(this).parent().next();

      var $form = $('form[name="receiptAllocationFrm"]');

      if (current == 1) {
        var selectedInvoiceElement = $form.find(
          'input[name="invoiceNumber"]:checked'
        );
        if (
          typeof selectedInvoiceElement.val() === "undefined" ||
          selectedInvoiceElement.val() == ""
        ) {
          swalToast({ type: "error", title: "Please select invoice" });
          return false;
        }
        var invoiceName = selectedInvoiceElement.attr("data-invoicename");
        var invoiceKgs = selectedInvoiceElement.attr("data-Kgs");
        var invoiceAmount = selectedInvoiceElement.attr("data-amount");
        $(".selectedInvoiceName").html(invoiceName);
        $(".dynamicKgs").html(invoiceKgs);
        $(".dynamicEuro").html(invoiceAmount);
        $form.block(block_config_spinner);
        var data = {
          action: "get_amplivo_user_byemail_act",
          email: invoiceName,
        };
        $.post(cipscript.ajax_url, data, function (response) {
          var obj = $.parseJSON(response);
          if (obj.Username != "") {
            $(".selectedInvoiceName").html(
              invoiceName + "(" + obj.Username + ")"
            );
          } else {
          }
          $(".receiptAllocationFrm #progressbar li")
            .eq($(".receiptAllocationFrm fieldset").index(next_fs))
            .addClass("active");
          next_fs.show();
          current_fs.animate(
            { opacity: 0 },
            {
              step: function (now) {
                opacity = 1 - now;

                current_fs.css({
                  display: "none",
                  position: "relative",
                });
                next_fs.css({ opacity: opacity });
              },
              duration: 500,
            }
          );
          setProgressBarRA(++current);
          $form.unblock();
        });
      } else if (current == 2) {
        $(".receiptAllocationFrm #progressbar li")
          .eq($(".receiptAllocationFrm fieldset").index(next_fs))
          .addClass("active");
        next_fs.show();
        current_fs.animate(
          { opacity: 0 },
          {
            step: function (now) {
              opacity = 1 - now;

              current_fs.css({
                display: "none",
                position: "relative",
              });
              next_fs.css({ opacity: opacity });
            },
            duration: 500,
          }
        );
        setProgressBarRA(++current);
      } else if (current == 3) {
        $(".receiptAllocationFrm #progressbar li")
          .eq($(".receiptAllocationFrm fieldset").index(next_fs))
          .addClass("active");
        next_fs.show();
        current_fs.animate(
          { opacity: 0 },
          {
            step: function (now) {
              opacity = 1 - now;

              current_fs.css({
                display: "none",
                position: "relative",
              });
              next_fs.css({ opacity: opacity });
            },
            duration: 500,
          }
        );
        setProgressBarRA(++current);
      } else if (current == 4) {
        if (
          $form
            .find('input[name="uploadOcaAllocationConfirm"]:checked')
            .val() != 1 ||
          $form
            .find('input[name="purchasedAllocationConfirm"]:checked')
            .val() != 1
        ) {
          swalToast({
            type: "error",
            title: "Please check all confimation box.",
          });
          return false;
        }
        var data = $form.serialize();
        $form.block(block_config_spinner);
        $.post(cipscript.ajax_url, data, function (response) {
          var obj = JSON.parse(response);
          if (obj.error == 0) {
            swalToast({ type: "success", title: obj.msg });
            $form[0].reset();
            $form.block(block_config_spinner);
            if (obj.url != "") {
              window.location.href = obj.url;
            }
          } else {
            swalToast({ type: "error", title: obj.msg });
          }
          $form.unblock();
        });
      }
    });
    $("body").on("click", ".previous", function () {
      current_fs = $(this).parent();
      previous_fs = $(this).parent().prev();

      $(".receiptAllocationFrm #progressbar li")
        .eq($(".receiptAllocationFrm fieldset").index(current_fs))
        .removeClass("active");

      previous_fs.show();

      current_fs.animate(
        { opacity: 0 },
        {
          step: function (now) {
            opacity = 1 - now;

            current_fs.css({
              display: "none",
              position: "relative",
            });
            previous_fs.css({ opacity: opacity });
          },
          duration: 500,
        }
      );
      setProgressBarRA(--current);
    });

    function setProgressBarRA(curStep) {
      var percent = parseFloat(100 / steps) * curStep;
      percent = percent.toFixed();
      $("body")
        .find(".receiptAllocationFrm .progress-bar")
        .css("width", percent + "%");
    }
    $("body").on(
      "click",
      'form[name="receiptAllocationFrm"] input[name="cancel"]',
      function () {
        $("#cancelReceiptProcessModal").modal({
          backdrop: "static",
          keyboard: false,
        });
      }
    );
    $("body").on("submit", "#cancelReceiptAllocationFrm", function () {
      var $form = $(this);
      var data = $form.serialize();
      if (
        $form.find('input[name="uploadOcaCancelConfirm"]:checked').val() != 1 ||
        $form.find('input[name="purchasedCancelConfirm"]:checked').val() != 1
      ) {
        swalToast({
          type: "error",
          title: "Please check all confimation box.",
        });
        return false;
      }
      var data = $form.serialize();
      $form.block(block_config_spinner);
      $.post(cipscript.ajax_url, data, function (response) {
        var obj = JSON.parse(response);
        if (obj.error == 0) {
          swalToast({ type: "success", title: obj.msg });
          $form[0].reset();
          $form.block(block_config_spinner);
          if (obj.url != "") {
            window.location.href = obj.url;
          }
        } else {
          swalToast({ type: "error", title: obj.msg });
        }
        $form.unblock();
      });
      return false;
    });

    $("body").on("change", 'input[name="invoiceNumber"]', function () {
      var selectedInvoiceElement = $form.find(
        'input[name="invoiceNumber"]:checked'
      );
      if (
        typeof selectedInvoiceElement.val() === "undefined" ||
        selectedInvoiceElement.val() == ""
      ) {
        swalToast({ type: "error", title: "Please select invoice" });
        return false;
      }
      var invoiceName = selectedInvoiceElement.attr("data-invoicename");
      var invoiceKgs = selectedInvoiceElement.attr("data-Kgs");
      var invoiceAmount = selectedInvoiceElement.attr("data-amount");
      var packageName = selectedInvoiceElement.attr("data-package");
      $(".selectedInvoiceName").html(invoiceName);
      $(".dynamicKgs").html(invoiceKgs + "(" + packageName + ")");
      $(".dynamicEuro").html(invoiceAmount);
      $(".firstCancelAllocation").show();
    });
  }
  if ($("#unpaid_order_invoice").length > 0) {
    var $tableUnpaidOrderInvoice = jQuery("#unpaid_order_invoice");
    $tableUnpaidOrderInvoice.bootstrapTable();
  }
  if ($(".bpf_grid_item").length > 0) {
    $("body").on(
      "click",
      ".bpf_grid_item .bpf_grid_bottom a[data-pkgid]",
      function (e) {
        var thisId = $(this).attr("data-pkgid");
        var data = { action: "getBuyPackageTxnPwdact", thisId: thisId };
        $.blockUI(block_config_spinner);
        $.post(cipscript.ajax_url, data, function (response) {
          var obj = JSON.parse(response);
          if (obj.error == 0) {
            $("#buyPackageTxnPwdModal .modal-body").html(obj.html);
            $("#buyPackageTxnPwdModal").modal(
              { backdrop: "static", keyboard: false },
              "show"
            );
          } else {
            swalToast({ type: "error", title: obj.msg });
          }
          $.unblockUI();
        });
        return false;
      }
    );
    $("#buyPackageTxnPwdModal").on("hide.bs.modal", function () {
      $("#buyPackageTxnPwdModal .modal-body").html("");
    });
    $("body").on("submit", "#createPurchaseOrderTxnFrm", function () {
      var $form = $(this);
      var data = $form.serialize();
      if ($form.find('input[name="transaction_password"]').val() == "") {
        swalToast({
          type: "error",
          title: "Please enter the transaction password",
        });
        return false;
      }
      var data = $form.serialize();
      $form.block(block_config_spinner);
      $.post(cipscript.ajax_url, data, function (response) {
        var obj = JSON.parse(response);
        if (obj.error == 0) {
          swalToast({ type: "success", title: obj.msg });
          $("#buyPackageTxnPwdModal").modal("hide");
          $form[0].reset();
          $form.block(block_config_spinner);
          if (obj.url != "") {
            window.location.href = obj.url;
          }
        } else {
          swalToast({ type: "error", title: obj.msg });
        }
        $form.unblock();
      });
      return false;
    });
  }

  $("body").on("submit", "#sm_email_sending_switch_frm", function () {
    $form = $(this);
    var data = $(this).serialize();
    $form.block(block_config_spinner);
    $.post(cipscript.ajax_url, data, function (response) {
      var obj = JSON.parse(response);
      $form.unblock();
      if (obj.error == 0) {
        swalToast({ type: "success", title: obj.msg });
      } else {
        swalToast({ type: "error", title: obj.msg });
      }
    });
    return false;
  });

  if ($('[data-toggle-column="tooltip"]').length > 0) {
    $('[data-toggle-column="tooltip"]').tooltip({ boundary: "window" });
  }
  /* 172 */
  if(jQuery('#sa_member_invoice_list').length > 0){
    /*document.getElementById('export_invoice_button').addEventListener('click', function() {
      var $tableProcessReceipt = $('#sa_member_invoice_list');
      var tableProcessReceiptdata = $tableProcessReceipt.bootstrapTable('getData');
      var rowCount = tableProcessReceiptdata.length;
      if(rowCount <= 0){
        swalToast({ type: "error", title: 'No invoices found.' });
      }
    });*/
    $('body').on('click','#delete_member_invoice',function(){
      var id = $(this).attr('data-id');
      $invocice_table = $("#sa_member_invoice_list");
      swal({
        title: "Are you sure?",
        text: "It will permanently deleted !",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Yes, delete it!",
      }).then((willDelete) => {
        if (willDelete.value) {
          $invocice_table.block(block_config_spinner);
          $.ajax({
            type: "POST",
            url: cipscript.ajax_url, // WordPress AJAX endpoint URL
            data: {
              action: "delete_member_invoice_act",
              invoice_id: id,
            },
            success: function (response) {
              $invocice_table.unblock();
              if (response.error == 0) {
                swalToast({ type: "success", title: response.msg });
                $invocice_table.bootstrapTable('refresh');
              } else {
                swalToast({ type: "error", title: response.msg });
              }
            },
          });
        }else{
          $invocice_table.unblock();
        }
      });
    });
  }
});
function convertFormToJSON(form) {
  const array = jQuery(form).serializeJSON();
  var json = {};
  json = array;
  return JSON.stringify(json);
}
jQuery("#input_4_1_3, #input_4_1_6, #input_4_2, #input_4_5_3,#input_4_30").bind(
  "input",
  function () {
    var c = this.selectionStart,
      r = /[^a-z-_ ]/gi,
      v = jQuery(this).val();
    if (r.test(v)) {
      jQuery(this).val(v.replace(r, ""));
      c--;
    }
    this.setSelectionRange(c, c);
  }
);
jQuery("#input_4_5_5, #input_4_4,#confimation_password").bind(
  "input",
  function () {
    var c = this.selectionStart,
      r = /[^a-z0-9-_ ]/gi,
      v = jQuery(this).val();
    if (r.test(v)) {
      jQuery(this).val(v.replace(r, ""));
      c--;
    }
    this.setSelectionRange(c, c);
  }
);
jQuery("#input_4_5_1, #input_4_5_2").bind("input", function () {
  var c = this.selectionStart,
    r = /[^a-z0-9-_, ]/gi,
    v = jQuery(this).val();
  if (r.test(v)) {
    jQuery(this).val(v.replace(r, ""));
    c--;
  }
  this.setSelectionRange(c, c);
});
jQuery(document).ready(function ($) {
  /* 11-17-2023 */
  $(document).on("change", ".packages-change", function () {
    var checkboxValue = this.checked ? "true" : "false";
    var text, checkboxValuedata;
    // Get the user ID if it's available on your page.
    if (checkboxValue == "true") {
      text = "Active";
      checkboxValuedata = 1;
    } else {
      text = "Inactive";
      checkboxValuedata = 0;
    }
    $(this).parent(".custom-switch").find(".form-check-label").text(text);
    var userId = $(this).attr("data-id");
    var package_euro_amount = $(this).parents("tr").find(".euro_amount").text();
    $.ajax({
      type: "POST",
      url: cipscript.ajax_url, // WordPress AJAX endpoint URL
      data: {
        action: "update_checkbox_packages_auth",
        user_id: userId,
        checkbox_value: checkboxValuedata,
        package_euro_amount: package_euro_amount,
      },
      success: function (response) {
        Swal.fire({
          toast: true,
          type: "success",
          animation: false,
          position: "bottom",
          showConfirmButton: false,
          timer: 3000,
          timerProgressBar: true,
          title: response.data.message,
          text: "",
          allowOutsideClick: true,
        });
      },
    });
  });
  $("#add_package_button").click(function () {
    $(
      "#add_package_button_modal .modal-title,#add_package_button_modal  #savePackage"
    ).text("Add Package");
    $("#add_package_button_modal #id").val("");
    $("#add_package_button_modal #euro_amount").val("");
    $("#add_package_button_modal #packageid").val("");
    $("#add_package_button_modal #packageid").prop("readonly", false);
    $("#add_package_button_modal #description").val("");
    $("#add_package_button_modal #heading").val("");
    $("#saPackageForm #active").prop("checked", false);
    $("#add_package_button_modal").modal("show");
  });
  //editprovince_managementButton
  $(document).on("click", "#editprovince_managementButton", function () {
    var province_id = $(this).attr("data-province-id");
    $.ajax({
      type: "GET",
      url: cipscript.ajax_url, // WordPress AJAX URL
      data: {
        action: "sa_get_province_loader",
        province_id: province_id,
      },
      success: function (response) {
        if (response.success) {
          // Handle the success response
          $(
            "#add_province_button_modal .modal-title,#add_province_button_modal  #saveprovince"
          ).text("Update province");
          $("#add_province_button_modal #id").val(response.data.id);
          $("#add_province_button_modal #province_name").val(
            response.data.province_name
          );
          $("#add_province_button_modal #GST").val(response.data.GST);
          $("#add_province_button_modal #QST").val(response.data.QST);
          $("#add_province_button_modal #HST").val(response.data.HST);
          $("#add_province_button_modal").modal("show");
        }
      },
    });
  });
  $(document).on("click", "#editpackagesButton", function () {
    var package_id = $(this).attr("data-packages-id");
    $.ajax({
      type: "GET",
      url: cipscript.ajax_url, // WordPress AJAX URL
      data: {
        action: "sa_get_packages_loader",
        package_id: package_id,
      },
      success: function (response) {
        if (response.success) {
          // Handle the success response
          $(
            "#add_package_button_modal .modal-title,#add_package_button_modal  #savePackage"
          ).text("Update Package");
          $("#add_package_button_modal #id").val(response.data.id);
          $("#add_package_button_modal #euro_amount").val(
            response.data.euro_amount
          );
          $("#add_package_button_modal #packageid").val(
            response.data.packageid
          );
          $("#add_package_button_modal #heading").val(response.data.heading);
          $("#add_package_button_modal #description").val(
            response.data.description
          );
          $("#add_package_button_modal #packageid").prop("readonly", true);
          if (response.data.active == 1) {
            $("#saPackageForm #active").prop("checked", true);
          } else {
            $("#saPackageForm #active").prop("checked", false);
          }

          $("#add_package_button_modal").modal("show");
        }
      },
    });
  });
  $(document).on("click", "#savePackage", function () {
    var formData = $("#saPackageForm").serialize(); // Serialize the form data
    $.ajax({
      type: "POST",
      url: cipscript.ajax_url, // WordPress AJAX handler URL
      data: {
        action: "handle_sa_package_form", // Action to be handled in PHP
        form_data: formData,
      },
      success: function (response) {
        // Handle the response here, e.g., show success message or perform additional actions
        // Close the modal after successful submission
        if (response.success) {
          let eve = jQuery.Event("keyup");

          eve.which = 13;

          eve.keyCode = 13;

          $('#sa_packages_listing_list input[type="search"]').trigger(eve);

          $("#add_package_button_modal").modal("hide");

          Swal.fire({
            toast: true,
            type: "success",
            animation: false,
            position: "bottom",
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            title: response.data.message,
            text: "",
            allowOutsideClick: true,
          });
        } else {
          Swal.fire({
            toast: true,
            type: "error",
            animation: false,
            position: "bottom",
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            title: response.data.message,
            text: "",
            allowOutsideClick: true,
          });
        }
      },
      error: function (xhr, status, error) {
        // Handle errors here
        console.error(error);
      },
    });
  });
  $(document).on("click", "#saveprovince", function () {
    var formData = $("#saprovinceForm").serialize(); // Serialize the form data
    $.ajax({
      type: "POST",
      url: cipscript.ajax_url, // WordPress AJAX handler URL
      data: {
        action: "handle_sa_province_form", // Action to be handled in PHP
        form_data: formData,
      },
      success: function (response) {
        // Handle the response here, e.g., show success message or perform additional actions
        // Close the modal after successful submission
        if (response.success) {
          let eve = jQuery.Event("keyup");

          eve.which = 13;

          eve.keyCode = 13;

          $('#sa_province_management_listing input[type="search"]').trigger(
            eve
          );

          $("#add_province_button_modal").modal("hide");

          Swal.fire({
            toast: true,
            type: "success",
            animation: false,
            position: "bottom",
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            title: response.data.message,
            text: "",
            allowOutsideClick: true,
          });
        } else {
          Swal.fire({
            toast: true,
            type: "error",
            animation: false,
            position: "bottom",
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            title: response.data.message,
            text: "",
            allowOutsideClick: true,
          });
        }
      },
      error: function (xhr, status, error) {
        // Handle errors here
        console.error(error);
      },
    });
  });
  $(document).on("click", "#delete_sa_package", function () {
    swal({
      title: "Are you sure?",
      text: "It will permanently deleted !",
      type: "warning",
      showCancelButton: true,
      confirmButtonColor: "#3085d6",
      cancelButtonColor: "#d33",
      confirmButtonText: "Yes, delete it!",
    }).then((willDelete) => {
      console.log(willDelete);
      if (willDelete.value) {
        var postId = $(this).attr("data-packages-id");
        var package_euro_amount = $(this)
          .parents("tr")
          .find(".euro_amount")
          .text();
        $.ajax({
          type: "POST",
          url: cipscript.ajax_url, // WordPress AJAX URL
          data: {
            action: "delete_sa_package",
            package_id: postId,
            package_euro_amount: package_euro_amount,
          },
          success: function (response) {
            // Handle the success response
            if (response.success) {
              $("[data-packages-id='" + response.data.id + "']")
                .parents("tr")
                .remove();
              Swal.fire({
                toast: true,
                type: "error",
                animation: false,
                position: "bottom",
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                title: response.data.message,
                text: "",
                allowOutsideClick: true,
              });
            }
          },
        });
      }
    });
  });
  /* 11-17-2023 */

  if ($("#cip_withdrawal_requests_table_list").length > 0) {
    let dateFormat = "DD-MM-YYYY";
    $(
      '._date input.bootstrap-table-filter-control-create_date[type="search"]'
    ).daterangepicker(
      {
        autoUpdateInput: false,
        locale: {
          format: dateFormat,
          separator: " - ",
          firstDay: 1,
        },
        opens: "left",
        cancelButtonClasses: "btn-default cancelButton__date",
      },
      function (start, end) {
        startDate = start.format(dateFormat);
        endDate = end.format(dateFormat);
        let dates = [startDate, endDate];
        // filterByDate(dates, '_date');
        $(
          '._date input.bootstrap-table-filter-control-create_date[type="search"]'
        ).val(start.format(dateFormat) + " - " + end.format(dateFormat));
        var $pool_ref = jQuery(
          '._date input.bootstrap-table-filter-control-create_date[type="search"]'
        );
        let eve = jQuery.Event("keyup");
        console.log("test2");
        eve.which = 13;
        eve.keyCode = 13;
        $pool_ref.trigger(eve);
      }
    );
    $(
      '.create_date input.bootstrap-table-filter-control-create_date[type="search"]'
    ).daterangepicker(
      {
        autoUpdateInput: false,
        locale: {
          format: dateFormat,
          separator: " - ",
          firstDay: 1,
        },
        opens: "left",
        cancelButtonClasses: "btn-default cancelButton__date",
      },
      function (start2, end2) {
        start2Date = start2.format(dateFormat);
        end2Date = end2.format(dateFormat);
        let dates = [start2Date, end2Date];
        // filterByDate(dates, '_date');
        $(
          '.create_date input.bootstrap-table-filter-control-create_date[type="search"]'
        ).val(start2.format(dateFormat) + " - " + end2.format(dateFormat));
        var $pool_ref2 = jQuery(
          '.create_date input.bootstrap-table-filter-control-create_date[type="search"]'
        );
        let eve2 = jQuery.Event("keyup");
        console.log("test2");
        eve2.which = 13;
        eve2.keyCode = 13;
        $pool_ref2.trigger(eve2);
      }
    );
  }

  if ($(".member_transaction_w_detail_table-body").length > 0) {
    let dateFormat = "DD-MM-YYYY";
    $(
      '#member_transaction__detail_table input.bootstrap-table-filter-control-date[type="search"]'
    ).daterangepicker(
      {
        autoUpdateInput: false,
        locale: {
          format: dateFormat,
          separator: " - ",
          firstDay: 1,
        },
        opens: "left",
        cancelButtonClasses: "btn-default cancelButton__date",
      },
      function (start, end) {
        startDate = start.format(dateFormat);
        endDate = end.format(dateFormat);
        let dates = [startDate, endDate];
        // filterByDate(dates, '_date');
        $(
          '#member_transaction__detail_table input.bootstrap-table-filter-control-date[type="search"]'
        ).val(start.format(dateFormat) + " - " + end.format(dateFormat));
        var $pool_ref = jQuery(
          '#member_transaction__detail_table input.bootstrap-table-filter-control-date[type="search"]'
        );
        let eve = jQuery.Event("keyup");
        console.log("test2");
        eve.which = 13;
        eve.keyCode = 13;
        $pool_ref.trigger(eve);
      }
    );
    $(
      '#member_transaction_w_detail_table input.bootstrap-table-filter-control-create_date[type="search"]'
    ).daterangepicker(
      {
        autoUpdateInput: false,
        locale: {
          format: dateFormat,
          separator: " - ",
          firstDay: 1,
        },
        opens: "left",
        cancelButtonClasses: "btn-default cancelButton__date",
      },
      function (start2, end2) {
        start2Date = start2.format(dateFormat);
        end2Date = end2.format(dateFormat);
        let dates = [start2Date, end2Date];
        // filterByDate(dates, '_date');
        $(
          '#member_transaction_w_detail_table input.bootstrap-table-filter-control-create_date[type="search"]'
        ).val(start2.format(dateFormat) + " - " + end2.format(dateFormat));
        var $pool_ref2 = jQuery(
          '#member_transaction_w_detail_table input.bootstrap-table-filter-control-create_date[type="search"]'
        );
        let eve2 = jQuery.Event("keyup");
        console.log("test2");
        eve2.which = 13;
        eve2.keyCode = 13;
        $pool_ref2.trigger(eve2);
      }
    );
  }
  // footer login form login funcation start
  jQuery(document).on("click", "#footer_canada_verify_button a", function (e) {
    e.preventDefault();

    // Get the height of the element to be faded out
    var fadeOutHeight = jQuery("#footer_canada_verify_button").outerHeight();

    // Set the container height to maintain space
    jQuery("#footer_canada_verify_button").css("height", fadeOutHeight);

    // Fade out the button
    jQuery("#footer_canada_verify_button").fadeOut("fast", function () {
      // Once faded out, remove the fixed height
      jQuery(this).css("height", "auto");

      // Fade in the login form
      jQuery("#footer_canada_login_form").fadeIn();
    });
  });
  // footer login form login funcation end
});
// jQuery(document).on('change','#usdt_exchange_amount',function(){
// 	var amount = jQuery(this).val();
// 	var ex_rate = jQuery('#usdt_exchange_rate').val();
// 	jQuery('#usdt_amount_euro').val(amount*ex_rate);
// 	jQuery('#cad_amount').text(amount);
// 	jQuery('.withdrawal_request_estimate_usdt_txt span').text(amount*ex_rate);
// 	jQuery('#usdt_exchange_rate').val(parseFloat(jQuery('#usdt_exchange_rate').val()).toFixed(4));
// 	jQuery('#usdt_amount_euro').val(parseFloat(jQuery('#usdt_amount_euro').val()).toFixed(2));
// });
jQuery(document).on("change", "#type_of_deposit", function () {
  // var amount = jQuery(this).val();
  // var ex_rate = jQuery('#usdt_exchange_rate').val();
  // jQuery('#usdt_amount_euro').val(amount*ex_rate);
  // jQuery('#cad_amount').text(amount);
  // jQuery('.withdrawal_request_estimate_usdt_txt span').text(amount*ex_rate);
  // jQuery('#usdt_exchange_rate').val(parseFloat(jQuery('#usdt_exchange_rate').val()).toFixed(4));
  // jQuery('#usdt_amount_euro').val(parseFloat(jQuery('#usdt_amount_euro').val()).toFixed(2));
  jQuery("#usdt_exchange_rate").val("");
  jQuery("#usdt_amount_euro,#usdt_exchange_amount").val("");
  jQuery("#cad_amount").text("");
});
jQuery(document).on("change", "#usdt_block_chain", function () {
  var amount = jQuery(this).val();
  jQuery("#showblockchain").text(amount);
  if (amount == "ERC20") {
    jQuery("#showblockchain_type").text("Ethereum");
    jQuery("#showaddress").text("0x04f1e7d02386f9c436bce026fb0fa9f9a83d2f9c");
  } else if (amount == "BSC") {
    jQuery("#showblockchain_type").text("Binance Smart Chain (BSC)");
    jQuery("#showaddress").text("0x04f1e7d02386f9c436bce026fb0fa9f9a83d2f9c");
  } else if (amount == "Tron") {
    jQuery("#showblockchain_type").text("Tron");
    jQuery("#showaddress").text("TQxgWbBUbAmjsrd22D7Vu8QV9PaX1HPahu");
  }
});
jQuery(document).on("change", "#usdt_exchange_rate", function () {
  // var amount = jQuery(this).val(); var ex_rate = jQuery('#usdt_exchange_amount').val(); jQuery('#usdt_amount_euro').val(amount*ex_rate);
});
jQuery(
  "#euro_amount,#GST,#QST,#HST, #usdt_exchange_amount,#usdt_amount_euro,#usdt_exchange_rate"
).on("input", function () {
  var c = this.selectionStart,
    v = jQuery(this).val();

  // Remove non-numeric and non-decimal characters except a single dot
  v = v.replace(/[^\d.]/g, "");

  // Split the value into integer and decimal parts
  var parts = v.split(".");

  // Limit the decimal part to 2 digits
  if (parts.length > 1) {
    parts[1] = parts[1].slice(0, 2);
  }

  // Reconstruct the value with at most 2 decimal places
  v = parts[0] + (parts.length === 2 ? "." + parts[1] : "");

  // Update the input value
  jQuery(this).val(v);

  // Adjust the selection position if necessary
  var diff = v.length - this.value.length;
  c += diff;
  this.setSelectionRange(c, c);
});
