<?php
/**
 * Plugin Name: CIP Helper
 * Description: CIP Helper
 * Version: 0.19
 * Author: Corsair
 * Author URI: https://corsairnow.com/
 * Text Domain: cip-helper
 */
define( 'CIP_TXTDOMAIN', 'cip-helper' );
define( 'CIP_PLUGIN_FOLDER', plugin_dir_url(__FILE__) );
define( 'CIP_PLUGIN_BASE', plugin_dir_path(__FILE__) );
register_activation_hook( __FILE__, "activate_cip_helper" );
//activation script
function activate_cip_helper(){
	global $table_prefix, $wpdb;
	$thTable = $table_prefix . 'token_holder';
	$logsTable = $table_prefix . 'cip_logs';
	$thTableCol = $table_prefix . 'token_holder_columns';
	$invoice= $table_prefix.'cip_member_invoice';
	$invoice_paid= $table_prefix.'cip_member_invoice_paid';
	$signValidateTable = $table_prefix.'eth_sign_validate';
	$account= $table_prefix.'sm_accounts_management';
	$province_management= $table_prefix.'province_management';
	$sa_packages_table = $wpdb->prefix . 'sa_packages'; // Adjust 'sa_packages' to your preferred table name
	$charset_collate = $wpdb->get_charset_collate();

	//create logs table if not exists
	if( $wpdb->get_var( "show tables like '$logsTable'" ) != $logsTable ) {
		$cipLogsSql = "CREATE TABLE `$logsTable` (
			`id` INT(11) NOT NULL auto_increment,
			`user_id` INT(11),
			`user_type` VARCHAR(100),
			`log_type` VARCHAR(100),
			`logs` LONGTEXT,
			`_date` VARCHAR(100),
			PRIMARY KEY (`id`)
		) $charset_collate;";

		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		dbDelta($cipLogsSql);
	}

	//create Member Invoice table if not exists
	if( $wpdb->get_var( "show tables like '$invoice'" ) != $invoice ) {
		$invoice_table = "CREATE TABLE `$invoice` (
			`id` INT(11) NOT NULL auto_increment,
			`BusinessName` VARCHAR(100) COLLATE utf8_general_ci,
			`Package` VARCHAR(100) COLLATE utf8_general_ci,
			`ProductPrice` VARCHAR(100) COLLATE utf8_general_ci,
			`Address1` VARCHAR(100) COLLATE utf8_general_ci,
			`Address2` VARCHAR(100) COLLATE utf8_general_ci,
			`City` VARCHAR(100) COLLATE utf8_general_ci,
			`State` VARCHAR(100) COLLATE utf8_general_ci,
			`Country` VARCHAR(100) COLLATE utf8_general_ci,
			`Zipcode` VARCHAR(100) COLLATE utf8_general_ci,
			`IntroducedBy` VARCHAR(100) COLLATE utf8_general_ci,
			`FirstName` VARCHAR(100) COLLATE utf8_general_ci,
			`LastName` VARCHAR(100) COLLATE utf8_general_ci,
			`Number` VARCHAR(100) COLLATE utf8_general_ci,
			`Email` VARCHAR(100) COLLATE utf8_general_ci,
			`CSRExchangeDiscount` VARCHAR(100) COLLATE utf8_general_ci,
			`Date` VARCHAR(100) COLLATE utf8_general_ci,
			`PaidDate` VARCHAR(100) COLLATE utf8_general_ci,
			`UniqueKey` VARCHAR(100) COLLATE utf8_general_ci,
			`Status` VARCHAR(100) COLLATE utf8_general_ci,
			`InvoiceNumber` BIGINT(20),
			`ProformaInvoiceNumber` BIGINT(20),
			`Kgs` VARCHAR(100) COLLATE utf8_general_ci,
			`Type` VARCHAR(100) COLLATE utf8_general_ci,
			`POGrossAmount` VARCHAR(100) COLLATE utf8_general_ci,
			`GrossAmount` VARCHAR(100) COLLATE utf8_general_ci,
			`ArchiveStatus` VARCHAR(100) COLLATE utf8_general_ci,
			`BankId` VARCHAR(100) COLLATE utf8_general_ci,
			PRIMARY KEY (`id`)
		) $charset_collate;";

		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		dbDelta($invoice_table);
	}


	//create Member Invoice table if not exists
	if( $wpdb->get_var( "show tables like '$account'" ) != $account ) {
		$account_table = "CREATE TABLE `$account` (
		`id` INT(11) NOT NULL AUTO_INCREMENT ,
		`Status` VARCHAR(100) NULL ,
		`AccountHolder` VARCHAR(100) NULL ,
		`IBAN` VARCHAR(100) NULL ,
		`BIC` VARCHAR(100) NULL ,
		`BankCode` VARCHAR(50) NULL ,
		`BankName` VARCHAR(100) NULL ,
		`BankAddress` VARCHAR(150) NULL ,
		`AssignedTo` VARCHAR(100) NULL ,
		`Date` VARCHAR(50) NULL ,
		PRIMARY KEY  (`id`)
	) $charset_collate;";

		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		dbDelta($account_table);
	}
	// SQL query to create the packages table if it does not exist
	if ($wpdb->get_var("SHOW TABLES LIKE '$sa_packages_table'") != $sa_packages_table) {
		$sql = "CREATE TABLE $sa_packages_table (
			id INT(11) NOT NULL AUTO_INCREMENT,
			euro_amount DECIMAL(10, 2) NOT NULL,
			description TEXT,
			active TINYINT(1) DEFAULT 1,
			PRIMARY KEY (id)
		) $charset_collate;";
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		dbDelta($sql);
	}
	if( $wpdb->get_var( "show tables like '$province_management'" ) != $province_management ) {
		$sql = "CREATE TABLE `$province_management` (
			`id` INT(11) NOT NULL AUTO_INCREMENT ,
			`province_name` VARCHAR(100) NULL ,
			`GST` INT(11),
			`QST` INT(11),
			PRIMARY KEY  (`id`)
		) $charset_collate;";
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		dbDelta($sql);
	}

}
add_action( 'after_setup_theme', 'cip_global_var_for_default_column_arr_cb' );
function cip_global_var_for_default_column_arr_cb(){
	if (!current_user_can('administrator') && !is_admin()) {
  		show_admin_bar(false);
	}
}
//admin menu for listing token holder
add_action('admin_menu', 'cip_menu_tokenholder_records_cb');
function cip_menu_tokenholder_records_cb(){
	add_submenu_page( 'users.php', __( 'CIP Helper', CIP_TXTDOMAIN ), __( 'CIP Helper', CIP_TXTDOMAIN ), 'manage_options', 'cip-helper', 'ciphelper_setting_option_content' );
}
add_action('admin_init', 'ciphelper_options_settings');
function ciphelper_options_settings(){
	register_setting( 'cip_options_group', 'cipoptions' );
}
function ciphelper_setting_option_content(){
	$cipoptions = (array)get_option('cipoptions');
	?>
	<div>
  		<h2><?php _e('CIP Helper',CIP_TXTDOMAIN); ?></h2>
	  	<form method="post" action="options.php">
	  	<?php settings_fields( 'cip_options_group' ); ?>
	  	<table>
	  		<tr valign="top">
	  			<th scope="row"><label for="routine_maintenance_page"><?php _e('Routine maintenance',CIP_TXTDOMAIN); ?></label></th>
	  			<td><input type="text" class="regular-text" id="routine_maintenance_page" name="cipoptions[routine_maintenance_page]" value="<?php echo $cipoptions['routine_maintenance_page']; ?>" /></td>
	  	</tr>
	  	</table>
	  <?php submit_button(); ?>
	  </form>
  	</div>
	<?php
}

add_action( 'template_redirect', 'price_api_page_template_redirect' );
function price_api_page_template_redirect(){
	if(is_page( 7855 )){
		// die();
		global $wpdb;

		$incCsr = ( !empty( get_option('selling_price_csr_inc') ) ) ? get_option('selling_price_csr_inc') : 8;
		$amplivo_api_mode = get_option('amplivo_api_mode');
		if ($amplivo_api_mode == 'live') {
			$sourceUrl = get_option('amplivo_api_live_source_url') . 'get-csr-price-changes';
		} else {
			$sourceUrl = get_option('amplivo_api_test_source_url') . 'get-csr-price-changes';
		}

		// Prepare the request arguments for wp_remote_post()
		$username = get_option( 'amplivo_api_auth_username' );
		$auth_password = get_option( 'amplivo_api_auth_pwd' );

		// Create an array with the request arguments, including Basic Auth in the headers
		$request_args = array(
			'headers' => array(
				'Authorization' => 'Basic ' . base64_encode( $username . ':' . $auth_password ),
				'Content-Type' => 'application/json', // Adjust content type if necessary
			)
		);

		// Make the POST request using wp_remote_post()
		$responseApi = wp_remote_post($sourceUrl, $request_args);

		$response_body = wp_remote_retrieve_body( $responseApi );

		$data = json_decode( $response_body );

		$apiSellingPrice = ( !empty( get_option('selling_price_csr') ) ) ? get_option('selling_price_csr') : 1;

		if(isset($data->result[0]))
		{
			if($data->result[0]->status == 'active')
			{
				$apiSellingPrice = $data->result[0]->csr_price;
			}
			else
			{
				foreach ($data->result as $key => $value) {
					if($value->status == 'active')
					{
						$apiSellingPrice = $value->csr_price;
					}
				}
			}
		}

		$selling_price_csr = $apiSellingPrice;
		$tableScheduler = $wpdb->prefix.'csr_scheduler';
		$getOldActive = $wpdb->get_results("SELECT * FROM $tableScheduler WHERE status='active'");
		if( $getOldActive ){
			foreach( $getOldActive as $oldActive ){
				if($selling_price_csr != $oldActive->csr_price ){
					$price_type = 'prompt';

					$status = ( $price_type == 'prompt' ) ? 'active' : 'pending';
					$schedule_time = ( $price_type == 'prompt' ) ? gmdate('Y-m-d H:i') : '';
					$data = array(
						'csr_price'		=>	$selling_price_csr,
						'price_type'	=>	$price_type,
						'create_date'	=>	gmdate('Y-m-d H:i'),
						'start_date'	=>	$schedule_time,
						'status'		=>	$status,
					);
					$insert = $wpdb->insert($tableScheduler, $data);
					if( $insert ){
						if( $price_type == 'prompt' ){
							$lastid = $wpdb->insert_id;
							$update_csr_price = 0;
							$getOldActive = $wpdb->get_results("SELECT * FROM $tableScheduler WHERE status='active' AND id!=$lastid");
							if( $getOldActive ){
								foreach( $getOldActive as $oldActive ){
									if($selling_price_csr != $oldActive->csr_price ){
										$update_csr_price = 1;
										$dataActive = array( 'status'	=>	'overwritten' );
										$whereActive = array( 'id'	=>	$oldActive->id );
										$updateActive = $wpdb->update($tableScheduler, $dataActive, $whereActive);
									}
								}
							}
							if($update_csr_price == 1){
								$selling_price_csr = ( !empty( $selling_price_csr ) ) ? $selling_price_csr : 0.025;
								update_option( 'selling_price_csr', $selling_price_csr );
								$log_type = 'selling_price_csr';
								$user = wp_get_current_user();
								$message = "New CSR (".$selling_price_csr.")price added price_type ".$price_type." schedule on ".$schedule_time;
								create_cip_logs_entery( $user->ID, $log_type, $message);
								$out = array( "error" => 0, 'msg' => __('Success', CIP_TXTDOMAIN), 'redirect_url'	=> get_permalink( 5631 ) );
							}
						}

					}
				}
			}
		}
	}
}

add_action( 'template_redirect', 'my_page_template_redirect' );
function my_page_template_redirect(){
	$cipoptions = (array)get_option('cipoptions');
	$routine_maintenance = get_option('cip_routine_maintenance_mode');
	$member_maintenance = get_option('cip_member_maintenance_mode');
	$site_maintenance = get_option('cip_site_maintenance_mode');
	$login_page_id = get_option( 'login_page_url' );
	$userData = wp_get_current_user();
	$user_roles = $userData->roles;
	if( $cipoptions['routine_maintenance_page'] == get_the_ID() && ( $routine_maintenance != 1 && $site_maintenance != 1 && $member_maintenance != 1 ) ){
		wp_redirect( get_permalink( $login_page_id ) );
		exit();
	}
    if( $site_maintenance == 1 && !is_page(  $login_page_id ) && $cipoptions['routine_maintenance_page'] != get_the_ID() ){
		if( !in_array("administrator",$userData->roles) && !in_array("supportmanager",$userData->roles) && !in_array("supportagent",$userData->roles) ){
			if( is_user_logged_in() ){
				$current_user = wp_get_current_user();
				$sessions = WP_Session_Tokens::get_instance( $current_user->ID );
				$sessions->destroy_all();
			}
			wp_redirect( get_permalink( $cipoptions['routine_maintenance_page'] ) );
			exit();
		}
    }
}
add_action( 'wp_enqueue_scripts', 'cip_enqueue_scripts_cb' );
function cip_enqueue_scripts_cb(){
	wp_enqueue_script('jquery', "//cdn.jsdelivr.net/npm/jquery/dist/jquery.min.js", array(),'3.6.0', false);
	wp_enqueue_script('jquery.serializejson', plugin_dir_url( __FILE__ ). 'assets/jquery.serializejson.min.js', array( 'jquery' ),'3.2.1', false);
	wp_enqueue_script( 'bs-popper', '//cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js', array( 'jquery' ), '1.16.0', true );
	wp_enqueue_script( 'bs-js', '//stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js', array( 'jquery' ), '4.3.1', true );
	wp_register_script( 'bs-table', plugin_dir_url( __FILE__ ). 'assets/bootstrap-table.min.js', array( 'jquery' ), '1.18.3', true );
	wp_register_script( 'bs-table-filter-control', plugin_dir_url( __FILE__ ).'assets/bootstrap-table-filter-control.min.js', array( 'jquery' ), '1.18.3', true );
	wp_register_script( 'bs-sticky-header', plugin_dir_url( __FILE__ ).'assets/bootstrap-table-sticky-header.min.js', array( 'jquery' ), '1.18.3', true );
	wp_register_style( 'bs-table', plugin_dir_url( __FILE__ ).'assets/bootstrap-table.min.css', array(), '1.18.3', 'all' );
	wp_register_style( 'bs-sticky-header', '//unpkg.com/bootstrap-table@1.18.3/dist/extensions/sticky-header/bootstrap-table-sticky-header.css', array(), '1.18.3', 'all' );
	wp_enqueue_style( 'bs-css', '//stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css', array(), '4.3.1', 'all' );
	wp_enqueue_style( 'global-cip-css', plugin_dir_url( __FILE__ ) . 'global-style.css', array(), '1.0.0', 'all' );
	wp_register_script( 'tbl-ex-js', '//cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/tableExport.min.js', array( 'jquery' ), '4.3.1', true );
	wp_register_script( 'jspdf', '//cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/libs/jsPDF/jspdf.min.js', array( 'jquery' ), '4.3.1', true );
	wp_register_script( 'pdf-autotable-js', '//cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/libs/jsPDF-AutoTable/jspdf.plugin.autotable.js', array( 'jquery' ), '4.3.1', true );
	wp_enqueue_script('sweetalert', "//cdn.jsdelivr.net/npm/sweetalert2@7.32.4/dist/sweetalert2.all.min.js", array('jquery'),false, false);
	wp_register_script( 'ex-js', '//unpkg.com/bootstrap-table@1.18.3/dist/extensions/export/bootstrap-table-export.min.js', array( 'jquery' ), '4.3.1', true );
	//bs datepicker
	wp_register_script('bs-datepicker', "//cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js", array('jquery'),'1.9.0', false);
	wp_register_style('bs-datepicker', '//cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css');
	wp_register_style('cip-css', plugin_dir_url( __FILE__ ) . 'cip-style.css', array(), '1.0.0', 'all');

	//date range

	wp_register_script('dr-moment', '//cdn.jsdelivr.net/momentjs/latest/moment.min.js', array('jquery'), '1.0.0', true);

	wp_register_script('daterangepicker-script', '//cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js', array('jquery'), '1.0.0', true);

    wp_register_style('daterangepicker-style', '//cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css');
	//blockUI
	wp_enqueue_script( 'blockUI', '//cdnjs.cloudflare.com/ajax/libs/jquery.blockUI/2.70/jquery.blockUI.min.js', array(),'2.70' , true );
	wp_register_script( 'crypto-js', '//cdnjs.cloudflare.com/ajax/libs/crypto-js/4.0.0/crypto-js.min.js', array(),'4.0.0' , false );
	wp_register_script('cip-abi', plugin_dir_url( __FILE__ ). 'cip-abi.js', '',time(), true);
	wp_register_script('cip-scripts', plugin_dir_url( __FILE__ ). 'cip-scripts.js', '',time(), true);
	wp_register_script('notify-js', "//cdnjs.cloudflare.com/ajax/libs/notify/0.4.2/notify.js", array(),'0.4.2', false);
	wp_enqueue_script('web3@latest', "//cdn.jsdelivr.net/npm/web3@latest/dist/web3.min.js", array(),'0.4.2', false);

	wp_register_script('jquery-ui', "//ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js", array(),'1.12.1', false);
	wp_register_style('jquery-ui-style', "//ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css", array(),'1.12.1', false);
	wp_register_script('jquery.inputmask', '//cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/5.0.8/jquery.inputmask.min.js', array('jquery'), '5.0.8', true);

	//select2
	wp_register_script('select2', '//cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js', array('jquery'), '4.1.0', true);
    wp_register_style('select2', '//cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css');

	$csr_wallet_api_mode = ( !empty( get_option('csr_wallet_api_mode') ) ) ? get_option('csr_wallet_api_mode') : 'test';
	$contractaddress = ( $csr_wallet_api_mode == 'live' ) ? get_option('csr_wallet_api_mode_live_tkn') : get_option('csr_wallet_api_mode_test_tkn');
	$web3provider = ( $csr_wallet_api_mode == 'live' ) ? 'VHH03XzIO+b1N341d4FIw9PSFMDehQ0zFegIOpZP9G3IzFBELJuW5BN1iXr0sc+CJ7w3ds1N+jq10+QSTlza2A==' : 'VW0k6zOoKNehXstKs24IIPWVqqPoLPjgy4L2k3zHoCK/0rcmQ2+lW52mK3E+2c74f3Ky79U8NK5dDKwb8Sps1A==';
	$localize_string = array(
		'cipEncki'		=>  'c419c4b7724aab6ce4050d6722d20919',
		'cipEncvct'		=>  '53e38f43ad9e361e',
		'web3provider'	=>	$web3provider,
	);
	wp_localize_script( 'crypto-js', 'cryptojs', $localize_string );
	wp_enqueue_script('crypto-js');

	global $wpdb;

	$incCsr = ( !empty( get_option('selling_price_csr_inc') ) ) ? get_option('selling_price_csr_inc') : 8;
	/* $amplivo_api_mode = get_option('amplivo_api_mode');
	if ($amplivo_api_mode == 'live') {
		$sourceUrl = get_option('amplivo_api_live_source_url') . 'get-csr-price-changes';
	} else {
		$sourceUrl = get_option('amplivo_api_test_source_url') . 'get-csr-price-changes';
	}

	// Prepare the request arguments for wp_remote_post()
	$username = get_option( 'amplivo_api_auth_username' );
	$auth_password = get_option( 'amplivo_api_auth_pwd' );

	// Create an array with the request arguments, including Basic Auth in the headers
	$request_args = array(
		'headers' => array(
			'Authorization' => 'Basic ' . base64_encode( $username . ':' . $auth_password ),
			'Content-Type' => 'application/json', // Adjust content type if necessary
		)
	);

	// Make the POST request using wp_remote_post()
	$responseApi = wp_remote_post($sourceUrl, $request_args);

	$response_body = wp_remote_retrieve_body( $responseApi );

	$data = json_decode( $response_body );

	$apiSellingPrice = ( !empty( get_option('selling_price_csr') ) ) ? get_option('selling_price_csr') : 1;

	if(isset($data->result[0]))
	{
		if($data->result[0]->status == 'active')
		{
			$apiSellingPrice = $data->result[0]->csr_price;
		}
		else
		{
			foreach ($data->result as $key => $value) {
				if($value->status == 'active')
				{
					$apiSellingPrice = $value->csr_price;
				}
			}
		}
	}

	$selling_price_csr = $apiSellingPrice; */
	$selling_price_csr = ( !empty( get_option('selling_price_csr') ) ) ? get_option('selling_price_csr') : 1;
	$selling_kgs = ( !empty( get_option('selling_kgs') ) ) ? get_option('selling_kgs') : 1;


	$microschedulardel = wp_create_nonce( '_XyPendingSchedularDeleteyX_' );
	$localize_string = array(
		'ajax_url' 			=> admin_url( 'admin-ajax.php'),
		'site_url' 			=> site_url(),
		'incCsr'			=> $incCsr,
		'selling_price'		=> $selling_price_csr,
		'selling_kgs'		=> $selling_kgs,
		'tokenaddress'		=> $contractaddress,
		'csrapi_mode'		=> $csr_wallet_api_mode,
		'microschedulardel'	=> $microschedulardel,
		'current_page'		=> get_permalink(),
		'cip_images_folder'	=>	CIP_PLUGIN_FOLDER . '/images/',
	);
	wp_localize_script( 'cip-scripts', 'cipscript', $localize_string );
	wp_enqueue_script('cip-scripts');
}
add_action('wp_head','web3_installing_script');
function web3_installing_script(){
?>
<script type="text/javascript">
	var DataEncrypt = "VHH03XzIO+b1N341d4FIw+YG+XiohgONw+NWWJ0ZVOb+NbHiwP025+x9JHf5sV\/BVTxaC+XH1\/5A0RoLOewfKQ==";
	var DataKey = CryptoJS.enc.Utf8.parse( cryptojs.cipEncki );
	var DataVector = CryptoJS.enc.Utf8.parse( cryptojs.cipEncvct );
	var decrypted = CryptoJS.AES.decrypt(DataEncrypt, DataKey, { iv: DataVector });
	var decrypted = CryptoJS.enc.Utf8.stringify(decrypted);
	web3 = new Web3(new Web3.providers.HttpProvider( decrypted ));
</script>
<?php
}
add_action('init', 'cip_startsession', 20);
function cip_startsession(){
	if(!session_id()){
		@session_start();
    }
}
function cip_create_logs( $message = "", $faildlog = false ){
	$user_id = get_current_user_id();
	if( $faildlog == true ){
		$filename = $user_id . '_' . 'cip_import_faild.log';
	}else{
		$filename = $user_id . '_' . 'cip_import.log';
	}
	$file = fopen(CIP_PLUGIN_BASE.'/'.$filename,"a");
	fwrite($file, $message . "\n");
	fclose($file);
}
function cip_clear_logs(){
	$user_id = get_current_user_id();
	$filename = $user_id . '_' . 'cip_import.log';
	$file = fopen(CIP_PLUGIN_BASE.'/'.$filename,"w");
	fclose($file);
	$filename = $user_id . '_' . 'cip_import_faild.log';
	$file = fopen(CIP_PLUGIN_BASE.'/'.$filename,"w");
	fclose($file);
}
add_action('wp_footer','cip_init_bs_table_script');
function cip_init_bs_table_script(){
	$euvatapiLogsData = array();
	$euvatapiLogsData['action'] = 'euvatapi_logs_loader';
	$euvatapiLogsData['pageid'] = get_the_ID();
	$euvatapiLogsUrl = add_query_arg( $euvatapiLogsData, admin_url( 'admin-ajax.php' ) );
	$walletapiLogsData = array();
	$walletapiLogsData['action'] = 'wallet_api_logs_loader';
	$walletapiLogsUrl = add_query_arg( $walletapiLogsData, admin_url( 'admin-ajax.php' ) );
?><script>
jQuery(document).ready(function($){
  	var sathpage = "<?php echo get_the_permalink(); ?>";
  	var ajax_url = "<?php echo admin_url( 'admin-ajax.php' ); ?>";
	if( $('#cip_sasm_table').length > 0 ){
		var $tablesasm = $('#cip_sasm_table');
		$tablesasm.bootstrapTable({
			stickyHeader: true,
			stickyHeaderOffsetY: parseInt($('header').height()),
		});
	}
	var block_config = { message: null,overlayCSS:{ backgroundColor: '#fff',opacity:0.8} };
	$("body").on("submit","#sa_member_update",function(){
		var data = $(this).serialize();
		if( $('#update_all_match:checked').val() == 1 ){
			if( $('#update_all_option').val() == 'all_reference_update' ){
				if( $('#reference_update_field').val() == "" ){
					$('.form_response').html( 'Reference is required' );
					return false;
				}
			}
		}
		$('#sa_member_update').block( block_config );
		$.post(ajax_url, data, function(response) {
			var obj = JSON.parse( response );
			$('#sa_member_update').unblock();
			//console.log( obj );
			if( obj.error == 0 ){
				window.location.href = sathpage;
			}
			$('.form_response').html( obj.msg );
		});
		return false;
	});
	//MA enable form script
	$("body").on("submit","#ma_member_update",function(){
		var data = $(this).serialize();
		if( $('#update_all_match:checked').val() == 1 ){
			if( $('#update_all_option').val() == 'all_reference_update' ){
				if( $('#reference_update_field').val() == "" ){
					$('.form_response').html( 'Reference is required' );
					return false;
				}
			}
		}
		$('#ma_member_update').block( block_config );
		$.post(ajax_url, data, function(response) {
			var obj = JSON.parse( response );
			$('#ma_member_update').unblock();
			console.log( obj );
			if( obj.error == 0 ){
				window.location.href = sathpage;
			}
			$('.form_response').html( obj.msg );
		});
		return false;
	});
	$("body").on("submit","#smsa_update_usr",function(){
		var data = $(this).serialize();
		$('#smsa_update_usr').block( block_config );
		$.post(ajax_url, data, function(response) {
			var obj = JSON.parse( response );
			$('#smsa_update_usr').unblock();
			$('.form_response').html( obj.msg );
		});
		return false;
	});
	$("body").on("submit","#smsaown_update_usr",function(){
		var data = $(this).serialize();
		$('#smsaown_update_usr').block( block_config );
		$.post(ajax_url, data, function(response) {
			var obj = JSON.parse( response );
			$('#smsaown_update_usr').unblock();
			$('.form_response').html( obj.msg );
		});
		return false;
	});
	$('body').on('click','.delete_sath', function(){
		if( confirm("Are you sure want to delete?") === true ){
			var thisId = $(this).attr('data-id');
			var data = {'action':'sa_delth_act','sathid':thisId};
			$.post(ajax_url, data, function(response) {
				var obj = JSON.parse( response );
				alert( obj.msg );
				if( obj.error == 0 ){
					window.location.href = sathpage;
				}
			});
		}
	});
	$('body').on('change','select[name="update_smsa"]', function(){
		var thisId = $(this).attr('data-uid');
		var thisVal = $(this).val();
		var blockElem = $(this).closest('tr');
		var data = {'action':'sasm_updatestatus_act','cipthisid':thisId,'cipthisval':thisVal};
		blockElem.block( block_config );
		$.post(ajax_url, data, function(response) {
			var obj = JSON.parse( response );
			blockElem.unblock();
		});
	});
	window.BsTableFilterStatus = function (text, value, field, data){
		if( text.toLowerCase() === value.toLowerCase() ){
			return true;
		}else{
			return false;
		}
	}

	if( $('#cip_amount_wallet_table').length > 0 ){
		var $tableWallet = $('#cip_amount_wallet_table');
		$tableWallet.bootstrapTable({
			stickyHeader: true,
			stickyHeaderOffsetY: parseInt($('header').height()),
			onPostBody: function (){
				$('[data-toggle-tt="tooltip"]').tooltip();
			},
		});
	}
	if( $('#euvatapi_logs_table').length > 0 ){
		var euvatapi_logs_table = $('#euvatapi_logs_table');
		var euvatapiLogsUrl = "<?php echo $euvatapiLogsUrl; ?>";
		euvatapi_logs_table.bootstrapTable({
			method: 'post',
			contentType: 'application/x-www-form-urlencoded',
			url: euvatapiLogsUrl,
			queryParams: function (p) {
				return {
					columnfilter: p.filter,
					limit: p.limit,
					offset: p.offset,
					sort: p.sort,
					order: p.order,
				};
			},
			stickyHeader: true,
			stickyHeaderOffsetY: parseInt($('header').height()),
			onPostBody: function (){

		  	}
		});
	}
	if( $('#cip_logs_table').length > 0 ){
		var cip_logs_table = $('#cip_logs_table');
		var walletapiLogsUrl = "<?php echo $walletapiLogsUrl; ?>";
		cip_logs_table.bootstrapTable({
			method: 'post',
			contentType: 'application/x-www-form-urlencoded',
			url: walletapiLogsUrl,
			queryParams: function (p) {
				filterByConditionPoolRef = convertFormToJSON( '#filter_by_logs' );
				return {
					columnfilter: p.filter,
					limit: p.limit,
					offset: p.offset,
					'filterByConditionPoolRef': filterByConditionPoolRef,
					sort: p.sort,
					order: p.order,
				};
			},
			stickyHeader: true,
			onPostBody: function (){

		  	}
		});
	}
	if( $('#schedule_time').length > 0 ){
		$('#schedule_time').datepicker({
			dateFormat: 'dd/mm/yy',
			minDate:0,
			altField: "#schedule_time_alt",
			altFormat: "yy-mm-dd",
		}).attr('readonly', 'readonly');
	}
	function convertToUtc(str) {
        return moment(str).utc().format('YYYY-MM-DD HH:mm');
	}
});
</script>
<?php
}
add_action('wp_ajax_sasm_updatestatus_act','sasm_updatestatus_act_cb');
function sasm_updatestatus_act_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	$update = update_user_meta( $_POST['cipthisid'], 'cip_user_status', $_POST['cipthisval'] );
	if( $update ){
		$out = array( "error" => 0,'msg' => __('Updated',CIP_TXTDOMAIN) );
	}
	echo wp_json_encode( $out );
	exit;
}
add_action('wp_ajax_sasm_update_profile_act','sasm_update_profile_act_cb');
function sasm_update_profile_act_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_micro'],'_XupdatesasmprofX_' ) ){
		update_user_meta( $_POST['sasmuid'], 'first_name', $_POST['firstname'] );
		update_user_meta( $_POST['sasmuid'], 'last_name', $_POST['lastname'] );
		update_user_meta( $_POST['sasmuid'], 'phonenumber', $_POST['phonenumber'] );
		update_user_meta( $_POST['sasmuid'], 'cip_user_status', $_POST['user_status'] );
		$out = array( "error" => 0,'msg' => __('Updated',CIP_TXTDOMAIN) );
		$log_type = 'update_profile';
		$user = wp_get_current_user();
		$data = array(
			'First Name' => $_POST['firstname'],
			'Last Name' => $_POST['lastname'],
			'Phone Number' => $_POST['phonenumber'],
			'User Status' => $_POST['user_status'],
		);
		$message = " ".json_encode($data)." ";
		create_cip_logs_entery( $user->ID, $log_type, $message );
	}
	echo wp_json_encode( $out );
	exit;
}
add_action('wp_ajax_own_update_profile_act','own_update_profile_act_cb');
function own_update_profile_act_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_micro'],'_XupdateownprofX_' ) ){
		$currentUser = wp_get_current_user();
		update_user_meta( $currentUser->ID, 'first_name', $_POST['firstname'] );
		update_user_meta( $currentUser->ID, 'last_name', $_POST['lastname'] );
		update_user_meta( $currentUser->ID, 'phonenumber', $_POST['phonenumber'] );
		$out = array( "error" => 0,'msg' => __('Updated',CIP_TXTDOMAIN) );
		$log_type = 'update_profile';
		$user = wp_get_current_user();
		$data = array(
			'First Name' => $_POST['firstname'],
			'Last Name' => $_POST['lastname'],
			'Phone Number' => $_POST['phonenumber'],
		);
		$message = " ".json_encode($data)." ";
		create_cip_logs_entery( $user->ID, $log_type, $message );
	}
	echo wp_json_encode( $out );
	exit;
}
add_action('admin_post_export_smmemberinvoice_act','cip_export_smmemberinvoice_act_callback');
function cip_export_smmemberinvoice_act_callback(){
	global $wpdb;
	$tableName = $wpdb->prefix . 'cip_member_invoice';
	include('PHPExcel/Classes/PHPExcel.php');
	include('PHPExcel/Classes/PHPExcel/IOFactory.php');
	$getMIsData = $wpdb->get_results("SELECT * FROM $tableName WHERE `Status` = 'Paid' AND `InvoiceNumber` IS NOT NULL");
	$objPHPExcel = new PHPExcel();
	$objPHPExcel->getProperties()->setCreator("CIP Helper")
		->setLastModifiedBy("CIP Helper")
		->setTitle("CIP Helper")
		->setSubject("CIP Helper")
		->setDescription("CIP Helper")
		->setKeywords("CIP Helper")
		->setCategory("CIP Helper");
	
	$sheetCounter = 0;
	
	
	$objPHPExcel->setActiveSheetIndex( $sheetCounter );
	$objPHPExcel->getActiveSheet()->setTitle(__('CIP Member Invoice',CIP_TXTDOMAIN));
	$excelRow = 2;
	$objPHPExcel->getActiveSheet()->setCellValue('A1', 'Package');
	$objPHPExcel->getActiveSheet()->setCellValue('B1', 'ProductPrice');
	$objPHPExcel->getActiveSheet()->setCellValue('C1', 'PriceCAD');
	$objPHPExcel->getActiveSheet()->setCellValue('D1', 'ExchangeRate');
	$objPHPExcel->getActiveSheet()->setCellValue('E1', 'GSTCAD');
	$objPHPExcel->getActiveSheet()->setCellValue('F1', 'QSTCAD');
	$objPHPExcel->getActiveSheet()->setCellValue('G1', 'TotalCAD');
	$objPHPExcel->getActiveSheet()->setCellValue('H1', 'Description');
	$objPHPExcel->getActiveSheet()->setCellValue('I1', 'Address1');
	$objPHPExcel->getActiveSheet()->setCellValue('J1', 'Address2');
	$objPHPExcel->getActiveSheet()->setCellValue('K1', 'City');
	$objPHPExcel->getActiveSheet()->setCellValue('L1', 'State');
	$objPHPExcel->getActiveSheet()->setCellValue('M1', 'Country');
	$objPHPExcel->getActiveSheet()->setCellValue('N1', 'Zipcode');
	$objPHPExcel->getActiveSheet()->setCellValue('O1', 'IntroducedBy');
	$objPHPExcel->getActiveSheet()->setCellValue('P1', 'username');
	$objPHPExcel->getActiveSheet()->setCellValue('Q1', 'FirstName');
	$objPHPExcel->getActiveSheet()->setCellValue('R1', 'LastName');
	$objPHPExcel->getActiveSheet()->setCellValue('S1', 'Email');
	$objPHPExcel->getActiveSheet()->setCellValue('T1', 'Date');
	$objPHPExcel->getActiveSheet()->setCellValue('U1', 'PaidDate');
	$objPHPExcel->getActiveSheet()->setCellValue('V1', 'UniqueKey');
	$objPHPExcel->getActiveSheet()->setCellValue('W1', 'Status');
	$objPHPExcel->getActiveSheet()->setCellValue('X1', 'InvoiceNumber');
	$objPHPExcel->getActiveSheet()->setCellValue('Y1', 'ProformaInvoiceNumber');
	$objPHPExcel->getActiveSheet()->setCellValue('Z1', 'Kgs');
	$objPHPExcel->getActiveSheet()->setCellValue('AA1', 'csr');
	$objPHPExcel->getActiveSheet()->setCellValue('AB1', 'Type');
	$objPHPExcel->getActiveSheet()->setCellValue('AC1', 'POGrossAmount');
	$objPHPExcel->getActiveSheet()->setCellValue('AD1', 'GrossAmount');
	$objPHPExcel->getActiveSheet()->setCellValue('AE1', 'BankId');
	$objPHPExcel->getActiveSheet()->setCellValue('AF1', 'ArchiveStatus');
	$objPHPExcel->getActiveSheet()->setCellValue('AG1', 'inclusiveUnit');
	$objPHPExcel->getActiveSheet()->setCellValue('AH1', 'Language');
	$objPHPExcel->getActiveSheet()->setCellValue('AI1', 'giftcode');
	$objPHPExcel->getActiveSheet()->setCellValue('AJ1', 'giftcode_status');
	foreach( $getMIsData as $getMIData ){
		$objPHPExcel->getActiveSheet()->setCellValue('A' . $excelRow, $getMIData->Package);
		$objPHPExcel->getActiveSheet()->setCellValue('B' . $excelRow, $getMIData->ProductPrice);
		$objPHPExcel->getActiveSheet()->setCellValue('C' . $excelRow, $getMIData->PriceCAD);
		$objPHPExcel->getActiveSheet()->setCellValue('D' . $excelRow, $getMIData->ExchangeRate);
		$objPHPExcel->getActiveSheet()->setCellValue('E' . $excelRow, $getMIData->GSTCAD);
		$objPHPExcel->getActiveSheet()->setCellValue('F' . $excelRow, $getMIData->QSTCAD);
		$objPHPExcel->getActiveSheet()->setCellValue('G' . $excelRow, $getMIData->TotalCAD);
		$objPHPExcel->getActiveSheet()->setCellValue('H' . $excelRow, $getMIData->Description);
		$objPHPExcel->getActiveSheet()->setCellValue('I' . $excelRow, $getMIData->Address1);
		$objPHPExcel->getActiveSheet()->setCellValue('J' . $excelRow, $getMIData->Address2);
		$objPHPExcel->getActiveSheet()->setCellValue('K' . $excelRow, $getMIData->City);
		$objPHPExcel->getActiveSheet()->setCellValue('L' . $excelRow, $getMIData->State);
		$objPHPExcel->getActiveSheet()->setCellValue('M' . $excelRow, $getMIData->Country);
		$objPHPExcel->getActiveSheet()->setCellValue('N' . $excelRow, $getMIData->Zipcode);
		$objPHPExcel->getActiveSheet()->setCellValue('O' . $excelRow, $getMIData->IntroducedBy);
		$objPHPExcel->getActiveSheet()->setCellValue('P' . $excelRow, $getMIData->username);
		$objPHPExcel->getActiveSheet()->setCellValue('Q' . $excelRow, $getMIData->FirstName);
		$objPHPExcel->getActiveSheet()->setCellValue('R' . $excelRow, $getMIData->LastName);
		$objPHPExcel->getActiveSheet()->setCellValue('S' . $excelRow, $getMIData->Email);
		$objPHPExcel->getActiveSheet()->setCellValue('T' . $excelRow, $getMIData->Date);
		$objPHPExcel->getActiveSheet()->setCellValue('U' . $excelRow, $getMIData->PaidDate);
		$objPHPExcel->getActiveSheet()->setCellValue('V' . $excelRow, $getMIData->UniqueKey);
		$objPHPExcel->getActiveSheet()->setCellValue('W' . $excelRow, $getMIData->Status);
		$objPHPExcel->getActiveSheet()->setCellValue('X' . $excelRow, $getMIData->InvoiceNumber);
		$objPHPExcel->getActiveSheet()->setCellValue('Y' . $excelRow, $getMIData->ProformaInvoiceNumber);
		$objPHPExcel->getActiveSheet()->setCellValue('Z' . $excelRow, $getMIData->Kgs);
		$objPHPExcel->getActiveSheet()->setCellValue('AA' . $excelRow, $getMIData->csr);
		$objPHPExcel->getActiveSheet()->setCellValue('AB' . $excelRow, $getMIData->Type);
		$objPHPExcel->getActiveSheet()->setCellValue('AC' . $excelRow, $getMIData->POGrossAmount);
		$objPHPExcel->getActiveSheet()->setCellValue('AD' . $excelRow, $getMIData->GrossAmount);
		$objPHPExcel->getActiveSheet()->setCellValue('AE' . $excelRow, $getMIData->BankId);
		$objPHPExcel->getActiveSheet()->setCellValue('AF' . $excelRow, $getMIData->ArchiveStatus);
		$objPHPExcel->getActiveSheet()->setCellValue('AG' . $excelRow, $getMIData->inclusiveUnit);
		$objPHPExcel->getActiveSheet()->setCellValue('AH' . $excelRow, $getMIData->Language);
		$objPHPExcel->getActiveSheet()->setCellValue('AI' . $excelRow, $getMIData->giftcode);
		$objPHPExcel->getActiveSheet()->setCellValue('AJ' . $excelRow, $getMIData->giftcode_status);
		$excelRow++;
	}
	$log_type = 'export_invoice';
	$user = wp_get_current_user();
	create_cip_logs_entery( $user->ID, $log_type );
	PHPExcel_Settings::setZipClass(PHPExcel_Settings::PCLZIP);
	$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'CSV');
	$file_name = 'CIPMemberInvoices-'.date_i18n('d-m-Y H-i-s');
	header('Content-type: application/vnd.ms-excel');
	header('Content-Disposition: attachment; filename="'.$file_name.'.csv"');
	$objWriter->save('php://output');
	exit;
}
add_action('wp_ajax_cip_sm_import_mi_csv_act','cip_sm_import_mi_csv_act_callback');
function cip_sm_import_mi_csv_act_callback(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_micro'],'_CIPxYSMmiimportMSYxCIP_' ) ){
		if( isset($_FILES['mi_csv_file']['name']) && !empty($_FILES['mi_csv_file']['name']) ){ // importing data
			$allowed_extension = array('csv');
			$ext = pathinfo($_FILES['mi_csv_file']['name'], PATHINFO_EXTENSION);
			if( in_array($ext, $allowed_extension) ){
				$file = $_FILES['mi_csv_file']['tmp_name'];
				include( 'PHPExcel/Classes/PHPExcel/IOFactory.php' );
				$inputFileName = $file;
				try {
					$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
					$objReader = PHPExcel_IOFactory::createReader($inputFileType);
					$objReader->setInputEncoding('ISO-8859-1');
					$objPHPExcel = $objReader->load($inputFileName);
				}catch(Exception $e){
					$out = array( "error" => 1,'msg' => $e->getMessage() );
					echo wp_json_encode( $out );
					exit;
				}
				global $table_prefix, $wpdb;
				$thTable = $table_prefix . 'cip_member_invoice';
				$sheet = $objPHPExcel->getSheet(0);
				$highestRow = $sheet->getHighestRow();
				$highestColumn = $sheet->getHighestColumn();
				$count = 2;
				$trDanger = "table-danger";
				$trSuccess = "table-success";
				$logs = "";
				$countError = 0;
				$countSuccess = 0;
				cip_clear_logs();
				for($row = 2; $row <= $highestRow; $row++){
					$rowError = false;
					$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);

					$Package = ($rowData[0][0] != "") ? $rowData[0][0] : null;
					$ProductPrice = ($rowData[0][1] != "") ? $rowData[0][1] : null;
					$PriceCAD = ($rowData[0][2] != "") ? $rowData[0][2] : null;
					$ExchangeRate = ($rowData[0][3] != "") ? $rowData[0][3] : null;
					$GSTCAD = ($rowData[0][4] != "") ? $rowData[0][4] : null;
					$QSTCAD = ($rowData[0][5] != "") ? $rowData[0][5] : null;
					$TotalCAD = ($rowData[0][6] != "") ? $rowData[0][6] : null;
					$Description = ($rowData[0][7] != "") ? $rowData[0][7] : null;
					$Address1 = ($rowData[0][8] != "") ? $rowData[0][8] : null;
					$Address2 = ($rowData[0][9] != "") ? $rowData[0][9] : null;
					$City = ($rowData[0][10] != "") ? $rowData[0][10] : null;
					$State = ($rowData[0][11] != "") ? $rowData[0][11] : null;
					$Country = ($rowData[0][12] != "") ? $rowData[0][12] : null;
					$Zipcode = ($rowData[0][13] != "") ? $rowData[0][13] : null;
					$IntroducedBy = ($rowData[0][14] != "") ? $rowData[0][14] : null;
					$username = ($rowData[0][15] != "") ? $rowData[0][15] : null;
					$FirstName = ($rowData[0][16] != "") ? $rowData[0][16] : null;
					$LastName = ($rowData[0][17] != "") ? $rowData[0][17] : null;
					$Email = ($rowData[0][18] != "") ? $rowData[0][18] : null;
					$Date = ($rowData[0][19] != "") ? $rowData[0][19] : null;
					$PaidDate = ($rowData[0][20] != "") ? $rowData[0][20] : null;
					$UniqueKey = ($rowData[0][21] != "") ? $rowData[0][21] : null;
					$Status = ($rowData[0][22] != "") ? $rowData[0][22] : null;
					$InvoiceNumber = ($rowData[0][23] != "") ? $rowData[0][23] : null;
					$ProformaInvoiceNumber = ($rowData[0][24] != "") ? $rowData[0][24] : null;
					$Kgs = ($rowData[0][25] != "") ? $rowData[0][25] : null;
					$csr = ($rowData[0][26] != "") ? $rowData[0][26] : null;
					$Type = ($rowData[0][27] != "") ? $rowData[0][27] : null;
					$POGrossAmount = ($rowData[0][28] != "") ? $rowData[0][28] : null;
					$GrossAmount = ($rowData[0][29] != "") ? $rowData[0][29] : null;
					$BankId = ($rowData[0][30] != "") ? $rowData[0][30] : null;
					$ArchiveStatus = ($rowData[0][31] != "") ? $rowData[0][31] : null;
					$inclusiveUnit = ($rowData[0][32] != "") ? $rowData[0][32] : null;
					$Language = ($rowData[0][33] != "") ? $rowData[0][33] : null;
					$giftcode = ($rowData[0][34] != "") ? $rowData[0][34] : null;
					$giftcode_status = ($rowData[0][35] != "") ? $rowData[0][35] : null;

					$rowRawString = '<tr class="%s"><th scope="row">%s</th><td>%s</td><td>%s</td></tr>';
					$data = [
						'Package' => wp_strip_all_tags($Package),
						'ProductPrice' => wp_strip_all_tags($ProductPrice),
						'PriceCAD' => wp_strip_all_tags($PriceCAD),
						'ExchangeRate' => wp_strip_all_tags($ExchangeRate),
						'GSTCAD' => wp_strip_all_tags($GSTCAD),
						'QSTCAD' => wp_strip_all_tags($QSTCAD),
						'TotalCAD' => wp_strip_all_tags($TotalCAD),
						'Description' => wp_strip_all_tags($Description),
						'Address1' => wp_strip_all_tags($Address1),
						'Address2' => wp_strip_all_tags($Address2),
						'City' => wp_strip_all_tags($City),
						'State' => wp_strip_all_tags($State),
						'Country' => wp_strip_all_tags($Country),
						'Zipcode' => wp_strip_all_tags($Zipcode),
						'IntroducedBy' => wp_strip_all_tags($IntroducedBy),
						'username' => wp_strip_all_tags($username),
						'FirstName' => wp_strip_all_tags($FirstName),
						'LastName' => wp_strip_all_tags($LastName),
						'Email' => wp_strip_all_tags($Email),
						'Date' => wp_strip_all_tags($Date),
						'PaidDate' => wp_strip_all_tags($PaidDate),
						'UniqueKey' => wp_strip_all_tags($UniqueKey),
						'Status' => wp_strip_all_tags($Status),
						'InvoiceNumber' => wp_strip_all_tags($InvoiceNumber),
						'ProformaInvoiceNumber' => wp_strip_all_tags($ProformaInvoiceNumber),
						'Kgs' => wp_strip_all_tags($Kgs),
						'csr' => wp_strip_all_tags($csr),
						'Type' => wp_strip_all_tags($Type),
						'POGrossAmount' => wp_strip_all_tags($POGrossAmount),
						'GrossAmount' => wp_strip_all_tags($GrossAmount),
						'BankId' => wp_strip_all_tags($BankId),
						'ArchiveStatus' => wp_strip_all_tags($ArchiveStatus),
						'inclusiveUnit' => $inclusiveUnit,
						'Language' => wp_strip_all_tags($Language),
						'giftcode' => wp_strip_all_tags($giftcode),
						'giftcode_status' => wp_strip_all_tags($giftcode_status),
					];
					$inserting = $wpdb->insert( $thTable, $data );
					if( $inserting ){
						$logs .= sprintf( $rowRawString, $trSuccess, $row, $reference, __('inserted',CIP_TXTDOMAIN) );
						$log_msg = $row . ' :: ' . __('inserted',CIP_TXTDOMAIN);
						cip_create_logs( $log_msg );
						$countSuccess++;
					}else{
						$logs .= sprintf( $rowRawString, $trDanger, $row, $reference, __('failed',CIP_TXTDOMAIN) );
						$log_msg = $row . ' :: ' . __('failed',CIP_TXTDOMAIN);
						$countError++;
						cip_create_logs( $log_msg );
					}
				}
				$log_type = 'import_csv';
				$user = wp_get_current_user();
				create_cip_logs_entery( $user->ID, $log_type );
				if( $countSuccess > 0 ){
					$successRowText = sprintf( _n( '%s row', '%s rows', $countSuccess, CIP_TXTDOMAIN ), $countSuccess );
				}else{
					$successRowText = sprintf( __( '%s row', CIP_TXTDOMAIN ), $countSuccess );
				}
				if( $countError > 0 ){
					$failedRowText = sprintf( _n( '%s row', '%s rows', $countError, CIP_TXTDOMAIN ), $countError );
				}else{
					$failedRowText = sprintf( __( '%s row', CIP_TXTDOMAIN ), $countError );
				}
				$importNoticeMsg = sprintf( __('%s imported and %s failed',CIP_TXTDOMAIN), $successRowText, $failedRowText );
				if( !empty( $logs ) ){
					$logTable = '<style>.table-success tbody+tbody, .table-success td, .table-success th, .table-success thead th{border-color: #8fd19e;}.table-success, .table-success>td, .table-success>th{background-color: #84d897 !important;}.table-danger tbody+tbody, .table-danger td, .table-danger th, .table-danger thead th{border-color: #ed969e !important;}.table-danger, .table-danger>td, .table-danger>th{background-color: #f5c6cb !important;}</style><div class="row"><div class="col-md-12 text-center mb-1"><button type="button" class="btn btn-info mr-5" id="show_all">show all</button><button type="button" class="btn btn-info" id="error_all">show errors</button></div><div class="col-md-12 text-center mb-1"><h4>'.$importNoticeMsg.'</h4></div></div><table class="table table-sm table-borderless">
								  <thead>
								    <tr>
								      <th scope="col">#</th>
								      <th scope="col">'.__('Reference',CIP_TXTDOMAIN).'</th>
								      <th scope="col">'.__('Log',CIP_TXTDOMAIN).'</th>
								    </tr>
								  </thead>
								  <tbody>';
					$logTable .= $logs;
					$logTable .= '</tbody>
								</table>';
				}
				$out = array( "error" => 0,'msg' => __('Success',CIP_TXTDOMAIN), 'logs' => $logTable );
			}else{
				$out = array( "error" => 1,'msg' => __('Invalid file type',CIP_TXTDOMAIN) );
			}
		}
	}
	echo wp_json_encode( $out );
	exit;
}
add_action('wp_ajax_routine_maintenance_mode_act','cip_routine_maintenance_mode_act_cb');
function cip_routine_maintenance_mode_act_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_micro'],'_XYroutinemaintenancemodeYX_' ) && current_user_can( 'supportmanager' ) ){
		$maintenance_mode = 0;
		if( isset($_POST['routine_maintenance_mode']) && !empty( $_POST['routine_maintenance_mode'] ) ){
			$maintenance_mode = 1;
			$args = array(
				'role'    => 'member'
			);
			$member_users = get_users($args);
			foreach ($member_users as $user) {
				$user_id = $user->ID;
				// Check if the user does not have the roles 'administrator', 'supportmanager', or 'supportagent'
				if (!in_array('administrator', $user->roles) && !in_array('supportmanager', $user->roles) && !in_array('supportagent', $user->roles)) {
					$sessions = WP_Session_Tokens::get_instance($user_id);
					$sessions->destroy_all();
				}
			}
		}
		$log_type = 'maintenance';
		$extra_val = ( $maintenance_mode ) ? __('activate',CIP_TXTDOMAIN) : __('deactivate',CIP_TXTDOMAIN) ;
		$user = wp_get_current_user();
		create_cip_logs_entery( $user->ID, $log_type , $extra_val );
		update_option( 'cip_routine_maintenance_mode', $maintenance_mode );
		$out = array( "error" => 0,'msg' => sprintf( __('%s live site maintenance mode',CIP_TXTDOMAIN),ucfirst($extra_val)) );
	}
	echo wp_json_encode( $out );
	exit;
}
// MEMBER MAINTENANCE MODE
add_action('wp_ajax_member_maintenance_mode_act','cip_member_maintenance_mode_act_cb');
function cip_member_maintenance_mode_act_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_micro'],'_XYmember_maintenance_modeYX_' ) && current_user_can( 'supportmanager' ) ){
		$maintenance_mode = 0;
		if( isset($_POST['member_maintenance_mode']) && !empty( $_POST['member_maintenance_mode'] ) ){
			$maintenance_mode = 1;
			$local_custom_email_id = get_option('local_custom_email_id');
			if( $local_custom_email_id ){
				$local_user = get_user_by( 'email', $local_custom_email_id );
				if( $local_user ){
					$token = wp_get_session_token();
					 if( $token ){
					 	$sessions = WP_Session_Tokens::get_instance( $local_user->ID );
						$sessions->destroy_all();
					 }
				}
			}
		}
		$log_type = 'member maintenance';
		$extra_val = ( $maintenance_mode ) ? __('activate',CIP_TXTDOMAIN) : __('deactivate',CIP_TXTDOMAIN) ;
		$user = wp_get_current_user();
		create_cip_logs_entery( $user->ID, $log_type , $extra_val );
		update_option( 'cip_member_maintenance_mode', $maintenance_mode );
		$out = array( "error" => 0,'msg' => __('Updated',CIP_TXTDOMAIN) );
	}
	echo wp_json_encode( $out );
	exit;
}
// SITE MAINTENANCE MODE
add_action('wp_ajax_site_maintenance_mode_act','cip_site_maintenance_mode_act_cb');
function cip_site_maintenance_mode_act_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_sitemicro'],'_XYsite_maintenance_modeYX_' ) && current_user_can( 'supportmanager' ) ){
		$maintenance_mode = 0;
		if( isset($_POST['site_maintenance_mode']) && !empty( $_POST['site_maintenance_mode'] ) ){
			$maintenance_mode = 1;
			$args = array(
				'role'    => 'member'
			);
			$member_users = get_users($args);
			foreach ($member_users as $user) {
				$user_id = $user->ID;
				// Check if the user does not have the roles 'administrator', 'supportmanager', or 'supportagent'
				if (!in_array('administrator', $user->roles) && !in_array('supportmanager', $user->roles) && !in_array('supportagent', $user->roles)) {
					$sessions = WP_Session_Tokens::get_instance($user_id);
					$sessions->destroy_all();
				}
			}
		}
		$log_type = 'site maintenance';
		$extra_val = ( $maintenance_mode ) ? __('activate',CIP_TXTDOMAIN) : __('deactivate',CIP_TXTDOMAIN) ;
		$user = wp_get_current_user();
		create_cip_logs_entery( $user->ID, $log_type , $extra_val );
		update_option( 'cip_site_maintenance_mode', $maintenance_mode );
		$out = array( "error" => 0,'msg' => sprintf( __('%s whole site maintenance mode',CIP_TXTDOMAIN),ucfirst($extra_val)) );
	}
	echo wp_json_encode( $out );
	exit;
}
add_action('wp_ajax_retirement_maintenance_mode_act','cip_retirement_maintenance_mode_act_cb');
function cip_retirement_maintenance_mode_act_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_micro'],'_XYretirement_maintenance_modeYX_' ) && current_user_can( 'supportmanager' ) ){
		$maintenance_mode = 0;
		if( isset($_POST['retirement_maintenance_mode']) && !empty( $_POST['retirement_maintenance_mode'] ) ){
			$maintenance_mode = 1;
		}
		$log_type = 'maintenance_log';
		$extra_val = ( $maintenance_mode ) ? __('activate retirement',CIP_TXTDOMAIN) : __('deactivate retirement',CIP_TXTDOMAIN) ;
		$user = wp_get_current_user();
		create_cip_logs_entery( $user->ID, $log_type , $extra_val );
		update_option( 'cip_retirement_maintenance_mode', $maintenance_mode );
		$out = array( "error" => 0,'msg' => __('Updated',CIP_TXTDOMAIN) );
	}
	echo wp_json_encode( $out );
	exit;
}
add_action('wp_ajax_smsupport_endpoint_act','cip_smsupport_endpoint_act_cb');
function cip_smsupport_endpoint_act_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_micro'],'_XYsmsupportendpointYX_' ) && current_user_can( 'supportmanager' ) ){
		update_option( 'cip_support_ticket_mode', $_POST['support_ticket_mode'] );
		$out = array( "error" => 0,'msg' => __('Updated',CIP_TXTDOMAIN) );
	}
	echo wp_json_encode( $out );
	exit;
}
add_action('wp_ajax_smthclearmember_act','cip_smthclearmember_act_cb');
function cip_smthclearmember_act_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_micro'],'_XYclearsmMembersYX_' ) && current_user_can( 'supportmanager' ) ){
		global $wpdb;
		$tableName = $wpdb->prefix.'token_holder';
		$delete = $wpdb->query("TRUNCATE TABLE `".$tableName."`");
		if( $delete ){
			$out = array( "error" => 0,'msg' => __('All data cleared',CIP_TXTDOMAIN) );
			$log_type = 'delete_tbl_holder';
			$user = wp_get_current_user();
			create_cip_logs_entery( $user->ID, $log_type );
		}
	}
	echo wp_json_encode( $out );
	exit;
}
add_action('wp_ajax_smclearmemberinvoice_act','cip_smclearmemberinvoice_act_cb');
function cip_smclearmemberinvoice_act_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_micro'],'_XYclearsmMembersInvoiceYX_' ) && current_user_can( 'supportmanager' ) ){
		global $wpdb;
		$tableName = $wpdb->prefix.'cip_member_invoice';
		$delete = $wpdb->query("TRUNCATE TABLE `".$tableName."`");
		if( $delete ){
			$out = array( "error" => 0,'msg' => __('All data cleared',CIP_TXTDOMAIN) );
			$log_type = 'delete_tbl_mi';
			$user = wp_get_current_user();
			create_cip_logs_entery( $user->ID, $log_type );
		}
	}
	echo wp_json_encode( $out );
	exit;
}
function cip_number_format( $number = 0, $decimal = false ){
	if( $decimal ){
		return number_format( $number, 2, '.', ',' );
	}else{
		return number_format( $number );
	}
}
function create_cip_logs_entery( $user_id = 0, $log_type = '', $extra_val = '', $user_type = '', $logs = '' , $islog = true ){ //4966
	global $wpdb;
	$logsTable = $wpdb->prefix . 'cip_logs';
	$userData = get_user_by( 'id', $user_id );
	$userRoles = array();
	if( $userData ){
		$userRoles = $userData->roles;
	}

	if( in_array( "supportagent", $userRoles ) ){
		$user_type = 'sa';
		$islog = true;
	}else if( in_array( "supportmanager", $userRoles ) ){
		$user_type = 'sm';
		$islog = true;
	}
	if( $islog ){
		$user_roles = $userRoles;
		$user_role = array_shift($user_roles);

		switch ($log_type) {
			case 'loggedin':
				$logs = sprintf( __('%s (%s) logged in at %s (IP: %s)',CIP_TXTDOMAIN),$userData->user_email, $user_role, date_i18n('d/m/Y H:i A'), $_SERVER['REMOTE_ADDR'] );
				break;
			case 'loggedout':
				$logs = sprintf( __('%s (%s) logged out at %s (IP: %s)',CIP_TXTDOMAIN),$userData->user_email, $user_role, date_i18n('d/m/Y H:i A'), $_SERVER['REMOTE_ADDR'] );
				break;
			case 'import_csv':
				$logs = sprintf( __('%s (%s) import csv at %s',CIP_TXTDOMAIN),$userData->user_email, $user_role, date_i18n('d/m/Y H:i A') );
				break;
			case 'update_csv':
				$logs = sprintf( __('%s (%s) update csv at %s',CIP_TXTDOMAIN),$userData->user_email, $user_role, date_i18n('d/m/Y H:i A') );
				break;
			case 'update_profile':
				$logs = sprintf( __('%s (%s) update (%s) profile at %s',CIP_TXTDOMAIN),$userData->user_email, $user_role, $extra_val, date_i18n('d/m/Y H:i A') );
				break;

			case 'export_invoice':
				$logs = sprintf( __('%s (%s) export invoices at %s',CIP_TXTDOMAIN),$userData->user_email, $user_role, date_i18n('d/m/Y H:i A') );
				break;

			case 'maintenance':
				$logs = sprintf( __('%s (%s) %s maintenance mode at %s',CIP_TXTDOMAIN),$userData->user_email, $user_role, $extra_val, date_i18n('d/m/Y H:i A') );
				break;

			case 'delete_tbl_mi':
				$logs = sprintf( __('%s (%s) clear member invoice records at %s',CIP_TXTDOMAIN),$userData->user_email, $user_role, $extra_val, date_i18n('d/m/Y H:i A') );
				break;
			case 'selling_price_csr':
				$logs = sprintf( __('%s (%s) %s at %s',CIP_TXTDOMAIN),$userData->user_email, $user_role, $extra_val, date_i18n('d/m/Y H:i A') );
				break;

			case 'packages_csr':
				$logs = sprintf( __('%s (%s) %s at %s',CIP_TXTDOMAIN),$userData->user_email, $user_role, $extra_val, date_i18n('d/m/Y H:i A') );
				break;
			case 'provinces_csr':
				$logs = sprintf( __('%s (%s) %s at %s',CIP_TXTDOMAIN),$userData->user_email, $user_role, $extra_val, date_i18n('d/m/Y H:i A') );
				break;
			case 'manage_bank_accounts_csr':
				$logs = sprintf( __('%s (%s) %s at %s',CIP_TXTDOMAIN),$userData->user_email, $user_role, $extra_val, date_i18n('d/m/Y H:i A') );
				break;
			case 'maintenance_log':
				$logs = sprintf( __('%s (%s) %s maintenance mode at %s',CIP_TXTDOMAIN),$userData->user_email, $user_role, $extra_val, date_i18n('d/m/Y H:i A') );
				break;
			case 'amplivo_api_update':
				$logs = sprintf( __('%s (%s) %s at %s',CIP_TXTDOMAIN),$userData->user_email, $user_role, $extra_val, date_i18n('d/m/Y H:i A') );
				break;
			case 'deposit_request':
				$logs = sprintf( __('%s (%s) %s at %s',CIP_TXTDOMAIN),$userData->user_email, $user_role, $extra_val, date_i18n('d/m/Y H:i A') );
				break;
			case 'withdrawal_request':
				$logs = sprintf( __('%s (%s) %s at %s',CIP_TXTDOMAIN),$userData->user_email, $user_role, $extra_val, date_i18n('d/m/Y H:i A') );
				break;
			case 'redeem_gift_code':
				$logs = sprintf( __('%s (%s) %s at %s',CIP_TXTDOMAIN),$userData->user_email, $user_role, $extra_val, date_i18n('d/m/Y H:i A') );
				break;
			case 'setting_option':
				$logs = sprintf( __('%s (%s) %s at %s',CIP_TXTDOMAIN),$userData->user_email, $user_role, $extra_val, date_i18n('d/m/Y H:i A') );
				break;
			case 'maintenance':
				$logs = sprintf( __('%s (%s) %s live site maintenance mode at %s','aachelper'),$userData->user_email, $user_role, $extra_val, date_i18n('d/m/Y H:i A') );
				break;
			case 'site maintenance':
				$logs = sprintf( __('%s (%s) %s whole site maintenance mode at %s','aachelper'),$userData->user_email, $user_role, $extra_val, date_i18n('d/m/Y H:i A') );
				break;
			case 'delete_member_invoice':
				$logs = sprintf( __('%s (%s) %s at %s','aachelper'),$userData->user_email, $user_role, $extra_val, date_i18n('d/m/Y H:i A') );
				break;

		}
		if($user_type == ""){
			$user_type = "Member";
		}
		$data = [
			'user_id'	=>	$user_id,
			'user_type'	=>	$user_type,
			'log_type'	=>	$log_type,
			'logs'		=>	$logs,
			'_date'		=>	date_i18n('Y-m-d H:i:s'),
		];
		$wpdb->insert(  $logsTable, $data );
	}
}
add_action( 'wp_login', 'cip_user_loggin_logs_cb', 10, 2 );
function cip_user_loggin_logs_cb( $user_login, WP_User $user ){
	$log_type = 'loggedin';
	create_cip_logs_entery( $user->ID, $log_type );
}
add_action( 'clear_auth_cookie', 'cip_user_loggout_logs_cb', 10 );
function cip_user_loggout_logs_cb(){
	$log_type = 'loggedout';
	$user = wp_get_current_user();
	create_cip_logs_entery( $user->ID, $log_type );
}
add_action('wp_ajax_proforma_toggle_action','proforma_toggle_action_cb');
function proforma_toggle_action_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	global $wpdb;
	$date = date_i18n( 'Y-m-d h:i:sa');
	$invoice = $wpdb->prefix . 'cip_member_invoice';
	$invoice_paid = $wpdb->prefix . 'cip_member_invoice_paid';
	$logs = $wpdb->prefix . 'cip_logs';

	$sa_id = get_current_user_id();
	$user = wp_get_current_user();
	$sa_email = $user->user_email;

	$idd=$_POST['id'];
	$ref=$_POST['ref'];
	$status = "Un-Paid";
	$paidDate= date_i18n( 'd-m-Y');
	if($ref == 'Un-Paid'){
		$status = "Paid";
	}

	if( $status == 'Paid' ){
		$invoiceRecordMaxQry = "SELECT * FROM $invoice WHERE `Status` = 'Paid' ORDER BY `InvoiceNumber` DESC";
		$invoiceRecordMaxRecord = $wpdb->get_row($invoiceRecordMaxQry);
		if( $invoiceRecordMaxRecord ){
			$InvoiceNumber = $invoiceRecordMaxRecord->InvoiceNumber + 1;
		}else{
			$InvoiceNumber = 1001;
		}
		$update_account = $wpdb->update( $invoice, ['Status' => $status,'PaidDate' => $paidDate, 'InvoiceNumber' => $InvoiceNumber], ['id' => $idd] );
	}else{
		$update_account = $wpdb->update( $invoice, ['Status' => $status,'PaidDate' => $paidDate], ['id' => $idd] );
	}

	if( $update_account ){
		$data = array(
			'user_id'	=>	$sa_id,
			'user_type'	=>	'sa',
			'log_type'	=>	'Invoice',
			'logs'	=>	sprintf( __('%s(supportagent) Update Invoice Status.',CIP_TXTDOMAIN), $sa_email),
			'_date'	=>	$date,
		);
		$wpdb->insert( $logs, $data );
		$out = array( "error" => 0, 'status' => $status, 'msg' => __('Updated Successfully.',CIP_TXTDOMAIN) );
	}
	echo wp_json_encode( $out );
	exit;
}
// SA ARCHIVE STATUS
add_action('wp_ajax_archive_toggle_action','archive_toggle_action_cb');
function archive_toggle_action_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	global $wpdb;
	$date = date_i18n( 'Y-m-d h:i:sa');
	$invoice = $wpdb->prefix . 'cip_member_invoice';
	$invoice_paid = $wpdb->prefix . 'cip_member_invoice_paid';
	$logs = $wpdb->prefix . 'cip_logs';

	$sa_id = get_current_user_id();
	$user = wp_get_current_user();
	$sa_email = $user->user_email;

	$idd=$_POST['id'];
	$arch=$_POST['arch'];
	$archive = "No";
	if($arch == 'No'){
		$archive = "Yes";
	}

	if( $archive == 'Yes' ){
		$update_invoice = $wpdb->update( $invoice, ['ArchiveStatus' => $archive], ['id' => $idd] );
	}else{
		$update_invoice = $wpdb->update( $invoice, ['ArchiveStatus' => $archive], ['id' => $idd] );
	}

	if( $update_invoice ){
		$data = array(
			'user_id'	=>	$sa_id,
			'user_type'	=>	'sa',
			'log_type'	=>	'Archive Status',
			'logs'	=>	sprintf( __('%s(supportagent) Update Archieve Status.',CIP_TXTDOMAIN), $sa_email),
			'_date'	=>	$date,
		);
		$wpdb->insert( $logs, $data );
		$out = array( "error" => 0, 'status' => $archive, 'msg' => __('Updated Successfully.',CIP_TXTDOMAIN) );
	}
	echo wp_json_encode( $out );
	exit;
}
// END SA ARCHIVE STATUS
add_filter( 'gform_validation_4', 'custom_vat_validation' );
function custom_vat_validation($validation_result){
    // page 2
    if (GFFormDisplay::get_source_page( 4 ) == 3) {
		if( isset($_COOKIE['buyproductsubmit']) && $_COOKIE['buyproductsubmit'] == 'yes' ){
			$validation_result['is_valid'] = false;
			$validation_result["form"]["fields"][23]["failed_validation"] = true;
			$validation_result["form"]["fields"][23]["validation_message"] = __('Duplicate order detected. Please review your order in the My Purchases section of My CSR. If your order is not listed you can try again by clicking "Become Plastic Neutral"',CIP_TXTDOMAIN);
		}
	}
    return $validation_result;
}
function get_all_gform_fields_value( $form , $entry = array() ){
	$data = array();
	if( $form ){
		foreach($form["fields"] as &$field){
			if (is_array($field["inputs"])){
				foreach($field["inputs"] as &$input){
					$label = $input["label"];
					if( empty( $entry ) ){
						$value = rgpost( "input_{$field['id']}" );
					}else{
						$value = $entry[strval($input["id"])];
					}
					if( !empty( $value ) ){
						$data[ $label ] = $value;
					}
				}
			}else{
				$label = $field["label"];
				if( empty( $entry ) ){
					$value = rgpost( "input_{$field['id']}" );
				}else{
					$value = $entry[$field["id"]];
				}
				if( !empty( $value ) ){
					$data[ $label ] = $value;
				}
			}
		}
	}
	return $data;
}
add_action('wp_head','clear_buy_product_cookie');
function clear_buy_product_cookie(){
	if( is_page( 4258 ) ){
		setcookie('buyproductsubmit', 'no', time() + (86400 / 1440 ) * 15, "/");
	}
}
function cip_get_client_ip() {
    $ipaddress = '';
    if (isset($_SERVER['HTTP_CLIENT_IP'])){
        $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
    }else if(isset($_SERVER['HTTP_X_FORWARDED_FOR'])){
        $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
    }else if(isset($_SERVER['HTTP_X_FORWARDED'])){
        $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
    }else if(isset($_SERVER['HTTP_FORWARDED_FOR'])){
        $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
    }else if(isset($_SERVER['HTTP_FORWARDED'])){
        $ipaddress = $_SERVER['HTTP_FORWARDED'];
    }else if(isset($_SERVER['REMOTE_ADDR'])){
        $ipaddress = $_SERVER['REMOTE_ADDR'];
    }else{
        $ipaddress = '';
	}
    return $ipaddress;
}
function isEU($countrycode) {
    $eu_countrycodes = array( 'AT', 'BE', 'BG', 'CY', 'CZ', 'DE', 'DK', 'EE', 'EL', 'ES', 'FI', 'FR', 'GR', 'HR', 'HU', 'IE', 'IT', 'LT', 'LU', 'LV', 'MT', 'NL', 'PL', 'PT', 'RO', 'SE', 'SI', 'SK' );
    return (in_array($countrycode, $eu_countrycodes));
}
add_filter( 'gform_replace_merge_tags', 'cip_custom_merge_tags_replace_cb', 10, 7 );
function cip_custom_merge_tags_replace_cb( $text, $form, $entry, $url_encode, $esc_html, $nl2br, $format ) {
	global $wpdb;
	$buyer_email = $_SESSION['refAccount'];
	$introducedby = "";
	$business_name = "";
	$vat_number = "";
	$country = "";
	$invoiceTable = $wpdb->prefix.'cip_member_invoice';
	if( !empty( $_SESSION['refAccount'] ) ){
		$refAccount = $_SESSION['refAccount'];
		$getMemberData = $wpdb->get_row("SELECT * FROM $invoiceTable WHERE Email='$refAccount' ORDER BY `id` DESC");
		if( $getMemberData ){
			$buyer_email = $getMemberData->Email;
			$business_name = $getMemberData->BusinessName;
			$vat_number = $getMemberData->VatNumber;
			$country = $getMemberData->VATCountry;
		}
	}
	$custom_merge_tags = array(
		'{site_url}'  			=> get_site_url(),
		'{site_name}' 			=> get_bloginfo( 'name' ),
		'{cip_buyer_email}' 	=> $buyer_email,
		'{cip_introducedby}' 	=> $introducedby,
		'{cip_business_name}'	=> $business_name,
		'{cip_vat_number}'		=> $vat_number,
		'{cip_vat_country}'		=> $country,
	);
    return str_replace( array_keys( $custom_merge_tags ), array_values( $custom_merge_tags ), $text);
}
//for default value add custom merge tags
add_filter('gform_custom_merge_tags', 'cip_121021_custom_merge_tags', 10, 4);
function cip_121021_custom_merge_tags( $merge_tags, $form_id, $fields, $element_id ){
	$merge_tags[] = array('label' => 'CIP Buyer Email', 'tag' => '{cip_buyer_email}');
	$merge_tags[] = array('label' => 'CIP IntroducedBy', 'tag' => '{cip_introducedby}');
	$merge_tags[] = array('label' => 'CIP Business Name', 'tag' => '{cip_business_name}');
	$merge_tags[] = array('label' => 'CIP VAT Number', 'tag' => '{cip_vat_number}');
	$merge_tags[] = array('label' => 'CIP Country', 'tag' => '{cip_vat_country}');
	return $merge_tags;
}
add_filter('gform_field_content', 'cip_121021_field_content_replacebyvalue_cb', 999, 5);
function cip_121021_field_content_replacebyvalue_cb($field_content, $field, $value, $lead_id, $form_id) {
	global $wpdb;
	$buyer_email = $_SESSION['refAccount'];
	$introducedby = "";
	$business_name = "";
	$vat_number = "";
	$country = "";
	$invoiceTable = $wpdb->prefix.'cip_member_invoice';
	if( !empty( $_SESSION['refAccount'] ) ){
		$refAccount = $_SESSION['refAccount'];
		$getMemberData = $wpdb->get_row("SELECT * FROM $invoiceTable WHERE Email='$refAccount' ORDER BY `id` DESC");
		if( $getMemberData ){
			$buyer_email = $getMemberData->Email;
			$business_name = $getMemberData->BusinessName;
			$vat_number = $getMemberData->VatNumber;
			$country = $getMemberData->VATCountry;
		}
	}
    if (strpos($field_content, '{cip_buyer_email}') !== false) {
        $field_content = str_replace('{cip_buyer_email}', $buyer_email, $field_content);
    }
	if (strpos($field_content, '{cip_introducedby}') !== false) {
        $field_content = str_replace('{cip_introducedby}', $introducedby, $field_content);
    }
	if (strpos($field_content, '{cip_business_name}') !== false) {
        $field_content = str_replace('{cip_business_name}', $business_name, $field_content);
    }
	if (strpos($field_content, '{cip_vat_number}') !== false) {
        $field_content = str_replace('{cip_vat_number}', $vat_number, $field_content);
    }
	if (strpos($field_content, '{cip_vat_country}') !== false) {
        $field_content = str_replace('{cip_vat_country}', $country, $field_content);
    }
    return $field_content;
}
add_action('wp_ajax_cip_sm_api_settings_act','cip_sm_api_settings_act_cb');
function cip_sm_api_settings_act_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_micro'],'_CIPxsmapisettingxCIP_' ) && current_user_can( 'supportmanager' ) ){
		update_option( 'euvatapi_access_key', $_POST['euvatapi_access_key'] );
		update_option( 'euvatapi_ip_address', $_POST['euvatapi_ip_address'] );

		$amplivo_api_mode = get_option('amplivo_api_mode');
		$amplivo_api_test_source_url = get_option('amplivo_api_test_source_url');
		$amplivo_api_live_source_url = get_option('amplivo_api_live_source_url');
		$amplivo_api_auth_username = get_option('amplivo_api_auth_username');
		$amplivo_api_auth_pwd = get_option('amplivo_api_auth_pwd');

		update_option('amplivo_api_mode', isset($_POST['amplivo_api_mode']) ? $_POST['amplivo_api_mode'] : '');
		update_option('amplivo_api_test_source_url', isset($_POST['amplivo_api_test_source_url']) ? $_POST['amplivo_api_test_source_url'] : '');
		update_option('amplivo_api_live_source_url', isset($_POST['amplivo_api_live_source_url']) ? $_POST['amplivo_api_live_source_url'] : '');
		update_option('amplivo_api_auth_username', isset($_POST['amplivo_api_auth_username']) ? $_POST['amplivo_api_auth_username'] : '');
		update_option('amplivo_api_auth_pwd', isset($_POST['amplivo_api_auth_pwd']) ? $_POST['amplivo_api_auth_pwd'] : '');

		$log_type = 'amplivo_api_update';
		$data_array = array(
			"Amplivo api mode" => $_POST['amplivo_api_mode'],
			"Amplivo api test source url" => $_POST['amplivo_api_test_source_url'],
			"Amplivo api live source url" => $_POST['amplivo_api_live_source_url'],
			"Amplivo api auth username" => $_POST['amplivo_api_auth_username'],
			"Amplivo api auth pwd" => $_POST['amplivo_api_auth_pwd'],
		);
		$pre_data_array = array(
			"Amplivo api mode" => $amplivo_api_mode,
			"Amplivo api test source url" => $amplivo_api_test_source_url,
			"Amplivo api live source url" => $amplivo_api_live_source_url,
			"Amplivo api auth username" => $amplivo_api_auth_username,
			"Amplivo api auth pwd" => $amplivo_api_auth_pwd,
		);
		$extra_val = 'changed Amplivo api values '.json_encode($data_array).' Previous values '.json_encode($pre_data_array);
		$user = wp_get_current_user();
		create_cip_logs_entery( $user->ID, $log_type , $extra_val );

		$out = array( "error" => 0,'msg' => __('Updated',CIP_TXTDOMAIN) );
	}
	echo wp_json_encode( $out );
	exit;
}
function csr_to_two_decimal( $csr_amount = 0, $round = false ){
	$csr_amount = number_format((float)$csr_amount, 2, '.', '');
	if( $round ){
		$csr_amount = round( $csr_amount );
	}
	return $csr_amount;
}
function cip_pdf_number_formater( $numVal = 0 ){
	return number_format((float)$numVal, 2, '.', '');
}
add_action('wp_footer','sponser_validation_script_cb');
function sponser_validation_script_cb(){
?><script>
var $ = jQuery;
var block_config = { message: null,overlayCSS:{ backgroundColor: '#fff',opacity:0.8} };
var $form = $('#gform_page_4_2');
var focusOutCount = 0;
jQuery(document).ready(function(){
	jQuery(document).on('gform_post_render', function(event, form_id, current_page){
		if( form_id == 4 && current_page == 2 ){
			if( jQuery('.gform_body #input_4_3').length > 0 ){
				if( focusOutCount != 2 ){
					focusOutCount++;
					setTimeout( function(){ if( jQuery('.gform_body #input_4_3').val() != "" ){ jQuery('.gform_body #input_4_3').trigger('focusout'); } }, 1000);
					console.log('second');
					return;
				}
				if( jQuery('.gform_body #input_4_3').val() != "" ){
					focusOutCount++;
					jQuery('.gform_body #input_4_3').trigger('focusout');
					console.log('first');
				}
			}
			console.log( 'form_id', form_id );
			console.log( 'current_page', current_page );
		}
    });
});
jQuery(document).ready(async function(){
	var error_msg = 'The supplied Sponsor ID does not correspond with our records. Please contact the person who referred you to this site. <br/>Proceeding without or with an incorrect Sponsor ID will delay your order.';
	var buy_email_status = "";
	if( jQuery('.gform_body #input_4_3').length > 0 ){
		sponser_validate_by_email( $("#input_4_3") );
	}
	if( jQuery('.gform_body #input_4_30').length > 0 ){
		sponser_validate_by_username( $("#input_4_30") );
		if( $('#input_4_3').val() != "" && $('#input_4_30').val() != ""  ){
			$('#input_4_30').focus();
			$('#input_4_30').blur();
		}
	}
	function sponser_validate_by_email(field) {
		var next_button = field.parent().parent().parent().parent().next().find('.button').next('.button');
		field.on("focusout", function(){
			var email_address = field.val();
			if( email_address != "" ){
				var $form = $("#input_4_3").closest('div.gfield');
				$form.block( block_config );
				var sponsor_name = $('#input_4_30').val();
				var data = { 'action' : 'sponser_validator_byemail_act', 'email' : email_address};
				$.post(cipscript.ajax_url, data, function(response){
					var obj = JSON.parse( response );
					var errorElem = $('#field_4_30');
					$('body').find('.introduced_error').remove();
					buy_email_status = obj.status;
					if( obj.username != "" ){
						$('#input_4_30').val( obj.username );
						if( obj.username != "" ){ $('#input_4_30').attr('readonly',true); }
					}else if( obj.status == 'active' && obj.username == "" ){
						$('#input_4_30').val( obj.username );
						if( obj.username == "" ){ $('#input_4_30').attr('readonly',false); }
						$('<div id="introduced_error" class="introduced_error gfield_description validation_message gfield_validation_message">'+error_msg+'</div>').appendTo( errorElem );
					}else if( obj.status == "notfound" ){
						$('#input_4_30').val('');
						$('#input_4_30').attr('readonly',false);
					}else if( obj.status != "notfound" && obj.status != "active" ){
						$('<div id="introduced_error" class="introduced_error gfield_description validation_message gfield_validation_message">'+error_msg+'</div>').appendTo( errorElem );
						$('#input_4_30').val('');
						$('#input_4_30').attr('readonly',false);
					}else if( obj.status != "active" && sponsor_name == "" ){
						$('<div id="introduced_error" class="introduced_error gfield_description validation_message gfield_validation_message">'+error_msg+'</div>').appendTo( errorElem );
						$('#input_4_30').val('');
						$('#input_4_30').attr('readonly',false);
					}
					$form.unblock();
				});
			}
		});
	}
	function sponser_validate_by_username(field) {
		var next_button = field.closest('.gform_page').find('#gform_submit_button_4');
		field.on("focusout", function(){
			next_button.css('pointer-events', 'none');
			var username = field.val();
			var inputEmail = $('#input_4_3').val();
			if( username != "" ){
				var data = { 'action' : 'sponser_validator_byusername_act', 'username' : username, 'email' : inputEmail };
				$('body').find('.introduced_error').remove();
				var $form = $("#input_4_30").closest('div.gfield');
				$form.block( block_config );
				$.post(cipscript.ajax_url, data, function(response){
					var obj = JSON.parse( response );
					var errorElem = $('#field_4_30');
					$('body').find('.introduced_error').remove();

					if( obj.email_username != 'notfound' && obj.email_username != obj.username ){
						$('<div id="introduced_error" class="introduced_error gfield_description validation_message gfield_validation_message">The supplied sponsor and email not matched</div>').appendTo( errorElem );
						next_button.css('pointer-events', 'none');
					}else{
						if( obj.username != "" ){
							$('#input_4_30').val( obj.username );
							next_button.css('pointer-events', '');
						}else if( obj.username == "" ){
							$('#input_4_30').val( obj.username );
							$('<div id="introduced_error" class="introduced_error gfield_description validation_message gfield_validation_message">'+error_msg+'</div>').appendTo( errorElem );
							next_button.css('pointer-events', '');
						}else if( obj.status == "notfound" ){
							$('#input_4_30').val('');
							next_button.css('pointer-events', '');
						}else if( obj.status != "active" ){
							$('<div id="introduced_error" class="introduced_error gfield_description validation_message gfield_validation_message">'+error_msg+'</div>').appendTo( errorElem );
							$('#input_4_30').val('');
							next_button.css('pointer-events', '');
						}
					}

					$form.unblock();
				});
			}else if( username == "" ){
				$('body').find('.introduced_error').remove();
				next_button.css('pointer-events', '');
				$('#input_4_30').val('');
			}
		});
	}
});
</script><?php
}
add_action('wp_ajax_sponser_validator_byemail_act','cip_sponser_validator_byemail_act_cb');
add_action('wp_ajax_nopriv_sponser_validator_byemail_act','cip_sponser_validator_byemail_act_cb');
function cip_sponser_validator_byemail_act_cb(){
	$validateData = array(
		'status'	=> 'notfound',
		'email'	=>	'',
		'username'	=>	'',
		'sponsor_full_name'	=>	'',
	);
	if( !empty( $_POST['email'] ) ){
		$email = $_POST['email'];
		$request_url = add_query_arg( 'email', urlencode( $email ), 'https://amplivo.com/api/userstatus/get' );
		$response = wp_remote_get( $request_url );
		if( !is_wp_error( $response ) ) {
			$response_body = wp_remote_retrieve_body( $response );
			$data = json_decode( $response_body );
			if( is_object( $data ) && isset( $data->Status ) ){
				$validateData = array(
					'status'	=> $data->Status,
					'email'	=>	$data->Email,
					'username'	=>	$data->sponsor_username,
					'sponsor_full_name'	=>	$data->sponsor_full_name,
				);
			}
		}
	}
	echo wp_json_encode( $validateData );
	exit;
}
add_action('wp_ajax_sponser_validator_byusername_act','cip_sponser_validator_byusername_act_cb');
add_action('wp_ajax_nopriv_sponser_validator_byusername_act','cip_sponser_validator_byusername_act_cb');
function cip_sponser_validator_byusername_act_cb(){
	$validateData = array(
		'status'	=> 'notfound',
		'email'	=>	'',
		'email_username'	=>	'notfound',
		'username'	=>	'',
		'sponsor_full_name'	=>	'',
	);
	if( !empty( $_POST['username'] ) ){
		$username = $_POST['username'];
		$request_url = add_query_arg( 'username', urlencode( $username ), 'https://amplivo.com/api/userstatus/get' );
		$response = wp_remote_get( $request_url );
		if( !is_wp_error( $response ) ) {
			$response_body = wp_remote_retrieve_body( $response );
			$data = json_decode( $response_body );
			if( is_object( $data ) && isset( $data->Status ) ){
				$validateData = array(
					'status'	=> $data->Status,
					'email'	=>	$data->Email,
					'email_username'	=>	'notfound',
					'username'	=>	$data->Username,
					'sponsor_full_name'	=>	$data->user_full_name,
				);
			}
		}
	}
	if( !empty( $_POST['email'] ) ){
		$email = $_POST['email'];
		$request_url = add_query_arg( 'email', urlencode( $email ), 'https://amplivo.com/api/userstatus/get' );
		$response = wp_remote_get( $request_url );
		if( !is_wp_error( $response ) ) {
			$response_body = wp_remote_retrieve_body( $response );
			$data = json_decode( $response_body );
			if( is_object( $data ) && isset( $data->Status ) ){
				$validateData['email_username']	= $data->sponsor_username;
			}
		}
	}
	echo wp_json_encode( $validateData );
	exit;
}
function get_sponsor_fullname_byuser( $username = '' ){
	$validateData = array(
		'status'	=> '',
		'email'	=>	'',
		'username'	=>	'',
		'sponsor_full_name'	=>	'',
	);
	if( !empty( $username ) ){
		$request_url = add_query_arg( 'username', urlencode( $username ), 'https://amplivo.com/api/userstatus/get' );
		$response = wp_remote_get( $request_url );
		if( !is_wp_error( $response ) ) {
			$response_body = wp_remote_retrieve_body( $response );
			$data = json_decode( $response_body );
			if( is_object( $data ) && isset( $data->Status ) ){
				$validateData = array(
					'status'	=> $data->Status,
					'email'	=>	$data->Email,
					'username'	=>	$data->Username,
					'sponsor_full_name'	=>	$data->user_full_name,
				);
			}
		}
	}
	return $validateData;
}
function get_sponsor_username_byemail( $email = '' ){
	$username =	'';
	if( !empty( $email ) ){
		$request_url = add_query_arg( 'email', urlencode( $email ), 'https://amplivo.com/api/userstatus/get' );
		$response = wp_remote_get( $request_url );
		if( !is_wp_error( $response ) ) {
			$response_body = wp_remote_retrieve_body( $response );
			$data = json_decode( $response_body );
			if( is_object( $data ) && isset( $data->Status ) ){
				$username = $data->sponsor_username;
			}
		}
	}
	return $username;
}
function cip_convert_csr_by_price( $price = 10 ){
	$selling_price_csr = ( !empty( get_option('selling_price_csr') ) ) ? get_option('selling_price_csr') : 1;

	$selling_price_csr25 = ( !empty( get_option('selling_price_csr25') ) ) ? get_option('selling_price_csr25') : 1;
	$ampliov_price_type = ( !empty( get_option('ampliov_price_type') ) ) ? get_option('ampliov_price_type') : 'CSR';
	if( $ampliov_price_type == 'CSR25' ){
		$selling_price_csr = $selling_price_csr25;
	}

	$csr_amount = csr_to_two_decimal( $price / $selling_price_csr, true );
	return $csr_amount;
}
function cip_convert_kgs_by_price( $price = 10 ){
	$selling_price_csr = ( !empty( get_option('selling_price_csr') ) ) ? get_option('selling_price_csr') : 1;

	$selling_price_csr25 = ( !empty( get_option('selling_price_csr25') ) ) ? get_option('selling_price_csr25') : 1;
	$ampliov_price_type = ( !empty( get_option('ampliov_price_type') ) ) ? get_option('ampliov_price_type') : 'CSR';
	if( $ampliov_price_type == 'CSR25' ){
		$selling_price_csr = $selling_price_csr25;
	}

	$csr_amount = $price / $selling_price_csr;
	$kgs = csr_to_two_decimal( $csr_amount / 10, true );
	return $kgs;
}
function cip_convert_csr_by_price_pdf( $price = 10, $selling_price = 1 ){
	$csr_amount = csr_to_two_decimal( $price / $selling_price, true );
	return $csr_amount;
}
add_filter( 'gform_field_content', function( $input, $field ) {
	if ( $field->type == 'email' ) {
		$autocomplete = 'password';
		return preg_replace( '/<(input|textarea)/', '<${1} autocomplete="' . $autocomplete . '" ', $input );
	}
	return $input;
}, 11, 2 );
add_action('wp_ajax_cip_add_csr_scheduler','cip_add_csr_scheduler_callback');
function cip_add_csr_scheduler_callback(){
	$out = array( "error" => 1, 'msg' => __('Something Went Wrong.', CIP_TXTDOMAIN) );
	global $wpdb;
	$tableScheduler = $wpdb->prefix.'csr_scheduler';
	if( wp_verify_nonce( $_POST['_micro'],'_CIPxsmCSRScheduleraddxCIP_' ) && current_user_can( 'supportmanager' ) ){
		$status = ( $_POST['price_type'] == 'prompt' ) ? 'active' : 'pending';
		$schedule_time = ( $_POST['price_type'] == 'prompt' ) ? gmdate('Y-m-d H:i') : sprintf( '%s %s:%s', $_POST['schedule_time_alt'], $_POST['schedule_hours'], $_POST['schedule_minutes'] );
		$data = array(
			'csr_price'		=>	$_POST['selling_price_csr'],
			'price_type'	=>	$_POST['price_type'],
			'create_date'	=>	gmdate('Y-m-d H:i'),
			'start_date'	=>	$schedule_time,
			'status'		=>	$status,
		);
		$insert = $wpdb->insert($tableScheduler, $data);
		if( $insert ){
			if( $_POST['price_type'] == 'prompt' ){
				$lastid = $wpdb->insert_id;
				$getOldActive = $wpdb->get_results("SELECT * FROM $tableScheduler WHERE status='active' AND id!=$lastid");
				if( $getOldActive ){
					foreach( $getOldActive as $oldActive ){
						$dataActive = array( 'status'	=>	'overwritten' );
						$whereActive = array( 'id'	=>	$oldActive->id );
						$updateActive = $wpdb->update($tableScheduler, $dataActive, $whereActive);
					}
				}

				$selling_price_csr = ( !empty( $_POST['selling_price_csr'] ) ) ? $_POST['selling_price_csr'] : 0.025;
				update_option( 'selling_price_csr', $selling_price_csr );
			}
			$log_type = 'selling_price_csr';
			$user = wp_get_current_user();
			$message = "New CSR (".$_POST['selling_price_csr'].")price added price_type ".$_POST['price_type']." schedule on ".$schedule_time;
			create_cip_logs_entery( $user->ID, $log_type, $message);
			$out = array( "error" => 0, 'msg' => __('Success', CIP_TXTDOMAIN), 'redirect_url'	=> get_permalink( 5631 ) );
		}
	}
	echo wp_json_encode($out);
	exit;
}
add_action('wp_ajax_csr_schedular_script','cip_csr_schedular_script_cb');
add_action('wp_ajax_nopriv_csr_schedular_script','cip_csr_schedular_script_cb');
function cip_csr_schedular_script_cb(){
	$out = array( "error" => 1, 'msg' => __('Something went wrong.', CIP_TXTDOMAIN) );
	global $wpdb;
	$tableScheduler = $wpdb->prefix.'csr_scheduler';
	if( isset( $_GET['cronmicro'] ) && str_rot13( $_REQUEST['cronmicro'] ) === 'CIPcsr_schedularCIP'  ){ //PVCpfe_fpurqhynePVC
		$getSchedulars = $wpdb->get_results("SELECT * FROM $tableScheduler WHERE price_type='scheduled' AND status='pending'");
		if( $getSchedulars ){
			foreach( $getSchedulars as $getSchedular ){
				$start_date = "";
				$current_date = DateTime::createFromFormat( 'Y-m-d H:i', gmdate('Y-m-d H:i') );
				try{
					$start_date = DateTime::createFromFormat( 'Y-m-d H:i', $getSchedular->start_date );
				}catch (\Throwable $th){
				}
				if( !empty( $start_date ) ){
					if( $current_date >= $start_date ){

						$dataActive = array( 'status'	=>	'overwritten' );
						$whereActive = array( 'status'	=>	'active' );
						$updateActive = $wpdb->update($tableScheduler, $dataActive, $whereActive);
						$data = array('status'	=>	'active');
						$where = array('id'	=>	$getSchedular->id);
						$update = $wpdb->update($tableScheduler, $data, $where);
						if( $update ){
							update_option( 'selling_price_csr', $getSchedular->csr_price );
						}
					}
				}
			}
		}
	}
	exit;
}
add_action('wp_ajax_cip_schedular_remover','cip_schedular_remover_callback');
function cip_schedular_remover_callback(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_micro'],'_XyPendingSchedularDeleteyX_' ) ){
		global $wpdb;
		$tableScheduler = $wpdb->prefix.'csr_scheduler';
		$getSingleSchedular = $wpdb->get_row("SELECT id FROM $tableScheduler WHERE id = ".$_POST['thisid']." AND status = 'pending'");
		if( $getSingleSchedular ){
			$where = [ 'id' => $_POST['thisid'] ];
			$deleting = $wpdb->delete( $tableScheduler, $where );
			$out = array( "error" => 0,'msg' => __('Record Deleted',CIP_TXTDOMAIN) );
		}else{
			$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
		}
	}
	echo wp_json_encode( $out );
	exit;
}
//includes shortcodes file
include 'includes/shortcodes.php';
include 'cip-help-branch-5937.php';
include 'includes/support-ticket-api.php';
include 'includes/refer_script.php';
include 'includes/cip-bst-ajax.php';
include 'includes/Converter.php';
include 'php-ecrecover/autoload.php';
add_filter( 'gform_countries', 'cipBuyProductFormRemoveCountry', 99 );
function cipBuyProductFormRemoveCountry( $countries ){
	$newCountries = array();
	if( is_page( 4250 ) ){
		$removeCountriesList = [
			'Afghanistan',
			'American Samoa',
			'Angola',
			'Bahamas',
			'Barbados',
			'Belarus',
			'Bosnia and Herzegovina',
			'Botswana',
			'Burundi',
			'Cambodia',
			'Cabo Verde',
			'Cayman Islands',
			'Central African Republic',
			'Chad',
			'China',
			'Congo',
			'Congo, Democratic Republic of the',
			'C�0�0te d\'Ivoire',
			'Cuba',
			'Korea, Democratic People\'s Republic of',
			'Egypt',
			'Equatorial Guinea',
			'Eritrea',
			'Ethiopia',
			'Fiji',
			'Ghana',
			'Guam',
			'Guinea',
			'Guinea-Bissau',
			'Guyana',
			'Haiti',
			'Iran',
			'Iraq',
			'Jamaica',
			'Lao People\'s Democratic Republic',
			'Lebanon',
			'Liberia',
			'Libya',
			'Mali',
			'Mauritius',
			'Moldova',
			'Mongolia',
			'Montenegro',
			'Mozambique',
			'Myanmar',
			'Nicaragua',
			'Nigeria',
			'Oman',
			'Pakistan',
			'Palau',
			'Palestine, State of',
			'Panama',
			'Papua New Guinea',
			'Puerto Rico',
			'Russian Federation',
			'Samoa',
			'Saudi Arabia',
			'Serbia',
			'Sierra Leone',
			'Somalia',
			'Sri Lanka',
			'Sudan',
			'Syria Arab Republic',
			'Tanzania',
			'Tanzania, the United Republic of',
			'Trinidad and Tobago',
			'T��rkiye',
			'Vanuatu',
			'Venezuela',
			'Virgin Islands, U.S.',
			'Yemen',
			'Zimbabwe',
		];
		foreach( $countries as $country ){
			if( !in_array( $country, $removeCountriesList ) ){
				$newCountries[] = $country;
			}
		}
	}else{
		$newCountries = $countries;
	}
    return $newCountries;
}
//5077 code
function getOrdinal($number){
	$digit = abs($number) % 10;
	$ext = 'th';
	$ext = ((abs($number) %100 < 21 && abs($number) %100 > 4) ? 'th' : (($digit < 4) ? ($digit < 3) ? ($digit < 2) ? ($digit < 1) ? 'th' : 'st' : 'nd' : 'rd' : 'th'));
	return $number.$ext;
}
function get_amplivo_user_status( $username = '' ){
	$validateData = array(
		'status'	=> '',
		'email'	=>	'',
		'username'	=>	'',
		'sponsor_full_name'	=>	'',
	);
	if( !empty( $username ) ){

		$endpoint = 'https://amplivo.com/api/userstatus/get';
		$request_url = add_query_arg( array(
			'username' 			=> urlencode( $username ),
		), $endpoint );

		$response = wp_remote_get( $request_url );
		if( !is_wp_error( $response ) ) {
			$response_body = wp_remote_retrieve_body( $response );
			$data = json_decode( $response_body );
			if( is_object( $data ) && isset( $data->Status ) ){
				$validateData = array(
					'status'	=> $data->Status,
					'email'	=>	$data->Email,
					'username'	=>	$data->Username,
					'sponsor_full_name'	=>	$data->user_full_name,
				);
			}
		}
	}
	return $validateData;
}
add_action( 'init', 'prohibit_access_to_admin' );
function prohibit_access_to_admin() {
	if ( is_admin() && !current_user_can( 'administrator' ) && ! ( defined( 'DOING_AJAX' ) && DOING_AJAX ) && !strpos($_SERVER['SCRIPT_NAME'], 'admin-post.php') ) {
		wp_redirect( home_url() ); exit;
	}
}
add_action( 'wp_ajax_province_vat_rate_update_act', 'province_vat_rate_update_act_callback' );
function province_vat_rate_update_act_callback(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( current_user_can( 'supportagent' ) || current_user_can( 'supportmanager' ) ){
		global $wpdb;
		$tableCanadaProvince = $wpdb->prefix.'canada_province';
		$vat_rates = $_POST['vat_rates'];
		if( is_array( $vat_rates ) && !empty( $vat_rates ) ){
			foreach( $vat_rates as $key => $vat_rate ){
				$updateVat = $wpdb->update( $tableCanadaProvince, [ 'vat_rate' => $vat_rate, 'last_update' => date_i18n('Y-m-d H:i:s') ], [ 'id' => $key ] );
			}
		}
		$out = array( "error" => 0,'msg' => __('Success', CIP_TXTDOMAIN) );
	}
	echo wp_json_encode( $out );
	exit;
}

add_action('wp_ajax_get_amplivo_user_byemail_act','cip_get_amplivo_user_byemail_act_cb');
add_action('wp_ajax_nopriv_get_amplivo_user_byemail_act','cip_get_amplivo_user_byemail_act_cb');
function cip_get_amplivo_user_byemail_act_cb(){
	$validateData = array(
		'Status'			=> '',
		'user_full_name'	=> '',
		'Email'	=>	'',
		'Username'	=>	'',
	);
	if( !empty( $_POST['email'] ) ){
		$email = $_POST['email'];
		$request_url = add_query_arg( 'email', urlencode( $email ), 'https://amplivo.com/api/userstatus/get' );
		$response = wp_remote_get( $request_url );
		if( !is_wp_error( $response ) ) {
			$response_body = wp_remote_retrieve_body( $response );
			$data = json_decode( $response_body );
			if( is_object( $data ) && isset( $data->Status ) ){
				$validateData = array(
					'Status'		=> $data->Status,
					'user_full_name'=> $data->user_full_name,
					'Email'			=>	$data->Email,
					'Username'		=>	$data->Username,
				);
			}
		}
	}
	echo wp_json_encode( $validateData );
	exit;
}
function cip_get_agent_user_name( $user_id = null ) {
	$user_info = $user_id ? new WP_User( $user_id ) : wp_get_current_user();
	if ( $user_info->first_name ) {
		if ( $user_info->last_name ) {
			return $user_info->first_name . ' ' . $user_info->last_name;
	  	}
	  	return $user_info->first_name;
	}
	return $user_info->display_name;
}
function get_var_rate_by_province( $state = "" ){
	global $wpdb;
	$tableCanadaProvince = $wpdb->prefix.'province_management';
	$vat_rate_data = array(
		'GST'	=>	0,
		'QST'	=>	0,
	);
	if( !empty( $state ) ){
		$getProvinceData = $wpdb->get_row("SELECT * FROM $tableCanadaProvince WHERE `province_name`='".$state."'");
		if( $getProvinceData ){
			$vat_rate_data = array(
				'GST'	=>	$getProvinceData->GST,
				'QST'	=>	$getProvinceData->QST,
			);
		}
	}
	return $vat_rate_data;
}
function amplivo_sign_up_redirect_after_delay() {
    if (is_page(7671)) {
        ?>
        <script type="text/javascript">
            setTimeout(function() {
                window.location.href = '<?php echo get_ampliov_link_url(); ?>sign-up';
            }, 10000);
        </script>
        <?php
    }
}
add_action('wp_footer', 'amplivo_sign_up_redirect_after_delay');
add_action( 'wp_ajax_getBuyPackageTxnPwdact', 'getBuyPackageTxnPwdact_callback' );
function getBuyPackageTxnPwdact_callback(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( current_user_can( 'member' ) ){
		global $wpdb;
		$tablePackages = $wpdb->prefix.'sa_packages';

		$decryptedId_raw = base64_decode( $_POST['thisId'] );
		$pkgId = preg_replace(sprintf('/%s/', md5('123QCIP_Buy_Packages_CIPQ321') ), '', $decryptedId_raw);
		$getPackage = $wpdb->get_row("SELECT * FROM $tablePackages WHERE `id`=$pkgId");
		if( $getPackage ){
			$data_micro = wp_create_nonce( $getPackage->id . md5('123QCIP_Buy_Packages_CIPQ321') );
			$csrPrice = cip_convert_csr_by_price($getPackage->euro_amount);
			$current_user = wp_get_current_user();
			$user_id = $current_user->ID;
			$html = "";
			$amplivo_api_mode = get_option('amplivo_api_mode');
			if ($amplivo_api_mode == 'live') {
				$sourceUrl = get_option('amplivo_api_live_source_url') . 'get-user-data';
			} else {
				$sourceUrl = get_option('amplivo_api_test_source_url') . 'get-user-data';
			}
			$current_user = wp_get_current_user();
			// Prepare the request arguments for wp_remote_post()
			$username = get_option( 'amplivo_api_auth_username' );
			$auth_password = get_option( 'amplivo_api_auth_pwd' );
			$body = wp_json_encode( array(
				'email'	=>	$current_user->user_email
			) );
			// Create an array with the request arguments, including Basic Auth in the headers
			$request_args = array(
				'headers' => array(
					'Authorization' => 'Basic ' . base64_encode( $username . ':' . $auth_password ),
					'Content-Type' => 'application/json', // Adjust content type if necessary
				),
				'body' 		=> $body,
			);

			// Make the POST request using wp_remote_post()
			$responseApi = wp_remote_post($sourceUrl, $request_args);

			$response_body = wp_remote_retrieve_body( $responseApi );

			$data = json_decode( $response_body );
			$vat_rate_data = get_var_rate_by_province( $data->result->StateProvinceRegion );

			$coinbase_request_url = add_query_arg( 'currency', 'EUR', 'https://api.coinbase.com/v2/exchange-rates' );
			$coinbase_response = wp_remote_get( $coinbase_request_url );
			$exchangeRate = 0;
			if( !is_wp_error( $coinbase_response ) ) {
				$coinbase_response_body = wp_remote_retrieve_body( $coinbase_response );
				$data = json_decode( $coinbase_response_body );
				if( is_object( $data ) ){
					$rates = $data->data->rates;
					if( isset( $rates->CAD ) ){
						$exchangeRate = round( $rates->CAD, 4 );
					}
				}
			}

			$PriceCAD = $getPackage->euro_amount;
			// $PriceCAD = round( ($getPackage->euro_amount * $exchangeRate) , 2);
			$GSTCAD = $vat_rate_data['GST'];
			$QSTCAD = $vat_rate_data['QST'];

			$PriceGSTCAD = $PriceCAD * $GSTCAD / 100;
			$PriceQSTCAD = $PriceCAD * $QSTCAD / 100;

			$TotalCAD = ( $PriceCAD + $PriceGSTCAD + $PriceQSTCAD );

			$coinbase_request_url = add_query_arg( 'currency', 'CAD', 'https://api.coinbase.com/v2/exchange-rates' );
			$coinbase_response = wp_remote_get( $coinbase_request_url );
			$exchangeRate = 0;
			if( !is_wp_error( $coinbase_response ) ) {
				$coinbase_response_body = wp_remote_retrieve_body( $coinbase_response );
				$data = json_decode( $coinbase_response_body );
				if( is_object( $data ) ){
					$rates = $data->data->rates;
					if( isset( $rates->EUR ) ){
						$exchangeRate = round( $rates->EUR, 4 );
					}
				}
			}

			$ocaBalance = 0;
			$body = [
				'email'	=>	$current_user->user_email
			];
			$response_oca = amplivo_api_send_requests( $body, 'get-oca-balance');
			if( $response_oca['success'] == true ){
				$current_ocaBalance = $response_oca['result'];
			}

			$ampliov_price_type = ( !empty( get_option('ampliov_price_type') ) ) ? get_option('ampliov_price_type') : 'CSR';

			// $TotalCAD = round( ($TotalCAD * $exchangeRate) , 2);
			ob_start();
			?>
			<div class="container-fluid">
				<span class="withdrawal_close_btn close" data-dismiss="modal">&times;</span>

				<form class="createPurchaseOrderTxnFrm" id="createPurchaseOrderTxnFrm" name="createPurchaseOrderTxnFrm">
					<!-- <h5 class="mb-1"><?php _e('Transaction Password', CIP_TXTDOMAIN); ?></h5> -->
					<h5 class="mb-1"><?php _e('Confirm purchase', CIP_TXTDOMAIN); ?></h5>
					<div class="form-group user-transaction_password-wrap pt-3">
						<!-- <p class="bpg_gi_bdec"><?php echo sprintf( __('You will get %s CSR', CIP_TXTDOMAIN), number_format( $csrPrice ) ); ?></p> -->
						<p class="bpg_gi_bdec"><?php echo sprintf( __('
						<div class="pb-3">You are purchasing a Plastic Neutrality Package in amount of <strong>%s Euros</strong>.</div>

						<div class="pb-3">The total cost, including local taxes, is <strong>%s Euros</strong>. 						</div>

						<div class="pb-3">The receipted amount of '.$ampliov_price_type.' is <strong>%s</strong>.</div>
						<div class="pb-3">(Purchase reporting on <a href="'.get_ampliov_link_url().'" target="_blank" ><strong>amplivo.com</strong></a> excludes local taxes)</div>
						', CIP_TXTDOMAIN), round( $getPackage->euro_amount ),number_format( $TotalCAD, 2, '.', '' ),number_format( $csrPrice ) ); ?>
						<?php
						if($current_ocaBalance < $TotalCAD){
							echo sprintf( __('Your OCA balance is lower than the package price of <strong>%s Euros</strong> (including local taxes). Your current OCA balance is <strong>%s Euros</strong>.', CIP_TXTDOMAIN), number_format( $TotalCAD, 2, '.', '' ),number_format( $current_ocaBalance, 2, '.', ''  ) );
						}
						?>
						</p>
						<?php
						if($current_ocaBalance > $TotalCAD){
							?>
							<p class="mb-0"><label for="transaction_password"><?php _e( 'Please enter the transaction password', 'corsair-login' ); ?></label></p>
							<div class="input-group-append align-items-center wp-pwd toggle_password">
								<input type="password" name="transaction_password" id="transaction_password" class="input password-input" value="" autocomplete="new-password" />
								<div class="input-group-addon pl-1 pr-1"><a tabindex="-1" href="javascript:void(0);"><i class="fa fa-eye-slash" aria-hidden="true"></i></a></div>
							</div>
							<?php
						}
						?>

					</div>
					<?php
					if($current_ocaBalance > $TotalCAD){
					?>
					<button type="submit" class="btn btn-secondary"><?php _e('Submit', CIP_TXTDOMAIN); ?></button>
					<?php
					}
					?>
					<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Cancel', CIP_TXTDOMAIN) ?></button>
					<input type="hidden" name="action" value="create_purchaseOrder_act" />
					<input type="hidden" name="thisId" value="<?php echo $_POST['thisId']; ?>" />
					<input type="hidden" name="_micro" value="<?php echo $data_micro; ?>" />
				</form>
			</div>
			<?php
		}
		$html = ob_get_clean();
		$out = array( "error" => 0,'msg' => __('Success',CIP_TXTDOMAIN), 'html' => $html );
	}
	echo wp_json_encode( $out );
	exit;
}
add_action( 'wp_ajax_create_purchaseOrder_act', 'create_purchaseOrder_act_callback' );
function create_purchaseOrder_act_callback(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( current_user_can( 'member' ) ){
		global $wpdb;
		$tablePackages = $wpdb->prefix.'sa_packages';

		$decryptedId_raw = base64_decode( $_POST['thisId'] );
		$pkgId = preg_replace(sprintf('/%s/', md5('123QCIP_Buy_Packages_CIPQ321') ), '', $decryptedId_raw);
		$getPackage = $wpdb->get_row("SELECT * FROM $tablePackages WHERE `id`=$pkgId");
		if( $getPackage && wp_verify_nonce( $_POST['_micro'], $getPackage->id . md5('123QCIP_Buy_Packages_CIPQ321') ) ){
			$current_user = wp_get_current_user();
			$user_id = $current_user->ID;
			$body = [
				'email'					=>	$current_user->user_email,
				'transactionpassword'	=>	$_POST['transaction_password'],
			];
			$response = amplivo_api_send_requests( $body, 'validate-transaction-password');
			if( $response['success'] == true ){
				$amplivo_api_mode = get_option('amplivo_api_mode');
				if ($amplivo_api_mode == 'live') {
					$sourceUrl = get_option('amplivo_api_live_source_url') . 'get-csr-price-changes';
				} else {
					$sourceUrl = get_option('amplivo_api_test_source_url') . 'get-csr-price-changes';
				}

				// Prepare the request arguments for wp_remote_post()
				$username = get_option( 'amplivo_api_auth_username' );
				$auth_password = get_option( 'amplivo_api_auth_pwd' );

				// Create an array with the request arguments, including Basic Auth in the headers
				$request_args = array(
					'headers' => array(
						'Authorization' => 'Basic ' . base64_encode( $username . ':' . $auth_password ),
						'Content-Type' => 'application/json', // Adjust content type if necessary
					)
				);

				// Make the POST request using wp_remote_post()
				$responseApi = wp_remote_post($sourceUrl, $request_args);

				$response_body = wp_remote_retrieve_body( $responseApi );

				$data = json_decode( $response_body );

				$apiSellingPrice = ( !empty( get_option('selling_price_csr') ) ) ? get_option('selling_price_csr') : 1;

				if(isset($data->result[0]))
				{
					if($data->result[0]->status == 'active')
					{
						$apiSellingPrice = $data->result[0]->csr_price;
					}
					else
					{
						foreach ($data->result as $key => $value) {
							if($value->status == 'active')
							{
								$apiSellingPrice = $value->csr_price;
							}
						}
					}
				}

				$selling_price_csr = $apiSellingPrice;
				$selling_price_csr25 = ( !empty( get_option('selling_price_csr25') ) ) ? get_option('selling_price_csr25') : 1;
				$ampliov_price_type = ( !empty( get_option('ampliov_price_type') ) ) ? get_option('ampliov_price_type') : 'CSR';
				if( $ampliov_price_type == 'CSR25' ){
					$selling_price_csr = $selling_price_csr25;
				}

				$inclusiveUnit = 	$selling_price_csr;
				

				$invoiceTable= $wpdb->prefix.'cip_member_invoice';
				$account= $wpdb->prefix.'sm_accounts_management';
				$invoice_record = "SELECT * FROM $invoiceTable ORDER BY `id` DESC";
				$invoice_result = $wpdb->get_row($invoice_record);
				if( $invoice_result && !empty( $invoice_result->ProformaInvoiceNumber ) ){
					$proformaNo = $invoice_result->ProformaInvoiceNumber + 1;
				}else{
					$proformaNo = 1001;
				}
				$price = $getPackage->euro_amount;
				//bank account assigning
				$bank_id = null;
				$LatestId = 0;
				$is_rotate = false;
				$getAssignedBank = $wpdb->get_row("SELECT * FROM $invoiceTable WHERE Email = '$email' ORDER BY id DESC");
				if( $getAssignedBank ){ //get from already assigned
					$checkActiveBank = $wpdb->get_row(" SELECT * FROM $account WHERE id = $getAssignedBank->BankId AND Status = 'Active' ");
					if( $checkActiveBank ){
						$bank_id = $checkActiveBank->id;
					}else{
						$getAssignedBanks = $wpdb->get_results("SELECT * FROM $invoiceTable WHERE Email = '$email'");
						$inIds = array();
						if( $getAssignedBanks ){
							foreach( $getAssignedBanks as $assignedBankData ){
								$inIds[] = $assignedBankData->BankId;
							}
						}
						if( !empty( $inIds ) ){
							$inIdsString = implode(",",$inIds);
							$getActiveBank = $wpdb->get_row(" SELECT * FROM $account WHERE id IN($inIdsString) AND Status = 'Active' ORDER BY id DESC ");
							if( $getActiveBank ){
								$bank_id = $getActiveBank->id;
							}else{ //get rotation
								$lastAssignedBank = $wpdb->get_row("SELECT * FROM $account WHERE LatestId = 1");
								if( $lastAssignedBank ){
									$LatestId = $lastAssignedBank->id;
									$getNextBank = $wpdb->get_row("SELECT * FROM $account WHERE Status = 'Active' AND id > $lastAssignedBank->id ORDER BY id ASC");
									if( $getNextBank ){
										$bank_id = $getNextBank->id;
										$is_rotate = true;
									}else{
										$firstAssignedBank = $wpdb->get_row("SELECT * FROM $account WHERE Status = 'Active' ORDER BY id ASC");
										if( $firstAssignedBank ){
											$bank_id = $firstAssignedBank->id;
											$is_rotate = true;
										}
									}
								}else{
									$firstAssignedBank = $wpdb->get_row("SELECT * FROM $account WHERE Status = 'Active' ORDER BY id ASC");
									if( $firstAssignedBank ){
										$bank_id = $firstAssignedBank->id;
										$is_rotate = true;
									}
								}
							}
						}
					}

				}else{ //get rotating
					$lastAssignedBank = $wpdb->get_row("SELECT * FROM $account WHERE LatestId = 1");
					if( $lastAssignedBank ){
						$LatestId = $lastAssignedBank->id;
						$getNextBank = $wpdb->get_row("SELECT * FROM $account WHERE Status = 'Active' AND id > $lastAssignedBank->id ORDER BY id ASC");
						if( $getNextBank ){
							$bank_id = $getNextBank->id;
							$is_rotate = true;
						}else{
							$firstAssignedBank = $wpdb->get_row("SELECT * FROM $account WHERE Status = 'Active' ORDER BY id ASC");
							if( $firstAssignedBank ){
								$bank_id = $firstAssignedBank->id;
								$is_rotate = true;
							}
						}
					}else{
						$firstAssignedBank = $wpdb->get_row("SELECT * FROM $account WHERE Status = 'Active' ORDER BY id ASC");
						if( $firstAssignedBank ){
							$bank_id = $firstAssignedBank->id;
							$is_rotate = true;
						}
					}
				}

				$IntroducedBy = "";
				$username = "";
				$fname = "";
				$lname = "";
				$Address1 = "";
				$Address2 = "";
				$City = "";
				$State = "";
				$Country = "";
				$Zipcode = "";
				$body = [
					'email'	=>	$current_user->user_email,
				];
				$response = amplivo_api_send_requests( $body, 'get-user-data');
				if( $response['success'] == true ){
					$result = $response['result'];
					$Address1 = $result['Address1'];
					$Address2 = $result['Address2'];
					$City = $result['City'];
					$State = $result['StateProvinceRegion'];
					$Zipcode = $result['PostalZip'];
					$Country = $result['Country'];
					$fname = $result['user_first_name'];
					$lname = $result['user_last_name'];
					$username = $result['Username'];
					$IntroducedBy = $result['sponsor_username'];

				}
				$vat_rate_data = get_var_rate_by_province( $State );
				$entryDate= date_i18n( 'd-m-Y');
				$paidDate= date_i18n( 'd-m-Y');
				//Current Timestamp
				$date = new DateTime();
				$curr_timestamp = $date->getTimestamp();


				$coinbase_request_url = add_query_arg( 'currency', 'EUR', 'https://api.coinbase.com/v2/exchange-rates' );
				$coinbase_response = wp_remote_get( $coinbase_request_url );
				$exchangeRate = 0;
				if( !is_wp_error( $coinbase_response ) ) {
					$coinbase_response_body = wp_remote_retrieve_body( $coinbase_response );
					$data = json_decode( $coinbase_response_body );
					if( is_object( $data ) ){
						$rates = $data->data->rates;
						if( isset( $rates->CAD ) ){
							$exchangeRate = round( $rates->CAD, 4 );
						}
					}
				}

				$PriceCAD = round( ($price * $exchangeRate) , 2);
				$GSTCAD = $vat_rate_data['GST'];
				$QSTCAD = $vat_rate_data['QST'];

				$PriceGSTCAD = round( ( $PriceCAD * $GSTCAD / 100 ), 2 );
				$PriceQSTCAD = round( ( $PriceCAD * $QSTCAD / 100 ), 2 );

				$TotalCAD = ( $PriceCAD + $PriceGSTCAD + $PriceQSTCAD );

				$PriceGSTEURO = $price * $GSTCAD / 100;
				$PriceQSTEURO = $price * $QSTCAD / 100;
				$Totaltax = ( $PriceGSTEURO + $PriceQSTEURO );

				$csrKgs = cip_convert_kgs_by_price( $getPackage->euro_amount );
				$csrAmount = cip_convert_csr_by_price_pdf( $getPackage->euro_amount, $inclusiveUnit );

				$ampliov_price_type = ( !empty( get_option('ampliov_price_type') ) ) ? get_option('ampliov_price_type') : 'CSR';

				

				$add_product = $wpdb->insert( $invoiceTable,
					array(
						'Package'            		=> 	'One Time',
						'ProductPrice'          	=> 	$price,
						'PriceCAD'					=>	$PriceCAD,
						'ExchangeRate'				=>	$exchangeRate,
						'GSTCAD'					=>	$GSTCAD,
						'QSTCAD'					=>	$QSTCAD,
						'TotalCAD'					=>	$TotalCAD,
						'Description'				=>	$getPackage->heading,
						'Address1' 					=> 	$Address1,
						'Address2'       			=> 	$Address2,
						'City'           			=> 	$City,
						'State'          			=> 	$State,
						'Country'        			=>  $Country,
						'Zipcode'            		=> 	$Zipcode,
						'IntroducedBy'  			=>  $IntroducedBy,
						'username'          		=> 	$username,
						'FirstName'          		=> 	$fname,
						'LastName'          		=> 	$lname,
						'Email'      				=> 	$current_user->user_email,
						'Date'   					=>	$entryDate,
						'PaidDate' 					=>	$paidDate,
						'UniqueKey'    				=>	$curr_timestamp,
						'Status'    				=>  'Un-Paid',
						'InvoiceNumber'				=> 	null,
						'ProformaInvoiceNumber'		=> 	$proformaNo,
						'Kgs' 						=> 	$csrKgs,
						'csr' 						=> 	$csrAmount,
						'POGrossAmount' 			=> 	$price,
						'GrossAmount' 				=> 	$price,
						'BankId' 					=> 	$bank_id,
						'ArchiveStatus' 			=> 	'No',
						'inclusiveUnit' 			=> 	$inclusiveUnit,
						'Language'    				=>  'English',
						'token'						=>  $ampliov_price_type
					)
				);
				if( $add_product ){
					$insertedInvoiceId = $wpdb->insert_id;

					$body = [
						'email'	=>	$current_user->user_email,
						'packageid'	=>	$getPackage->packageid
					];
					$response = amplivo_api_send_requests( $body, 'purchase');
					if( $response['success'] == true ){
						$invoiceRecordMaxQry = "SELECT * FROM $invoiceTable WHERE `Status` = 'Paid' ORDER BY `InvoiceNumber` DESC";
						$invoiceRecordMaxRecord = $wpdb->get_row($invoiceRecordMaxQry);
						if( $invoiceRecordMaxRecord ){
							$InvoiceNumber = $invoiceRecordMaxRecord->InvoiceNumber + 1;
						}else{
							$InvoiceNumber = null;	
						}
						if( $is_rotate ){
							if( $LatestId ){
								$update_account = $wpdb->update( $account, array( 'LatestId'   => 	'0', ), array( 'id' => $LatestId ) );
							}
							if( $bank_id ){
								$update_account = $wpdb->update( $account, array( 'LatestId'   => 	'1', ), array( 'id' => $bank_id ) );
							}
						}
						if($Totaltax > 0){
							$ocabody = array(
								'Name'   => 	$username,
								'email'   => 	$current_user->user_email,
								'amount'   => 	-$Totaltax,
								'description'   => 	'Product taxes',
							);
							$responsetex = amplivo_api_send_requests( $ocabody, 'update-oca-balance');
							if($responsetex['success'] == true){
								$logstex = sprintf( __('New purchase OCA taxes (%s) of %s at %s. Order number: %s', CIP_TXTDOMAIN), -$Totaltax , $current_user->user_email , date_i18n('d/m/Y H:i A'), $InvoiceNumber );
								create_cip_logs_entery( $user_id, 'member', '','member', $logstex, true );
								$updateInvoice = $wpdb->update( $invoiceTable, array( 'giftcode' => $response['result'], 'giftcode_status' => 'Pending', 'Status' => 'Paid','InvoiceNumber' => $InvoiceNumber ), array( 'id' => $insertedInvoiceId ) );
								$logs = sprintf( __('New purchase order created by %s at %s. Order number: %s', CIP_TXTDOMAIN), $current_user->user_email , date_i18n('d/m/Y H:i A'), $InvoiceNumber );
								create_cip_logs_entery( $user_id, 'member', '','member', $logs, true );
		
								setcookie('buyproductsubmit', 'yes', time() + (86400 / 1440 ) * 15, "/");
								$redirect_url = get_permalink( get_page_by_title( 'Order' ) );
								$redirect_link_param = add_query_arg( array( 'key' => $curr_timestamp ), $redirect_url );
								$out = array( "error" => 0,'msg' => 'Package Purchased' ,'url' => $redirect_link_param );
							}else{
								$refundocabody = array(
									'Name'   => 	$username,
									'email'   => 	$current_user->user_email,
									'amount'   => 	$getPackage->euro_amount,
									'description'   => 	'Product OCA Balance Refund',
								);
								$responserefundocabalance = amplivo_api_send_requests( $refundocabody, 'update-oca-balance');
								if($responserefundocabalance['success'] == true){
									$refundlogs = sprintf( __('Successfully refunded purchase to OCA balance (%s) of %s at %s due to failed tax deduction.', CIP_TXTDOMAIN), $getPackage->euro_amount , $current_user->user_email , date_i18n('d/m/Y H:i A') );
								}else{
									$refundlogs = sprintf( __('Failed to refund purchase(ID:%s) to OCA balance (%s) of %s at %s.', CIP_TXTDOMAIN), $insertedInvoiceId, $getPackage->euro_amount , $current_user->user_email , date_i18n('d/m/Y H:i A') );
								}
								create_cip_logs_entery( $user_id, 'member', '','member', $refundlogs, true );
								$logstex = sprintf( __('Failed to purchase OCA taxes (%s) of %s at %s.', CIP_TXTDOMAIN), -$Totaltax , $current_user->user_email , date_i18n('d/m/Y H:i A') );
								create_cip_logs_entery( $user_id, 'member', '','member', $logstex, true );
								$out = array( "error" => 1,'msg' => "Failed to complete purchase due to failed tax deduction." );
							}
						}else{
							$updateInvoice = $wpdb->update( $invoiceTable, array( 'giftcode' => $response['result'], 'giftcode_status' => 'Pending','Status' => 'Paid','InvoiceNumber' => $InvoiceNumber ), array( 'id' => $insertedInvoiceId ) );
							$logs = sprintf( __('New purchase order created by %s at %s. Order number: %s', CIP_TXTDOMAIN), $current_user->user_email , date_i18n('d/m/Y H:i A'), $InvoiceNumber );
							create_cip_logs_entery( $user_id, 'member', '','member', $logs, true );
	
							setcookie('buyproductsubmit', 'yes', time() + (86400 / 1440 ) * 15, "/");
							$redirect_url = get_permalink( get_page_by_title( 'Order' ) );
							$redirect_link_param = add_query_arg( array( 'key' => $curr_timestamp ), $redirect_url );
							$out = array( "error" => 0,'msg' => 'Package Purchased' ,'url' => $redirect_link_param );
						}
					}else{
						if (isset($response['error']) && $response['error'] == "You can’t purchase this product as gift!") {
							$response['error'] = "This package cannot be purchased as a gift code.";
						}
						$out = array( "error" => 1,'msg' => $response['error'] );
					}
				}

			}else{
				$out = array( "error" => 1,'msg' => $response['error'] );
			}
		}
	}
	echo wp_json_encode( $out );
	exit;
}

add_shortcode('SA-PACKAGES-LISTING-AUTHENTICATION-MANAGE', 'sa_packages_listing_authentication_manage_callback');
function sa_packages_listing_authentication_manage_callback(){
	$html = "";
	if( current_user_can('supportmanager') || current_user_can('supportagent') ){
		wp_enqueue_style( 'cip-css' );
		wp_enqueue_style( 'bs-table' );
		wp_enqueue_style( 'bs-sticky-header' );
		wp_enqueue_script('bs-table');
		wp_enqueue_script('bs-sticky-header');
		wp_enqueue_script('bs-table-filter-control');
		ob_start();
		?>
		<div class="modal fade" id="add_package_button_modal" tabindex="-1" role="dialog">
			<div class="modal-dialog modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Add/Update SA Package</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							<span aria-hidden="true">&times;</span>
						</button>
					</div>
					<div class="modal-body">
						<form id="saPackageForm">
							<input type="hidden" name="id" id="id" value="">
							<div>
								<label for="packageid">Amplivo Package ID*</label>
								<input type="number" name="packageid" id="packageid" class="form-control" placeholder="Enter Amplivo Package ID" required>
							</div>
							<div>
								<label for="euro_amount">Euro Amount*</label>
								<input type="text" name="euro_amount" id="euro_amount" class="form-control" placeholder="Enter Euro Amount" required>
							</div>
							<div>
								<label for="heading">Heading</label>
								<input type="text" name="heading" id="heading" class="form-control" placeholder="Enter Heading" required>
							</div>
							<div>
								<label for="description">Description</label>
								<div class="notes-des">
									Note:
									<ul>
										<li>Use [kg] and [price] to display the product's Kgs and price.</li>
										<li> Use [BR] to move the subsequent text to a new line. </li>
									</ul>
								</div>
								<textarea name="description" id="description" class="form-control" placeholder="Enter Description" required></textarea>
							</div>
							<div>
								<label for="active"><input type="checkbox" name="active" id="active">Do you want to activate this package?</label>
							</div>
						</form>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-primary" id="savePackage">Save Package</button>
						<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
					</div>
				</div>
			</div>
		</div>
		<button id="add_package_button" class="btn btn-primary">Add Package</button>
		<table id="sa_packages_listing_list" data-filter-control="true" data-show-search-clear-button="true" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
		<thead>
			<tr>
				<th data-field="id" class="id"><?php _e('ID', 'aac-helper-domain'); ?></th>
				<th data-field="packageid" class="packageid" data-filter-control="input"><?php _e('Amplivo Package ID', 'aac-helper-domain'); ?></th>

				<th data-field="heading" class="heading" data-filter-control="input"><?php _e('Heading', 'aac-helper-domain'); ?></th>
				<th data-field="description" class="description" data-filter-control="input"><?php _e('Description', 'aac-helper-domain'); ?></th>
				<th data-field="euro_amount" class="euro_amount" data-filter-control="input"><?php _e('Euro Amount', 'aac-helper-domain'); ?></th>
				<th data-field="active_inactive" class="active_inactive" data-filter-control="select" data-filter-data="var:selectChoices"><?php _e('Active/Inactive', 'aac-helper-domain'); ?></th>
				<th data-field="action" class="action"><?php _e('Action', 'aac-helper-domain'); ?></th>
			</tr>
		</thead>
		<tbody>
		</tbody>
		</table>
		<script>
			var selectChoices = {
				" ": "All",
				"1": "active",
				"0": "In-active"
			};
		</script>
		<?php
		$html .= ob_get_clean();
	}
	return $html;
}
add_shortcode('SA-PROVINCE-MANAGEMENT', 'sa_province_management_authentication_manage_callback');
function sa_province_management_authentication_manage_callback(){
	$html = "";
	if( current_user_can('supportmanager') || current_user_can('supportagent') ){
		wp_enqueue_style( 'cip-css' );
		wp_enqueue_style( 'bs-table' );
		wp_enqueue_style( 'bs-sticky-header' );
		wp_enqueue_script('bs-table');
		wp_enqueue_script('bs-sticky-header');
		wp_enqueue_script('bs-table-filter-control');
		ob_start();
		?>
		<div class="modal fade" id="add_province_button_modal" tabindex="-1" role="dialog">
			<div class="modal-dialog modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Add/Update SA province</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							<span aria-hidden="true">&times;</span>
						</button>
					</div>
					<div class="modal-body">
						<form id="saprovinceForm">
							<input type="hidden" name="id" id="id" value="">
							<div>
								<label for="province_name">Province Name*</label>
								<input type="text" name="province_name" id="province_name" class="form-control" placeholder="Enter Province Name" required>
							</div>
							<div>
								<label for="GST">GST/HST(CAD)</label>
								<input type="text" name="GST" id="GST" class="form-control" placeholder="Enter GST Amount" required>
							</div>
							<div>
								<label for="QST">QST(CAD)</label>
								<input type="text" name="QST" id="QST" class="form-control" placeholder="Enter QST Amount" required>
							</div>
						</form>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-primary" id="saveprovince">Save province</button>
						<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
					</div>
				</div>
			</div>
		</div>


		<div class="modal fade" id="pst_info_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">
		      <div class="modal-header">
		        <h5 class="modal-title" id="exampleModalLabel">Provincial sales tax (PST)</h5>
		        <span class="close" style="cursor: pointer;" data-dismiss="modal">×</span>
		      </div>
		      <div class="modal-body">
				<p>In Quebec, it is called the Quebec sales tax (QST).</p>
				<p>In Manitoba, it is called the Retail sales tax (RST).</p>
		      </div>
		      <div class="modal-footer">
		        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
		      </div>
		    </div>
		  </div>
		</div>

		<table id="sa_province_management_listing" data-filter-control="true" data-show-search-clear-button="true" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
		<thead>
			<tr>
				<th data-field="id" class="id"><?php _e('ID', 'aac-helper-domain'); ?></th>
				<th data-field="province_name" class="province_name" data-filter-control="input"><?php _e('Province Name', 'aac-helper-domain'); ?></th>

				<th data-field="GST" class="GST" data-filter-control="input"><?php _e('GST/HST (CAD)', 'aac-helper-domain'); ?></th>
				<th data-field="QST" class="QST" data-filter-control="input"><?php _e('PST (CAD)', 'aac-helper-domain'); ?> <i class="fa fa-info-circle" aria-hidden="true" data-toggle="modal" data-target="#pst_info_modal" style="cursor: pointer;"></i></th>
				<th data-field="action" class="action"><?php _e('Action', 'aac-helper-domain'); ?></th>
			</tr>
		</thead>
		<tbody>
		</tbody>
		</table>
		<?php
		$html .= ob_get_clean();
	}
	return $html;
}
add_action('wp_footer', 'acc_bsdatatable_script');
function acc_bsdatatable_script(){
	$sa_packages_listing_list_url = add_query_arg( [
		'action'	=>	'sa_packages_listing_list_loader',
		'pageid'	=>	get_the_ID(),
	], admin_url( 'admin-ajax.php' ) );
	$sa_province_management_listing_url = add_query_arg( [
		'action'	=>	'sa_province_management_listing_loader',
		'pageid'	=>	get_the_ID(),
	], admin_url( 'admin-ajax.php' ) );
	?>
	<script>
	jQuery(document).ready(function($){
		if( $('#sa_packages_listing_list').length > 0 ){
			var sa_packages_listing_list_url = "<?php echo $sa_packages_listing_list_url ?>";
			var wpadminbar = isNaN( parseInt( $('#wpadminbar').height() ) ) ? 0 : parseInt( $('#wpadminbar').height() ) ;
			stickyHeaderOffset = wpadminbar;
			var $tablePendinReview = $('#sa_packages_listing_list');
			$tablePendinReview.bootstrapTable({
				method: 'post',
				contentType: 'application/x-www-form-urlencoded',
				url: sa_packages_listing_list_url,
				queryParams: function (p) {
					return {
						columnfilter: p.filter,
						limit: p.limit,
						offset: p.offset,
						sort: p.sort,
						order: p.order,
					};
				},
				stickyHeader: false,
				stickyHeaderOffsetY: stickyHeaderOffset,
				onPostBody: function (){
					if( $('[data-toggle-tt="tooltip"]').length > 0 ){
						$('[data-toggle-tt="tooltip"]').tooltip();
					}
					$('.filter-control input.search-input').prop('readonly',false);
				},
				onSearch: function( search ){
					$('.filter-control input.search-input').prop('readonly',true);
				}
			});
		}
		if( $('#sa_province_management_listing').length > 0 ){
			var sa_province_management_listing_url = "<?php echo $sa_province_management_listing_url ?>";
			var wpadminbar = isNaN( parseInt( $('#wpadminbar').height() ) ) ? 0 : parseInt( $('#wpadminbar').height() ) ;
			stickyHeaderOffset = wpadminbar;
			var $tablePendinReview = $('#sa_province_management_listing');
			$tablePendinReview.bootstrapTable({
				method: 'post',
				contentType: 'application/x-www-form-urlencoded',
				url: sa_province_management_listing_url,
				queryParams: function (p) {
					return {
						columnfilter: p.filter,
						limit: p.limit,
						offset: p.offset,
						sort: p.sort,
						order: p.order,
					};
				},
				stickyHeader: false,
				stickyHeaderOffsetY: stickyHeaderOffset,
				onPostBody: function (){
					if( $('[data-toggle-tt="tooltip"]').length > 0 ){
						$('[data-toggle-tt="tooltip"]').tooltip();
					}
					$('.filter-control input.search-input').prop('readonly',false);
				},
				onSearch: function( search ){
					$('.filter-control input.search-input').prop('readonly',true);
				}
			});
		}
	});
  	</script>
  <?php
}
add_action('wp_ajax_sa_packages_listing_list_loader','sa_packages_listing_list_loader_cb');
function sa_packages_listing_list_loader_cb(){
	global $wpdb;

	$limit = isset( $_POST['limit'] ) ? $_POST['limit'] : 10;
	$offset = isset( $_POST['offset'] ) ? $_POST['offset'] : 0;
	$orderby = isset( $_POST['sort'] ) ? $_POST['sort'] : 'id';
	$order = (isset($_POST['order']) && in_array($_POST['order'], array('asc', 'desc'))) ? $_POST['order'] : 'desc';

	$logTable = $wpdb->prefix.'sa_packages';
	$limit = isset( $_POST['limit'] ) ? $_POST['limit'] : 10;
	$offset = isset( $_POST['offset'] ) ? $_POST['offset'] : 0;
	$orderby = isset( $_POST['sort'] ) ? $_POST['sort'] : 'id';
	$order = (isset($_POST['order']) && in_array($_POST['order'], array('asc', 'desc'))) ? $_POST['order'] : 'desc';

	$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $logTable WHERE 1=1");

	$filter_qry = "";
	$filters = json_decode( stripslashes( $_REQUEST['columnfilter'] ), true );
	if( !empty( $filters ) ){
		foreach( $filters as $filterKey => $filterData ){
			if( $filterKey == 'user_type'  ){
				$filter_qry .= " AND `$filterKey` = '" . $filterData . "'";
			}elseif($filterKey == 'active_inactive'){
				$filter_qry .= " AND `active` = '" . $filterData . "'";
			}else{
				$filter_qry .= " AND `$filterKey` like '%" . $filterData . "%'";
			}
		}
		$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $logTable WHERE 1=1 $filter_qry");
	}
	$filterByConditionPoolRef = json_decode( stripslashes( $_REQUEST['filterByConditionPoolRef'] ), true );

	if( !empty( $filterByConditionPoolRef ) ){
		foreach( $filterByConditionPoolRef as $filterKey => $filterData ){
			if($filterData != ''){
				$filter_qry .= " AND `logs` like '%" . $filterData . "%'";
			}
		}
	}
	if($filter_qry != ""){
		$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $logTable WHERE 1=1 $filter_qry");
	}
	$getLogs = $wpdb->get_results( "SELECT * FROM $logTable WHERE 1=1 $filter_qry ORDER BY `$orderby` $order LIMIT $limit OFFSET $offset" );

	$rows = array();
	if( $getLogs ){
		$rowCounter = 1;
		foreach( $getLogs as $getLog ){

			$description_array = explode("[BR]",$getLog->description);
			$getLogdescription = '';
			foreach($description_array as $description_item){
				if($description_item != ''){
					$getLogdescription .= sprintf( __('<span><strong class="text-danger">*</strong>  %s</span><br>', CIP_TXTDOMAIN), trim($description_item) );
				}
			}

			$row = array(
				'id' => $getLog->id,
				'packageid' => $getLog->packageid,
				'euro_amount' => $getLog->euro_amount,
				'heading' => $getLog->heading,
				'description' => $getLogdescription,
				'action' => '<a id="editpackagesButton" data-packages-id="' . $getLog->id . '" class="mr-1" ><i class="fa fa-edit"></i></a><a id="delete_sa_package" data-packages-id="' . $getLog->id . '"><i class=" fa fa-trash"></i></a>'
			);
			if( !empty($getLog->active) ){
				if( $getLog->active == 1 ){
					$row['active_inactive'] = '<div class="form-check form-switch custom-switch"><input class="form-check-input packages-change" login_auth="yes" type="checkbox" data-id="'.$getLog->id.'" role="switch" id="packages_id_'.$getLog->id.'" checked><label class="form-check-label" for="packages_id_'.$getLog->id.'">Active</label></div>';
				}else{
					$row['active_inactive'] = '<div class="form-check form-switch custom-switch"><input class="form-check-input packages-change" login_auth="yes" type="checkbox" data-id="'.$getLog->id.'" role="switch" id="packages_id_'.$getLog->id.'"><label class="form-check-label" for="packages_id_'.$getLog->id.'">Inactive</label></div>';
				}
			}else{
				$row['active_inactive'] = '<div class="form-check form-switch custom-switch"><input class="form-check-input packages-change" login_auth="yes" type="checkbox" data-id="'.$getLog->id.'" role="switch" id="packages_id_'.$getLog->id.'"><label class="form-check-label" for="packages_id_'.$getLog->id.'">Inactive</label></div>';
			}
			$rows[] = $row;
			$rowCounter++;
		}
	}
	$out = array(
		'total'		=>	$total_items,
		'rows'		=>	$rows
	);
	echo wp_json_encode( $out );
	exit;
}
add_action('wp_ajax_sa_province_management_listing_loader','sa_province_management_listing_loader');
function sa_province_management_listing_loader(){
	global $wpdb;

	$limit = isset( $_POST['limit'] ) ? $_POST['limit'] : 10;
	$offset = isset( $_POST['offset'] ) ? $_POST['offset'] : 0;
	$orderby = isset( $_POST['sort'] ) ? $_POST['sort'] : 'id';
	$order = (isset($_POST['order']) && in_array($_POST['order'], array('asc', 'desc'))) ? $_POST['order'] : 'asc';

	$logTable = $wpdb->prefix.'province_management';
	$limit = isset( $_POST['limit'] ) ? $_POST['limit'] : 10;
	$offset = isset( $_POST['offset'] ) ? $_POST['offset'] : 0;
	$orderby = isset( $_POST['sort'] ) ? $_POST['sort'] : 'id';
	$order = (isset($_POST['order']) && in_array($_POST['order'], array('asc', 'desc'))) ? $_POST['order'] : 'asc';

	$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $logTable WHERE 1=1");

	$filter_qry = "";
	$filters = json_decode( stripslashes( $_REQUEST['columnfilter'] ), true );
	if( !empty( $filters ) ){
		foreach( $filters as $filterKey => $filterData ){
			if( $filterKey == 'user_type'  ){
				$filter_qry .= " AND `$filterKey` = '" . $filterData . "'";
			}elseif($filterKey == 'active_inactive'){
				$filter_qry .= " AND `active` = '" . $filterData . "'";
			}else{
				$filter_qry .= " AND `$filterKey` like '%" . $filterData . "%'";
			}
		}
		$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $logTable WHERE 1=1 $filter_qry");
	}
	$filterByConditionPoolRef = json_decode( stripslashes( $_REQUEST['filterByConditionPoolRef'] ), true );

	if( !empty( $filterByConditionPoolRef ) ){
		foreach( $filterByConditionPoolRef as $filterKey => $filterData ){
			if($filterData != ''){
				$filter_qry .= " AND `logs` like '%" . $filterData . "%'";
			}
		}
	}
	if($filter_qry != ""){
		$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $logTable WHERE 1=1 $filter_qry");
	}
	$getLogs = $wpdb->get_results( "SELECT * FROM $logTable WHERE 1=1 $filter_qry ORDER BY `$orderby` $order LIMIT $limit OFFSET $offset" );

	$rows = array();
	if( $getLogs ){
		$rowCounter = 1;
		foreach( $getLogs as $getLog ){
			$row = array(
				'id' => $getLog->id,
				'province_name' => $getLog->province_name,
				'GST' => $getLog->GST,
				'QST' => $getLog->QST,
				'action' => '<a id="editprovince_managementButton" data-province-id="' . $getLog->id . '" class="mr-1" ><i class="fa fa-edit"></i></a>'
			);
			if( !empty($getLog->active) ){
				if( $getLog->active == 1 ){
					$row['active_inactive'] = '<div class="form-check form-switch custom-switch"><input class="form-check-input packages-change" login_auth="yes" type="checkbox" data-id="'.$getLog->id.'" role="switch" id="packages_id_'.$getLog->id.'" checked><label class="form-check-label" for="packages_id_'.$getLog->id.'">Active</label></div>';
				}else{
					$row['active_inactive'] = '<div class="form-check form-switch custom-switch"><input class="form-check-input packages-change" login_auth="yes" type="checkbox" data-id="'.$getLog->id.'" role="switch" id="packages_id_'.$getLog->id.'"><label class="form-check-label" for="packages_id_'.$getLog->id.'">Inactive</label></div>';
				}
			}else{
				$row['active_inactive'] = '<div class="form-check form-switch custom-switch"><input class="form-check-input packages-change" login_auth="yes" type="checkbox" data-id="'.$getLog->id.'" role="switch" id="packages_id_'.$getLog->id.'"><label class="form-check-label" for="packages_id_'.$getLog->id.'">Inactive</label></div>';
			}
			$rows[] = $row;
			$rowCounter++;
		}
	}
	$out = array(
		'total'		=>	$total_items,
		'rows'		=>	$rows
	);
	echo wp_json_encode( $out );
	exit;
}
// AJAX handler for adding/updating SA Packages
add_action('wp_ajax_handle_sa_package_form', 'handle_sa_package_form');
add_action('wp_ajax_nopriv_handle_sa_package_form', 'handle_sa_package_form'); // For non-logged-in users
function handle_sa_package_form() {
    global $wpdb;
    // Get form data sent via AJAX
    $form_data = isset($_POST['form_data']) ? wp_unslash($_POST['form_data']) : '';
    parse_str($form_data, $form_values); // Parse serialized form data into an array
	if($form_values['packageid'] == "" || $form_values['description'] == "" || $form_values['euro_amount'] == "" ){
		wp_send_json_error(array('message' => 'Please fill all required fields.'));
		die();
	}
    $package_name = isset($form_values['package_name']) ? sanitize_text_field($form_values['package_name']) : '';
    $euro_amount = isset($form_values['euro_amount']) ? floatval($form_values['euro_amount']) : 0;
	$euro_amount = $euro_amount;
    $heading = isset($form_values['heading']) ? sanitize_textarea_field($form_values['heading']) : '';
    $description = isset($form_values['description']) ? sanitize_textarea_field($form_values['description']) : '';
    $active = (isset($form_values['active']) && $form_values['active'] == 'on' ) ? 1 : 0;
    $package_id = isset($form_values['id']) ? intval($form_values['id']) : 0;
    $packageid = isset($form_values['packageid']) ? intval($form_values['packageid']) : 0;
	$existing_package = $wpdb->get_row(
		$wpdb->prepare(
			"SELECT id FROM {$wpdb->prefix}sa_packages WHERE packageid = %f AND id != $package_id",
			$packageid,
		)
	);

	if ($existing_package) {
		// The $packageid is already used in another row.
		// You may want to handle this situation, such as showing an error message.
		wp_send_json_error(array('message' => 'This package ID is already in use.'));
		die();
	}
	if($active == 1){
		$active_value = "Active";
	}else{
		$active_value = "In-active";
	}
    if ($package_id > 0) {
		$per_result = $wpdb->get_results($wpdb->prepare(
			"SELECT * FROM {$wpdb->prefix}sa_packages WHERE id = ".$package_id.""
		));
        // Update existing package
        $wpdb->update(
            $wpdb->prefix . 'sa_packages',
            array(
                'packageid' => $packageid,
                'euro_amount' => $euro_amount,
	            'heading' => $heading,
                'description' => $description,
                'active' => $active,
            ),
            array('id' => $package_id),
            array('%f','%d', '%s','%s','%f'),
            array('%d')
        );
		$data = array(
			'id' => $package_id,
			'packageid' => $packageid,
			'euro_amount' => $euro_amount,
			'heading' => $heading,
			'description' => $description,
			'active' => $active_value,
		);
		foreach($per_result as $row){
			$rowactive = ($row->active == 'active') ? 'Active' : 'In-active' ;
			$per_updatedata = array(
				'id' => $row->id,
				'packageid' => $row->packageid,
				'euro_amount' => $row->euro_amount,
				'heading' => $row->heading,
				'description' => $row->description,
				'active' => $rowactive,
			);
		}
		$updatedata = array(
			'id' => $package_id,
			'packageid' => $packageid,
			'euro_amount' => $euro_amount,
			'heading' => $heading,
			'description' => $description,
			'active' => $active,
		);
		$data_encoded = json_encode($data);
		$per_update_encoded = json_encode($per_updatedata);
		$log_type = 'packages_csr';
		$user = wp_get_current_user();
		$message = "changed package values ".$data_encoded." Previous values ".$per_update_encoded;
		create_cip_logs_entery( $user->ID, $log_type, $message);
		wp_send_json_success(array('message' => 'Your package has been updated.','update' => $updatedata));
    } else {
        // Insert new package
        $wpdb->insert(
            $wpdb->prefix . 'sa_packages',
            array(
				'packageid' => $packageid,
                'euro_amount' => $euro_amount,
                'heading' => $heading,
				'description' => $description,
				'active' => $active,
            ),
            array('%f', '%d', '%s','%s','%f')
        );

		$data = array(
			'packageid' => $packageid,
			'euro_amount' => $euro_amount,
			'heading' => $heading,
			'description' => $description,
			'active' => $active_value,
		);
		$data_encoded = json_encode($data);
		$log_type = 'packages_csr';
		$user = wp_get_current_user();
		$message = "insert (".$data_encoded.") package";
		create_cip_logs_entery( $user->ID, $log_type, $message);
		wp_send_json_success(array('message' => 'Your package has been add into packages.'));
    }
	// echo $euro_amount;
    wp_die(); // Always use wp_die() at the end of your AJAX callback function
}
add_action('wp_ajax_handle_sa_province_form', 'handle_sa_province_form');
add_action('wp_ajax_nopriv_handle_sa_province_form', 'handle_sa_province_form'); // For non-logged-in users
function handle_sa_province_form() {
    global $wpdb;
    // Get form data sent via AJAX
    $form_data = isset($_POST['form_data']) ? wp_unslash($_POST['form_data']) : '';
    parse_str($form_data, $form_values); // Parse serialized form data into an array
	if($form_values['province_name'] == ""){
		wp_send_json_error(array('message' => 'Please fill all required fields.'));
		die();
	}
    $province_name = isset($form_values['province_name']) ? sanitize_text_field($form_values['province_name']) : '';
    $GST = isset($form_values['GST']) ? sanitize_textarea_field($form_values['GST']) : 0;
    $QST = isset($form_values['QST']) ? sanitize_textarea_field($form_values['QST']) : 0;
    $provinceid = isset($form_values['id']) ? intval($form_values['id']) : 0;
	if($active == 1){
		$active_value = "Active";
	}else{
		$active_value = "In-active";
	}
    if ($provinceid > 0) {
		$per_result = $wpdb->get_results($wpdb->prepare(
			"SELECT * FROM {$wpdb->prefix}province_management WHERE id = ".$provinceid.""
		));
        // Update existing province
        $wpdb->update(
            $wpdb->prefix . 'province_management',
            array(
                'province_name' => $province_name,
                'GST' => $GST,
                'QST' => $QST,
            ),
            array('id' => $provinceid),
            array('%s','%f', '%f','%f'),
            array('%d')
        );
		$data = array(
			'id' => $provinceid,
			'province_name' => $province_name,
			'GST' => $GST,
			'QST' => $QST,
		);
		foreach($per_result as $row){
			$per_updatedata = array(
				'id' => $row->id,
				'province_name' => $row->province_name,
				'GST' => $row->GST,
				'QST' => $row->QST,
			);
		}
		$updatedata = array(
			'id' => $provinceid,
			'province_name' => $province_name,
			'GST' => $GST,
			'QST' => $QST,
		);
		$data_encoded = json_encode($data);
		$per_update_encoded = json_encode($per_updatedata);
		$log_type = 'provinces_csr';
		$user = wp_get_current_user();
		$message = "changed province values ".$data_encoded." Previous values ".$per_update_encoded;
		create_cip_logs_entery( $user->ID, $log_type, $message);
		wp_send_json_success(array('message' => 'Your province has been updated.','update' => $updatedata));
    }
    wp_die(); // Always use wp_die() at the end of your AJAX callback function
}
add_action('wp_ajax_update_checkbox_packages_auth', 'update_checkbox_packages_auth');
add_action('wp_ajax_nopriv_update_checkbox_packages_auth', 'update_checkbox_packages_auth');
function update_checkbox_packages_auth() {
	global $wpdb;
    if (isset($_POST['user_id']) && isset($_POST['checkbox_value'])) {
        $package_id = sanitize_text_field($_POST['user_id']);
		$per_result = $wpdb->get_results($wpdb->prepare(
			"SELECT * FROM {$wpdb->prefix}sa_packages WHERE id = ".$package_id.""
		));
		foreach($per_result as $row){
			$package_info = array(
				'Package id'=> $row->packageid,
				'Euro amount' => $row->euro_amount,
				'Description'=> $row->description
			);
		}
        $checkbox_value = sanitize_text_field($_POST['checkbox_value']);

		$wpdb->update(
            $wpdb->prefix . 'sa_packages',
            array(
                'active' => $checkbox_value,
            ),
            array('id' => $package_id),
            array('%f'),
            array('%d')
        );
		if($checkbox_value == 1){
			$log_type = 'packages_csr';
			$user = wp_get_current_user();
			$message = "Activated ".json_encode($package_info)." package";
			create_cip_logs_entery( $user->ID, $log_type, $message);
			wp_send_json_success(array('message' => 'Your package has been Activated.'));
		}else{
			$log_type = 'packages_csr';
			$user = wp_get_current_user();
			$message = "In-activated ".json_encode($package_info)." package";
			create_cip_logs_entery( $user->ID, $log_type, $message);
			wp_send_json_success(array('message' => 'Your package has been In-Activated.'));
		}
        die(); // Important to terminate the AJAX request properly.
    }
}
add_action('wp_ajax_delete_sa_package', 'delete_sa_package');
add_action('wp_ajax_nopriv_delete_sa_package', 'delete_sa_package'); // For non-logged-in users
function delete_sa_package() {
    global $wpdb;
    $package_id = isset($_POST['package_id']) ? intval($_POST['package_id']) : 0;
	$per_result = $wpdb->get_results($wpdb->prepare(
		"SELECT * FROM {$wpdb->prefix}sa_packages WHERE id = ".$package_id.""
	));
	foreach($per_result as $row){
		$package_info = array(
			'Package id'=> $row->packageid,
			'Euro amount' => $row->euro_amount,
			'Description'=> $row->description
		);
	}
    if ($package_id > 0) {
        $wpdb->delete(
            $wpdb->prefix . 'sa_packages',
            array('ID' => $package_id),
            array('%d')
        );
        // Handle success or error messages as needed
        // echo 'Package deleted successfully!';
		$log_type = 'packages_csr';
		$user = wp_get_current_user();
		$message = "deleted ".json_encode($package_info)." package";
		create_cip_logs_entery( $user->ID, $log_type, $message);
		wp_send_json_success(array('id' => $package_id,'message' => 'Your package has been remove form packages.'));
    } else {
        echo 'Invalid package ID!';
    }
    wp_die(); // Always use wp_die() at the end of your AJAX callback function
}
add_action('wp_ajax_sa_get_packages_loader','sa_get_packages_loader_cb');
function sa_get_packages_loader_cb(){
	global $wpdb;
	$logTable = $wpdb->prefix.'sa_packages';
	$getLogs = $wpdb->get_results( "SELECT * FROM $logTable WHERE id = '".$_REQUEST['package_id']."'" );

	$rows = array();
	if( $getLogs ){
		$rowCounter = 1;
		foreach( $getLogs as $getLog ){
			$row = array(
				'id' => $getLog->id,
				'packageid' => $getLog->packageid,
				'euro_amount' => $getLog->euro_amount,
				'heading' => $getLog->heading,
				'description' => $getLog->description,
				'active' => $getLog->active,
				'action' => '<a id="editpackagesButton" data-packages-id="' . $getLog->id . '" class="mr-1" ><i class="fa fa-edit"></i></a><a id="delete_sa_package" data-packages-id="' . $getLog->id . '"><i class=" fa fa-trash"></i></a>'
			);
			if( !empty($getLog->active) ){
				if( $getLog->active == 1 ){
					$row['active_inactive'] = '<div class="form-check form-switch custom-switch"><input class="form-check-input packages-change" login_auth="yes" type="checkbox" data-id="'.$getLog->id.'" role="switch" id="packages_id_'.$getLog->id.'" checked><label class="form-check-label" for="packages_id_'.$getLog->id.'">Active</label></div>';
				}else{
					$row['active_inactive'] = '<div class="form-check form-switch custom-switch"><input class="form-check-input packages-change" login_auth="yes" type="checkbox" data-id="'.$getLog->id.'" role="switch" id="packages_id_'.$getLog->id.'"><label class="form-check-label" for="packages_id_'.$getLog->id.'">Inactive</label></div>';
				}
			}else{
				$row['active_inactive'] = '<div class="form-check form-switch custom-switch"><input class="form-check-input packages-change" login_auth="yes" type="checkbox" data-id="'.$getLog->id.'" role="switch" id="packages_id_'.$getLog->id.'"><label class="form-check-label" for="packages_id_'.$getLog->id.'">Inactive</label></div>';
			}
			$rows[] = $row;
			$rowCounter++;
		}
	}
	$out = array(
		'total'		=>	$total_items,
		'row'		=>	$row
	);
	echo wp_send_json_success( $row );
	exit;
}
add_action('wp_ajax_sa_get_province_loader','sa_get_province_loader_cb');
function sa_get_province_loader_cb(){
	global $wpdb;
	$logTable = $wpdb->prefix.'province_management';
	$getLogs = $wpdb->get_results( "SELECT * FROM $logTable WHERE id = '".$_REQUEST['province_id']."'" );

	$rows = array();
	if( $getLogs ){
		$rowCounter = 1;
		foreach( $getLogs as $getLog ){
			$row = array(
				'id' => $getLog->id,
				'province_name' => $getLog->province_name,
				'GST' => $getLog->GST,
				'QST' => $getLog->QST,
				'action' => '<a id="editpackagesButton" data-packages-id="' . $getLog->id . '" class="mr-1" ><i class="fa fa-edit"></i></a><a id="delete_sa_package" data-packages-id="' . $getLog->id . '"><i class=" fa fa-trash"></i></a>'
			);
			$rows[] = $row;
			$rowCounter++;
		}
	}
	$out = array(
		'total'		=>	$total_items,
		'row'		=>	$row
	);
	echo wp_send_json_success( $row );
	exit;
}
function amplivo_api_send_requests( $body = [], $endpoint = "" ){
	$amplivo_api_mode = ( !empty( get_option('amplivo_api_mode') ) ) ? get_option('amplivo_api_mode') : 'test';
	$amplivo_api_test_source_url = ( !empty( get_option('amplivo_api_test_source_url') ) ) ? get_option('amplivo_api_test_source_url') : 'https://cloudhorizon.sandbox.jox.hu/api/';
	$amplivo_api_live_source_url = ( !empty( get_option('amplivo_api_live_source_url') ) ) ? get_option('amplivo_api_live_source_url') : 'https://amplivo.com/api/';
	$amplivo_api_auth_username = ( !empty( get_option('amplivo_api_auth_username') ) ) ? get_option('amplivo_api_auth_username') : 'amplivoapiuser';
	$amplivo_api_auth_pwd = ( !empty( get_option('amplivo_api_auth_pwd') ) ) ? get_option('amplivo_api_auth_pwd') : 'fdlkg948ty89gh498rghuv';
	$sourceApiUrl = ( $amplivo_api_mode == 'live' ) ? $amplivo_api_live_source_url : $amplivo_api_test_source_url;
	$body = wp_json_encode( $body );
	$authorization = 'Basic ' . base64_encode( $amplivo_api_auth_username . ':' . $amplivo_api_auth_pwd );
	$response = wp_remote_post( $sourceApiUrl . $endpoint, array(
		'method' 	=> 'POST',
		'headers'	=> array(
			'accept'		=>	'application/json',
			'Authorization'		=>	$authorization,
			'content-type'	=>	'application/json',
		),
		'body' 		=> $body,
	) );
	if ( ! is_wp_error( $response ) ) {
		$bodyResponse = json_decode( wp_remote_retrieve_body( $response ), true );
	}else{
		$error_message = $response->get_error_message();
		$bodyResponse = json_decode( '{"success":false,"error":"'.$error_message.'"}', true );
	}
	return $bodyResponse;
}
function cipColumnHeaderTooltip( $toolTip = "" ){
	$html = "";
	if( !empty( $toolTip ) ){
		$html = '<span class="fa fa-info-circle" data-toggle-column="tooltip" data-placement="top" title="'.$toolTip.'"></span>';
	}
	return $html;
}
add_action('wp_ajax_cip_sm_email_sending_switch_settings_act','cip_sm_email_sending_switch_settings_act_cb');
function cip_sm_email_sending_switch_settings_act_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_micro'],'_CIPxsm_csr_email_sending_switch_settingxCIP_' ) && current_user_can( 'supportmanager' ) ){

		$current_ip = cip_get_client_ip();
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		$valueData = array();

		$email_notification_toggle_login = ( get_option('email_notification_toggle_login') == 1 ) ? 'Enable' : 'Disable' ;
		$email_notification_toggle_2fa_enabled_disabled = ( get_option('email_notification_toggle_2fa_enabled_disabled') == 1 ) ? 'Enable' : 'Disable' ;
		$email_notification_toggle_otp_enabled_disabled = ( get_option('email_notification_toggle_otp_enabled_disabled') == 1 ) ? 'Enable' : 'Disable' ;
		$new_email_notification_toggle_login = ( $_POST['email_notification_switch_toggle_login'] == 1 ) ? 'Enable' : 'Disable' ;
		$new_email_notification_toggle_2fa_enabled_disabled = ( $_POST['email_notification_switch_toggle_2fa_enabled_disabled'] == 1 ) ? 'Enable' : 'Disable' ;
		$new_email_notification_toggle_otp_enabled_disabled = ( $_POST['email_notification_switch_toggle_otp_enabled_disabled'] == 1 ) ? 'Enable' : 'Disable' ;
		if( isset( $_POST['email_notification_switch_toggle_login'] ) && $_POST['email_notification_switch_toggle_login'] == 1 ){
			update_option( 'email_notification_toggle_login', 1 );
		}else{
			update_option( 'email_notification_toggle_login', 0 );
		}
		if( isset( $_POST['email_notification_switch_toggle_2fa_enabled_disabled'] ) && $_POST['email_notification_switch_toggle_2fa_enabled_disabled'] == 1 ){
			update_option( 'email_notification_toggle_2fa_enabled_disabled', 1 );
		}else{
			update_option( 'email_notification_toggle_2fa_enabled_disabled', 0 );
		}
		if( isset( $_POST['email_notification_switch_toggle_otp_enabled_disabled'] ) && $_POST['email_notification_switch_toggle_otp_enabled_disabled'] == 1 ){
			update_option( 'email_notification_toggle_otp_enabled_disabled', 1 );
		}else{
			update_option( 'email_notification_toggle_otp_enabled_disabled', 0 );
		}
		$valueData[] = sprintf( __('Email send switch update by %s at %s', CIP_TXTDOMAIN), $current_user->user_email, date_i18n('d/m/Y H:i A') );
		$valueData[] = sprintf( __('IP : %s', CIP_TXTDOMAIN), $current_ip );
		$valueData[] = sprintf( __('Login : %s to %s', CIP_TXTDOMAIN), $email_notification_toggle_login, $new_email_notification_toggle_login );
		$valueData[] = sprintf( __('2FA enabled / disabled : %s to %s', CIP_TXTDOMAIN), $email_notification_toggle_2fa_enabled_disabled, $new_email_notification_toggle_2fa_enabled_disabled );
		$valueData[] = sprintf( __('OTP enabled / disabled : %s to %s', CIP_TXTDOMAIN), $email_notification_toggle_otp_enabled_disabled, $new_email_notification_toggle_otp_enabled_disabled );
		$message = implode( PHP_EOL, $valueData);
		$logs = $message;
		create_cip_logs_entery( $user_id, 'setting_option', '','sm', $logs, true );

		$out = array( "error" => 0,'msg' => __('Updated',CIP_TXTDOMAIN) );
	}
	echo wp_json_encode( $out );
	exit;
}


add_action( 'after_setup_theme', 'amplivo_canada_support_gform_validation' );
function amplivo_canada_support_gform_validation() {
	$GW_Minimum_Characters_Class = new GW_Minimum_Characters( array(
		'form_id'                => 2,
		'field_id'               => 15,
		'min_chars'              => 10,
		'max_chars'              => 50,
		'min_validation_message' => __( 'Oops! You need to enter at least %s characters.' ),
		'max_validation_message' => __( 'Oops! You can only enter %s characters.' ),
	) );
}
function get_email_send_toggle( $option ){
	$status = 0;
	$prefix = 'email_notification_toggle_';
	$optionName = $prefix.$option;
	$optionValue = ( !empty( get_option( $optionName ) ) ) ? get_option( $optionName ) : 0 ;
	if( !empty( $optionValue ) ){
		$status = $optionValue;
	}
	return $status;
}


function amplivo_get_exchange_rates( $currency = '', $returnVal = '' ){
	if( !empty( $currency ) ){
		$coinbase_request_url = add_query_arg( 'currency', $currency, 'https://api.coinbase.com/v2/exchange-rates' );
		$coinbase_response = wp_remote_get( $coinbase_request_url );
		$exchangeRate = 0;
		if( !is_wp_error( $coinbase_response ) ) {
			$coinbase_response_body = wp_remote_retrieve_body( $coinbase_response );
			$data = json_decode( $coinbase_response_body );
			if( is_object( $data ) ){
				$rates = $data->data->rates;
				if( isset( $rates->$returnVal ) ){
					$exchangeRate = round( $rates->$returnVal, 4 );
				}
			}
		}
	}
	return $exchangeRate;
}
add_action('init', 'bypass_attempting_to_logout_confirmation');
function bypass_attempting_to_logout_confirmation(){
    if (isset($_GET['action']) && $_GET['action'] === 'logout') {
        wp_logout();
        wp_safe_redirect(home_url());
        exit;
    }
}
function get_amplivo_api_source_url(){
	$amplivo_api_mode = ( !empty( get_option('amplivo_api_mode') ) ) ? get_option('amplivo_api_mode') : 'test';
	$amplivo_api_test_source_url = ( !empty( get_option('amplivo_api_test_source_url') ) ) ? get_option('amplivo_api_test_source_url') : 'https://cloudhorizon.sandbox.jox.hu/api/';
	$amplivo_api_live_source_url = ( !empty( get_option('amplivo_api_live_source_url') ) ) ? get_option('amplivo_api_live_source_url') : 'https://amplivo.com/api/';
	$sourceUrl = ( $amplivo_api_mode == 'live' ) ? $amplivo_api_live_source_url : $amplivo_api_test_source_url;
	return $sourceUrl;
}
add_action( 'wp_ajax_get_estimate_amount', 'get_estimate_amount_callback' );
function get_estimate_amount_callback(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	$exchangeRate = 0;
	$estimateAmoun = 0;
	if( !empty( $_POST['from'] ) && !empty( $_POST['to'] ) && !empty( $_POST['amount'] ) ){
		$exchangeRate = amplivo_get_exchange_rates( $_POST['from'], $_POST['to'] );
		$estimateAmount = number_format( round( $_POST['amount'] * $exchangeRate, 2 ), 2 );
	}
	$out = array( "error" => 0, 'estimateAmount' => $estimateAmount, 'exchangeRate' => $exchangeRate );
	echo wp_json_encode( $out );
	exit;
}

// redeem amplivo gift code
add_action('wp_ajax_redeem_amplivo_gift_code_funcation','cip_redeem_amplivo_gift_code_funcation_cb');
function cip_redeem_amplivo_gift_code_funcation_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_micro'],'_Xupdatesasmredeem_amplivo_gift_code_funcation_' ) ){
		global $wpdb;

		$wpdb_prefix = $wpdb->prefix;

		$invoice= $wpdb_prefix.'cip_member_invoice';

		$e_mail=$_SESSION['refAccount'];

		$invoice_record = "SELECT * FROM $invoice WHERE giftcode = '".$_POST['redeem_gift_code']."' ORDER BY `id` DESC";
		$invoice_result = $wpdb->get_results($invoice_record);
		if($_POST['redeem_gift_code'] != ''){

			if( $invoice_result ){
				if( !empty( $invoice_result[0]->giftcode_status ) && $invoice_result[0]->giftcode_status != 'USED'){

					if( $_POST['popup'] == 1){
						$giftcode_status = $row->giftcode_status;

						$incCsr = ( !empty( get_option('selling_price_csr_inc') ) ) ? get_option('selling_price_csr_inc') : 8;
						$amplivo_api_mode = get_option('amplivo_api_mode');
						if ($amplivo_api_mode == 'live') {
							$sourceUrl = get_option('amplivo_api_live_source_url') . 'redeem-gift-code';
						} else {
							$sourceUrl = get_option('amplivo_api_test_source_url') . 'redeem-gift-code';
						}

						// Prepare the request arguments for wp_remote_post()
						$username = get_option( 'amplivo_api_auth_username' );
						$auth_password = get_option( 'amplivo_api_auth_pwd' );
						$body = wp_json_encode( array(
							'giftcode' => $_POST['redeem_gift_code'],
							'email' => $e_mail
						) );
						// Create an array with the request arguments, including Basic Auth in the headers
						$request_args = array(
							'headers' => array(
								'Authorization' => 'Basic ' . base64_encode( $username . ':' . $auth_password ),
								'Content-Type' => 'application/json', // Adjust content type if necessary
							),'body' => $body
						);

						// Make the POST request using wp_remote_post()
						$responseApi = wp_remote_post($sourceUrl, $request_args);

						$response_body = wp_remote_retrieve_body( $responseApi );

						$data = json_decode( $response_body );

						// if(isset($data->result[0]))
						// {
						if($data->success == true){
							$query = $wpdb->prepare(
								"UPDATE $invoice SET giftcode_status = %s WHERE giftcode = %s",
								'USED',
								$_POST['redeem_gift_code']
							);

							// Executing the query
							$result = $wpdb->query($query);

							// Check if the update was successful
							if ($result !== false) {
								$log_type = 'redeem_gift_code';
								$extra_val = 'redeemed their ('.$_POST['redeem_gift_code'].') gift code.';
								$user = wp_get_current_user();
								create_cip_logs_entery( $user->ID, $log_type , $extra_val );
								$out = array( "error" => 0,'msg' => __('Gift code redeemed successfully!',CIP_TXTDOMAIN) );
							}
						}else{
							$out = array( "error" => 1,'msg' => $data->error,'responce' => $data->error,'data' => $body );
						}
					}else{
						$popup_html = '<div class="modal fade" id="redeem_gift_code_modal" tabindex="-1" role="dialog">
							<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
								<div class="modal-content">
									<div class="modal-header">
										<h5 class="modal-title">Notification</h5>
										<button type="button" class="close" data-dismiss="modal" aria-label="Close">
										<span aria-hidden="true">&times;</span>
										</button>
									</div>
									<div class="modal-body">
										<p>Redemption of <b>'.$invoice_result[0]->Description.'</b> in amount of <b>'.$invoice_result[0]->ProductPrice.'</b> Euros is being completed by username <b>'.$invoice_result[0]->username.'</b></p>
										<p>Please check this is what you expect and require. This action cannot be reversed or undone.</p>
										<p>Click <b>Okay</b> to confirm or <b>Close</b> to reject.</p>
									</div>
									<div class="modal-footer d-flex justify-content-between">
										<button type="button" class="btn btn-primary" id="gift_code_now">Okay</button>
										<button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
									</div>
								</div>
							</div>
						</div>';
						$out = array( "error" => 0,'html'=>$popup_html,'msg' => __('This gift code has been redeemed earlier.',CIP_TXTDOMAIN) );
					}

				}else{
					$out = array( "error" => 1,'msg' => __('This gift code has been redeemed earlier.',CIP_TXTDOMAIN) );
				}
			}else{
				$out = array( "error" => 1,'msg' => __('Incorrect Gift Code.',CIP_TXTDOMAIN) );
			}
		}else{
			$out = array( "error" => 1,'msg' => __('Please Enter Gift Code.',CIP_TXTDOMAIN) );
		}
	}
	echo wp_json_encode( $out );
	exit;
}
/**
 * Generate google 2FA activation QR code image
 */
add_action('wp_ajax_google2fa_qrcode','cip_google2fa_qrcode_cb');
function cip_google2fa_qrcode_cb(){
	require_once dirname(__DIR__, 1) ."/cip-helper/phpqrcode/qrlib.php";

	QRcode::png( $_GET['qr'], false, QR_ECLEVEL_H, 4, 0, false );
	exit;
}

function amplivo_canada_dy_link_menu_item($items, $menu, $args) {

	if ( ! is_admin() ) {
		$ampliov_url_change = ( !empty( get_option('ampliov_url_change') ) ) ? get_option('ampliov_url_change') : 'Stage';
		if($ampliov_url_change == 'Live'){
			$menu_item_id_to_remove = 8544; // amplivo
		}else{
			$menu_item_id_to_remove = 8564; // cloud
		}



		foreach ($items as $key => $item) {
			// Check if this is the menu item to remove by ID

			if ($item->ID == $menu_item_id_to_remove) {
				unset($items[$key]);
			}
		}
	}
    // Return the modified items array
    return $items;
}

add_filter('wp_get_nav_menu_items', 'amplivo_canada_dy_link_menu_item', 10, 3);

function save_maintenance_mode() {

	$out = array( "error" => 1,'msg' => __('Something went wrong.', 'ciphelper') );
	if( wp_verify_nonce( $_POST['_micro'],'_CIPxmaintenance_form_settingsxCIP_' ) && current_user_can( 'supportmanager' ) ){
		$live_title = sanitize_text_field($_POST['live_title']);
		$live_message = $_POST['live_message'];
		$whole_title = sanitize_text_field($_POST['whole_title']);
		$whole_message = $_POST['whole_message'];
		$maintenance_live_option_array = array(
			"title" => $live_title,
			"message" => $live_message,
		);
		$maintenance_whole_option_array = array(
			"title" => $whole_title,
			"message" => $whole_message,
		);
		update_option('maintenance_live_option', $maintenance_live_option_array);
		update_option('maintenance_whole_option', $maintenance_whole_option_array);
		$current_user = wp_get_current_user();
		$logs = sprintf( __('Routine maintenance title & message changed by %s at %s', 'ciphelper'), $current_user->user_email, date_i18n('d/m/Y H:i A') );
		create_cip_logs_entery( $current_user->ID, 'sm', '','sm', $logs, true );
		$out = array( "error" => 0,'msg' => __('Saved', 'ciphelper') );
	}
	echo wp_json_encode( $out );
	exit;
}
add_action('wp_ajax_save_maintenance_mode', 'save_maintenance_mode');
add_action('wp_ajax_nopriv_save_maintenance_mode', 'save_maintenance_mode');

add_shortcode('CIP-SMSA-AUTH-TYPE', 'cip_smsa_auth_type_callback');
function cip_smsa_auth_type_callback(){
	wp_enqueue_style( 'cip-css' );
	$html = "";
	$current_user = wp_get_current_user();
	$user_id = $current_user->ID;
	ob_start();
	if( is_user_logged_in() && ( current_user_can('supportmanager') || current_user_can('supportagent') ) ){
		$current_user = wp_get_current_user();
		$google_auth_key = get_user_meta( $user_id, 'google_auth_key', true );
		$google_auth_key_login = get_user_meta( $user_id, 'google_auth_key_login', true );
		$google_auth_key_walletdelivery = get_user_meta( $user_id, 'google_auth_key_walletdelivery', true );
		$total_step = 4;

		$ga2fa_login_enabled = ( !empty( $google_auth_key ) && $google_auth_key_login == 1 ) ? 1 : 0;
		$ga2fa_delivery_enabled = ( !empty( $google_auth_key ) && $google_auth_key_walletdelivery == 1 ) ? 1 : 0;
	?>
	<div class="row">
		<div class="col-md-12 shadow p-3 bg-white rounded">
		<form id="users_login_authentication_option" name="users_login_authentication_option">
			<h5><?php _e('2 Factor Authentication', 'corsair-login'); ?><p><small class="text-muted"><?php _e('Improve your account security by enabling additional security measures.', 'corsair-login'); ?></small></p></h5><br/>
			<div class="2fa_ga_section">
			<h5><?php _e('Google Authenticator 2FA', 'corsair-login'); ?></h5>
			<div class="m-10">
				<div class="card-">

					<?php if( empty( $google_auth_key ) ){ ?>
						<p class="card-text"><?php _e('Google authenticator app is required and available for download in the next step.') ?></p>
					<?php } ?>
					<div class="" style="padding-top: 0 !important;">

						<div class="custom-control custom-checkbox mb-3">
							<input type="checkbox" class="custom-control-input" data-_micro="<?php echo wp_create_nonce('_SMSALOGIN2FAMicro_'); ?>" <?php checked( 1, $ga2fa_login_enabled, true ); ?> disabled />
							<label class="custom-control-label pt-1" for="ga2fa_smsa_login"><?php _e('Login', 'corsair-login'); ?></label>
						</div>

						<div class="custom-control custom-checkbox mb-3">
							<input type="checkbox" class="custom-control-input" data-_micro="<?php echo wp_create_nonce('_WalletDelivery2FAMicro_'); ?>" <?php checked( 1, $ga2fa_delivery_enabled, true ); ?> disabled />
							<label class="custom-control-label pt-1" for="ga2fa_walletdelivery"><?php _e('Admin actions', 'corsair-login'); ?></label>
						</div>
						<input type="hidden" name="_micro" id="toggle2famicro" value="<?php echo wp_create_nonce('_CL_Toogle2FAMicroWallertDelivery_LC_'); ?>" />

						<?php if( empty( $google_auth_key ) || $google_auth_key_login != 1 || $google_auth_key_walletdelivery != 1 ){ ?>
							<button type="button" class="btn btn-primary" id="enable_smsa_ga2fa_modal" data-toggle="modal" data-target="#enableSmSaGa2faModal"><?php _e('Enable', 'corsair-login'); ?></button>
						<?php } ?>
						<?php /*if( !empty( $google_auth_key ) ){ ?>
							<button type="button" class="btn btn-primary" id="disable_smsa_ga2fa_modal" data-toggle="modal" data-target="#disableSmSaGa2faModal"><?php _e('Disable', 'corsair-login'); ?></button>
						<?php }*/ ?>

						<?php if( empty( $google_auth_key ) || $google_auth_key_login != 1 || $google_auth_key_walletdelivery != 1 ){ ?>
						<h6 class="text-danger"><?php _e('Please activate Google Authenticator 2FA', CIP_TXTDOMAIN); ?></h6>
						<?php } ?>

					</div>
				</div>
			</div>
			</div>
			<input type="hidden" name="action" value="smsa_delivery_auth_options_act" />
			<input type="hidden" name="_micro" value="<?php echo wp_create_nonce( '_SMSA_Delivery_AuthenticatioN_OPTION_' ); ?>" />
		</form>
		</div>
	</div>
	<?php if( empty( $google_auth_key ) ){ ?>
	<div class="modal fade" id="enableSmSaGa2faModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
			<div class="modal-content">
				<div class="modal-body">
				<div class="container-fluid">
					<span class="withdrawal_close_btn close" data-dismiss="modal">&times;</span>
					<div class="row justify-content-center">
						<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 text-center p-0 mt-0 mb-2">
							<div class="card-">
								<form name="smsaGa2faEnableFrm" class="smsaGa2faEnableFrm" id="msform">
								<!-- progressbar -->
									<ul id="progressbar" class="mb-3">
										<li class="active" id="fieldmapping"><strong><?php _e('Download App','corsair-login') ?></strong></li>
										<li id="fieldmapping"><strong><?php _e('Scan QR Code','corsair-login') ?></strong></li>
										<li id="fieldmapping"><strong><?php _e('Enable Google Authenticator','corsair-login') ?></strong></li>
										<li id="fieldmapping"><strong><?php _e('Complete','corsair-login') ?></strong></li>
									</ul>
									<div class="progress">
										<div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuemin="0" aria-valuemax="100"></div>
									</div>
									<br> <!-- fieldsets -->
									<fieldset class="step_0">
										<div class="form-card">
											<div class="row">
												<div class="col-12">
													<p class="steps"><?php echo sprintf('Step %s - %s', 1, $total_step); ?></p>
												</div>
											</div>

											<div class="row text-center justify-content-center">
												<div class="col-lg-8 col-10 pt-24">
													<h3 class="text-center"><?php _e('Download and install the Authenticator app', CIP_TXTDOMAIN ); ?></h3>
													<br>
													<div class=" row">
														<div class="col-sm-6 text-center">
															<img src="<?php echo CIP_PLUGIN_FOLDER;?>/assets/app-store-ga-qr-code.png">
															<p class="main_heading text-center"><?php _e('App Store', CIP_TXTDOMAIN ); ?></p>
														</div>
														<div class="col-sm-6 text-center">
															<img src="<?php echo CIP_PLUGIN_FOLDER;?>/assets/google-play-store-ga-qr.png">
															<p class="main_heading text-center"><?php _e('Android APK', CIP_TXTDOMAIN ); ?></p>
														</div>
													</div>
													<div class="row">
														<div class="col-sm-12">
															<p class="text-center mt-3"><b><?php _e('Scan to Download', CIP_TXTDOMAIN ); ?></b> <?php _e('iOS and Android', CIP_TXTDOMAIN ); ?></p>
														</div>
													</div>
													<br>
												</div>
                                    		</div>
										</div>
										<input type="button" name="next" class="next_wdga action-button" value="Next" />
									</fieldset>

									<fieldset class="step_1">
										<div class="form-card">
											<div class="row">
												<div class="col-12">
													<p class="steps mb-0"><?php echo sprintf('Step %s - %s', 2, $total_step); ?></p>
												</div>
											</div>
											<div class="row text-center justify-content-center">
											<?php
												$siteUrl = get_bloginfo('url');
												$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
												$google2fa = new \PragmaRX\Google2FA\Google2FA();
												$secret_key = $google2fa->generateSecretKey();
												$qr = $google2fa->getQRCodeUrl( $siteUrlName, $current_user->user_email, $secret_key );
												// $image_url = 'https://chart.googleapis.com/chart?cht=qr&chs=250x250&chl='.$qr;
												$_SESSION['google_auth_key'] = $secret_key;
												$image_url = add_query_arg( array(
													'qr'	=>	$qr,
													'action' => 'google2fa_qrcode',
												), admin_url('admin-ajax.php') );
											?>
											<input type="hidden" name="google_auth_key" id="google_auth_key" value="<?php echo $secret_key; ?>" />
											<div class="col-12">
												<h3 class="fs-title text-center main_heading mb-0"><?php _e('Scan this QR Code in the Authenticator app', 'corsair-login'); ?></h3>
												<img style="padding: 30px;" src="<?php echo $image_url; ?>" />
											</div>
											</div>
											<div class="row text-center justify-content-center">
												<div class="col-sm-8 pt-24">
													<h3 class="fs-title text-center main_heading"><?php _e('Save this Backup Key in secure location', 'corsair-login'); ?></h3>
												<p class="csr_color text-center"> <strong><?php echo $secret_key; ?></strong></p>
												<p class="text-center"><?php _e('If you are unable to scan the Qr Code, Please enter this code manually into the app', 'corsair-login'); ?></p>
												<div class="text-center">
													<p class="text-center mb-0"><?php _e('This key will allow you to recover your Authenticator, if you lose your phone. Otherwise, resetting Google Authenticator will take at least 7 days.', 'corsair-login'); ?></p>
												</div>
											</div>
											</div>
										</div>
										<input type="button" name="next" class="next_wdga action-button" value="Next" /> <input type="button" name="previous" class="previous_wdga action-button-previous" value="Previous" />
									</fieldset>
									<fieldset class="step_2">
										<div class="form-card">
											<div class="row">
												<div class="col-12">
													<p class="steps"><?php echo sprintf('Step %s - %s', 3, $total_step); ?></p>
												</div>
											</div>

											<div class="row justify-content-center">
											<div class="col-12">
												<h3 class="fs-title text-center main_heading"><?php _e('Enable Authenticator by verifying your account', 'corsair-login'); ?></h3>
												<div class="form-group">
													<label for="backupkey"><?php _e('Enter Backup Key', 'corsair-login'); ?></label>
													<div class="input-group-append align-items-center" id="show_hide_password">
														<input class="form-control" type="password" name="key" id="backupkey" />
														<div class="input-group-addon pl-1 pr-1"><a href="javascript:void(0);"><i class="fa fa-eye-slash" aria-hidden="true"></i></a></div>
													</div>
												</div>
												<div class="form-group">
													<label for="backupkey"><?php _e('Enter the 6-digit code generated by the Authenticator App.', 'corsair-login'); ?></label>
													<input type="number" class="form-control" name="code" placeholder="" id="init-code" maxlength="6">

												</div>
											</div>
											</div>
										</div>
										<input type="button" name="next" class="next_wdga action-button" value="Next" /> <input type="button" name="previous" class="previous_wdga action-button-previous" value="Previous" />
									</fieldset>
									<fieldset class="step_3">
										<div class="form-card">
											<div class="row">
												<div class="col-12">
													<p class="steps"><?php echo sprintf('Step %s - %s', 4, $total_step); ?></p>
												</div>
											</div>
										</div>
										<input type="button" name="next" class="next_wdga action-button" value="Submit" /> <input type="button" name="previous" class="previous_wdga action-button-previous" value="Previous" />
									</fieldset>
									<input type="hidden" name="action" value="googleAuth2FAWalletDeliveryactivationAct" />
									<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_AACGoogleAuthenticatorWalletDeliveryEnablingAAC_'); ?>" />
								</form>
							</div>
						</div>
					</div>
				</div>
				</div>
			</div>
		</div>
	</div>
	<?php }else if( !empty( $google_auth_key ) ){ ?>
	<div class="modal fade" id="disableSmSaGa2faModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-body">
				<div class="container-fluid">
					<div class="row">
						<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 p-0 mt-2 mb-2">
							<div class="card-">
								<form name="SmSaga2faDisableFrm" class="SmSaga2faDisableFrm">
									<div class="row">
										<div class="col-12">
											<p class="text-center main_heading"><b><?php _e('Disable Google 2FA', 'corsair-login'); ?></b></p>
											<div class="form-group">
												<label for="verify-code"><?php _e('Enter the 6-digit code generated by the Authenticator App.', 'corsair-login'); ?></label>
												<input type="number" class="form-control" name="code" placeholder="" id="verify-code" maxlength="6">

											</div>
											<input type="submit" name="submit" class="action-button" value="<?php _e('Confirm', 'corsair-login'); ?>" />
											<input type="button" name="cancel" class="action-button" data-dismiss="modal" value="<?php _e('Cancel', 'corsair-login'); ?>" />
										</div>
									</div>
									<input type="hidden" name="action" value="SmSagoogleAuth2FADeactivateAct" />
									<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPSmSaGoogleAuthenticatorDisablingCIP_'); ?>" />
								</form>
							</div>
						</div>
					</div>
				</div>
				</div>
			</div>
		</div>
	</div>
	<div class="modal fade" id="toggleSaSmGa2faModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-body">
				<div class="container-fluid">
					<div class="row">
						<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 p-0 mt-2 mb-2">
							<div class="card-">
								<form name="SmSaga2faToggleFrm" class="SmSaga2faToggleFrm">
									<div class="row">
										<div class="col-12">
											<p class="text-center main_heading"><b><?php _e('', 'corsair-login'); ?></b></p>
											<div class="form-group">
												<label for="verify-code"><?php _e('Enter the 6-digit code generated by the Authenticator App.', 'corsair-login'); ?></label>
												<input type="number" class="form-control" name="code" placeholder="" id="verify-code" maxlength="6">
											</div>
											<input type="submit" name="submit" class="action-button" value="<?php _e('Confirm', 'corsair-login'); ?>" />
											<input type="button" name="cancel" class="action-button" data-dismiss="modal" value="<?php _e('Cancel', 'corsair-login'); ?>" />
										</div>
									</div>
									<input type="hidden" name="action" value="toggle_for_smsa_ga_twofa" />
									<input type="hidden" name="_micro" id="toggle2famicro" value="<?php echo wp_create_nonce('_CL_Toogle2FAMicroSaSm_LC_'); ?>" />
								</form>
							</div>
						</div>
					</div>
				</div>
				</div>
			</div>
		</div>
	</div>
	<?php
	}
	}
	$html .= ob_get_clean();
	return $html;
}

add_action( 'wp_ajax_googleAuth2FAWalletDeliveryactivationAct', 'corsair_login_googleAuth2FAWalletDeliveryactivationAct_callback' );
function corsair_login_googleAuth2FAWalletDeliveryactivationAct_callback(){

	$out = array( "error" => 1,'msg' => __('Something went wrong. Please try agin or contact admin.','corsair-login') );
	//require_once __DIR__ . '/google2fa/vendor/autoload.php';
	require_once dirname(__DIR__) . '/corsair_login/google2fa/vendor/autoload.php';

	if( wp_verify_nonce( $_POST['_micro'],'_AACGoogleAuthenticatorWalletDeliveryEnablingAAC_' ) && ( current_user_can( 'supportmanager' ) || current_user_can( 'supportagent' ) ) ){
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		$thisType = ( isset( $_POST['thisType'] ) && ( $_POST['thisType'] == 'delivery' || $_POST['thisType'] == 'login' ) ) ? $_POST['thisType'] : '-';
		$logType = '-';
		if( current_user_can( 'supportagent' ) ){
			$logType = 'sa';
		}else if( current_user_can( 'supportmanager' ) ){
			$logType = 'sm';
		}
		// if( isset( $_POST['thisType'] ) && ( $thisType == 'delivery' || $thisType == 'login' ) ){

			if( !empty( $_POST['key'] ) && !empty( $_SESSION['google_auth_key'] ) ){
				if( $_POST['key'] == $_SESSION['google_auth_key'] ){
					$google2fa = new \PragmaRX\Google2FA\Google2FA();

					if( $google2fa->verifyKey($_SESSION['google_auth_key'], $_POST['code'], 0) ){
						update_user_meta( $user_id, 'google_auth_key', $_SESSION['google_auth_key'] );
						$_SESSION['google_auth_key'] = "";
						unset( $_SESSION['google_auth_key'] );

						/* if( $thisType == 'delivery' ){
							update_user_meta( $user_id, 'google_auth_key_walletdelivery', 1 );
						}else if( $thisType == 'login' ){
							update_user_meta( $user_id, 'google_auth_key_login', 1 );
						} */
						update_user_meta( $user_id, 'google_auth_key_login', 1 );
						update_user_meta( $user_id, 'google_auth_key_walletdelivery', 1 );
						$out = array( "error" => 0,'msg' => __('Google authenticator activated.','corsair-login'), 'thisType' => $_POST['thisType'] );

						$logs = sprintf( __('2FA google authenticator activated by %s at %s', 'corsair-login'), $current_user->user_email, date_i18n('d/m/Y H:i A') );
						create_cip_logs_entery( $user_id, 'profile', '',$logType, $logs, true );
					}else{
						$out = array( "error" => 1,'msg' => __('Invalid backup key or 6-digit code.','corsair-login') );
					}
				}else{
					$out = array( "error" => 1,'msg' => __('Please enter valid backup key or 6-digit code to continue.','corsair-login') );
				}
			}else{
				$out = array( "error" => 1,'msg' => __('Please enter valid backup key or 6-digit code to continue.','corsair-login') );
			}
		// }
	}
	wp_send_json($out);
	exit;
}
add_action( 'template_redirect', 'support_agent_to_force_set2fa', 20 );
function support_agent_to_force_set2fa(){
	$current_user = wp_get_current_user();
	$user_roles = $current_user->roles;
	if (in_array('supportagent', $user_roles) && !is_page(8715) && get_current_user_id() != 1) {
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		$google_auth_key = get_user_meta( $user_id, 'google_auth_key', true );
		$google_auth_key_login = get_user_meta( $user_id, 'google_auth_key_login', true );
		$google_auth_key_walletdelivery = get_user_meta( $user_id, 'google_auth_key_walletdelivery', true );
		if( empty( $google_auth_key ) || $google_auth_key_login != 1 || $google_auth_key_walletdelivery != 1 ){
			$saProfilePage = get_permalink( 8715 );
			wp_safe_redirect( $saProfilePage );
			exit();
		}
	}
}
// REDIRECTION TO DIFFERENT PAGES AFTER LOGIN BASED ON USER ROLE
add_action('template_redirect', 'cip_after_login_redirect');
function cip_after_login_redirect() {
	$current_user = wp_get_current_user();
    $user_roles = $current_user->roles;
    $user_role = array_shift($user_roles);
	$sa_url = get_permalink( get_page_by_title( 'Support Agent Profile' ) );
	//$sm_url = get_permalink( get_page_by_title( 'Support Manager Dashboard' ) );
	$member_url = get_permalink( get_page_by_title( 'CSR Holder Dashboard' ) );
	$site = get_site_url();
    if ( is_user_logged_in() ) {
   	  if( is_page('Lobby')) {
   		  if ($user_role == 'supportagent' || $user_role == 'supportmanager') {
   			  wp_redirect($sa_url);
   		  }
   		//  else if($user_role == 'supportmanager'){
   		// 	  wp_redirect($sm_url);
   		//   }
   		//   else if($user_role == 'member'){
   		// 	  wp_redirect($member_url);
   		//   }
   		//   else{
   		// 	   wp_redirect($site);
  		//   }
  	  }
    }
}
/* TASK 172 Start */
add_action('wp_ajax_delete_member_invoice_act', 'delete_member_invoice_act_funcation');
function delete_member_invoice_act_funcation() {
    global $wpdb;
	$out = array( "error" => 1,'msg' => __('Something went wrong. Please try agin or contact admin.','corsair-login') );
	if(current_user_can( 'supportagent' )){
		$invoice_table = $wpdb->prefix.'cip_member_invoice';
		$invoice_id = isset($_POST['invoice_id']) ? intval($_POST['invoice_id']) : 0;
		$invoice_data = "SELECT * FROM $invoice_table WHERE `id` = '$invoice_id' ORDER BY `InvoiceNumber` DESC";
		$invoiceResult = $wpdb->get_row($invoice_data);
		if ($invoice_id != 0 && $invoiceResult) {
			if($invoiceResult->Status == 'Un-Paid'){
				$wpdb->delete(
					$invoice_table,
					array('id' => $invoice_id),
					array('%d')
				);
				// Handle success or error messages as needed
				// echo 'Package deleted successfully!';
				$log_type = 'delete_member_invoice';
				$user = wp_get_current_user();
				$message = sprintf( __('deleted %s invoice %s(ID:%s)',CIP_TXTDOMAIN),$invoiceResult->Email,$invoiceResult->Description,$invoice_id );
				create_cip_logs_entery( $user->ID, $log_type, $message);
				$out = array( "error" => 0,'msg' => __('Invoice remove successfuly.','corsair-login') );
			}else{
				$out = array( "error" => 1,'msg' => __('You can’t delete paid invoices.','corsair-login') );
			}
		}
	}
    wp_send_json($out);
	exit;
}
add_action('admin_post_export_filter_smmemberinvoice_act','cip_export_filter_smmemberinvoice_act_callback');
function cip_export_filter_smmemberinvoice_act_callback(){
	global $wpdb;
	$tableName = $wpdb->prefix . 'cip_member_invoice';
	include('PHPExcel/Classes/PHPExcel.php');
	include('PHPExcel/Classes/PHPExcel/IOFactory.php');
	if(isset($_REQUEST['columnfilter']) && $_REQUEST['columnfilter'] != ''){
		$filter_qry = "";
		$filters = json_decode(stripslashes($_REQUEST['columnfilter']), true);
		if (!empty($filters)) {
			foreach ($filters as $filterKey => $filterData) {
				$filter_qry .= " AND `$filterKey` like '%" . $filterData . "%'";
			}
		}
		$getMIsData = $wpdb->get_results("SELECT * FROM $tableName WHERE `Status` = 'Paid' AND `InvoiceNumber` IS NOT NULL $filter_qry");
	}else{
		$getMIsData = $wpdb->get_results("SELECT * FROM $tableName WHERE `Status` = 'Paid' AND `InvoiceNumber` IS NOT NULL");
	}
	$objPHPExcel = new PHPExcel();
	$objPHPExcel->getProperties()->setCreator("CIP Helper")
		->setLastModifiedBy("CIP Helper")
		->setTitle("CIP Helper")
		->setSubject("CIP Helper")
		->setDescription("CIP Helper")
		->setKeywords("CIP Helper")
		->setCategory("CIP Helper");
	
	$sheetCounter = 0;
	$objPHPExcel->setActiveSheetIndex( $sheetCounter );
	$objPHPExcel->getActiveSheet()->setTitle(__('CIP Member Invoice',CIP_TXTDOMAIN));
	$excelRow = 2;
	$visibleFields = explode(",", $_REQUEST['visibleFields']);
	$columnLetter = 'A';
	
	foreach ($visibleFields as $field) {
		if($field == 'FirstName'){
			$objPHPExcel->getActiveSheet()->setCellValue($columnLetter . '1', 'Name');	
		}else if($field == 'QSTCAD'){
			$objPHPExcel->getActiveSheet()->setCellValue($columnLetter . '1', 'HST (CAD)');
		}else if($field == 'GrossAmount'){
			$objPHPExcel->getActiveSheet()->setCellValue($columnLetter . '1', 'Price (EUR)');
		}else if($field == 'PriceCAD'){
			$objPHPExcel->getActiveSheet()->setCellValue($columnLetter . '1', 'Price (CAD)');
		}else if($field == 'GSTCAD'){
			$objPHPExcel->getActiveSheet()->setCellValue($columnLetter . '1', 'GST (CAD)');
		}else if($field == 'TotalCAD'){
			$objPHPExcel->getActiveSheet()->setCellValue($columnLetter . '1', 'Total (CAD)');
		}else{
			$objPHPExcel->getActiveSheet()->setCellValue($columnLetter . '1', $field);
		}
		$columnLetter++;
	}
	foreach ($getMIsData as $getMIData) {
		$columnLetter = 'A';
		foreach ($visibleFields as $field) {
			if($field == 'GSTCAD'){
				$PriceCAD = $getMIData->PriceCAD;
                $GSTPrice = $PriceCAD * $getMIData->GSTCAD / 100;
                
				$objPHPExcel->getActiveSheet()->setCellValue($columnLetter . $excelRow, number_format( $GSTPrice, 2 ));
			}else if($field == 'QSTCAD'){
				$PriceCAD = $getMIData->PriceCAD;
                $QSTPrice = $PriceCAD * $getMIData->QSTCAD / 100;
				$objPHPExcel->getActiveSheet()->setCellValue($columnLetter . $excelRow, number_format( $QSTPrice, 2 ) );
			}else if($field == 'FirstName'){
				$objPHPExcel->getActiveSheet()->setCellValue($columnLetter . $excelRow, $getMIData->FirstName.' '.$getMIData->LastName);
			}else if( $field == 'TotalCAD' ){
			    $objPHPExcel->getActiveSheet()->setCellValue($columnLetter . $excelRow, number_format( $getMIData->$field, 2 ) );
			}else{
				$objPHPExcel->getActiveSheet()->setCellValue($columnLetter . $excelRow, $getMIData->$field);
			}
			$columnLetter++;
		}
		$excelRow++;
	}
	$log_type = 'export_invoice';
	$user = wp_get_current_user();
	create_cip_logs_entery( $user->ID, $log_type );
	PHPExcel_Settings::setZipClass(PHPExcel_Settings::PCLZIP);
	$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'CSV');
	$file_name = 'CIPMemberTableInvoices-'.date_i18n('d-m-Y H-i-s');
	header('Content-type: application/vnd.ms-excel');
	header('Content-Disposition: attachment; filename="'.$file_name.'.csv"');
	$objWriter->save('php://output');
	exit;
}
/* TASK 172 End */
include 'includes/detect_site_mode/detect_site_mode.php';