<?php
if ( ! class_exists( 'WP_List_Table' ) ) {
	require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}
class tokenHolderCls extends WP_List_Table {

	function __construct(){
        global $status, $page, $wpdb;
        //Set parent defaults
        parent::__construct( array(
            'singular'  => get_admin_page_title(),
            'plural'    => get_admin_page_title(),
            'ajax'      => false  
        ) );

    }
	function column_default($item, $column_name){
        return $item[$column_name];
	}

	function get_columns(){
        $columns = array(
            'reference'                 =>  __('Reference',CIP_TXTDOMAIN),
            'eth_address'               =>  __('ETH Address',CIP_TXTDOMAIN),
            'occurs_times'              =>  __('Occurs times',CIP_TXTDOMAIN),
            'csr_amount_initial'        =>  __('CSR Amount Initial',CIP_TXTDOMAIN),
            'csramount_by_ethaddress'   =>  __('CSR amount. By ETH address',CIP_TXTDOMAIN),
            'csr_amount_issued'         =>  __('CSR Amount Issued',CIP_TXTDOMAIN),
            'amount_due'                =>  __('Amount due',CIP_TXTDOMAIN),
            'username'                  =>  __('Username',CIP_TXTDOMAIN),
            'csramount_byusername'      =>  __('CSR amount. By username',CIP_TXTDOMAIN),
            'occurs_times_user'         =>  __('Occurs times. By username',CIP_TXTDOMAIN),
            'first_name'                =>  __('First Name',CIP_TXTDOMAIN),
            'last_name'                 =>  __('Last Name',CIP_TXTDOMAIN),
            'redemption_date'           =>  __('Redemption Date',CIP_TXTDOMAIN),
            'claim_date'                =>  __('Claim Date',CIP_TXTDOMAIN),
            'email'                     =>  __('Email',CIP_TXTDOMAIN),
            '_user_status'              =>  __('User Status',CIP_TXTDOMAIN),
            'kyc_status'                =>  __('KYC Status',CIP_TXTDOMAIN),
            'pool_ref'                  =>  __('Pool Ref',CIP_TXTDOMAIN),
            'approvedkyc'               =>  __('Approved KYC/Invalid Docs',CIP_TXTDOMAIN),
            'corp_approved'             =>  __('Corp Approved',CIP_TXTDOMAIN),
            'notes_external'            =>  __('Notes (External for member)',CIP_TXTDOMAIN),
            'notes_internal'            =>  __('Notes (Internal Private)',CIP_TXTDOMAIN),
        );
        return $columns;
	}
	
	function prepare_items(){
        global $wpdb;
        $table_name = $wpdb->prefix . 'token_holder';
       
        $per_page = 30; // constant, how much records will be shown per page
        $columns = $this->get_columns();
        $hidden = array();
        $sortable = $this->get_sortable_columns();
        // here we configure table headers, defined in our methods
        $this->_column_headers = array($columns, $hidden, $sortable);
        // [OPTIONAL] process bulk action if any
        $this->process_bulk_action();
        // will be used in pagination settings
		
        // prepare query params, as usual current page, order by and order direction
        $paged = isset($_REQUEST['paged']) ? max(0, intval($_REQUEST['paged'] -1) * $per_page ) : 0;
        $orderby = (isset($_REQUEST['orderby']) && in_array($_REQUEST['orderby'], array_keys($this->get_sortable_columns()))) ? $_REQUEST['orderby'] : 'id';
        $order = (isset($_REQUEST['order']) && in_array($_REQUEST['order'], array('asc', 'desc'))) ? $_REQUEST['order'] : 'asc';
        // [REQUIRED] define $items array
        // notice that last argument is ARRAY_A, so we will retrieve array
		$total_items = $wpdb->get_var("SELECT COUNT(*) FROM $table_name");
        
		$this->items = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name order by id $order LIMIT %d OFFSET %d", $per_page, $paged), ARRAY_A);
		
        // [REQUIRED] configure pagination
        $this->set_pagination_args(array(
            'total_items' => $total_items, // total items defined above
            'per_page' => $per_page, // per page constant defined at top of method
            'total_pages' => ceil($total_items / $per_page) // calculate pages count
        ));
    }
}
?>
