<?php
/*
  Plugin Name: Gravity Forms Entries Import
  Description: Easy way to import entries to gravity forms.
  Version: 1.3.1
  Author: WpExperts.
  Author URI: https://wpexperts.io/
  Text Domain: gf_entries_import
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}



if ( ! function_exists( 'gf__fs' ) ) {
    // Create a helper function for easy SDK access.
    function gf__fs() {
        global $gf__fs;

        if ( ! isset( $gf__fs ) ) {
            // Include Freemius SDK.
            require_once dirname(__FILE__) . '/freemius/start.php';

            $gf__fs = fs_dynamic_init( array(
                'id'                  => '5345',
                'slug'                => 'gf_entries_import',
                'type'                => 'plugin',
                'public_key'          => 'pk_d5c8209e625c34c1cf93e075938e3',
                'is_premium'          => false,
                'has_addons'          => false,
                'has_paid_plans'      => false,
                'menu'                => array(
                    'slug'           => 'gf_entries_import',
                    'first-path'     => 'admin.php?page=gf-import-settings',
                    'support'        => false,
                ),
            ) );
        }

        return $gf__fs;
    }

    // Init Freemius.
    gf__fs();
    // Signal that SDK was initiated.
    do_action( 'gf__fs_loaded' );
}


define('GFEI_MODIFY_PLUGIN_URL', plugin_dir_url(__FILE__));
define('GFEI_MODIFY_PLUGIN_PATH', plugin_dir_path(__FILE__));

if (!class_exists('Gravity_Forms_Entries_Import')) {

    class Gravity_Forms_Entries_Import {

        public function __construct() {
            add_action('wp_loaded', array($this, 'plugin_dependencies'));
        }
        
        public function plugin_dependencies() {
            $this->includes();
        }

        /**
         * Add Plugin Include Files
         */
        private function includes() {
            include_once(GFEI_MODIFY_PLUGIN_PATH . '/includes/Importer.php');
        }

        public static function gfei_activation() {
            // create logs table
            global $wpdb;

            $table_name = $wpdb->prefix . 'gfei_import_log';

            $charset_collate = $wpdb->get_charset_collate();

            $sql = "CREATE TABLE $table_name (
                    id mediumint(9) NOT NULL AUTO_INCREMENT,
                    file_name tinytext NOT NULL,
                    error_file_name tinytext NULL,
                    log_file_name tinytext NULL,
                    status tinytext NOT NULL,
                    created_at datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
                    updated_at datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
                    PRIMARY KEY  (id)
            ) $charset_collate;";

            require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
            dbDelta($sql);
        }

        public static function gfei_deactivation() {
            
        }

    }

    $gravity_forms_entries_import = new Gravity_Forms_Entries_Import();

    // add logic on plugin activation
    register_activation_hook(__FILE__, array($gravity_forms_entries_import, 'gfei_activation'));

    // remove logic on plugin deactivation
    register_deactivation_hook(__FILE__, array($gravity_forms_entries_import, 'gfei_deactivation'));
}
