<?php
add_action( 'gform_after_submission_2', 'cip_send_support_api_data', 10, 2 );
function cip_send_support_api_data( $entry, $form ) {
	$support_mode = ( !empty( get_option('cip_support_ticket_mode') ) ) ? get_option('cip_support_ticket_mode') : 'disable';
	$endpoint_url = '';
	if( $support_mode == 'live' ){
		$endpoint_url = 'https://amplivo.com/api/support/create';
	}else if( $support_mode == 'test' ){
		$endpoint_url = 'https://cloudhorizon.sandbox.jox.hu/api/support/create';
	}else{		
		$endpoint_url = '';
	}
	if( !empty( $endpoint_url ) ){
		$email = "";
		$registered_user = rgar( $entry, '17' );
		if( $registered_user == 'Yes' ){
			$email = rgar( $entry, '5' );
		}else{
			$email = rgar( $entry, '13' );
		}
		$body = array(
			'email' => $email,
			'subject' => rgar( $entry, '15' ),
			'message' => rgar( $entry, '16' ),
			'language' => 'en-GB',
			'name' => rgar( $entry, '1.3' ).' '.rgar( $entry, '1.6' ),
			'category' => rgar( $entry, '14' ),
			'status' => 1,
		);
		GFCommon::log_debug( 'gform_after_submission: body => ' . json_encode( $body ) );
		$response = wp_remote_post( $endpoint_url, array(
			'method' 	=> 'POST',
			'body' 		=> $body,
		) );
		if( !is_wp_error( $response ) ){
			GFCommon::log_debug( 'gform_after_submission: response => ' . $response['body'] );
		}
	}
}