<?php
require_once  dirname(__DIR__, 1) . '/pdf/db_connection.php';
require_once  dirname(__DIR__, 1) . '/fpdf/fpdf.php';
$conn = mysqli_connect(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
if ( !$conn ) {
	die( 'Not Connected: ' . mysql_error());
}
$invoice = $table_prefix . 'cip_member_invoice';
$account = $table_prefix . 'sm_accounts_management';
$site = get_site_url();

$header_img = $site."/wp-content/uploads/Logo-Amplivo-Full-Blue-version.png";
$paid_img = $site."/wp-content/plugins/cip-helper/images/Asset_Paid.png";
define('EURO',chr(128));
class PDF extends FPDF{
	function SetCellMargin($margin){
		// Set cell margin
		$this->cMargin = $margin;
	}
}
$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Arial','B',15);
$pdf->SetTextColor(0, 0, 0);
$pdf->SetLeftMargin(12);
// $pdf->SetDrawColor(204, 204, 204);

$pdf->Image($header_img,12,18,45);

if((isset($_GET['id'])) || (isset($_GET['key']))){
	$id = $_GET['id'];
	$key = $_GET['key'];
	$email= ( !empty( $_SESSION['refAccount'] ) ) ? $_SESSION['refAccount'] : '-';
	if ($id){
		
		if( isset( $_GET['paid'] ) && $_GET['paid'] == 1 ){
			$type = "Invoice";
		}
		
		if( current_user_can('supportagent') ){
			$sel_invoice = "SELECT * FROM $invoice WHERE id='$id'";
		}else{			
			$sel_invoice = "SELECT * FROM $invoice WHERE id='$id' AND Email='$email'";
		}
	}else{
		$sel_invoice = "SELECT * FROM $invoice WHERE UniqueKey=$key";
		if( isset( $_GET['paid'] ) && $_GET['paid'] == 1 ){
			$type = "Invoice";
		}
	}
	
	$result = mysqli_query($conn, $sel_invoice);
	$count_rows = mysqli_num_rows($result);
	if($count_rows){
		while($row = mysqli_fetch_assoc($result)){
			$status = $row['Status'];

			$inclusiveUnit = ( !empty( $row['inclusiveUnit'] ) ) ? $row['inclusiveUnit'] : 8;
			if(strpos($row['Date'], '2021') !== false){
				$inclusiveUnit = 10;
			}
			$csr_inc = cip_convert_csr_by_price_pdf( $row['ProductPrice'], $inclusiveUnit );
			
			$token = $row['token'];
	
			$Package = $row['Package'];
			$InvoiceTxt = 'Invoice #';
			$DateTxt = 'Date:';
			$ReferenceTxt = 'Reference:';
			$GSTTxt = 'TPS:';
			$QST_PSTTxt = 'TVQ:';
			$PurchaseOrderTxt = 'Purchase Order';
			$VATNumberTxt = 'VAT Number:';
			$SupplierTxt = 'Supplier';
			$SupporterTxt = 'Supporter';
			$CSRServicesEuropeOUTxt = 'Amplivo Canada Inc';
			$DescriptionTxt = 'Description';
			$PlasticNeutralitypackageTxt = 'Plastic Neutrality package';
			$InclusiveTxt = 'Inclusive '.$token.':';
			$InclusiveAmountTxt = $csr_inc .' '.$token;
			$PlasticCreditTxt ='Plastic Neutrality package:';
			$giftCodeTxt ='Gift Code:';
			$giftCodeTxtValue = $row['giftcode'];
			$PlasticCreditAmountTxt = $row['Kgs']. ' kg ' .$Package;
			$PoNotesTxt = "This purchase order is valid for 30 days. If purchase order is not paid for and/or redeemed in specified time, Company can refuse to fulfil the order, in full or partially, if conditions have changed and cannot be met.";
			
			$PriceTxt = 'Price ('.EURO.')';
			$VatTxt = 'VAT:';
			$TotalPayableTxt = 'Total Payable ('.EURO.')';
			$BankDetailsTxt = 'Bank Details';
			$AccountHolderTxt = 'Account Holder:';
			$IBANTxt = 'IBAN:';
			$BICTxt = 'BIC:';
			$BankNameTxt = 'Bank Name:';
			$BankAddressTxt = 'Bank Address:';
			$RegisteredInTxt = 'Amplivo Canada Inc Registered in Canada number 1448427-4';
			
			
			if( $row['Language'] == 'French' ){
				
				switch ($row['Package']) {
					case "Monthly":
						$Package = 'Mese';
						break;
					case "One Time":
						$Package = 'Pagamento unico';
						break;
					case "Yearly":
						$Package = 'anno';
						break;
					default:
					
				}
				
				$InvoiceTxt = 'Fattura #';
				$DateTxt = 'Data:';
				$ReferenceTxt = 'Numero ordine:';
				$PurchaseOrderTxt = 'Ordine d’acquisto';
				$PurchaseOrderTxt = iconv('UTF-8', 'windows-1252', $PurchaseOrderTxt);
				$VATNumberTxt = 'Partita IVA:';
				$SupplierTxt = 'Fornitore';
				$SupporterTxt = 'Sostenitore';
				$CSRServicesEuropeOUTxt = 'Amplivo Canada Inc';
				$DescriptionTxt = 'Causale';
				$PlasticNeutralitypackageTxt = 'Servizio per la sostenibilità';
				$PlasticNeutralitypackageTxt = iconv('UTF-8', 'windows-1252', $PlasticNeutralitypackageTxt);
				$InclusiveTxt = 'CSR Plastic Credits:';
				$InclusiveAmountTxt = $csr_inc .' CSR';
				$PlasticCreditTxt ='Quantità di plastica eliminata:';
				$PlasticCreditTxt = iconv('UTF-8', 'windows-1252', $PlasticCreditTxt);
				$giftCodeTxt ='code cadeau:';
				$giftCodeTxt = iconv('UTF-8', 'windows-1252', $giftCodeTxt);
				$PlasticCreditAmountTxt = $row['Kgs']. ' kg ' .$Package;
				$PoNotesTxt = "Questo ordine di acquisto è valido per 30 giorni. Se l'ordine di acquisto non viene pagato e/o riscattato nei tempi stabiliti, la Società può rifiutarsi di evadere l'ordine, in tutto o in parte, se le condizioni sono cambiate e non possono essere soddisfatte.";
				$PoNotesTxt = iconv('UTF-8', 'windows-1252', $PoNotesTxt);
				
				$PriceTxt = 'Prezzo ('.EURO.')';
				$VatTxt = 'IVA:';
				$TotalPayableTxt = 'Totale da pagare ('.EURO.')';
				$BankDetailsTxt = 'Coordinate bancarie';
				$AccountHolderTxt = 'Titolare del conto:';
				$IBANTxt = 'IBAN:';
				$BICTxt = 'BIC:';
				$BankNameTxt = 'Nome della banca:';
				$BankAddressTxt = 'Indirizzo della banca:';
				$RegisteredInTxt = 'Amplivo Canada Inc Registrata in Canada number 1448427-4';
			}
			$pdf->SetLeftMargin(118);
			if($status == 'Paid' && $type == 'Invoice'){
				
				$pdf->SetFont('Arial','B',13);
				$pdf->Cell(80,1,'', "T,L,R,0","1","L");
				$pdf->Cell(80,7,'  '. $InvoiceTxt . $row['InvoiceNumber'], "L,R,0,0","1","L");
				$pdf->Cell(80,1,'', "T,L,R,0","1","l");
				$pdf->SetTextColor(0, 0, 0);
				$pdf->SetFont( 'Arial', '', 10 );
				$pdf->Cell(35,6,'   '. $DateTxt, "L,0,0,0","0","l");
				$pdf->SetFont( 'Arial', '', 10 );
				$pdf->Cell(45,6, $row['PaidDate'], "0,R,0,0","1","l");
				$pdf->Cell(35,6,'   '. $ReferenceTxt , "L,0,0,0","0","l");
				$pdf->SetFont( 'Arial', '', 10 );
				$pdf->MultiCell(45,6, "CA-PO-" . $row['ProformaInvoiceNumber'], "0,R,0,0","l");
			}
			else{
				$pdf->Cell(80,2,'', "T,L,R,0","1","L");
				$pdf->Cell(80,10,'   '. $PurchaseOrderTxt, "L,R,B,0","1","L");
				
				$pdf->SetTextColor(0, 0, 0);
				$pdf->SetFont( 'Arial', '', 12 );
				$pdf->Cell(80,2,'', "0,L,R,T","1","l");
				$pdf->Cell(35,6,'   '. $DateTxt, "L,0,0,0","0","l");
				$pdf->Cell(45,6, $row['Date'], "0,R,0,0","1","l");
				$pdf->Cell(35,6,'   '. $ReferenceTxt, "L,0,0,0","0","l");
				$pdf->MultiCell(45,6, "CA-PO-" . $row['ProformaInvoiceNumber'], "0,R,0,0","l");
			}

			$pdf->Cell(35,6,'   '. $GSTTxt , "L,0,0,0","0","l");
			$pdf->SetFont( 'Arial', '', 10 );
			$pdf->MultiCell(45,6, "754070746 RT0001", "0,R,0,0","l");
			$pdf->Cell(35,6,'   '. $QST_PSTTxt , "L,0,0,0","0","l");
			$pdf->SetFont( 'Arial', '', 10 );
			$pdf->MultiCell(45,6, "1230107153 TQ0001", "0,R,0,0","l");
			$pdf->Cell(80,1,' ', "L,R,B,0","0","l");
			$pdf->SetLeftMargin(12);
			$pdf->Ln( 5 );
			
			$pdf->SetFont('Arial','B',11);
			
			$pdf->Cell(93,8,'   '.$SupplierTxt, "T,R,B,L","0","l");
			$pdf->Cell(93,8,'   '.$SupporterTxt, "T,R,B,0","1","l");
			$pdf->SetFont('Arial','B',10);
			$pdf->Cell(93,6,'   '.$CSRServicesEuropeOUTxt, "0,R,0,L","0","l");
			$pdf->Cell(93,6,'   ' . $row['FirstName']." " .$row['LastName'] , "0,R,0,0","1","l");
			$pdf->SetTextColor(0, 0, 0);
			$pdf->SetFont('Arial','',10);
			$pdf->MultiCell(93,6,"   Registration number : 1448427-4", "0,R,0,L", "l");
			$x = $pdf->GetX();
			$y = $pdf->GetY();
			$pdf->SetXY($x + 93, $y);
			
			if($row['BusinessName']){
				$pdf->MultiCell(93,-6,'   ' . $row['BusinessName'], "0,R,0,0", "l");
			}
			else{
				$pdf->MultiCell(93,-6,'   ' . $row['Address1'], "0,R,0,L", "l");
			}
			$x = $pdf->GetX();
			$y = $pdf->GetY();
			$pdf->SetXY($x , $y+6);
			
			$pdf->Cell(93,6,'   Provincial code NEQ : 1178160769', "0,R,0,L","0","l");
			if($row['BusinessName']){
				$pdf->Cell(93,6,'   ' . $row['Address1'].", " .$row['Address2'] , "0,R,0,0","1","l");
			}
			else{
				$pdf->Cell(93,6,'   '.$row['Address2'] , "0,R,0,L","1","l");
			}
			$pdf->MultiCell(93,6,'   55, 20e avenue Nord Sherbrooke', "0,R,0,L", "l");
			$x = $pdf->GetX();
			$y = $pdf->GetY();
			$pdf->SetXY($x + 93, $y);
			$pdf->MultiCell(93,-6,'   ' . $row['City'].", " .$row['State'] , "0,R,0,0", "l");
			
			$x = $pdf->GetX();
			$y = $pdf->GetY();
			$pdf->SetXY($x , $y+6);

			$pdf->Cell(93,6,iconv('UTF-8', 'windows-1252', '   Québec'), "0,R,0,L","0","l");
			$pdf->Cell(93,6,'   ' . $row['Zipcode'] . ', ' . $row['Country'], "0,R,0,0","1","l");
			
			if( empty( $row['VatNumber'] ) ){
				$VATNumberTxt = "";
			}
			
			$pdf->MultiCell(93,6,"   J1E 3A9, Canada", "0,R,0,L", "l");
			$x = $pdf->GetX();
			$y = $pdf->GetY();
			$pdf->SetXY($x + 93, $y);
			$pdf->MultiCell(93,-6,"   " . $VATNumberTxt . $row['VatNumber'], "0,R,0,L", "l");
			$pdf->SetTextColor(0, 0, 0);
			$pdf->Ln( 6 );
			$pdf->Cell(186,1,'  ', "T,0,0,0","1","l");

			$pdf->SetFont('Arial','B',10);
			$pdf->SetTextColor(0, 0, 0);
			$pdf->Ln( 4 );
			$pdf->Cell(186,6,'   '.$DescriptionTxt, "T,L,R,0","1","l");
			$pdf->SetFont('Arial','',10);
			$pdf->SetTextColor(0, 0, 0);
			$pdf->Cell(186,6,'   '.$PlasticNeutralitypackageTxt, "0,L,R,0","1","l");
			$pdf->Cell(93,6,'   '.$InclusiveTxt, "0,L,0,0","0","l");
			$pdf->Cell(93,6,'   '.$InclusiveAmountTxt, "0,0,R,0","1","R");
			$pdf->Cell(93,6,'   '.$PlasticCreditTxt, "0,L,0,0","0","l");
			$pdf->Cell(93,6,'   '.$PlasticCreditAmountTxt, "0,0,R,0","1","R");
			
			$pdf->Cell(93,6,'   '.$giftCodeTxt, "0,L,0,0","0","l");
			$pdf->Cell(93,6,'   '.$giftCodeTxtValue, "0,0,R,0","1","R");

			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(93,6,'   '.$PriceTxt, "1","0","l");
			$pdf->SetFont('Arial','',9);
			$pdf->Cell(93,6,"   " . EURO . " " . number_format( $row['ProductPrice'], 2 ), "1","1","R");

			$PriceCAD = $row['PriceCAD'];
			$GSTPrice = $PriceCAD * $row['GSTCAD'] / 100;
			$QSTPrice = $PriceCAD * $row['QSTCAD'] / 100;
			$HSTPrice = $PriceCAD * $row['HSTCAD'] / 100;

			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(93,6,'   '.'Currency exchange rate', "0,L,R,B","0","l");
			$pdf->SetFont('Arial','',9);
			$pdf->Cell(93,6,"   " . number_format( $row['ExchangeRate'], 4 ), "0,L,R,B","1","R");

			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(93,6,'   '.'Price ($ CAD)', "0,L,R,B","0","l");
			$pdf->SetFont('Arial','',9);
			$pdf->Cell(93,6,"   " . '$' . " " . number_format( $PriceCAD, 2 ), "0,L,R,B","1","R");

			if($GSTPrice)
			{
				$pdf->SetFont('Arial','B',9);
				$pdf->Cell(93,6,'   '.'GST/HST '.(float)bcdiv($row['GSTCAD'], "1", 3).'%', "0,L,R,B","0","l");
				$pdf->SetFont('Arial','',9);
				$pdf->Cell(93,6,"   " . '$' . " " . number_format( $GSTPrice, 2 ), "0,L,R,B","1","R");
			}

			if($QSTPrice)
			{
				$taxLable = 'PST';
				if(strtolower($row['State']) == "quebec")
				{
					$taxLable = 'QST';
				}
				elseif (strtolower($row['State'])  == "manitoba") {
					$taxLable = 'RST';
				}
				$pdf->SetFont('Arial','B',9);
				$pdf->Cell(93,6,'   '.$taxLable.' '.(float)bcdiv($row['QSTCAD'], "1", 3).'%', "0,L,R,B","0","l");
				$pdf->SetFont('Arial','',9);
				$pdf->Cell(93,6,"   " . '$' . " " . number_format( $QSTPrice, 2 ), "0,L,R,B","1","R");
			}

			$pdf->SetFont('Arial','B',9);
			$pdf->Cell(93,6,'   '.'Total Payable ($ CAD)', "0,L,R,B","0","l");
			$pdf->SetFont('Arial','',9);
			$pdf->Cell(93,6,"   " . '$' . " " . number_format( $row['TotalCAD'], 2 ), "0,L,R,B","1","R");
			
			$assign_to=$row['BankId'];
			
			$sel_account = "SELECT * FROM $account WHERE id='$assign_to'";
			$result = mysqli_query($conn, $sel_account);
			$count_rows = mysqli_num_rows($result);
			$$count_rows = false;
			if($count_rows){
				while($row = mysqli_fetch_assoc($result)){
					
				}
			}

			$pdf->Ln( 3 );
			$html = '<br>Packages must be redeemed within 6 months of payment.';
			$pdf->WriteHTML($html);
			
			
			if( isset( $type ) && $type == 'Invoice' ){

			}else{ //PO Note
				$pdf->SetTextColor(0, 0, 0);
				$pdf->SetFont( 'Arial', 'I', 10 );
				$pdf->SetLeftMargin(8);
				$pdf->Ln( 2 );
				$pdf->MultiCell(0,4, $PoNotesTxt , 0,"L");
				$pdf->SetLeftMargin(12);
			}

			if($status == 'Paid' && $type == 'Invoice'){
				$pdf->Ln( 15 );
				$pdf->Image($paid_img,108,180,90,30);
				$pdf->SetAutoPageBreak(false);
				$pdf->SetY(219);
				$pdf->SetFont('Arial','I',8);
				$pdf->SetTextColor(140, 140, 140);
			}else{
				$pdf->SetAutoPageBreak(false);
				$pdf->SetY(283);
				$pdf->SetFont('Arial','I',8);
				$pdf->SetTextColor(140, 140, 140);
			}
		}
	}else{
		wp_redirect( site_url() );
		exit();
	}
}
$pdf->Output();
?>