<?php
add_action('wp_head','bst_filter_var_declarations');
function bst_filter_var_declarations(){
	global $wpdb;
	$tableName = $wpdb->prefix.'token_holder';
	$user_id = get_current_user_id();
	$is_admin_can = false;
	if( current_user_can('administrator') ){
		$is_admin_can = true;
	}
	$logTable = $wpdb->prefix.'cip_logs';
	$logTypeArr = array();
	$getLogTypes = $wpdb->get_results("SELECT DISTINCT `user_type` FROM `$logTable` WHERE 1 AND log_type != 'api_track'");
	if( $getLogTypes ){
		foreach( $getLogTypes as $getLogType ){
			$userTypeLabel = '—';
			if( $getLogType->user_type  == 'sm' ){
				$userTypeLabel = __('Support Manager',CIP_TXTDOMAIN);
			}else if( $getLogType->user_type  == 'sa' ){
				$userTypeLabel = __('Support Agent',CIP_TXTDOMAIN);
			}else if( $getLogType->user_type  == 'member' ){
				$userTypeLabel = __('Member',CIP_TXTDOMAIN);
			}else if( $getLogType->user_type  == 'MAs' ){
				$userTypeLabel = __('Member Assitant',CIP_TXTDOMAIN);
			}else if( $getLogType->user_type  == 'buyer' ){
				$userTypeLabel = __('Buyer',CIP_TXTDOMAIN);
			}
			$logTypeArr[ $getLogType->user_type ] = $userTypeLabel;
		}
	}

	$filterVisibilityArr = [ 1 => __("Private", CIP_TXTDOMAIN), 2 => __("Restricted", CIP_TXTDOMAIN), 3 => __("Public", CIP_TXTDOMAIN) ];
	$filterVisibilityjson = json_encode( $filterVisibilityArr );
?><script>var filterVisibilityStatus = <?php echo $filterVisibilityjson; ?>;var filterLogType = <?php echo json_encode( $logTypeArr ); ?>;</script><?php
}
add_action('wp_footer','cip_init_bs_paging_ajax_table_script');
function cip_init_bs_paging_ajax_table_script(){
	
	$cip_receipts_table_list_url = add_query_arg( [
		'action'	=>	'cip_receipts_table_list_loader',
		'pageid'	=>	get_the_ID(),
	], admin_url( 'admin-ajax.php' ) );
	
	$cip_process_receipts_table_list_url = add_query_arg( [
		'action'	=>	'cip_process_receipts_table_list_loader',
		'pageid'	=>	get_the_ID(),
	], admin_url( 'admin-ajax.php' ) );
	$cip_member_invoice_list_url = add_query_arg( [
		'action'	=>	'cip_member_invoice_list_loader',
		'pageid'	=>	get_the_ID(),
	], admin_url( 'admin-ajax.php' ) );
	$cip_sa_member_invoice_list_url = add_query_arg( [
		'action'	=>	'cip_sa_member_invoice_list_loader',
		'pageid'	=>	get_the_ID(),
	], admin_url( 'admin-ajax.php' ) );
	$exportMILink = add_query_arg('action', 'export_filter_smmemberinvoice_act', admin_url('admin-post.php'));

	$downloadInvoiceReport = add_query_arg('action', 'download_invoice_report_with_summery', admin_url('admin-post.php'));

?><script>
  jQuery(document).ready(function($){
	if( $('#cip_receipts_table_list').length > 0 ){		
		var cip_receipts_table_list_url = "<?php echo $cip_receipts_table_list_url ?>";
		var wpadminbar = isNaN( parseInt( $('#wpadminbar').height() ) ) ? 0 : parseInt( $('#wpadminbar').height() ) ;
		stickyHeaderOffset = wpadminbar;
		var $tablePendinReview = $('#cip_receipts_table_list');
		$tablePendinReview.bootstrapTable({
			method: 'post',
			contentType: 'application/x-www-form-urlencoded',
			url: cip_receipts_table_list_url,
			queryParams: function (p) {
				return {
					columnfilter: p.filter,
					limit: p.limit,
					offset: p.offset,
					sort: p.sort,
					order: p.order,
				};
			},
			stickyHeader: false,
			stickyHeaderOffsetY: stickyHeaderOffset,
			onPostBody: function (){
				if( $('[data-toggle-tt="tooltip"]').length > 0 ){
					$('[data-toggle-tt="tooltip"]').tooltip();
				}
				$('.filter-control input.search-input').prop('readonly',false);
		  	},
			onSearch: function( search ){
				$('.filter-control input.search-input').prop('readonly',true);
			}
		});
	}
	if( $('#cip_process_receipts_table_list').length > 0 ){		
		var cip_process_receipts_table_list_url = "<?php echo $cip_process_receipts_table_list_url ?>";
		var wpadminbar = isNaN( parseInt( $('#wpadminbar').height() ) ) ? 0 : parseInt( $('#wpadminbar').height() ) ;
		stickyHeaderOffset = wpadminbar;
		var $tableProcessReceipt = $('#cip_process_receipts_table_list');
		$tableProcessReceipt.bootstrapTable({
			method: 'post',
			contentType: 'application/x-www-form-urlencoded',
			url: cip_process_receipts_table_list_url,
			queryParams: function (p) {
				return {
					columnfilter: p.filter,
					limit: p.limit,
					offset: p.offset,
					sort: p.sort,
					order: p.order,
				};
			},
			stickyHeader: false,
			stickyHeaderOffsetY: stickyHeaderOffset,
			onPostBody: function (){
				if( $('[data-toggle-tt="tooltip"]').length > 0 ){
					$('[data-toggle-tt="tooltip"]').tooltip();
				}
				$('.filter-control input.search-input').prop('readonly',false);
		  	},
			onSearch: function( search ){
				$('.filter-control input.search-input').prop('readonly',true);
			}
		});
	}
	if( $('#member_invoice_list').length > 0 ){		
		var cip_member_invoice_list_url = "<?php echo $cip_member_invoice_list_url ?>";
		var wpadminbar = isNaN( parseInt( $('#wpadminbar').height() ) ) ? 0 : parseInt( $('#wpadminbar').height() ) ;
		stickyHeaderOffset = wpadminbar;
		var $tableProcessReceipt = $('#member_invoice_list');
		$tableProcessReceipt.bootstrapTable({
			method: 'post',
			contentType: 'application/x-www-form-urlencoded',
			url: cip_member_invoice_list_url,
			queryParams: function (p) {
				return {
					columnfilter: p.filter,
					limit: p.limit,
					offset: p.offset,
					sort: p.sort,
					order: p.order,
				};
			},
			stickyHeader: false,
			stickyHeaderOffsetY: stickyHeaderOffset,
			onPostBody: function (){
				if( $('[data-toggle-tt="tooltip"]').length > 0 ){
					$('[data-toggle-tt="tooltip"]').tooltip();
				}
				$('.filter-control input.search-input').prop('readonly',false);
			},
			onSearch: function( search ){
				$('.filter-control input.search-input').prop('readonly',true);
			}
		});
	}
	if( $('#sa_member_invoice_list').length > 0 ){		
		var cip_sa_member_invoice_list_url = "<?php echo $cip_sa_member_invoice_list_url ?>";
		var wpadminbar = isNaN( parseInt( $('#wpadminbar').height() ) ) ? 0 : parseInt( $('#wpadminbar').height() ) ;
		stickyHeaderOffset = wpadminbar;
		var currentColumnFilter = null;
		var $tableProcessReceipt = $('#sa_member_invoice_list');
		$tableProcessReceipt.bootstrapTable({
			method: 'post',
			contentType: 'application/x-www-form-urlencoded',
			url: cip_sa_member_invoice_list_url,
			queryParams: function (p) {
				currentColumnFilter = p.filter;
				return {
					columnfilter: p.filter,
					limit: p.limit,
					offset: p.offset,
					sort: p.sort,
					order: p.order,
				};
			},
			stickyHeader: false,
			stickyHeaderOffsetY: stickyHeaderOffset,
			onPostBody: function (){
				if( $('[data-toggle-tt="tooltip"]').length > 0 ){
					$('[data-toggle-tt="tooltip"]').tooltip();
				}
				$('.filter-control input.search-input').prop('readonly',false);
			},
			onSearch: function( search ){
				$('.filter-control input.search-input').prop('readonly',true);
			}
		});

		let dateFormat = 'DD/MM/YYYY';
		var $_date = $('input.form-control.bootstrap-table-filter-control-PaidDate.search-input[type="search"]');
		if( $_date.length > 0 ){
			$_date.daterangepicker({
					autoUpdateInput: false,
					locale: {
						format: dateFormat,
						separator: ' - ',
						firstDay: 2
					},
					opens: 'left',
					cancelButtonClasses: 'btn-default cancelButton_daterangepicker'
				},
				function(start, end) {
					startDate = start.format(dateFormat);
					endDate = end.format(dateFormat);
					let dates = [ startDate, endDate ];
					$_date.val(start.format(dateFormat) + ' - ' + end.format(dateFormat));
				}
			);
			$_date.on('apply.daterangepicker', function(ev, picker) {
				$(this).val(picker.startDate.format(dateFormat) + ' - ' + picker.endDate.format(dateFormat));
				let eve = jQuery.Event("keyup");
				eve.which = 13
				eve.keyCode = 13
				$_date.trigger(eve);
			});
			$_date.on('cancel.daterangepicker', function(ev, picker) {
				$(this).val('');
				let eve = jQuery.Event("keyup");
				eve.which = 13
				eve.keyCode = 13
				$_date.trigger(eve);
			});
		}


		document.getElementById('export_invoice_button').addEventListener('click', function() {
			var visibleFields = [];
			var columns = $tableProcessReceipt.bootstrapTable('getVisibleColumns');
			columns.forEach(function(column) {
				if (column.visible && column.field !== 'action') {
					visibleFields.push(column.field);
				}
			});
			var exportUrl = "<?php echo $exportMILink ?>";
			var tableProcessReceiptdata = $tableProcessReceipt.bootstrapTable('getData');
            var rowCount = tableProcessReceiptdata.length;
			if (rowCount > 0) {
				var visibleFieldsParam = visibleFields.length > 0 ? `visibleFields=${encodeURIComponent(visibleFields.join(','))}` : '';
				var filterParam = currentColumnFilter ? `columnfilter=${encodeURIComponent(currentColumnFilter)}` : '';
				if (exportUrl.includes('?')) {
					if (filterParam) {
						exportUrl += `&${filterParam}`;
					}
					if (visibleFieldsParam) {
						exportUrl += `&${visibleFieldsParam}`;
					}
				} else {
					exportUrl += '?';
					if (filterParam) {
						exportUrl += `${filterParam}`;
					}
					if (visibleFieldsParam) {
						exportUrl += (filterParam ? '&' : '') + `${visibleFieldsParam}`;
					}
				}
				window.open(exportUrl, '_blank');
			}
		});


		$(document).on('click', '#download_invoice_report_and_summery_button', function () {
		    var actionUrl = '<?=$downloadInvoiceReport?>';

		    var tableOptions = $tableProcessReceipt.bootstrapTable('getOptions');

		    var payload = {
		        columnfilter: currentColumnFilter,
		        limit: tableOptions.pageSize,
		        offset: (tableOptions.pageNumber - 1) * tableOptions.pageSize,
		        sort: tableOptions.sortName,
		        order: tableOptions.sortOrder
		    };

		    const columnfilter = JSON.stringify(payload || {});
		    const url = "<?php echo admin_url('admin-post.php'); ?>?action=download_invoice_csv_with_summery&columnfilter=" + encodeURIComponent(columnfilter);
		    window.open(url, '_blank');
		});

	}
	
  });
</script>
<?php
}
add_action('wp_ajax_euvatapi_logs_loader','cip_euvatapi_logs_loader_cb');
add_action('wp_ajax_nopriv_euvatapi_logs_loader','cip_euvatapi_logs_loader_cb');
function cip_euvatapi_logs_loader_cb(){
	global $wpdb;
	
	$limit = isset( $_POST['limit'] ) ? $_POST['limit'] : 10;
	$offset = isset( $_POST['offset'] ) ? $_POST['offset'] : 0;
	$orderby = isset( $_POST['sort'] ) ? $_POST['sort'] : 'id';
	$order = (isset($_POST['order']) && in_array($_POST['order'], array('asc', 'desc'))) ? $_POST['order'] : 'desc';
	
	$logTable = $wpdb->prefix.'cip_logs';
	$getLogs = $wpdb->get_results( "SELECT * FROM $logTable WHERE log_type = 'api_track' ORDER BY `$orderby` $order LIMIT $limit OFFSET $offset" );
	$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $logTable WHERE log_type = 'api_track'");
	
	$rows = array();
	if( $getLogs ){
		$rowCounter = 1;
		foreach( $getLogs as $getLog ){
			$row = array();
			$logsArr = maybe_unserialize( $getLog->logs );
			$logData = "";
			if( is_array( $logsArr ) ){
				foreach( $logsArr as $key => $logArr ){
					$logData .= '<p>'.$key.' : '. $logArr .'</p>';
				}
			}
			$row['id'] = $offset + $rowCounter;
			$row['logs'] = $logData;
			$row['log_type'] = $getLog->log_type;
			$row['_date'] = date_i18n( 'd/m/Y H:i A', strtotime( $getLog->_date ) );
			$rows[] = $row;
			$rowCounter++;
		}
	}
	$out = array(
		'total'		=>	$total_items,
		'rows'		=>	$rows
	);
	echo wp_json_encode( $out );
	exit;
}
add_action('wp_ajax_wallet_api_logs_loader','cip_wallet_api_logs_loader_cb');
function cip_wallet_api_logs_loader_cb(){
	global $wpdb;
	
	$limit = isset( $_POST['limit'] ) ? $_POST['limit'] : 10;
	$offset = isset( $_POST['offset'] ) ? $_POST['offset'] : 0;
	$orderby = isset( $_POST['sort'] ) ? $_POST['sort'] : 'id';
	$order = (isset($_POST['order']) && in_array($_POST['order'], array('asc', 'desc'))) ? $_POST['order'] : 'desc';
	
	$logTable = $wpdb->prefix.'cip_logs';

	$limit = isset( $_POST['limit'] ) ? $_POST['limit'] : 10;
	$offset = isset( $_POST['offset'] ) ? $_POST['offset'] : 0;
	$orderby = isset( $_POST['sort'] ) ? $_POST['sort'] : 'id';
	$order = (isset($_POST['order']) && in_array($_POST['order'], array('asc', 'desc'))) ? $_POST['order'] : 'desc';
	$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $logTable WHERE log_type != 'api_track'");
	$filter_qry = "";
	$filters = json_decode( stripslashes( $_REQUEST['columnfilter'] ), true );
	if( !empty( $filters ) ){
		foreach( $filters as $filterKey => $filterData ){
			if( $filterKey == 'user_type'  ){
				$filter_qry .= " AND `$filterKey` = '" . $filterData . "'";
			}else{				
				$filter_qry .= " AND `$filterKey` like '%" . $filterData . "%'";
			}
		}
		$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $logTable WHERE log_type != 'api_track' $filter_qry");
	}

	$filterByConditionPoolRef = json_decode( stripslashes( $_REQUEST['filterByConditionPoolRef'] ), true );
		
	if( !empty( $filterByConditionPoolRef ) ){
		foreach( $filterByConditionPoolRef as $filterKey => $filterData ){
			if($filterData != ''){
				$filter_qry .= " AND `logs` like '%" . $filterData . "%'";
			}
		}
	}
	if($filter_qry != ""){
		$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $logTable WHERE log_type != 'api_track' $filter_qry");
	}
    
    if( $orderby == 'id' || $orderby == '_date' ){
        $getLogs = $wpdb->get_results( "SELECT * FROM $logTable WHERE log_type != 'api_track' $filter_qry ORDER BY STR_TO_DATE(`_date`,'%Y-%m-%d %H:%i:%s') $order LIMIT $limit OFFSET $offset" );
    }else{
        $getLogs = $wpdb->get_results( "SELECT * FROM $logTable WHERE log_type != 'api_track' $filter_qry ORDER BY `$orderby` $order LIMIT $limit OFFSET $offset" );   
    }
	
	$rows = array();
	if( $getLogs ){
		$rowCounter = 1;
		foreach( $getLogs as $getLog ){
			$row = array();
			$logsArr = maybe_unserialize( $getLog->logs );
			$logData = "";
			if( is_array( $logsArr ) ){
				foreach( $logsArr as $key => $logArr ){
					$logData .= '<p>'.$key.' : '. $logArr .'</p>';
				}
			}
			$user_type = '—';
			if( $getLog->user_type  == 'sm' ){
				$user_type = __('Support Manager',CIP_TXTDOMAIN);
			}else if( $getLog->user_type  == 'sa' ){
				$user_type = __('Support Agent',CIP_TXTDOMAIN);
			}else if( $getLog->user_type  == 'member' ){
				$user_type = __('Member',CIP_TXTDOMAIN);
			}else if( $getLog->user_type  == 'MAs' ){
				$user_type = __('Member Assitant',CIP_TXTDOMAIN);
			}else if( $getLog->user_type  == 'buyer' ){
				$user_type = __('Buyer',CIP_TXTDOMAIN);
			}else{
				$user_type = __('Member',CIP_TXTDOMAIN);
			}
			$row['logs'] = $getLog->logs;
			$row['log_type'] = $user_type;
			$row['user_type'] = $user_type;

			$getLogDate = "";
			if( DateTime::createFromFormat('d/m/Y H:i:s', $getLog->_date) !== false ){
				try {
					$_date = DateTime::createFromFormat('d/m/Y H:i:s', $getLog->_date);
					$getLogDate = $_date->format('d/m/Y H:i A');
				} catch (\Throwable $th) {
					$getLogDate = '';
				}
			}else if( DateTime::createFromFormat('Y-m-d H:i:s', $getLog->_date) !== false ){
				try {
					$_date = DateTime::createFromFormat('Y-m-d H:i:s', $getLog->_date);
					$getLogDate = $_date->format('d/m/Y H:i A');
				} catch (\Throwable $th) {
					$getLogDate = '';
				}
			}

			$row['_date'] = $getLogDate;
			$rows[] = $row;
			$rowCounter++;
		}
	}
	$out = array(
		'total'		=>	$total_items,
		'rows'		=>	$rows
	);
	echo wp_json_encode( $out );
	exit;
}
add_action('wp_ajax_cip_receipts_table_list_loader','cip_receipts_table_list_loader_cb');
function cip_receipts_table_list_loader_cb(){
	global $wpdb;

	$tableReceipts = $wpdb->prefix.'cip_receipts';

	$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableReceipts WHERE 1");
	
	$limit = isset( $_POST['limit'] ) ? $_POST['limit'] : 10;
	$offset = isset( $_POST['offset'] ) ? $_POST['offset'] : 0;
	$orderby = isset( $_POST['sort'] ) ? $_POST['sort'] : 'id';
	$order = (isset($_POST['order']) && in_array($_POST['order'], array('asc', 'desc'))) ? $_POST['order'] : 'desc';
	
	$filter_qry = "";
	$filters = json_decode( stripslashes( $_REQUEST['columnfilter'] ), true );
	if( !empty( $filters ) ){
		foreach( $filters as $filterKey => $filterData ){
			if(isset($filterData) && $filterKey == 'status'){
				$filterDataval = ($filterData == 'Complete') ? 1 : 0 ;
				$filter_qry .= " AND `$filterKey` like '%" . $filterDataval . "%'";
			}else{
				$filter_qry .= " AND `$filterKey` like '%" . $filterData . "%'";
			}
		}
		$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableReceipts WHERE 1 $filter_qry");
	}
	
	$getReceiptsLists = $wpdb->get_results("SELECT * FROM $tableReceipts WHERE 1 $filter_qry ORDER BY `$orderby` $order LIMIT $limit OFFSET $offset");
	
	
	$rows = array();
	if( $getReceiptsLists ){
		$sno= $_REQUEST['offset'] + 1;
		foreach( $getReceiptsLists as $getReceiptsList ){
			$startus_check = 0;
			$row = array();
			$columnsArr = array(
				'id'						=>	__('id', CIP_TXTDOMAIN),
				'entry_date'				=>	__('entry_date', CIP_TXTDOMAIN),
				'agent_name'				=>	__('agent_name', CIP_TXTDOMAIN),
				'receipt_date'				=>	__('receipt_date', CIP_TXTDOMAIN),
				'sender_name'				=>	__('sender_name', CIP_TXTDOMAIN),
				'currency'					=>	__('currency', CIP_TXTDOMAIN),
				'amount'					=>	__('amount', CIP_TXTDOMAIN),
				'exchange_rate'				=>	__('exchange_rate', CIP_TXTDOMAIN),
				'converted_amount'			=>	__('converted_amount', CIP_TXTDOMAIN),
				'member_email'				=>	__('member_email', CIP_TXTDOMAIN),
				'sender_account_number'		=>	__('sender_account_number', CIP_TXTDOMAIN),
				'transaction_notes'			=>	__('transaction_notes', CIP_TXTDOMAIN),
				'status'			=>	__('status', CIP_TXTDOMAIN),
				'receipts_assistant_notes'	=>	__('receipts_assistant_notes', CIP_TXTDOMAIN),
			);

			if( $columnsArr ){
				foreach( $columnsArr as $columnKey => $columnsVal ){
					$columnsDataVal = $getReceiptsList->$columnKey;

					if( $columnKey == 'amount' ){
						if( !empty( $columnsDataVal ) ){
							$columnsDataVal = cip_number_format( $columnsDataVal, true );
						}
					}

					if( empty( $columnsDataVal ) ){
						$columnsDataVal = '—';
					}
					if($columnKey == 'status'){
						if($columnsDataVal == 1){
							$row[$columnKey] = 'Complete';
							$startus_check = 1;
						}else{
							$row[$columnKey] = 'Pending';
						}
					}else if ($columnKey == 'converted_amount') {
						$row[$columnKey] = cip_number_format($columnsDataVal,true);
					}else{
						$row[$columnKey] = $columnsDataVal;
					}
				}
			}
			$encryptId = base64_encode($getReceiptsList->id . md5('_CIP_RECEIPTS_CIP_'));
			if( $getReceiptsList->invoiceStatus != 'Paid' && $startus_check != 1 ){
				$row['action'] = '<a href="javascript:void(0);" class="edit-receipt" data-receipt="'. $encryptId .'"><i class="fas fa-pencil-alt" data-toggle-tt="tooltip" data-placement="top" title="'.__('Edit', CIP_TXTDOMAIN).'"></i></a>';
			}

			$rows[] = $row;
			$sno=$sno+1;
		}
	}
	$out = array(
		'total'			=>	$total_items,
		'rows'			=>	$rows
	);
	echo wp_json_encode( $out );
	exit;
}
add_action('wp_ajax_cip_process_receipts_table_list_loader','cip_process_receipts_table_list_loader_cb');
function cip_process_receipts_table_list_loader_cb(){
	global $wpdb;

	$tableReceipts = $wpdb->prefix.'cip_receipts';

	$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableReceipts WHERE 1");
	
	$limit = isset( $_POST['limit'] ) ? $_POST['limit'] : 10;
	$offset = isset( $_POST['offset'] ) ? $_POST['offset'] : 0;
	$orderby = isset( $_POST['sort'] ) ? $_POST['sort'] : 'id';
	$order = (isset($_POST['order']) && in_array($_POST['order'], array('asc', 'desc'))) ? $_POST['order'] : 'desc';
	
	$filter_qry = "";
	$filters = json_decode( stripslashes( $_REQUEST['columnfilter'] ), true );
	if( !empty( $filters ) ){
		foreach( $filters as $filterKey => $filterData ){
			$filter_qry .= " AND `$filterKey` like '%" . $filterData . "%'";
		}
		$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableReceipts WHERE 1 $filter_qry");
	}
	
	$getReceiptsLists = $wpdb->get_results("SELECT * FROM $tableReceipts WHERE 1 $filter_qry ORDER BY `$orderby` $order LIMIT $limit OFFSET $offset");
	
	
	$rows = array();
	if( $getReceiptsLists ){
		$sno= $_REQUEST['offset'] + 1;
		foreach( $getReceiptsLists as $getReceiptsList ){
			$row = array();
			$columnsArr = array(
				'id'						=>	__('id', CIP_TXTDOMAIN),
				'entry_date'				=>	__('entry_date', CIP_TXTDOMAIN),
				'agent_name'				=>	__('agent_name', CIP_TXTDOMAIN),
				'receipt_date'				=>	__('receipt_date', CIP_TXTDOMAIN),
				'sender_name'				=>	__('sender_name', CIP_TXTDOMAIN),
				'currency'					=>	__('currency', CIP_TXTDOMAIN),
				'amount'					=>	__('amount', CIP_TXTDOMAIN),
				'sender_account_number'		=>	__('sender_account_number', CIP_TXTDOMAIN),
				'transaction_notes'			=>	__('transaction_notes', CIP_TXTDOMAIN),
				'receipts_assistant_notes'	=>	__('receipts_assistant_notes', CIP_TXTDOMAIN),
			);

			if( $columnsArr ){
				foreach( $columnsArr as $columnKey => $columnsVal ){
					$columnsDataVal = $getReceiptsList->$columnKey;

					if( $columnKey == 'amount' ){
						if( !empty( $columnsDataVal ) ){
							$columnsDataVal = cip_number_format( $columnsDataVal, true );
						}
					}

					if( empty( $columnsDataVal ) ){
						$columnsDataVal = '—';
					}
					$row[$columnKey] = $columnsDataVal;
				}
			}
			$encryptId = base64_encode($getReceiptsList->id . md5('_CIP_RECEIPTS_CIP_'));
			$processUrl = add_query_arg( array('view' => $encryptId ), get_the_permalink( 6866 ) );
			if( $getReceiptsList->invoiceStatus != 'Paid' ){
				$row['action'] = '<a href="'. $processUrl .'"><i class="fas fa-pencil-alt" data-toggle-tt="tooltip" data-placement="top" title="'.__('Process', CIP_TXTDOMAIN).'"></i></a>';
			}

			$rows[] = $row;
			$sno=$sno+1;
		}
	}
	$out = array(
		'total'			=>	$total_items,
		'rows'			=>	$rows
	);
	echo wp_json_encode( $out );
	exit;
}

add_action('wp_ajax_cip_member_invoice_list_loader','cip_member_invoice_list_loader_cb');
function cip_member_invoice_list_loader_cb(){
	global $wpdb;
    $wpdb_prefix = $wpdb->prefix;
    $invoice= $wpdb_prefix.'cip_member_invoice';
    $e_mail=$_SESSION['refAccount'];

	$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $invoice WHERE Email='$e_mail' AND Status = 'Paid' ORDER BY `id` DESC");
	
	$limit = isset( $_POST['limit'] ) ? $_POST['limit'] : 10;
	$offset = isset( $_POST['offset'] ) ? $_POST['offset'] : 0;
	$orderby = isset( $_POST['sort'] ) ? $_POST['sort'] : 'id';
	$order = (isset($_POST['order']) && in_array($_POST['order'], array('asc', 'desc'))) ? $_POST['order'] : 'desc';
	
	$filter_qry = "";
	$filters = json_decode( stripslashes( $_REQUEST['columnfilter'] ), true );
	if( !empty( $filters ) ){
		foreach( $filters as $filterKey => $filterData ){
			if( $filterKey == 'token'){
		        $filter_qry .= " AND `$filterKey` = '". $filterData ."'";
		    }else{
				$filter_qry .= " AND `$filterKey` like '%" . $filterData . "%'";
		    }
		}
		$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $invoice WHERE 1 AND Email='$e_mail' AND Status = 'Paid' $filter_qry");
	}
	
	$getReceiptsLists = $wpdb->get_results("SELECT * FROM $invoice WHERE 1 $filter_qry AND Email='$e_mail' AND Status = 'Paid' ORDER BY `$orderby` $order LIMIT $limit OFFSET $offset");
	
	
	$rows = array();
	if( $getReceiptsLists ){
		$sno= $_REQUEST['offset'] + 1;
		foreach( $getReceiptsLists as $getReceiptsList ){
			$row = array();
			$columnsArr = array(
				'id'						=>	__('id', CIP_TXTDOMAIN),
				'entry_date'				=>	__('entry_date', CIP_TXTDOMAIN),
				'agent_name'				=>	__('agent_name', CIP_TXTDOMAIN),
				'receipt_date'				=>	__('receipt_date', CIP_TXTDOMAIN),
				'sender_name'				=>	__('sender_name', CIP_TXTDOMAIN),
				'currency'					=>	__('currency', CIP_TXTDOMAIN),
				'amount'					=>	__('amount', CIP_TXTDOMAIN),
				'sender_account_number'		=>	__('sender_account_number', CIP_TXTDOMAIN),
				'transaction_notes'			=>	__('transaction_notes', CIP_TXTDOMAIN),
				'receipts_assistant_notes'	=>	__('receipts_assistant_notes', CIP_TXTDOMAIN),
				'token'						=>	__('token', CIP_TXTDOMAIN),
			);
				$id = $getReceiptsList->id;
				$csr_inc = cip_convert_csr_by_price_pdf( $getReceiptsList->ProductPrice, $getReceiptsList->inclusiveUnit );
                $giftcode_status = 'Pending';
                if( !empty( $getReceiptsList->giftcode_status ) ){
                    $giftcode_status = $getReceiptsList->giftcode_status;
                }
                $PriceCAD = $getReceiptsList->PriceCAD;
                $GSTPrice = $PriceCAD * $getReceiptsList->GSTCAD / 100;
                $QSTPrice = $PriceCAD * $getReceiptsList->QSTCAD / 100;
                $HSTPrice = $PriceCAD * $getReceiptsList->HSTCAD / 100;

                    $row['id'] = $id; 

					$row['InvoiceNumber'] = ( $getReceiptsList->InvoiceNumber ) ? 'CA-'.$getReceiptsList->InvoiceNumber : '';
					
					$row['PaidDate'] = $getReceiptsList->PaidDate;

                    $row['Package'] = $getReceiptsList->Package;

                    $row['Description'] = $getReceiptsList->Description;
                    $row['username'] = $getReceiptsList->username;
                    $row['FirstName'] = $getReceiptsList->FirstName . ' ' . $getReceiptsList->LastName;
                    $row['Address1'] = $getReceiptsList->Address1;
                    $row['Kgs'] = number_format( $getReceiptsList->Kgs );
                    $row['csr'] = number_format( $csr_inc );

                    $row['GrossAmount'] = number_format( $getReceiptsList->GrossAmount, 2 );
                    $row['PriceCAD'] = number_format( $getReceiptsList->PriceCAD, 2 );
                    $row['ExchangeRate'] = $getReceiptsList->ExchangeRate;
                    $row['GSTPrice'] = number_format( $GSTPrice, 2 );
                    $row['QSTPrice'] = number_format( $QSTPrice, 2 );
                    $row['TotalCAD'] = number_format( $getReceiptsList->TotalCAD, 2 );
                    $row['giftcode'] = $getReceiptsList->giftcode;
                    $row['token'] = $getReceiptsList->token;

					$path = get_site_url();
                    $row['action'] = '<a class="ml-2" title="View Invoice" target="_blank" href="'.$path.'/wp-content/plugins/cip-helper/includes/pdf/download_pdf.php/?id='.$id.'&paid=1" style="color:#000;text-decoration:none;"><i class="fa fa-eye"></i></a>';
			
			$rows[] = $row;
			$sno=$sno+1;
		}
	}
	$out = array(
		'total'			=>	$total_items,
		'rows'			=>	$rows
	);
	echo wp_json_encode( $out );
	exit;
}
add_action('wp_ajax_cip_sa_member_invoice_list_loader','cip_sa_member_invoice_list_loader_cb');
function cip_sa_member_invoice_list_loader_cb(){
	global $wpdb;
    $wpdb_prefix = $wpdb->prefix;
    $invoice= $wpdb_prefix.'cip_member_invoice';
    $e_mail=$_SESSION['refAccount'];

	$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $invoice WHERE `status`='Paid' ORDER BY `id` DESC");
	
	$limit = isset( $_POST['limit'] ) ? $_POST['limit'] : 10;
	$offset = isset( $_POST['offset'] ) ? $_POST['offset'] : 0;
	$orderby = isset( $_POST['sort'] ) ? $_POST['sort'] : 'id';
	$order = (isset($_POST['order']) && in_array($_POST['order'], array('asc', 'desc'))) ? $_POST['order'] : 'desc';
	
	$filter_qry = "";
	$filters = json_decode( stripslashes( $_REQUEST['columnfilter'] ), true );
	if( !empty( $filters ) ){
		foreach( $filters as $filterKey => $filterData ){
		    if( $filterKey == 'status' || $filterKey == 'token'){
		        $filter_qry .= " AND `$filterKey` = '". $filterData ."'";
		    }elseif($filterKey == 'PaidDate') {		    	
				$filterDataMinMax = explode(' - ', $filterData);

				$filterDataMinMax0 = DateTime::createFromFormat('d/m/Y', $filterDataMinMax[0]);
				$filterDataMinMax0Date = $filterDataMinMax0->format('Y-m-d'); // '2025-01-01'

				$filterDataMinMax1 = DateTime::createFromFormat('d/m/Y', $filterDataMinMax[1]);
				$filterDataMinMax1Date = $filterDataMinMax1->format('Y-m-d'); // '2025-01-31'

				// Convert VARCHAR to DATE using STR_TO_DATE before comparing
				$filter_qry .= " AND STR_TO_DATE(`$filterKey`, '%d-%m-%Y') BETWEEN '$filterDataMinMax0Date' AND '$filterDataMinMax1Date'";
		    }else{
			    $filter_qry .= " AND `$filterKey` like '%" . $filterData . "%'";
		    }

		}
		$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $invoice WHERE `status`='Paid' $filter_qry");
	}
	
	$getReceiptsLists = $wpdb->get_results("SELECT * FROM $invoice WHERE `status`='Paid' $filter_qry ORDER BY `$orderby` $order LIMIT $limit OFFSET $offset");
	
	
	$rows = array();
	if( $getReceiptsLists ){
		$sno= $_REQUEST['offset'] + 1;
		foreach( $getReceiptsLists as $getReceiptsList ){
			$row = array();
			$columnsArr = array(
				'id'						=>	__('id', CIP_TXTDOMAIN),
				'entry_date'				=>	__('entry_date', CIP_TXTDOMAIN),
				'agent_name'				=>	__('agent_name', CIP_TXTDOMAIN),
				'receipt_date'				=>	__('receipt_date', CIP_TXTDOMAIN),
				'sender_name'				=>	__('sender_name', CIP_TXTDOMAIN),
				'currency'					=>	__('currency', CIP_TXTDOMAIN),
				'amount'					=>	__('amount', CIP_TXTDOMAIN),
				'sender_account_number'		=>	__('sender_account_number', CIP_TXTDOMAIN),
				'transaction_notes'			=>	__('transaction_notes', CIP_TXTDOMAIN),
				'receipts_assistant_notes'	=>	__('receipts_assistant_notes', CIP_TXTDOMAIN),
				'token'						=>	__('token', CIP_TXTDOMAIN),
			);
				$id = $getReceiptsList->id;
				$csr_inc = cip_convert_csr_by_price_pdf( $getReceiptsList->ProductPrice, $getReceiptsList->inclusiveUnit );
                $giftcode_status = 'Pending';
                if( !empty( $getReceiptsList->giftcode_status ) ){
                    $giftcode_status = $getReceiptsList->giftcode_status;
                }
                $PriceCAD = $getReceiptsList->PriceCAD;
                $GSTPrice = $PriceCAD * $getReceiptsList->GSTCAD / 100;
                $QSTPrice = $PriceCAD * $getReceiptsList->QSTCAD / 100;

                    $row['id'] = $sno; 

					$row['InvoiceNumber'] = ( $getReceiptsList->InvoiceNumber ) ? 'CA-'.$getReceiptsList->InvoiceNumber : '';
					
					$row['PaidDate'] = $getReceiptsList->PaidDate;

                    $row['Package'] = $getReceiptsList->Package;

                    $row['Description'] = $getReceiptsList->Description;
                    $row['username'] = $getReceiptsList->username;
                    $row['Email'] = $getReceiptsList->Email;
                    $row['FirstName'] = $getReceiptsList->FirstName . ' ' . $getReceiptsList->LastName;
                    $row['Address1'] = $getReceiptsList->Address1;
                     $row['State'] = $getReceiptsList->State;
                    $row['Kgs'] = number_format( $getReceiptsList->Kgs );
                    $row['csr'] = number_format( $csr_inc );

                    $row['GrossAmount'] = number_format( $getReceiptsList->GrossAmount, 2 );
                    $row['PriceCAD'] = number_format( $getReceiptsList->PriceCAD, 2 );
                    $row['ExchangeRate'] = $getReceiptsList->ExchangeRate;
                    $row['GSTCAD'] = number_format( $GSTPrice, 2 );
                    $row['QSTCAD'] = number_format( $QSTPrice, 2 );
                    $row['TotalCAD'] = number_format( $getReceiptsList->TotalCAD, 2 );
                    $row['giftcode'] = $getReceiptsList->giftcode;
                    $row['token'] = $getReceiptsList->token;
                    
                    $invoiceStatus = "Un-Paid";
                    if( $getReceiptsList->Status == 'Paid' ){
                        $invoiceStatus = "Paid";
                    }
                    $row['status'] = $invoiceStatus;

					$path = get_site_url();
					
				if( $getReceiptsList->Status == 'Paid' && $getReceiptsList->InvoiceNumber ){ 
					$row['action'] = '<a class="ml-2" title="View Invoice" target="_blank" href="'.$path.'/wp-content/plugins/cip-helper/includes/pdf/download_pdf.php/?id='.$getReceiptsList->id.'&paid=1" style="color:#000;text-decoration:none;"><i class="fa fa-eye"></i></a>';
				}else{
					$row['action'] = '<a class="ml-2" title="Delete" data-id="'.$getReceiptsList->id.'" id="delete_member_invoice" href="javascript:void(0);" style="color:#000;text-decoration:none;"><i class="fa fa-trash"></i></a>';
				}
				
			
			$rows[] = $row;
			$sno=$sno+1;
		}
	}
	$out = array(
		'total'			=>	$total_items,
		'rows'			=>	$rows
	);
	echo wp_json_encode( $out );
	exit;
}

add_action('admin_post_download_invoice_csv_with_summery', 'download_invoice_csv_with_summery_cb');
function download_invoice_csv_with_summery_cb() {
    global $wpdb;
    $invoice = $wpdb->prefix . 'cip_member_invoice';

    $limit = isset( $_GET['limit'] ) ? $_GET['limit'] : 10;
	$offset = isset( $_GET['offset'] ) ? $_GET['offset'] : 0;
	$orderby = isset( $_GET['sort'] ) ? $_GET['sort'] : 'id';
	$order = (isset($_GET['order']) && in_array($_GET['order'], array('asc', 'desc'))) ? $_GET['order'] : 'desc';

    $filter_qry = "";
   	$filters = json_decode( stripslashes( $_GET['columnfilter'] ), true );
   	$filters = json_decode($filters['columnfilter']);
	if( !empty( $filters ) ){
		foreach( $filters as $filterKey => $filterData ){
		    if( $filterKey == 'status' || $filterKey == 'token'){
		        $filter_qry .= " AND `$filterKey` = '". $filterData ."'";
		    }elseif($filterKey == 'PaidDate') {		    	
				$filterDataMinMax = explode(' - ', $filterData);

				$filterDataMinMax0 = DateTime::createFromFormat('d/m/Y', $filterDataMinMax[0]);
				$filterDataMinMax0Date = $filterDataMinMax0->format('Y-m-d'); // '2025-01-01'

				$filterDataMinMax1 = DateTime::createFromFormat('d/m/Y', $filterDataMinMax[1]);
				$filterDataMinMax1Date = $filterDataMinMax1->format('Y-m-d'); // '2025-01-31'

				// Convert VARCHAR to DATE using STR_TO_DATE before comparing
				$filter_qry .= " AND STR_TO_DATE(`$filterKey`, '%d-%m-%Y') BETWEEN '$filterDataMinMax0Date' AND '$filterDataMinMax1Date'";
		    }else{
			    $filter_qry .= " AND `$filterKey` like '%" . $filterData . "%'";
		    }

		}
	}
	
	$results = $wpdb->get_results("SELECT * FROM $invoice WHERE `status`='Paid' $filter_qry");
	

    if (!$results) {
        wp_die('No data found.');
    }

    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=invoice_export_' . date('Ymd_His') . '.csv');
    
	$output = fopen('php://output', 'a');

	fputcsv($output, ['Summary by State']);
	fputcsv($output, ['Province', 'Price (CAD)', 'GST (CAD)', 'HST (CAD)', 'Total (CAD)']);

	$summary_results = $wpdb->get_results("
	    SELECT 
	        State,
	        SUM(PriceCAD) AS TotalPrice,
	        SUM(PriceCAD * GSTCAD / 100) AS TotalGST,
	        SUM(PriceCAD * QSTCAD / 100) AS TotalQST,
	        SUM(TotalCAD) AS TotalTotal
	    FROM $invoice
	    WHERE 1 $filter_qry
	    GROUP BY State
	");

	$grandPrice = $grandGST = $grandQST = $grandTotal = 0;
	foreach ($summary_results as $summary) {
	    $grandPrice += $summary->TotalPrice;
	    $grandGST += $summary->TotalGST;
	    $grandQST += $summary->TotalQST;
	    $grandTotal += $summary->TotalTotal;

	    fputcsv($output, [
	        $summary->State,
	        number_format($summary->TotalPrice, 2),
	        number_format($summary->TotalGST, 2),
	        number_format($summary->TotalQST, 2),
	        number_format($summary->TotalTotal, 2),
	    ]);
	}

	fputcsv($output, [
	    'Total',
	    number_format($grandPrice, 2),
	    number_format($grandGST, 2),
	    number_format($grandQST, 2),
	    number_format($grandTotal, 2),
	]);

	fclose($output);

	$output = fopen('php://output', 'w');
	
	fputcsv($output, []);
	fputcsv($output, []);

    fputcsv($output, [
        'Id','InvoiceNumber', 'PaidDate', 'Description', 'Name', 'State', 'Price (EUR)', 'ExchangeRate', 'Price (CAD)', 'GST (CAD)', 'HST (CAD)', 'Total (CAD)'
    ]);

    foreach ($results as $r) {
        $csr_inc = cip_convert_csr_by_price_pdf($r->ProductPrice, $r->inclusiveUnit);
        $giftcode_status = !empty($r->giftcode_status) ? $r->giftcode_status : 'Pending';
        $PriceCAD = $r->PriceCAD;
        $GSTPrice = $PriceCAD * $r->GSTCAD / 100;
        $QSTPrice = $PriceCAD * $r->QSTCAD / 100;
        $status = ($r->Status == 'Paid') ? 'Paid' : 'Un-Paid';

        $invoicenumber = '';
        if($r->InvoiceNumber){
        	$invoicenumber = 'CA-' . $r->InvoiceNumber;
        }

        fputcsv($output, [
            $r->id,
            $invoicenumber,
            $r->PaidDate,
            $r->Description,
           	ucfirst($r->FirstName) . ' ' . ucfirst($r->LastName),
            $r->State,
            number_format($r->GrossAmount, 2),
            $r->ExchangeRate,
            number_format($r->PriceCAD, 2),
            number_format($GSTPrice, 2),
            number_format($QSTPrice, 2),
            number_format($r->TotalCAD, 2),
        ]);
    }

    fclose($output);
	exit;
}