<?php
function sm_create_account_form(){

    wp_enqueue_style( 'bs-select-style' );
	wp_enqueue_script('bs-select-js');

    global $wpdb;
    $wpdb_prefix = $wpdb->prefix;
    $invoice= $wpdb_prefix.'cip_member_invoice';
    $invoice_record = "SELECT DISTINCT Email FROM $invoice";
    $invoice_result = $wpdb->get_results($invoice_record);
    
    ?>
    <form method="post">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-12">
                <label style="color:#fff;" for="holder"><?php _e('Account Holder', CIP_TXTDOMAIN); ?></label><br>
                
                <input type="text" name="holder" class="form-control" aria-describedby="emailHelp" placeholder="Enter Account Holder" required />
            </div>

        </div>
        <div class="row">
            <div class="col-lg-4 col-md-4 col-12 mt-3">
                <label style="color:#fff;" for="website"><?php _e('BIC', CIP_TXTDOMAIN); ?></label><br>
                <input class="form-control" type="text" placeholder="Enter BIC" name="bic">
            </div>

            <div class="col-lg-4 col-md-4 col-12 mt-3">
                <label style="color:#fff;" for="number"><?php _e('Bank Code', CIP_TXTDOMAIN); ?></label><br>
                <input class="form-control" type="number" placeholder="Enter Bank Code" name="bcode">
            </div>

            <div class="col-lg-4 col-md-4 col-12 mt-3">
                <label style="color:#fff;" for="firstname"> <?php _e('IBAN', CIP_TXTDOMAIN); ?></label><br>
                <input class="form-control" type="text" placeholder="Enter IBAN" name="iban" required />
            </div>
        </div>
		
		 <div class="row">
            <div class="col-lg-4 col-md-4 col-12 mt-3">
                 <label style="color:#fff;" for="website"><?php _e('Bank Name', CIP_TXTDOMAIN); ?></label><br>
            	 <input class="form-control" type="text" placeholder="Enter Bank Name" name="bname">
            </div>

            <div class="col-lg-4 col-md-4 col-12 mt-3">
                <label style="color:#fff;" for="number"><?php _e('Status', CIP_TXTDOMAIN); ?></label><br>
				<select name="status">
					<option><?php _e('Active', CIP_TXTDOMAIN); ?></option>
					<option><?php _e('In-Active', CIP_TXTDOMAIN); ?></option>
				</select>
            </div>
            <div class="col-lg-4 col-md-4 col-12 mt-3">
                <label style="color:#fff;" for="number"><?php _e('Currency', CIP_TXTDOMAIN); ?></label><br>
				<select name="currency_type">
                    <?php
                        // Assuming $wpdb is the WordPress database object and $account holds the table name
                        global $wpdb;
                        $account = $wpdb->prefix . 'sm_accounts_management';

                        // Assuming $currency_types contains the allowed currency types
                        $allowed_currency_types = array('CAD', 'USD', 'Euro');

                        // Query the database for currency types present in the $account table
                        $existing_currency_types = $wpdb->get_col("SELECT DISTINCT currency_type FROM $account");

                        // Check for currency types that do not exist in the $account table
                        $missing_currency_types = array_diff($allowed_currency_types, $existing_currency_types);

                        // Generate options based on the existing currency types
                        foreach ($missing_currency_types as $currency_type) {
                            echo '<option>' . esc_html($currency_type) . '</option>';
                        }
                    ?>
					<!-- <option><?php _e('CAD', CIP_TXTDOMAIN); ?></option>
					<option><?php _e('USD', CIP_TXTDOMAIN); ?></option>
					<option><?php _e('Euro', CIP_TXTDOMAIN); ?></option> -->
				</select>
            </div>
        </div>

        <div class="mt-3">
            <label style="color:#fff;" for="website"><?php _e('Bank Address', CIP_TXTDOMAIN); ?></label><br>
            <textarea class="form-control" placeholder="Enter Bank Address" name="baddress"></textarea><br>
        </div>
        
        <div>
            <input type="submit" class="btn btn-primary" name="submit" value="Submit"/>
</div>  
    </form>
    <?php
    if(isset($_POST['submit']))
	{
		require_once 'sm_add_account.php';
        //Calling Function
        sm_add_new_account_details();
	}	
}
?>